/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/modules/set_null.c#1 $
*/

#define XP_WIDE_API	/* Use Wide APIs */

#include <avs/util.h>
#include <avs/err.h>
#include <avs/om.h>
#include <avs/fld.h>
#include <avs/arr.h>
#include <avs/data_utils.h>

#define ERR_RETURN(A) ERRerror("set_null",1,ERR_ORIG, A); return(0);

int FUNCset_null (OMobj_id in, OMobj_id out, int comp, int unset, double val);

int DVset_null_update(OMobj_id elem_id)
{
	OMobj_id in, out, e;
	int stat, unset, comp;
	double val;

	in = OMfind_subobj(elem_id, OMstr_to_name("in"), OM_OBJ_RW);
	out = OMfind_subobj(elem_id, OMstr_to_name("out"), OM_OBJ_RW);
	e = OMfind_subobj(elem_id, OMstr_to_name("component"), OM_OBJ_RD);
	stat = OMget_int_val(e, &comp);
	if (stat != 1)
		return(0);
	e = OMfind_subobj(elem_id, OMstr_to_name("null_value"), OM_OBJ_RD);
	stat = OMget_real_val(e, &val);
	if (stat != 1)
		return(0);
	e = OMfind_subobj(elem_id, OMstr_to_name("unset"), OM_OBJ_RD);
	stat = OMget_int_val(e, &unset);
	if (stat != 1)
		return(0);

	stat = FUNCset_null(in, out, comp, unset, val);
	return(stat);
}

int FUNCset_null (OMobj_id in, OMobj_id out, int comp, int unset, double val)
{
	int ncomp, type;
	double    null_val;

	if (FLDcopy_subelem_ref(out, in) != 1) {
		ERR_RETURN("Error setting field reference");
	}

	if (FLDget_node_data_ncomp(out, &ncomp) != 1) {
		ERR_RETURN("Error getting ncomp");
	}
	if (ncomp <= comp) {
		ERR_RETURN("bad component number");
	}
	if (unset) {
		if (FLDset_node_null_flag(out, comp, 0) != 1) {
			ERR_RETURN("Error setting null flag");
		}
	}
	else {
		if (FLDget_node_data_type(out, comp, &type) != 1) {
			ERR_RETURN("Error getting data type");
		}

		UTILdouble_to_type(&null_val, val, type);

		if (FLDset_node_null_data(out, comp, (char *)&null_val, type) != 1) {
			ERR_RETURN("Error setting null value");
		}
		if (FLDreset_node_minmax(out, 0) != 1) {
			ERR_RETURN("Error resetting node minmax");
		}
	}
	return(1);
}
