/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/modules/slicestr.c#1 $
*/

#define XP_WIDE_API	/* Use Wide APIs */

#include <avs/util.h>
#include <avs/err.h>
#include <avs/om.h>
#include <avs/fld.h>
#include <avs/math.h>
#include <avs/dv_util.h>
#include <avs/data_utils.h>

#define METHOD_SUCCESS 1
#define METHOD_FAILURE 0

#define ERR_RETURN(A) {ERRerror("slice_struct", 0, ERR_ORIG, A); \
                       return METHOD_FAILURE;}

#define MAX_NAME_SIZE 1024
#define EPS  0.01

int FUNCslice_struct (OMobj_id in, OMobj_id plane, double dist, int nmap_comp,
                      int *map_comp, OMobj_id out);

/* 64-bit porting. Only Modified Internally */
int DVslice_update(OMobj_id elem_id)
{
    OMobj_id in, out, plane, comp_id, dist_id;
    int stat, *comp, type;
    xp_long ncomp;
    double   dist;

    in = OMfind_subobj(elem_id, OMstr_to_name("in"), OM_OBJ_RD);
    out = OMfind_subobj(elem_id, OMstr_to_name("out"), OM_OBJ_RW);
    plane = OMfind_subobj(elem_id, OMstr_to_name("plane"), OM_OBJ_RD);
    dist_id = OMfind_subobj(elem_id, OMstr_to_name("dist"), OM_OBJ_RD);

    if (OMis_null_obj(dist_id)) {
        ERR_RETURN("dist id is NULL");
    }
    else {
        stat = OMget_real_val(dist_id, &dist);
        if (stat < 1)
            dist = 0.0;
    }

    comp_id = OMfind_subobj(elem_id, OMstr_to_name("map_comp"),
                            OM_OBJ_RD);

    type = OM_TYPE_INT;
    ncomp = 0;
    comp = (int *)NULL;
    stat = OMget_array_sz(comp_id, &type, (char **)(&comp),
                          &ncomp, OM_GET_ARRAY_RD);
    if (stat != OM_STAT_SUCCESS) {
        ncomp = 0;
        comp = NULL;
    }

    stat = FUNCslice_struct(in, plane, dist, (int)ncomp, comp, out);
    if (comp)
        ARRfree(comp);
    return(stat);
}

/* 64-bit porting. Only Modified Internally */
int
DV_ARRslice_update(OMobj_id elem_id, OMevent_mask event_mask, int seq_num)
{
    OMobj_id in_arr, out_arr;
    xp_long i, num_fields;

    OMobj_id in, out, plane, comp_id, dist_id;
    int stat, *comp, type;
    xp_long ncomp;
    double dist;

    in_arr  = OMfind_subobj(elem_id, OMstr_to_name("in"), OM_OBJ_RD);
    out_arr = OMfind_subobj(elem_id, OMstr_to_name("out"), OM_OBJ_RW);
    plane   = OMfind_subobj(elem_id, OMstr_to_name("plane"), OM_OBJ_RD);
    dist_id = OMfind_subobj(elem_id, OMstr_to_name("dist"), OM_OBJ_RD);
    if (OMis_null_obj(dist_id)) {
        ERR_RETURN("dist id is NULL");
    }
    else {
        stat = OMget_real_val(dist_id, &dist);
        if (stat != OM_STAT_SUCCESS)
            dist = 0.0;
    }

    stat = OMget_array_size( in_arr, &num_fields );
    if( stat != OM_STAT_SUCCESS ) return METHOD_FAILURE;

    stat = OMset_array_size( out_arr, num_fields );
    if( stat != OM_STAT_SUCCESS ) return METHOD_FAILURE;

    comp_id = OMfind_subobj(elem_id, OMstr_to_name("map_comp"), OM_OBJ_RD);

    type = OM_TYPE_INT;
    ncomp = 0;
    comp = (int *)NULL;
    stat = OMget_array_sz(comp_id, &type, (char **)(&comp),
                          &ncomp, OM_GET_ARRAY_RD);
    if (stat != OM_STAT_SUCCESS) {
        ncomp = 0;
        comp = NULL;
    }

    for( i = 0; i < num_fields; ++i ) {
        stat = OMget_array_val( in_arr,  i, &in,  OM_OBJ_RD );
        if( stat != OM_STAT_SUCCESS ) continue;
        stat = OMget_array_val( out_arr, i, &out, OM_OBJ_RW );
        if( stat != OM_STAT_SUCCESS ) continue;

        stat = FUNCslice_struct(in, plane, dist, (int)ncomp, comp, out);
#if 0
        if( stat != METHOD_SUCCESS ) {
            ERRerror( "slice_struct", 1, ERR_ORIG,
                      "Error while processing field: %d", i );
        }
#endif
    }

    if (comp)
        ARRfree(comp);
    return(stat);
}


/* 64-bit porting. Only Modified Internally */
int FUNCslice_struct (OMobj_id in, OMobj_id plane, double dist, int nmap_comp, int *map_comp, OMobj_id out)
{
	xp_long nnodes, size, *dims, out_dims[2], *min_node, *max_node;
	int   veclen, data_id, dims_size;
	int   plane_nspace, out_nspace, stat, comp, null_flag;
	int   data_type, type, i, ncomp;
	xp_long out_nnodes;
	float  *pnts, *points, *out_points, plane_dist, *t;
	float  bounds[3], norm[3], norm_xfm[3];
	float  xform[4][4], *xfm, in_xform[4][4], *in_xfm, t_xform[4][4];
	char *list;
	char   *node_data, *out_node_data;
	double null_value, new_null_value, new_nv, min, max;
	char  units[MAX_NAME_SIZE], label[MAX_NAME_SIZE];
	char   *mesh_info;

	if (FLDget_node_data_ncomp(in, &ncomp) != 1) {
		ncomp =0;
		nmap_comp = 0;
	}
	for (i=0; i<nmap_comp; i++) {
		if (map_comp[i] >= ncomp) {
			if (FLDset_node_data_ncomp (out, 0) != 1) {
				ERR_RETURN("Error setting nnode_data");
			}
			ERR_RETURN("requested component does not exist, slice is not performed");
		}
	}

	stat = FLDget_xform(in, (float *)in_xform);
	if (stat < 0) {
		ERR_RETURN("cannot get xform for in");
	}
	else if (stat == 0) {
		in_xfm = (float *)0;
	}
	else
		in_xfm = (float *)in_xform;


	/*-----------------*/
	/*   GET PLANE     */
	/*-----------------*/
	if (FLDget_nspace (plane, &plane_nspace) != 1) {
		ERR_RETURN("Error getting nspace");
	}
	if (FLDget_points (plane, &pnts, &size, OM_GET_ARRAY_RD) != 1) {
		ERR_RETURN("Error getting points");
	}
	stat = FLDget_xform(plane, (float *)xform);
	if (stat < 0) {
		ERR_RETURN("cannot get xform for probe");
	}
	else if (stat == 0) {
		xfm = (float *)0;
	}
	else
		xfm = (float *)xform;
	if (in_xfm) {
		MATmat4_inverse(t_xform, (Matr4 *)in_xfm);
		if (xfm)
			MATmat4_multiply((Matr4 *)xfm, t_xform, (Matr4 *)xfm);
		else
			xfm = (float *)t_xform;
	}
	/*------------------*/
	/* TRANSFORM PLANE  */
	/*------------------*/
	for (i=0; i<plane_nspace; i++)
		bounds[i] = pnts[i];
	for (; i<3; i++)
		bounds[i] = 0.0;
	norm[0] = 0.0; norm[1] = 0.0; norm[2] = 1.0;

	if (xfm) {
		MATvec3_mat4_multiply(bounds, (Matr4 *)xfm);
		MATxform_vecs(1, (Matr3 *)norm, (Matr4 *)xfm, (Matr3 *)norm_xfm);
	}
	if (FLDget_dims (in, &dims, &dims_size) != 1) {
		ERR_RETURN("Error getting dims");
	}
	if (FLDget_points (in, &points, &size, OM_GET_ARRAY_RD) != 1) {
		ERR_RETURN("Error getting points");
	}
	ARRfree(pnts);
	out_nspace = 2;
	plane_dist = bounds[0]*norm_xfm[0] + bounds[1]*norm_xfm[1] + bounds[2]*norm_xfm[2];

	stat = FLDget_mesh_info(in, &mesh_info);
	if (!stat) {
		ERR_RETURN("cannot create cell table");
	}
	out_nnodes = UTILrslice(mesh_info, dims, points, norm_xfm, plane_dist+dist,
				out_dims, &out_points, out_nspace, (float *)xform,
				&min_node, &max_node, &t, &list);
	ARRfree(points);

	/**
	if (out_nnodes == 0)
		return(0);
	**/

	/*-----------------------------*/
	/*   OUT FIELD                 */
	/*-----------------------------*/
	if (FLDset_ndim (out, 2) != 1) {
		ERR_RETURN("Error setting ndim");
	}
	if (FLDset_dims (out, out_dims) != 1) {
		ERR_RETURN("Error setting dims");
	}
	if (FLDset_nspace (out, out_nspace) != 1) {
		ERR_RETURN("Error setting nspace");
	}
	if (FLDget_points (out, &pnts, &size, OM_GET_ARRAY_WR) != 1) {
		ERR_RETURN("Error getting points");
	}
	memcpy(pnts, out_points, size*sizeof(float));
	free(out_points);

	if (in_xfm)
		MATmat4_multiply((Matr4 *)xfm, (Matr4 *)in_xfm, (Matr4 *)xfm);

	if (FLDset_xform (out, (float *)xfm) != 1) {
		ERR_RETURN("Error setting xform");
	}
	if (FLDset_node_data_ncomp (out, nmap_comp) != 1) {
		ERR_RETURN("Error setting nnode_data");
	}

	if (FLDget_nnodes (out, &nnodes) != 1) {
		ERR_RETURN("Error getting nnodes");
	}
	for (comp=0; comp<nmap_comp; comp++) {
		if (FLDget_node_data_units(in, map_comp[comp],
					   units, MAX_NAME_SIZE) != 1) {
			strcpy(units, "");
		}
		if (FLDget_node_data_label(in, map_comp[comp],
					   label, MAX_NAME_SIZE) != 1) {
			strcpy(label, "");
		}
		if (FLDget_node_data_veclen(in, map_comp[comp], &veclen) != 1) {
			ERR_RETURN("Error getting veclen");
		}
		if (FLDset_node_data_comp (out, comp, veclen, label, units) != 1) {
			ERR_RETURN("Error setting node component");
		}
		if (FLDget_node_null_data(in, map_comp[comp], &null_flag,
					  (char *)&null_value) != 1) {
			ERR_RETURN("cannot get null data");
		}
		if (FLDget_node_data_id(in, map_comp[comp], &data_id) == 1)
			FLDset_node_data_id(out, comp, data_id);

		if (FLDcopy_node_minmax(in, out, map_comp[comp], comp) != 1) {
			ERR_RETURN("Error copying node minmax");
		}
		if (FLDcopy_node_minmax_vec(in, out, map_comp[comp], comp) != 1) {
			ERR_RETURN("Error copying node minmax");
		}
		if (FLDget_node_data_type(in, map_comp[comp], &type) != 1) {
			ERR_RETURN("Error copying node minmax");
		}
		if (FLDget_node_data(in, map_comp[comp], &data_type, &node_data,
				     &size, OM_GET_ARRAY_RD) != 1) {
			ERR_RETURN("cannot get node data");
		}

		if (FLDget_node_data(out, comp, &data_type, &out_node_data,
				     &size, OM_GET_ARRAY_WR) != 1) {
			ERR_RETURN("Error setting node data");
		}
		UTILeval_param(nnodes, veclen, data_type, node_data, null_flag,
			       (char *)(&null_value),  min_node, max_node,
			       t, out_node_data);
		if (out_nnodes < out_dims[0]*out_dims[1]) {
			if (null_flag) {
				UTILtype_to_double(&new_null_value, (char *)&null_value, data_type);
			}
			else {
				if (FLDget_node_data_minmax(in, map_comp[comp],
							    (char *)&min, (char *)&max) != 1) {
					ERR_RETURN("Error getting node minmax");
				}
				if (veclen == 1) {
					UTILtype_to_double(&new_null_value, (char *)&max, data_type);
					++new_null_value;
				}
				else
					new_null_value = 0;
			}
			UTILthreshold(nnodes, list, 1, 0, DTYPE_CHAR,
				      0, (char *)&null_value,
				      1, (double)1, 0, (double)1,
				      out_node_data, veclen, data_type,
				      new_null_value, out_node_data);
			UTILdouble_to_type(&new_nv, new_null_value, data_type);
			if (FLDset_node_null_data(out, comp, (char *)&new_nv, data_type) != 1) {
				ERR_RETURN("Error setting null value");
			}
		}
		else {
			if (null_flag) {
				if (FLDset_node_null_data(out, comp,
							  (char *)&null_value, data_type) != 1) {
					ERR_RETURN("Error setting null value");
				}
			}
			else {
				if (FLDset_node_null_flag(out, comp, 0) != 1) {
					ERR_RETURN("Error setting null flag");
				}
			}
		}
		ARRfree(node_data);
		ARRfree(out_node_data);
	}
	FLDfree_mesh_info(mesh_info);
	ARRfree(list);
	ARRfree(dims);
	if (min_node)
		ARRfree(min_node);
	if (max_node)
		ARRfree(max_node);
	if (t)
		ARRfree(t);
	if (pnts)
		ARRfree(pnts);
	return(1);
}
