/*
			Copyright (c) 1996 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/modules/surf_opt.c#1 $
*/

#include <string.h>

#define XP_WIDE_API	/* Use Wide APIs */
#include <avs/util.h>
#include <avs/err.h>
#include <avs/om.h>
#include <avs/dtype.h>
#include <avs/fld.h>
#include <avs/arr.h>
#include <avs/dv_util.h>

#define MAX_NAME_SIZE 1024

#define ERR_RETURN(A) \
	ERRerror( "DVsurf_optimize_update", 0, ERR_ORIG, A ); return( 0 );


/* 64-bit porting. Only Modified Internally */
int DVsurf_optimize_update(OMobj_id elem_id)
{
	OMobj_id in, out, e_id, cell_set;
	double   eps;
	int      stat, nspace, dtype, veclen, dims_size;
	xp_long  *dims, size, nnodes, ntri, *conn;
	int      data_id;
	char  *data, *out_data;
	float *points, *coord;
	char  label[MAX_NAME_SIZE], units[MAX_NAME_SIZE];

	in  = OMfind_subobj(elem_id, OMstr_to_name("in"), OM_OBJ_RD);

	out = OMfind_subobj(elem_id, OMstr_to_name("out"), OM_OBJ_RW);

	e_id = OMfind_subobj(elem_id,OMstr_to_name("tolerance"),OM_OBJ_RD);
	OMget_real_val(e_id, &eps);
	if (eps < 0)
		eps = -eps;

	if (FLDset_nnodes(out, 0) != 1) {
		ERR_RETURN("cannot get nnodes");
	}
	if (FLDset_node_data_ncomp (out, 0) != 1) {
		ERR_RETURN("Error setting nnode_data");
	}
	if (FLDset_ncell_sets(out, 0) != 1) {
		ERR_RETURN("cannot set nsets");
	}

	if (FLDget_dims (in, &dims, &dims_size) != 1) {
		ERR_RETURN("Error getting dims");
	}
	if (FLDget_nspace(in, &nspace) != 1) {
		ERR_RETURN("cannot get nspace");
	}
	if (FLDget_points(in, &points, &size, OM_GET_ARRAY_RD) != 1) {
		ERR_RETURN("cannot get coordinates");
	}


	if (FLDget_node_data_veclen(in, 0, &veclen) !=1) {
		ERR_RETURN("Error getting veclen");
	}

	if (veclen != 1) {
		ERR_RETURN("data component is not scalar, optimization is not performed");
	}

	if (FLDget_node_data(in, 0, &dtype, &data, &size, OM_GET_ARRAY_RD) != 1) {
		ERR_RETURN("cannot get node data");
	}

	stat = UTILoptimize_surface(dims, nspace, points, dtype, data, eps,
				    &nnodes, &coord, &ntri, &conn, &out_data);
	if (stat != 1) {
		ERR_RETURN("cannot optimize surface");
	}

	if (FLDset_nspace (out, nspace) != 1) {
		ERR_RETURN("Error setting nspace");
	}
	if (FLDset_nnodes (out, nnodes) != 1) {
		ERR_RETURN("Error setting nnodes");
	}
	if (FLDadd_cell_set(out, "Tri") != 1) {
		ERR_RETURN("Error setting cell type");
	}
	if (FLDget_cell_set(out, 0, &cell_set) != 1) {
		ERR_RETURN("Error getting cell set");
	}
	if (FLDset_ncells(cell_set, ntri) != 1) {
		ERR_RETURN("Error setting ncells");
	}
	if (FLDset_node_connect(cell_set, conn, ntri*3,
				OM_SET_ARRAY_FREE) != 1) {
		ERR_RETURN("Error setting cell connect list");
	}
	if (FLDset_coord(out, coord, nspace*nnodes, OM_SET_ARRAY_FREE) != 1) {
		ERR_RETURN("Error setting coord");
	}

	if (FLDset_node_data_ncomp (out, 1) != 1) {
		ERR_RETURN("Error setting nnode_data");
	}
	if (FLDget_node_data_units(in, 0, units, MAX_NAME_SIZE) != 1) {
		strcpy(units, "");
	}
	if (FLDget_node_data_label(in, 0, label, MAX_NAME_SIZE) != 1) {
		strcpy(label, "");
	}
	if (FLDset_node_data_comp (out, 0, 1, label, units) != 1) {
		ERR_RETURN("Error setting node component");
	}
	if (FLDcopy_node_minmax(in, out, 0, 0) != 1) {
		ERR_RETURN("Error copying node minmax");
	}
	if (FLDcopy_node_minmax_vec(in, out, 0, 0) != 1) {
		ERR_RETURN("Error copying node minmax");
	}
	if (FLDget_node_data_id(in, 0, &data_id) == 1)
		FLDset_node_data_id(out, 0, data_id);

	if (FLDset_node_data(out, 0, (char *)out_data, dtype,
			     nnodes, OM_SET_ARRAY_FREE) != 1) {
		ERR_RETURN("Error setting node data");
	}

	ARRfree(points);
	ARRfree(dims);
	ARRfree(data);
	return(1);
}
