/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/modules/thresh0.c#1 $
*/

#define XP_WIDE_API	/* Use Wide APIs */

#include <avs/util.h>
#include <avs/err.h>
#include <avs/om.h>
#include <avs/fld.h>
#include <avs/arr.h>
#include <avs/dv_util.h>

#define ERR_RETURN(A) ERRerror("thresh_null", 0, ERR_ORIG, A); return(0);
#define MAX_NAME_SIZE 1024

int FUNCthresh_null (OMobj_id in, int comp, OMobj_id out, int *copy_in);

int DVthresh_null_update(OMobj_id elem_id)
{
	OMobj_id in, out, out_link, comp_id;
	int stat, comp, copy_in;

	in = OMfind_subobj(elem_id, OMstr_to_name("in"), OM_OBJ_RD);
	out = OMfind_subobj(elem_id, OMstr_to_name("out_thresh"), OM_OBJ_RW);
	out_link = OMfind_subobj(elem_id, OMstr_to_name("out"), OM_OBJ_RW);

	comp_id = OMfind_subobj(elem_id, OMstr_to_name("thresh_component"),
				      OM_OBJ_RW);
	OMget_int_val(comp_id, &comp);

	FUNCthresh_null(in, comp, out, &copy_in);
	if (copy_in) {
		stat = OMset_obj_ref(out_link, in, 0);
		if (stat != 1) {
			ERR_RETURN("Error setting out reference");
		}
	}
	else {
		stat = OMset_obj_ref(out_link, out, 0);
		if (stat != 1) {
			ERR_RETURN("Error setting out reference");
		}
	}
	return stat;
}

/* 64-bit porting. Only Modified Internally */
int FUNCthresh_null (OMobj_id in, int comp, OMobj_id out, int *copy_in)
{
	int   i, data_type, data_id, veclen, ncomp, null_flag;
	xp_long nnodes, *out_ncells1, *conn_size1, size;
	xp_long **out_clist1, **out_nlist1;
	int   stat, nspace, nsets, ns;
	xp_long *old_nlist, old_nnodes;
	char  cell_name[MAX_NAME_SIZE], units[MAX_NAME_SIZE], label[MAX_NAME_SIZE];
	float  *out_coord;
	char   *node_data, *out_node_data;
	char   *mesh_info;
	double null_value;
	OMobj_id   cell_set;

	if (FLDget_nnodes(in, &nnodes) != 1) {
		ERR_RETURN("Error getting nnodes");
	}
	if (FLDget_node_data_ncomp(in, &ncomp) != 1) {
		ERR_RETURN("Error getting ncomp");
	}
	if (comp >= ncomp) {
		if (FLDset_nnodes(out, 0) != 1) {
			ERR_RETURN("cannot set nnodes");
		}
		if (FLDset_ncell_sets(out, 0) != 1) {
			ERR_RETURN("cannot set nsets");
		}
		if (FLDset_node_data_ncomp (out, 0) != 1) {
			ERR_RETURN("Error setting nnode_data");
		}
		ERR_RETURN("bad component number, threshold is not performed");
	}
	if (ncomp>0) {
		if (FLDget_node_data_veclen(in, comp, &veclen) !=1) {
			ERR_RETURN("Error getting veclen");
		}
		if (veclen != 1) {
			ERR_RETURN("component is not scalar, threshold is not performed");
		}

		if (FLDget_node_null_data(in, comp, &null_flag, (char *)&null_value) != 1) {
			ERR_RETURN("cannot get null data");
		}
		if (null_flag == 0) {
			*copy_in = 1;
			if (FLDset_nnodes (out, 0) != 1) {
				ERR_RETURN("Error setting nnodes");
			}
			if (FLDset_node_data_ncomp (out, 0) != 1) {
				ERR_RETURN("Error setting nnode_data");
			}
			if (FLDset_ncell_sets(out, 0) != 1) {
				ERR_RETURN("cannot set nsets");
			}
			return(1);
		}
		else {
			*copy_in = 0;
		}

		if (FLDget_node_data(in, comp, &data_type, &node_data,
				     &size, OM_GET_ARRAY_RD) != 1) {
			ERR_RETURN("cannot get node data");
		}
	}
	if (FLDget_ncell_sets(in, &nsets) != 1) {
		ERR_RETURN("Error getting nsets");
	}
	if (FLDset_ncell_sets(out, 0) != 1) {
		ERR_RETURN("cannot set nsets");
	}
	/* Cell list, per cell set, after thresholding */
	out_clist1 = (xp_long **)calloc(nsets, sizeof(xp_long *));
	/* Number of cells, per cell set, after thresholding */
	out_ncells1 = (xp_long *)malloc(nsets*sizeof(xp_long));
	/* Connection list, per cell set, after thresholding */
	out_nlist1 = (xp_long **)malloc(nsets*sizeof(xp_long *));
	/* Size of connection list, per cell set, after thresholding */
	conn_size1 = (xp_long *)malloc(nsets*sizeof(xp_long));
	if (out_clist1 == NULL || out_ncells1 == NULL ||
            out_nlist1 == NULL || conn_size1 == NULL) {
		ERR_RETURN("cannot allocate cell lists");
	}
	stat = FLDget_mesh_info(in, &mesh_info);
	if (!stat) {
		ERR_RETURN("cannot create cell table");
	}
	if (ncomp>0){
		stat = UTILthresh_null(mesh_info, node_data, data_type,
				       (char *)&null_value,
				       &old_nnodes, &old_nlist,
				       nsets, out_clist1, out_ncells1,
				       out_nlist1, conn_size1);
		if (!stat) {
			ERR_RETURN("cannot thresh_null cells");
		}
	}
	else {
		for (i=0; i<nsets; i++) {
			if (FLDget_cell_set(in, i, &cell_set) != 1) {
				ERR_RETURN("cannot get cell set");
			}
			if (FLDget_ncells(cell_set, (&out_ncells1[i])) != 1) {
				ERR_RETURN("Error getting ncells");
			}
			if (FLDget_node_connect(cell_set, &(out_nlist1[i]), &(conn_size1[i]),
						OM_GET_ARRAY_RD) != 1) {
				ERR_RETURN("Error getting cell connect list");
			}
		}
	}
	ARRfree(node_data);
	node_data = NULL;
	/*** OUTPUT MESH ***/
	for (ns=0,i=0; i<nsets; i++) {
		if (out_ncells1[i] != 0) {
			if (FLDget_cell_set(in, i, &cell_set) != 1) {
				ERR_RETURN("cannot get cell set");
			}
			if (FLDget_cell_set_name(cell_set, cell_name, MAX_NAME_SIZE) != 1) {
				ERR_RETURN("Error getting set name");
			}
			if (FLDadd_cell_set(out, cell_name) != 1) {
				ERR_RETURN("Error adding cell set");
			}
			if (FLDget_cell_set(out, ns++, &cell_set) != 1) {
				ERR_RETURN("Error getting cell set");
			}
			if (FLDset_ncells(cell_set, out_ncells1[i]) != 1) {
				ERR_RETURN("Error setting ncells");
			}
			if (FLDset_node_connect(cell_set, out_nlist1[i], conn_size1[i],
						OM_SET_ARRAY_FREE) != 1) {
				ERR_RETURN("Error setting cell connect list");
			}
			/* Possibly add copy over cell data here */
			if (out_clist1[i]) ARRfree(out_clist1[i]);
		}
	}
	/*** OUTPUT FIELD ***/
	if (FLDset_nnodes (out, old_nnodes) != 1) {
		ERR_RETURN("Error setting nnodes");
	}
	if (FLDget_coord_units(in, units, MAX_NAME_SIZE) == 1) {
		if (FLDset_coord_units (out, units) != 1) {
			ERR_RETURN("Error setting units");
		}
	}
	if (FLDget_nspace (in, &nspace) != 1) {
		ERR_RETURN("Error setting nspace");
	}
	if (FLDset_nspace (out, nspace) != 1) {
		ERR_RETURN("Error setting nspace");
	}
	if (FLDget_coord(out, &out_coord, &size, OM_GET_ARRAY_WR) != 1) {
		ERR_RETURN("Error setting coordinate array");
	}
	if (old_nnodes) {
		UTILget_coord_list(mesh_info, old_nnodes, old_nlist, out_coord);
	}


	if (FLDset_node_data_ncomp (out, ncomp) != 1) {
		ERR_RETURN("Error setting nnode_data");
	}
	if (out_coord) ARRfree(out_coord);
	for (comp=0; comp<ncomp; comp++) {
		if (FLDget_node_data_units(in, comp, units, MAX_NAME_SIZE) != 1) {
			strcpy(units, "");
		}
		if (FLDget_node_data_label(in, comp, label, MAX_NAME_SIZE) != 1) {
			strcpy(label, "");
		}
		if (FLDget_node_data_veclen(in, comp, &veclen) != 1) {
			ERR_RETURN("Error getting veclen");
		}
		if (FLDset_node_data_comp (out, comp, veclen, label, units) != 1) {
			ERR_RETURN("Error setting node component");
		}
		if (FLDcopy_node_minmax(in, out, comp, comp) != 1) {
			ERR_RETURN("Error copying node minmax");
		}
		if (FLDcopy_node_minmax_vec(in, out, comp, comp) != 1) {
			ERR_RETURN("Error copying node minmax");
		}
		if (FLDget_node_data_id(in, comp, &data_id) == 1)
			FLDset_node_data_id(out, comp, data_id);

		if (FLDget_node_data(in, comp, &data_type, &node_data,
				     &size, OM_GET_ARRAY_RD) != 1) {
			ERR_RETURN("cannot get node data");
		}

		if (FLDget_node_data(out, comp, &data_type, &out_node_data,
				     &size, OM_GET_ARRAY_WR) != 1) {
			ERR_RETURN("Error setting node data");
		}
		size = UTILget_data_list(mesh_info, data_type, veclen, node_data,
					 old_nnodes, old_nlist, out_node_data);
		if (FLDget_node_null_data(in, comp, &null_flag, (char *)&null_value) != 1) {
			ERR_RETURN("cannot get null data");
		}
		if (null_flag) {
			if (FLDset_node_null_data(out, comp, (char *)&null_value, data_type) != 1) {
				ERR_RETURN("Error setting null value");
			}
		}
		else {
			if (FLDset_node_null_flag(out, comp, 0) != 1) {
				ERR_RETURN("Error setting null flag");
			}
		}
		ARRfree(node_data);
		if (out_node_data) ARRfree(out_node_data);
	}
	FLDfree_mesh_info(mesh_info);

	free(out_clist1);
	free(out_ncells1);
	free(out_nlist1);
	free(conn_size1);
	if (old_nlist)
		free(old_nlist);
	return(1);
}
