//			Copyright (c) 1998 by
//			Advanced Visual Systems Inc.
//			All Rights Reserved
//
//	This software comprises unpublished confidential information of
//	Advanced Visual Systems Inc. and may not be used, copied or made
//	available to anyone, except in accordance with the license
//	under which it is furnished.
//
//	This file is under Perforce control
//	$Id: //depot/express/fcs70/motif_ui/UIcursor.cxx#1 $
//

#include <stdio.h>

#define XP_WIDE_API	/* Use Wide APIs */
#include <sys/types.h>  /* time_t */
#include <avs/f_utils.h>
#include <avs/util.h>

#include <X11/cursorfont.h>
#include "ui/cursor.h"
#include "ui/cursornames.h"

int forceUpdate = -1;

// NOTE: All code in this module should be platform (UNIX vs WINDOWS) independent
// All GUI dependent code goes in the appropriate platform module i.e. UICursorP.cxx

/////////////////////////////// UIcursor Class methods //////////////////////

int
UIcursor::init(OMevent_mask, int)
{
   return 1;
}

int
UIcursor::update(OMevent_mask, int seq_num)
{
   // Get the platform dependent class
   UIcursorP *cursorP = (UIcursorP *)ret_class_ptr("UIcursorP");

   // Check Colors changed
   if( color.foregroundColor.changed(seq_num) ||
       color.backgroundColor.changed(seq_num) ) {
      // Change cursor color
      cursorP->recolorCursor( color );
   }

   cursorP->attachCursor( attach_cursor );

   // return 1 for success
   return(1);
}

//////////////////////// UIfontCursor Class methods /////////////////////////////

int
UIfontCursor::init(OMevent_mask, int)
{
    if( cursor_name.valid_obj() ) {
        UtString tmpName((char *)cursor_name);
        for( int i=0; i < XC_num_glyphs/2; i++ ) {
            if( tmpName == cursorNames[i] ) {
                font_index = i*2;
                break;
            }
        }
    }
    else if( font_index.valid_obj() ) {
        int name_index = font_index / 2; // Divide the index by 2
        if( (name_index >= 0) && (name_index < XC_num_glyphs/2) ) {
            cursor_name = cursorNames[name_index].c_str();
        }
        else {
            name_index = 0;
        }
        font_index = name_index * 2;
    }

   // return 1 for success
   return(1);
}

int
UIfontCursor::update(OMevent_mask event_mask, int seq_num)
{
   // Get the platform dependent class
   UIfontCursorP *cursorP = (UIfontCursorP *)ret_class_ptr("UIfontCursorP");

   if( cursor_name.changed(seq_num) ) {
       UtString tmpName((char *)cursor_name);
       for( int i=0; i < XC_num_glyphs/2; i++ ) {
           if( tmpName == cursorNames[i] ) {
               font_index = i*2;
               break;
           }
       }
   }
   else if( font_index.changed(seq_num) ) {
       int name_index = font_index / 2; // Divide the index by 2
       if( (name_index >= 0) && (name_index < XC_num_glyphs/2) ) {
           cursor_name = cursorNames[name_index].c_str();
       }
       else {
           name_index = 0;
       }
       font_index = name_index * 2;
   }

   cursorP->createCursor( font_index, color );

   // return 1 for success
   return UIcursor::update( event_mask, seq_num );
}

//////////////////////////// UIpixmap Class method ////////////////////////////

int
UIpixmapCursor::init(OMevent_mask, int)
{
   // return 1 for success
   return(1);
}

int
UIpixmapCursor::update(OMevent_mask event_mask, int seq_num)
{
   // Get the platform dependent class
   UIpixmapCursorP *cursorP = (UIpixmapCursorP *)ret_class_ptr("UIpixmapCursorP");

   // Check if cursor_pixmap value changed
   if( (seq_num == forceUpdate) ||
       cursor_pixmap.changed( seq_num ) ||
       mask_pixmap.changed( seq_num ) ) {

       if( cursor_pixmap.filename.valid_obj() ) { // Check valid filename
           UtString suffix;
           if( cursor_pixmap.fileType.valid_obj() ) {
               suffix = cursor_pixmap.fileType;
               if( suffix == "x_bitmap" ) { // X bitmaps
                   cursorP->createCursor( cursor_pixmap, mask_pixmap, color );
                   x = (cursorP->_x_hot) ? cursorP->_x_hot : 0;
                   y = (cursorP->_y_hot) ? cursorP->_y_hot : 0;
                   width = cursorP->_width;
                   height = cursorP->_height;
               }
               else {
                   fprintf( stderr, "UIpixmapCursor::update, Error in fileType\n" );
               }
           }
           // This value doesn't seem to be used for anything.
           // Whats the point?
           //suffix = FILEget_file_extension( cursor_pixmap.filename );
       }
   }

   // return 1 for success
   return UIcursor::update( event_mask, seq_num );
}
