/*
			Copyright (c) 1995 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/motif_ui/ui/UIcursorP.h#1 $
*/
//-*-Mode: C++;-*-
#ifndef _UIcursorP_h_
#define _UIcursorP_h_
#include "core.h"

class UIcursor;

//---- UIcursorP -----------------------------------------------------------

class UIcursorP {
  public:
	UIcursorP() : _handle(0), _cursor(0) {}
	virtual ~UIcursorP() {}

	virtual void		recolorCursor( UIcolor &);
	void			reg_handle( UIwinHandle *, UIcursor *);
	void			attachCursor( int );
	Cursor&			cursor() { return _cursor; };

  protected:
	int			setCursorColors( UIcolor &color );
	UIwinHandle *		_handle;
	Cursor			_cursor;
	XColor			_fgXcolor, _bgXcolor; // Foreground and background Xcolors
};

//---- UIfontCursorP -----------------------------------------------------------

class UIfontCursorP : public UIcursorP {
  public:
	void			createCursor( int index, UIcolor &color );
};

//---- UIpixmapCursorP -----------------------------------------------------------

class UIpixmapCursorP : public UIcursorP {
  friend class UIpixmapCursor;
  public:
	void createCursor( UIpixmap &pixmap, UIpixmap &maskpixmap, UIcolor &color );

  protected:
	int			_x_hot, _y_hot; // Hot spot position in bitmap
	unsigned int		_width, _height; // Size of bitmap cursor
};

#endif
