/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/motif_ui/ui/ui.h#1 $
*/

#ifndef _ui_h
#define _ui_h

#include <X11/Intrinsic.h>
#include <X11/IntrinsicP.h>
#include <Xm/Xm.h>

#include <avs/om.h>
#ifdef assert
#undef assert
#endif

#ifndef CXXUTIL_STRING_HXX
#include <avs/cxxutl/string.hxx>
#endif

// Typedefs
typedef UtString ClassType; // For now use string identifier = class name, i.e "UIwindow"
typedef const OMobj_id & ObjDefType;

// Forward class declarations
class UIwindow;

// Defines
// Widget States

#define UINORMAL_STATE              0
#define UIREBUILD_STATE             1
#define UILAYOUT_INSERT_STATE       2

// UI Error States

#define UIERROR_STATE_NORMAL        0
#define UIERROR_STATE_ERROR         1
#define UIDIALOG_ERROR_LOCK         100

//-------- Object Manager Access Macros ----------------------------------

inline const OMobj_id
FindSubObj( ObjDefType id, const char *name, int mode = OM_OBJ_RW )
{
	return OMfind_subobj(id, OMstr_to_name(name), mode);
}

#define GetIntVal(Id, Name, Val)	\
	OMget_int_val(OMfind_subobj(Id,OMstr_to_name(Name),OM_OBJ_RD), Val)


#define SetIntVal(Id, Name, Val)	\
	OMset_int_val(OMfind_subobj(Id,OMstr_to_name(Name),OM_OBJ_RW), Val)


#define GetPtrVal(Id, Name, Val)	\
	OMget_ptr_val(OMfind_subobj(Id,OMstr_to_name(Name),OM_OBJ_RD), (void **)Val, 0)


#define SetPtrVal(Id, Name, Val)	\
	OMset_ptr_val(OMfind_subobj(Id,OMstr_to_name(Name),OM_OBJ_RW), (void *)Val, 0)


#define GetRealVal(Id, Name, Val)	\
	OMget_real_val(OMfind_subobj(Id,OMstr_to_name(Name),OM_OBJ_RD),Val)


#define SetRealVal(Id, Name, Val)	\
	OMset_real_val(OMfind_subobj(Id,OMstr_to_name(Name),OM_OBJ_RW),Val)


#define GetStrVal(Id, Name, Val, Len)	\
	OMget_str_val(OMfind_subobj(Id,OMstr_to_name(Name),OM_OBJ_RD), \
			Val, Len)

#define SetStrVal(Id, Name, Val)	\
	OMset_str_val(OMfind_subobj(Id,OMstr_to_name(Name),OM_OBJ_RW),Val)

inline int
GetSeqNum( ObjDefType Id, const char * Name, int mode = 0 )
{
	ObjDefType subId = FindSubObj(Id, Name, OM_OBJ_RD);
	if( OMis_null_obj( subId ) )
		return OM_STAT_ERROR;
	else
		return OMget_obj_seq(subId, OMnull_obj, mode );
}

inline int
GetMaxSeqNum(ObjDefType Id, const char * Name)
{
	return GetSeqNum( Id, Name, OM_SEQ_VAL );
}

inline int
GetPtrSeqNum(ObjDefType Id, const char * Name)
{
	return GetSeqNum( Id, Name, OM_SEQ_PTRS );
}

//-------- Mouse Button Action defines ---------------------------------

#define cLeftButtonDown		0x1
#define cMiddleButtonDown	0x2
#define cRightButtonDown	0x3
#define cLeftButtonMotion	0x4
#define cMiddleButtonMotion	0x5
#define cRightButtonMotion	0x6
#define cLeftButtonUp		0x7
#define cMiddleButtonUp		0x8
#define cRightButtonUp		0x9

#define cShift			0x100
#define cControl		0x200
#define cAlt			0x400

// Forward references
extern Widget DefaultHiddenShell;
extern Boolean UIoffScreen;

void UIsetOMWindowX(ObjDefType ,int);
void UIsetOMWindowY(ObjDefType ,int);
void UIsetOMWindowWidth(ObjDefType ,int);
void UIsetOMWindowHeight(ObjDefType ,int);

Boolean UIgetOMWindowX(ObjDefType ,int *);
Boolean UIgetOMWindowY(ObjDefType ,int *);
Boolean UIgetOMWindowWidth(ObjDefType ,int *);
Boolean UIgetOMWindowHeight(ObjDefType ,int *);

// Some identity functions
Boolean UIisWorkAreaChild(Widget);
Boolean UIisAncestorOf(Widget hWnd, Widget Ancestor);
Boolean UIisDescendentOf(Widget hWnd, Widget Descendent);
Boolean UIisOptionBox(ObjDefType);
Boolean UIisOptionMenu(ObjDefType);
Boolean UIisApp(ObjDefType);
Boolean UIisShell(ObjDefType);
Boolean UIisTemplateDialog(ObjDefType);
Boolean UIisPanel(ObjDefType);
Boolean UIisRowColumn(ObjDefType);
Boolean UIisScrolledWindow(ObjDefType);
Boolean UIisFrame(ObjDefType);
Boolean UIisRadioBox(ObjDefType);
Boolean UIisDial(ObjDefType);
Boolean UIisSlider(ObjDefType);
Boolean UIisBeingDestroyed(Widget);

// Geometry Management Convenience Functions

// Gets the global normalized scaling factors

void UIgetScaleXY(double *, double *);

// Combination functions that set actual position and OM objects

// These set the x, y, width, and height subobjects

void UIupdateOMRequestedWindowPos(Widget, int, int, int);
void UIupdateOMRequestedWindowSize(Widget, int, int, int);
void UIupdateOMRequestedWindowPosSize(Widget, int, int, int, int, int);

// Global visual error handler

void UIerrorHandler(unsigned char, ObjDefType, const char *);

Widget UIfindNearestMainWindowAncestor(Widget);

// Default text height
// height of 12 agrees with NE default
// turn this into a resource eventually

#define UI_TEXT_HEIGHT 12

// Forward declaration for resources

void UIsetCoreResources(ObjDefType,Widget,int);

// Convenience functions for UI subobjects

Widget UIobjIdToWidget(ObjDefType);
ObjDefType UIwidgetToObjId(Widget);
UIwindow *UIobjIdToClass(ObjDefType);
UIwindow *UIwidgetToClass(Widget);
// Convenience functions
void UIdestroyWidget( Widget );
void SetParent(Widget, Widget);

// This function will disable the default translation that causes
// MB 2 to cause drag and drop functionality
// This function should be called right after widget creation
void DragAndDropDisable(Widget);

OMobj_id UIcreate_obj_from_str(const char *, const char *, int *);

#endif
