#!/bin/sh
#*************************************************************************
#
#	Copyright (c) Advanced Visual Systems, Inc., 1996
#                     All Rights Reserved.  Unpublished rights reserved 
#                     under the copyright laws of the United States
#
#  The software contained on this media is proprietary to and embodies
#  the confidential technology of Advanced Visual Systems, Inc..
#  Possession, use, duplication or dissemination of the software and
#  media is authorized only pursuant to a valid written license from
#  Advanced Visual Systems, Inc..
#
#  RESTRICTED RIGHTS LEGEND  Use, duplication, or disclosure by the
#  U.S. Government is subject to restrictions as set forth in 
#  Subparagraph (c) (1) (ii) of DFARS 252.227-7013, or in FAR 52.227-19,
#  as applicable.
#
#	This file is under Perforce control
#	$Id: install.sh,v 1.2 2005/01/28 17:08:32 zzcgujp Exp $
#
#*************************************************************************
#
PRODUCT_SET="AVS/Express"
#
RELEASE="$PRODUCT_SET Parallel Support Toolkit V0.1"
PRODUCT="$PRODUCT_SET Parallel Support Toolkit"
OPTION="PST Kit"
SUBSETNAME=`basename $0 .scp`
#
YEAR="2005"
#
VERSION="V0.1"
#
#
#----------------------------------------------------
#	GENERAL UTILITY ROUTINES
#----------------------------------------------------

:	-ShowMsg
#		Displays formatted user notification
#	given:  $1 - notification message string
#                 does:   Display product name then message
#                 return: NIL

ShowMsg()
{
	echo ""
	echo "$RELEASE"
	echo "$OPTION $1"
}

#------------------------------------------------------
#                  BEGIN EXECUTION HERE
#------------------------------------------------------
 cat << !EOF!


  Installing $PRODUCT_SET ($SUBSETNAME)...

      $RELEASE
      Copyright (c) Advanced Visual Systems, Inc., $YEAR.
      All Rights Reserved.  Unpublished rights reserved
      under the copyright laws of the United States.

      Possession, use, or copying of the software and
      media is authorized only pursuant to a valid written
      license from Advanced Visual Systems, Inc..

      RESTRICTED RIGHTS LEGEND   Use, duplication, or
      disclosure by the U.S. Government is subject to
      restrictions as set forth in Subparagraph (c)(1)(ii)
      of DFARS 252.227-7013, or in FAR 52.227-19, as
      applicable.

!EOF!


#------------------------------------------------------
#  First determine the platform that is doing the installation. 
#------------------------------------------------------

UNAME=`uname -s`

if [ "$UNAME" = "SunOS" ] ; then
    VERSION=`uname -r | sed -e 's/\..*$//'`
    if [ "$VERSION" = "5" ] ; then
	MINOR_VERSION=`uname -r | cut -f2 -d"."`
	if [ "$MINOR_VERSION" = "8" ] ; then
            if [ $MACHINE ]  && [ `isainfo -b` = "64" ] ; then
                # s8 or s8_64
                TYPE=$MACHINE
            else
                TYPE=s8
            fi
        else
            TYPE=s7
	fi
    else
        #TYPE=sun
        echo SunOS 4.X is no longer supported
	exit 1;
    fi

elif [ "$UNAME" = "HP-UX" ] ; then
    echo HP-UX is not supported
    exit 1;

elif [ "$UNAME" = "Linux" ] ; then
# IAC/PST: Test for IA64 platforms
    HW=`uname -i | grep -ci ia64`
    if [ "$HW" -ge 1 ] ; then 
	echo Linux IA64 detected
	TYPE=linux_ia64
    else
# use the compiler to make a guess as to which version of Red Hat
	COMPILER_VERSION=`gcc --version | grep -c 3.2`
	if [ "$COMPILER_VERSION" -ge 1 ] ; then
	    echo Red Hat 8.0 or compatible detected
	    TYPE=linux
	else
	    COMPILER_VERSION=`gcc --version | grep -c 2.96`
	    if [ "$COMPILER_VERSION" -ge 1 ] ; then
		echo Red Hat 7.0 or compatible detected
		TYPE=linux_rh7
	    else
		echo Unknown C compiler, assuming platform Linux Red Hat 8.0 or compatible
		TYPE=linux
	    fi
	fi
    fi

elif [ "$UNAME" = "IRIX" ] ; then
    TYPE=sgN32
elif [ "$UNAME" = "IRIX64" ] ; then
    if [ $MACHINE ] ; then
        # sgN32 or sg6
        TYPE=$MACHINE
    else
        TYPE=sg6
    fi
elif [ "$UNAME" = "AIX" ] ; then
    echo AIX is not supported
    exit 1;

elif [ "$UNAME" = "OSF1" ] ; then
    echo OSF1 is not supported
    exit 1;

else
    cat << !EOF!

  There is a problem attempting to verify the system archectiture.
  When installing AVS/Express $OPTION ($SUBSETNAME) this operating
  system is not supported.
!EOF!
    ShowMsg "installation failed !"
    exit 1;
fi

# PST: Use the MPI compiler scripts on linux (see call to 'make' later)
if [ "$TYPE" = "linux" ] ; then
    CCENV="CC=mpicc CXX=mpiCC"
else
    CCENV=
fi

#------------------------------------------------------
#  Check if  XP_ROOT is defined
#------------------------------------------------------
        if [ $XP_ROOT ]
        then
           echo "     "
       else
           echo "     "
           echo "     Installation cannot find required XP_ROOT environmental variable."
           echo "     Please check if  the environmental variable  (XP_ROOT) is set correctly."
           ShowMsg "installation failed !"
           exit 1;
        fi


#------------------------------------------------------
#  Show the user where XP_ROOT is currently defined to....
#  Ask user if this is correct.  If not correct, then script will exit with warning.
#------------------------------------------------------
   echo "      "
   echo "   The environmental variable for XP_ROOT is currently set to $XP_ROOT"
   echo "   Is this the correct setting for XP_ROOT [n]?"
   read RESPONSE
   if [ "$RESPONSE" != "y" ] && [ "$RESPONSE" != "Y" ] ; then
     echo "   Please set XP_ROOT to the correct setting and re-run this installation."
    ShowMsg "Incorrect setting for XP_ROOT"
     exit 0
  fi



#------------------------------------------------------
#  Next ask the user if they want to save current Express image
#------------------------------------------------------
  echo "   Do you want to save current version of AVS/Express [n]?"
  read RESPONSE
  if [ "$RESPONSE" = "y" ] || [ "$RESPONSE" = "Y" ] ; then
        if [ -f $XP_ROOT/bin/$TYPE/express ]
        then
          mv $XP_ROOT/bin/$TYPE/express $XP_ROOT/bin/$TYPE/express_old
          SAVE=1
        else
          SAVE=0
        fi
  fi



#------------------------------------------------------
#  Check if the Config.h file exists prior to editing
#------------------------------------------------------
        if [ -f $XP_ROOT/include/$TYPE/config.h ]
        then
           cp   $XP_ROOT/include/$TYPE/config.h     $XP_ROOT/include/$TYPE/config_old.h
       else
           echo "     "
           echo "     Installation cannot find required $PRODUCT  $XP_ROOT/include/$TYPE/config.h"
           echo "     Please check if  $PRODUCT is installed and the environmental variable"
           echo "     (XP_ROOT) is set correctly."
           ShowMsg "installation failed !"
           if [ "$SAVE" = "1" ] && [ -f $XP_ROOT/bin/$TYPE/express_old ]
           then
              mv -f $XP_ROOT/bin/$TYPE/express_old $XP_ROOT/bin/$TYPE/express
           fi
           exit 1;
        fi


#------------------------------------------------------
#  Update/EDIT the Config.h file with PST flag
#------------------------------------------------------

echo "#define PST_KIT" | cat >>  $XP_ROOT/include/$TYPE/config.h

#------------------------------------------------------
#   Move the .proj_lock file aside while we relink system......
#    Don't forget to put it back.
#------------------------------------------------------
        if [ -f $XP_ROOT/.proj_lock ]
        then
           chmod 660 $XP_ROOT/.proj_lock
           mv   $XP_ROOT/.proj_lock   $XP_ROOT/.proj_lock_temp
        fi


#------------------------------------------------------
#   Trap interrupt signal.
#    We want to guarentee that the .proj_lock gets put back if user signals
#------------------------------------------------------
  trap 'mv $XP_ROOT/.proj_lock_temp $XP_ROOT/.proj_lock; echo ""; echo "    $PRODUCT install terminated."; exit 1' 1 2 3 9 15


#------------------------------------------------------
#  Go relink the image...
#------------------------------------------------------
  echo " "
  echo "    Relinking $PRODUCT_SET..........................."
  echo " "
  cd $XP_ROOT
  $XP_ROOT/bin/$TYPE/base -gen_proc express -exit
  $CCENV make -f express.mk relink


#------------------------------------------------------
#   PUT the .proj_lock file BACK!!!!
#------------------------------------------------------
        if [ -f $XP_ROOT/.proj_lock_temp ]
        then
           mv   $XP_ROOT/.proj_lock_temp   $XP_ROOT/.proj_lock
           chmod 444 $XP_ROOT/.proj_lock
        fi

        if [ "$SAVE" = "1" ] && [ -f $XP_ROOT/bin/$TYPE/express_old ] \
           && [ ! -f $XP_ROOT/bin/$TYPE/express ]; then
           mv -f $XP_ROOT/bin/$TYPE/express_old $XP_ROOT/bin/$TYPE/express
        fi

exit 0
#
#
# End of Subset Control Program script ...express/pst/install.sh
#
