// PST
// pst_cache.h
// by James S. Perrin Time-stamp: <Thursday 12/06/03 16:43:17 james>
// Simple cache mechanism for feasabilty study

#ifndef PST_CACHE_H
#define PST_CACHE_H

#ifndef PSTAPI
#ifdef WIN32
#define PSTAPI __declspec(dllexport)
#else
#define PSTAPI
#endif
#endif

#ifdef __cplusplus
extern "C" {
#endif
  
typedef struct _PST_Cache_Obj {
  int id;
  void *data;
  struct _PST_Cache_Obj *next;
} PST_Cache_Obj;


PSTAPI void PST_CacheInit();
// Add a new PST_Cache_Obj with id
PSTAPI PST_Cache_Obj *PST_CacheAddObj(int id);
// return PST_Cache_Obj with id or NULL
PSTAPI PST_Cache_Obj *PST_CacheGetObj(int id);
// Delete PST_Cache_Obj with id
PSTAPI void PST_CacheDeleteObj(int id);
// Delete remaining objs
PSTAPI void PST_CacheCleanUp();
PSTAPI void PST_CacheAllocData(PST_Cache_Obj *obj, int size);

#ifdef __cplusplus
}
#endif

#endif
