/* PST */
/* pst_defs.h */
/* James S Perrin Time-stamp: <Thursday 06/01/05 17:46:37 james> */
/* Standard defines for PST */
/* Assume xp 7.0 or greater */

#ifndef PST_DEFS_H
#define PST_DEFS_H

#include <mpi.h>

#ifndef PSTAPI
#ifdef WIN32
#define PSTAPI __declspec(dllexport)
#else
#define PSTAPI
#endif
#endif

#ifdef __cplusplus
extern "C" {
#endif

  /* Message types */
#define PST_MESSAGE_PTAG 0
#define PST_MESSAGE_PDOMAIN 1
#define PST_MESSAGE_PNOTIFY 2
#define PST_MESSAGE_FLUSH_PDOMAIN_CACHE 3
#define PST_MESSAGE_FLUSH_PTAG_CACHE 4
#define PST_MESSAGE_CREATE_COMM 5
#define PST_MESSAGE_DESTROY_COMM 6
#define PST_MESSAGE_RETURN_PDOMAIN 7
#define PST_MESSAGE_QUIT 99
#define PST_MESSAGE_PROFILE_CONTROL 123
#define PST_MESSAGE_ERROR 666

  /* Recomposition flags */
#define PST_PTAG_DATA_RETURN 1
#define PST_PTAG_NO_DATA_RETURN 0

  /* Component type */
#define PST_COMP_TYPE_COORDS 1
#define PST_COMP_TYPE_NODE_DATA 2
#define PST_COMP_TYPE_CONN_LIST 4
#define PST_COMP_TYPE_CELL_DATA 8
#define PST_COMP_TYPE_USER 16

  /* Coordinate  type */ 
#define PST_COORD_TYPE_STRUCT 0
#define PST_COORD_TYPE_IMPLICIT_UNIF 1
#define PST_COORD_TYPE_IMPLICIT_RECT 2
#define PST_COORD_TYPE_UNSTRUCT 3
  /* define these for now but probably not required  */
#define PST_COORD_TYPE_EXPLICIT_UNIF 4
#define PST_COORD_TYPE_EXPLICIT_RECT 5

  /* AVS/Express datatypes for external libraries */
#ifndef DTYPE_INCLUDED
#define OM_TYPE_CHAR 0
#define OM_TYPE_BYTE 1
#define OM_TYPE_SHORT 2
#define OM_TYPE_INT 3
#define OM_TYPE_FLOAT 4
#define OM_TYPE_DOUBLE 5
#define OM_TYPE_LONG 6
#endif

/* 64bit support */
/* if we're not included in an Express module then define some similar
   macros and typedefs to support 64bit arch */ 
/* pst.h should alway be include after avs includes for now */

#ifndef PORT_HEADER_IS_INCLUDED

#ifdef __linux__
#if defined(__LP64__) || defined(__ia64__) || defined(__ia64) || defined(__x86_64__) || defined(__x86_64)
#define WORDLENGTH_64
#endif
#endif

#ifdef __sgi
#if defined( _ABI64) && (_MIPS_SIM == _ABI64)
#define WORDLENGTH_64
#endif
#endif

#if defined(hpux) || defined(__hpux)
#ifdef __LP64__
#define WORDLENGTH_64
#endif
#endif

#ifdef __sun
#ifdef __sparcv9
#define WORDLENGTH_64
#endif
#endif

#if defined (__alpha) && defined(__osf__)
#define WORDLENGTH_64
#endif

#ifdef WORDLENGTH_64             /* 64-bit platforms */
#ifdef MSDOS  /* Win64 */                
  typedef __int64 xp_long;
  typedef unsigned __int64 xp_ulong;
#else         /* Other platforms */                       
  typedef long xp_long;       
  typedef unsigned long xp_ulong;
#endif
#else                            /* 32-bit platforms */
  typedef int xp_long;
  typedef unsigned int xp_ulong;
#endif

/* 64-bit porting. Limits for the AVS datatypes */
#ifdef WORDLENGTH_64
#define AVS_INT_MIN  -2147483647
#define AVS_LONG_MIN -9223372036854775807
#define AVS_INT_MAX  +2147483647
#define AVS_LONG_MAX +9223372036854775807
#else
#define AVS_INT_MIN  -2147483647
#define AVS_LONG_MIN -2147483647
#define AVS_INT_MAX  +2147483647
#define AVS_LONG_MAX +2147483647
#endif

#endif /* PORT_HEADER_IS_INCLUDED */

  /* NOTE defining two different MPI types for xp_long breaks hetergenity */
  /*      between 32/64 archs. Handling 64bit longs on 32bit arch is
	  too much of an overhead */
#ifdef WORDLENGTH_64
#define MPI_XP_LONG MPI_LONG_LONG_INT
#else
#define MPI_XP_LONG MPI_LONG
#endif

  /* use this for PST meta data types of pst_int64 */
#define MPI_PST_INT64 MPI_LONG_LONG_INT

  /* define our own 64 bit integer for meta data */
#if defined (MSDOS) || defined(_WIN32)
  typedef __int64 pst_int64;
#else
  typedef long long pst_int64;
#endif
  
#ifdef __cplusplus
}
#endif
#endif
