/* PST */
/* pst_error.h */
/* James S Perrin Time-stamp: <Friday 07/01/05 11:31:51 james> */
/* return codes and error handling functions */

#include <stdio.h>
#include <mpi.h>
#include "pst_defs.h"

#ifndef PST_ERROR_H
#define PST_ERROR_H

#ifndef PSTAPI
#ifdef WIN32
#define PSTAPI __declspec(dllexport)
#else
#define PSTAPI
#endif
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* Function return values */
#define PST_OK 1
#define PST_FAIL 0

#define PST_IGNORE -1  
#define PST_UNSET -99

#ifndef WIN32 
#define PST_DEBUG_COLOUR
#endif
#ifdef PST_DEBUG
#define PST_DEBUG_CALL(M) { M; }
#ifdef PST_DEBUG_COLOUR
#define PST_DEBUG_PRINT(M)  {int r=0,f=37,i; MPI_Initialized(&i); if(i){ MPI_Comm_rank(MPI_COMM_WORLD, &r); f-=r%7; } printf("\033[%dm",f);  printf(M); printf("\033[39m\n"); fflush(stdout); }
#define PST_DEBUG_PRINT1(M, A) {int r=0,f=37,i; MPI_Initialized(&i); if(i){ MPI_Comm_rank(MPI_COMM_WORLD, &r); f-=r%7; } printf("\033[%dm",f); printf(M, A); printf("\033[39m\n"); fflush(stdout); }
#define PST_DEBUG_PRINT2(M, A, B) {int r=0,f=37,i; MPI_Initialized(&i); if(i){ MPI_Comm_rank(MPI_COMM_WORLD, &r); f-=r%7; } printf("\033[%dm",f);  printf(M, A, B); printf("\033[39m\n"); fflush(stdout); }
#define PST_DEBUG_PRINT3(M, A, B, C) {int r=0,f=37,i; MPI_Initialized(&i); if(i){ MPI_Comm_rank(MPI_COMM_WORLD, &r); f-=r%7; } printf("\033[%dm",f);  printf(M, A, B, C); printf("\033[39m\n"); fflush(stdout); }
#define PST_DEBUG_PRINT4(M, A, B, C, D) {int r=0,f=37,i; MPI_Initialized(&i); if(i){ MPI_Comm_rank(MPI_COMM_WORLD, &r); f-=r%7; } printf("\033[%dm",f);  printf(M, A, B, C, D); printf("\033[39m\n"); fflush(stdout); }
#define PST_DEBUG_PRINT5(M, A, B, C, D, E) {int r=0,f=37,i; MPI_Initialized(&i); if(i){ MPI_Comm_rank(MPI_COMM_WORLD, &r); f-=r%7; } printf("\033[%dm",f); printf(M, A, B, C, D, E); printf("\033[39m\n"); fflush(stdout); }
#else
#define PST_DEBUG_PRINT(M) { printf(M); printf("\n"); fflush(stdout); }
#define PST_DEBUG_PRINT1(M, A) { printf(M, A); printf("\n"); fflush(stdout); }
#define PST_DEBUG_PRINT2(M, A, B) { printf(M, A, B); printf("\n"); fflush(stdout); }
#define PST_DEBUG_PRINT3(M, A, B, C) { printf(M, A, B, C); printf("\n"); fflush(stdout); }
#define PST_DEBUG_PRINT4(M, A, B, C, D) { printf(M, A, B, C, D); printf("\n"); fflush(stdout); }
#define PST_DEBUG_PRINT5(M, A, B, C, D, E) { printf(M, A, B, C, D, E); printf("\n"); fflush(stdout); }
#endif
#else
#define PST_DEBUG_CALL(M) 
#define PST_DEBUG_PRINT(M)
#define PST_DEBUG_PRINT1(M, A)
#define PST_DEBUG_PRINT2(M, A, B)
#define PST_DEBUG_PRINT3(M, A, B, C)
#define PST_DEBUG_PRINT4(M, A, B, C, D)
#define PST_DEBUG_PRINT5(M, A, B, C, D, E)
#endif

#define PST_ERROR_PRINT(M) {int r; MPI_Comm_rank(MPI_COMM_WORLD, &r); printf("[%d]ERROR: ", r); printf(M); printf("\n"); fflush(stdout); }
#define PST_ERROR_PRINT1(M, A) {int r; MPI_Comm_rank(MPI_COMM_WORLD, &r);  printf("[%d]ERROR: ", r); printf(M, A); printf("\n"); fflush(stdout); }
#define PST_ERROR_PRINT2(M, A, B) {int r; MPI_Comm_rank(MPI_COMM_WORLD, &r);  printf("[%d]ERROR: ", r); printf(M, A, B); printf("\n"); fflush(stdout); }
#define PST_ERROR_PRINT3(M, A, B, C) {int r; MPI_Comm_rank(MPI_COMM_WORLD, &r);  printf("[%d]ERROR: ", r); printf(M, A, B, C); printf("\n"); fflush(stdout); }
#define PST_ERROR_PRINT4(M, A, B, C, D) {int r; MPI_Comm_rank(MPI_COMM_WORLD, &r);  printf("[%d]ERROR: ", r); printf(M, A, B, C, D); printf("\n"); fflush(stdout); }
#define PST_ERROR_PRINT5(M, A, B, C, D, E) {int r; MPI_Comm_rank(MPI_COMM_WORLD, &r);  printf("[%d]ERROR: ", r); printf(M, A, B, C, D, E); printf("\n"); fflush(stdout); }

#define PST_ERROR_STRING_MAX 256
  
  typedef struct _pError {
    pst_int64 moduleid;
    int pstnode;
    int flag; /* PST_OK no error, PST_FAIL error */
    char error_string[PST_ERROR_STRING_MAX];
  } PST_pError;
  
  /* These functions relate to the pError message type */
  /* create n pError structures */
  PSTAPI PST_pError *PST_pErrorCreateArray(int n);
  
#define PST_pErrorCreate() PST_pErrorCreateArray(1)
#define PST_pErrorDestroyArray(error, n) PST_UtilFree((char *)error)
#define PST_pErrorDestroy(error) PST_pErrorDestroyArray(error, 1)
  
  /* create an MPI type to use to pack PST_pError */
  PSTAPI int PST_pErrorMPI_Datatype(MPI_Datatype *pError_mpi, MPI_Comm comm);

#define PST_pErrorSize(pError_mpi, comm) PST_pMessageSize(pError_mpi, comm)
#define PST_pErrorPack(error, pError_mpi, comm, count) PST_pMessagePack(PST_MESSAGE_ERROR, error, pError_mpi, comm, count)
#define PST_pErrorUnPack(buffer, size, count, error, pError_mpi, comm) PST_pMessageUnPack(buffer, size, count, error, pError_mpi, comm)

  /* These functions relate to the global error string */
  PSTAPI void PST_ErrorSetErrorString(char *error_string);
  PSTAPI char *PST_ErrorGetErrorString();
  
#ifdef __cplusplus
}
#endif

#endif
