/* PST */
/* pst_item_cache.h */
/* by James S. Perrin Time-stamp: <Thursday 21/08/03 17:46:14 james> */
/* heterogeneous item cache */

#ifndef PST_ITEM_CACHE_H
#define PST_ITEM_CACHE_H

#define PST_ITEM_COMM 0

#ifndef PSTAPI
#ifdef WIN32
#define PSTAPI __declspec(dllexport)
#else
#define PSTAPI
#endif
#endif

#ifdef __cplusplus
extern "C" {
#endif

typedef struct _PST_ItemCache_ID {
  pst_int64 moduleid;
  pst_int64 fieldid;
  pst_int64 itemid;
  int type;
} PST_ItemCache_ID;
  
typedef struct _PST_ItemCache_Obj {
  PST_ItemCache_ID id;
  void *item;
  void (*ItemDestroy)(void *);
  struct _PST_ItemCache_Obj *next;
} PST_ItemCache_Obj;


PSTAPI void PST_ItemCacheInit();
// Add a new void with id
PSTAPI int PST_ItemCacheAddItem(PST_ItemCache_ID id, void *item, void(* ItemDestroy)(void *));
// return PST_ItemCache_Obj with id or NULL
PSTAPI PST_ItemCache_Obj *PST_ItemCacheGetObj(PST_ItemCache_ID id);
// return the next PST_ItemCache_Obj with id or NULL
PSTAPI PST_ItemCache_Obj *PST_ItemCacheGetNextObj(PST_ItemCache_ID id);
// return void with id or NULL
PSTAPI void *PST_ItemCacheGetItem(PST_ItemCache_ID id);
// return the next void with id or NULL
PSTAPI void *PST_ItemCacheGetNextItem(PST_ItemCache_ID id);
// Delete items which match the id mask from the cache
PSTAPI int PST_ItemCacheDeleteItems(PST_ItemCache_ID id);
// Delete remaining objs
PSTAPI void PST_ItemCacheCleanUp();
// dump infos about current cache
PSTAPI void PST_ItemCacheDump();
  
#ifdef __cplusplus
}
#endif

#endif
