/* PST */
/* pst_pdomain.h */
/* James S Perrin Time-stamp: <Monday 24/05/04 16:29:19 james> */
/* a pDomain is a struct that holds a small amount of information
   about subset of data most of its information is stored in an
   associated ptag struct */

#ifndef PST_PDOMAIN_H
#define PST_PDOMAIN_H

#include "mpi.h"
#include "pst_util.h"
#include "pst_defs.h"
#include "pst_pmessage.h"

#ifndef PSTAPI
#ifdef WIN32
#define PSTAPI __declspec(dllexport)
#else
#define PSTAPI
#endif
#endif

#ifdef __cplusplus
extern "C" {
#endif

  typedef struct _pDomain {
    pst_int64 moduleid; /* computation id */
    pst_int64 fieldid;
    pst_int64 compid;
    pst_int64 size; /* number of elements */
    int domain; /* which domain am I */
    int type; /* data type, Express like */
    int veclen; /* dimension of element */
    unsigned char *data; /* ptr to data must be local to the current process
			    this ptr is not sent between process and must be
			    set manually once the data has been recieved */
  } PST_pDomain;
  
  /* should change all pDomain refs to PST_pDomain for API consistency */
  typedef PST_pDomain pDomain;
  
  /* create n pDomain structures */
  PSTAPI PST_pDomain *PST_pDomainCreateArray(int n);
  
  /* destroy n pDomain structures, freeing any data allocated */
  PSTAPI int PST_pDomainDestroyArray(PST_pDomain *domain, int n);

#define PST_pDomainCreate() PST_pDomainCreateArray(1)
#define PST_pDomainDestroy(domain) PST_pDomainDestroyArray(domain, 1)
#define PST_pDomainDestroyNotData(domain) PST_UtilFree((char *)domain)
  
  /* allocate pDomain.data based on pDomain.type and pDomain.size */
  PSTAPI int PST_pDomainAllocData(PST_pDomain *domain);

  /* create an MPI type to use to pack pDomain */
  PSTAPI int PST_pDomainMPI_Datatype(MPI_Datatype *pDomain_mpi, MPI_Comm comm);
  
#define PST_pDomainSize(pDomain_mpi, comm) PST_pMessageSize(pDomain_mpi, comm)
#define PST_pDomainPack(domain, pDomain_mpi, comm, count) PST_pMessagePack(PST_MESSAGE_PDOMAIN, domain, pDomain_mpi, comm, count)
#define PST_pDomainUnPack(buffer, size, count, domain, pDomain_mpi, comm) PST_pMessageUnPack(buffer, size, count, domain, pDomain_mpi, comm)

  /* useful MACROS */

#define PST_pDomainRetDataPtr(DOMAIN) DOMAIN->data
#define PST_pDomainRetNNodes(DOMAIN) DOMAIN->size
#define PST_pDomainRetNValues(DOMAIN) (DOMAIN->size*DOMAIN->veclen)
#define PST_pDomainRetNBytes(DOMAIN) (DOMAIN->size*DOMAIN->veclen*PST_UtilSizeOfXPType(DOMAIN->type))
#define PST_pDomainRetVeclen(DOMAIN) DOMAIN->veclen
#define PST_pDomainRetXPType(DOMAIN) DOMAIN->type
#define PST_pDomainRetMPIType(DOMAIN) PST_UtilXPType2MPIType(DOMAIN->type)
  
#ifdef __cplusplus
}
#endif
#endif

