/* PST */
/* pst_pdomain_cache.h */
/* by James S. Perrin Time-stamp: <Friday 07/01/05 16:08:56 james> */

#ifndef PST_PDOMAIN_CACHE_H
#define PST_PDOMAIN_CACHE_H

#include "pst_defs.h"
#include "pst_pdomain.h"

#ifndef PSTAPI
#ifdef WIN32
#define PSTAPI __declspec(dllexport)
#else
#define PSTAPI
#endif
#endif

#ifdef __cplusplus
extern "C" {
#endif

typedef struct _PST_pDomainCache_ID {
  pst_int64 moduleid;
  pst_int64 fieldid;
  pst_int64 compid;
  int domainid;
} PST_pDomainCache_ID;
  
typedef struct _PST_pDomainCache_Obj {
  PST_pDomainCache_ID id;
  pDomain *domain;
  struct _PST_pDomainCache_Obj *next;
} PST_pDomainCache_Obj;


PSTAPI void PST_pDomainCacheInit();
// Add a new PST_pDomain with id
PSTAPI int PST_pDomainCacheAddDomain(PST_pDomainCache_ID id, PST_pDomain *domain);
// return PST_pDomainCache_Obj with id or NULL
PSTAPI PST_pDomainCache_Obj *PST_pDomainCacheGetObj(PST_pDomainCache_ID id);
// return the next PST_pDomainCache_Obj with id or NULL
PSTAPI PST_pDomainCache_Obj *PST_pDomainCacheGetNextObj(PST_pDomainCache_ID id);
// return PST_pDomain with id or NULL
PSTAPI PST_pDomain *PST_pDomainCacheGetDomain(PST_pDomainCache_ID id);
// return the next PST_pDomain with id or NULL
PSTAPI PST_pDomain *PST_pDomainCacheGetNextDomain(PST_pDomainCache_ID id);
// Delete domains which match the id mask from the cache
PSTAPI int PST_pDomainCacheDeleteDomains(PST_pDomainCache_ID id);
// Delete remaining objs
PSTAPI void PST_pDomainCacheCleanUp();
// dump infos about current cache
PSTAPI void PST_pDomainCacheDump();
  
#ifdef __cplusplus
}
#endif

#endif
