/* PST */
/* pst_pmessage.h */
/* James S Perrin Time-stamp: <Thursday 08/01/04 17:38:17 james> */

#ifndef PST_PMESSAGE_H
#define PST_PMESSAGE_H

#include "mpi.h"

#ifndef PSTAPI
#ifdef WIN32
#define PSTAPI __declspec(dllexport)
#else
#define PSTAPI
#endif
#endif

#ifdef __cplusplus
extern "C" {
#endif

  /* return size of pMessage when packed, includes message id */
  PSTAPI int PST_pMessageSize(MPI_Datatype pMessage_mpi, MPI_Comm comm);
  
  /* return buffer containing a packed pMessage the buffer should be freed by the user */
  PSTAPI char *PST_pMessagePack(int message_type, void *message, MPI_Datatype pMessage_mpi, MPI_Comm comm, int *count);
  
  /* return pMessage containing an unpacked buffer */
  PSTAPI int PST_pMessageUnPack(void *buffer, int size, int *count, void *message,
			       MPI_Datatype pMessage_mpi, MPI_Comm comm);
    
#ifdef __cplusplus
}
#endif
#endif

