/* PST */
/* pst_ptag.h */
/* James S Perrin Time-stamp: <Tuesday 27/07/04 10:51:13 james> */
/* a pTag is similar to the Express group pTags the only difference is
   that they refer to a single domain rather than the whole data */

#ifndef PST_PTAG_H
#define PST_PTAG_H

#include "mpi.h"
#include "pst_defs.h"
#include "pst_pmessage.h"
#include "pst_pdomain.h"
#include "pst_util.h"

#ifndef PSTAPI
#ifdef WIN32
#define PSTAPI __declspec(dllexport)
#else
#define PSTAPI
#endif
#endif

#ifdef __cplusplus
extern "C" {
#endif

  /* not all values are filled in depending on whether we are sending to(<) or from(>) PSTXP */
  /* pst_int64's are used as id's and dims may be 64bit */
  typedef struct _pTag {
    pst_int64 moduleid; /* id of the module this->obj_id.elem_id where this data originated */
    pst_int64 moduleid_out; /* id of the module this->obj_id.elem_id from where the resultant data originates */
    pst_int64 fieldid; /* in.obj_id().elem_id */
    pst_int64 fieldid_out; /* send tags only: set by a module as the fieldid that the resultant data is for */ 
    pst_int64 compid; /* array.obj_id().elem_id*/
    pst_int64 compid_out; /* send tags only: set by a module as the compid that the resultant data is for */ 
    pst_int64 dims[3];  /* > dims of the whole data */
    pst_int64 domain_dims[3];
    pst_int64 domain_st[2]; /* index of domain start, 1D or 2D decomp */
    pst_int64 domain_en[2];
    int comp_type; /* 0 = node_data, 1 = cell_set (conn_list), 2 = coords */
    int coord_type; /* implict_unif/structured etc. */
    int cell_type; /* ncells can be determined from conn_list size and cell_type */
    int ndims;  /* unstructured data ndims = 1 */
    int veclen;
    int decomp_dim; /* 1D or 2D */
    int ndomains;
    int domain; /* which domain am I */
    int domain_boundary;
    int type; /* data type */
    int pass_thru; /* component is not to be passed to CE but the tag (and domain if ret = 1) are to be sent back by PSTNode */
    int from; /* where is this being sent FROM */
    int to; /* where is this being sent TO */
    int ret; /* where to send to resultant data */
    int null_flag; /* is null value set */
    double null_value;
    double min; /* < data min value */
    double max; /* < data max value */
  } PST_pTag;

  /* should change all pTag refs to PST_pTag for API consistency */
  typedef PST_pTag pTag;
  
  /* create n pTag structures */
  PSTAPI PST_pTag *PST_pTagCreateArray(int n);
  
  /* destroy n PST_pTag structures, freeing any data allocated */
  /*  PSTAPI void PST_pTagDestroyArray(PST_pTag *tag, int n);*/

#define PST_pTagCreate() PST_pTagCreateArray(1)
#define PST_pTagDestroyArray(tag, n) PST_UtilFree((char *)tag)
#define PST_pTagDestroy(tag) PST_pTagDestroyArray(tag, 1)
  
  /* find the global min/max values for a set of PST_pTag's */
  PSTAPI int PST_pTagGetMinMax(int ntags, PST_pTag *tags, double *min, double *max);

  /* calulate and set in the tag the min/max for the given domain */
  PSTAPI int PST_pTagCalculateMinMax(PST_pTag *tag, PST_pDomain *domain);
  
  /* create an MPI type to use to pack PST_pTag */
  PSTAPI int PST_pTagMPI_Datatype(MPI_Datatype *pTag_mpi, MPI_Comm comm);
  
#define PST_pTagSize(pTag_mpi, comm) PST_pMessageSize(pTag_mpi, comm)
#define PST_pTagPack(tag, pTag_mpi, comm, count) PST_pMessagePack(PST_MESSAGE_PTAG, tag, pTag_mpi, comm, count)
#define PST_pTagUnPack(buffer, size, count, tag, pTag_mpi, comm) PST_pMessageUnPack(buffer, size, count, tag, pTag_mpi, comm)

  /*Initialise the tag_out with non-data-related values from tag_in; used by ce to init output */
  PSTAPI int PST_pTagInitTagOut(PST_pTag *tag_out, PST_pTag *tag_in);

  /* Initialise the domain_out with values from tag_in; used by ce to init output */
  PSTAPI int PST_pDomainInitDomainOutNoAlloc(PST_pDomain *domain_out, PST_pTag *tag_out);
  PSTAPI int PST_pDomainInitDomainOut(PST_pDomain *domain_out, PST_pTag *tag_out);

  /* If a component is coordinates then use these function to get
     domain points and coordinate if the tag->coord_type is implict */
  PSTAPI float *PST_pTagCalcDomainPoints(PST_pTag *tag, PST_pDomain *domain);
  PSTAPI float *PST_pTagCalcDomainCoords(PST_pTag *tag, PST_pDomain *domain);

  /* copy MACROS - initialize parts of TAG_OUT from TAG_IN */
#define PST_pTagCopyCompDims(TAG_OUT, TAG_IN) \
{ int i; TAG_OUT->ndims = TAG_IN->ndims; for(i=0; i<TAG_OUT->ndims; i++) TAG_OUT->dims[i] = TAG_IN->dims[i]; } 
#define PST_pTagCopyDomainDims(TAG_OUT, TAG_IN) \
{ int i; TAG_OUT->ndims = TAG_IN->ndims; for(i=0; i<TAG_OUT->ndims; i++) TAG_OUT->domain_dims[i] = TAG_IN->domain_dims[i]; } 
#define PST_pTagCopyDataInfo(TAG_OUT, TAG_IN) \
{ TAG_OUT->type = TAG_IN->type; TAG_OUT->veclen = TAG_IN->veclen; TAG_OUT->null_flag = TAG_IN->null_flag; TAG_OUT->null_value = TAG_IN->null_value; }
#define PST_pTagCopyCompInfo(TAG_OUT, TAG_IN) \
{ TAG_OUT->comp_type = TAG_IN->comp_type; TAG_OUT->coord_type = TAG_IN->coord_type; TAG_OUT->cell_type = TAG_IN->cell_type; }
#define PST_pTagCopyDomainExtents(TAG_OUT, TAG_IN) \
{ TAG_OUT->domain_st[0] = TAG_IN->domain_st[0]; TAG_OUT->domain_en[0] = TAG_IN->domain_en[0]; TAG_OUT->domain_boundary = TAG_IN->domain_boundary; } 
#define PST_pTagCopyAll(TAG_OUT, TAG_IN) \
{ PST_pTagCopyCompDims(TAG_OUT, TAG_IN); \
  PST_pTagCopyDomainDims(TAG_OUT, TAG_IN); \
  PST_pTagCopyDataInfo(TAG_OUT, TAG_IN); \
  PST_pTagCopyCompInfo(TAG_OUT, TAG_IN); \
  PST_pTagCopyDomainExtents(TAG_OUT, TAG_IN); }

/* set MACROS - set TAG structure values */
#define PST_pTagSetCompDims(TAG, NDIMS, COMP_DIMS) \
{ int i;  TAG->ndims = NDIMS; for(i=0; i<NDIMS; i++) TAG->dims[i] = COMP_DIMS[i]; } 
#define PST_pTagSetDomainDims(TAG, NDIMS, COMP_DIMS) \
{ int i;  TAG->ndims = NDIMS; for(i=0; i<NDIMS; i++) TAG->domain_dims[i] = DOMAIN_DIMS[i]; } 
#define PST_pTagSetDataInfo(TAG, TYPE, VECLEN, NULL_FLAG, NULL_VALUE) \
{ TAG->type = TYPE; TAG->veclen = VECLEN; TAG->null_flag = NULL_FLAG; TAG->null_value = NULL_VALUE; }
#define PST_pTagSetCompInfo(TAG, COMP_TYPE, COORD_TYPE, CELL_TYPE) \
{ TAG->comp_type = COMP_TYPE; TAG->COORD_TYPE = COORD_TYPE; TAG->CELL_TYPE = CELL_TYPE; }
#define PST_pTagSetDomainExtents(TAG, DOMAIN_ST, DOMAIN_EN, DOMAIN_BOUNDARY) \
{ TAG->domain_st[0] = DOMAIN_ST; TAG->domain_en[0] = DOMAIN_EN; TAG->domain_boundary = DOMAIN_BOUNDARY; }

/* get MACROS - get personal copy of TAG structure values */
#define PST_pTagGetCompDims(TAG, NDIMS, COMP_DIMS) \
{ int i; NDIMS = TAG->ndims; for(i=0; i<NDIMS; i++) COMP_DIMS[i] = TAG->dims[i]; } 
#define PST_pTagGetDomainDims(TAG, NDIMS, DOMAIN_DIMS) \
{ int i; NDIMS = TAG->ndims; for(i=0; i<NDIMS; i++) DOMAIN_DIMS[i] = TAG->domain_dims[i]; } 
#define PST_pTagGetDataInfo(TAG, TYPE, VECLEN, NULL_FLAG, NULL_VALUE) \
{ TYPE = TAG->type; VECLEN = TAG->veclen; NULL_FLAG = TAG->null_flag; NULL_VALUE = TAG->null_value; }
#define PST_pTagGetCompInfo(TAG, COMP_TYPE, COORD_TYPE, CELL_TYPE) \
{ COMP_TYPE = TAG->comp_type; COORD_TYPE = TAG->COORD_TYPE; CELL_TYPE = TAG->CELL_TYPE; }
#define PST_pTagGetDomainExtents(TAG, DOMAIN_ST, DOMAIN_EN, DOMAIN_BOUNDARY) \
{ DOMAIN_ST = TAG->domain_st[0]; DOMAIN_EN = TAG->domain_en[0]; DOMAIN_BOUNDARY = TAG->domain_boundary; }

/* useful MACROS */
#define PST_pTagCoordsImplicit(TAG)(TAG->comp_type == PST_COMP_TYPE_COORDS && \
				    (TAG->coord_type == PST_COORD_TYPE_IMPLICIT_UNIF || \
				     TAG->coord_type == PST_COORD_TYPE_IMPLICIT_RECT))
#define PST_pTagCoordsUnif(TAG) (TAG->comp_type == PST_COMP_TYPE_COORDS && TAG->coord_type == PST_COORD_TYPE_IMPLICIT_UNIF)
#define PST_pTagCoordsRect(TAG) (TAG->comp_type == PST_COMP_TYPE_COORDS && TAG->coord_type == PST_COORD_TYPE_IMPLICIT_RECT)
#define PST_pTagRetXPType(TAG) TAG->type
#define PST_pTagRetMPIType(TAG) PST_UtilXPType2MPIType(TAG->type)

#ifdef __cplusplus
}
#endif
#endif

