/* PST */
/* pst_ptag_cache.h */
/* by James S. Perrin Time-stamp: <Friday 26/03/04 13:49:40 james> */

#ifndef PST_PTAG_CACHE_H
#define PST_PTAG_CACHE_H

#include "pst_ptag.h"

#ifndef PSTAPI
#ifdef WIN32
#define PSTAPI __declspec(dllexport)
#else
#define PSTAPI
#endif
#endif

#ifdef __cplusplus
extern "C" {
#endif

typedef struct _PST_pTagCache_ID {
  pst_int64 moduleid;
  pst_int64 fieldid;
  pst_int64 compid;
  int tagid;
} PST_pTagCache_ID;
  
typedef struct _PST_pTagCache_Obj {
  PST_pTagCache_ID id;
  PST_pTag *tag;
  struct _PST_pTagCache_Obj *next;
} PST_pTagCache_Obj;


PSTAPI void PST_pTagCacheInit();
// Add a new PST_pTag with id
PSTAPI int PST_pTagCacheAddTag(PST_pTagCache_ID id, PST_pTag *tag);
// return PST_pTagCache_Obj with id or NULL
PSTAPI PST_pTagCache_Obj *PST_pTagCacheGetObj(PST_pTagCache_ID id);
// return the next PST_pTagCache_Obj with id or NULL
PSTAPI PST_pTagCache_Obj *PST_pTagCacheGetNextObj(PST_pTagCache_ID id);
// return PST_pTag with id or NULL
PSTAPI PST_pTag *PST_pTagCacheGetTag(PST_pTagCache_ID id);
// return the next PST_pTag with id or NULL
PSTAPI PST_pTag *PST_pTagCacheGetNextTag(PST_pTagCache_ID id);
// Delete tags which match the id mask from the cache
PSTAPI int PST_pTagCacheDeleteTags(PST_pTagCache_ID id);
// Delete remaining objs
PSTAPI void PST_pTagCacheCleanUp();
// dump infos about current cache
PSTAPI void PST_pTagCacheDump();
  
#ifdef __cplusplus
}
#endif

#endif
