/* PST */
/* pst_comp.h */
/* James S Perrin Time-stamp: <Thursday 29/04/04 13:49:16 james> */
/* internal structure used by express for storign information about
   the components this include the tags passed between pModules, these
   differ from the pst_ptags which are sent as messages to pstnodes */

#ifndef PST_COMP_H
#define PST_COMP_H

#include "pst/include/pst_defs.h"

#ifdef __cplusplus
extern "C" {
#endif
  
  typedef struct _PST_comp_pTags_info {
    xp_long domain_st;
    xp_long domain_en;
    int location; /* where the data is */
  } PST_comp_pTags_info;

  typedef struct _PST_comp_pTags {
    int distributed; /* 0 = local only, 1 = remote */
    int composed; /* 0 = remote only, 1 = local */
    int ndomains;
    pst_int64 moduleid; /* the module that performed this decompostion */
    pst_int64 fieldid; /* the field from which it was distributed (pass thrus can skip fields) */
    pst_int64 compid; /* the array from which it was distributed */
    int comp_type; /* 0 = coords, 1 = node_data, 2 = cell_set (conn_list),see pst_defs.h */
    int coord_type; /* 0 = struct, 1 = implicit unif, 2 = implicit rect, 3 = unstruct */
    int veclen;
    int type; /* data type */
    int domain_boundary;
    int ndims;
    xp_long dims[3];
    int null_flag;
    double null_value;
    double min;
    double max;
    PST_comp_pTags_info *info;
  } PST_comp_pTags;

  typedef struct _PST_comp_pTags_set {
    pst_int64 moduleid; /* the module that originally created this PST_comp_pTags_set */
    pst_int64 fieldid; /* the main field that the tag_set is associated with,
			individual comp_tags may have a different parent fieldid */
    int ncomps; /* # of components */
    int ndomains; /* equiv to npstnodes in associated schema */
    int decomp_dim; /* 1 or 2 */
    PST_comp_pTags **comps_tags; /* some coords maybe passed thru eg coords from upstream */
    int ref_count; /* how many other modules are using this tag */
  } PST_comp_pTags_set;

  typedef struct _PST_comp_pTags_set_link {
    PST_comp_pTags_set *tags;
    struct _PST_comp_pTags_set_link *next;
  } PST_comp_pTags_set_link;
  
  typedef struct _PST_comp_info {
    int pass_thru; /* 1 if component is to be passed from input to output */
    int process; /* 1 if component is processed/used by the module's CE */
    int decompose; /* 1 if component needs to be decomposed and distributed */
    int distributed; /* 1 if the component has already been decomposed */
    int computed; /* 1 if the component is computed by the CE */
    int comp_type;
    int coord_type;
    OMobj_id comp_id; /* obj_id of actual array being considered */
    OMobj_id comp_out_id; /* obj_id of array that this comp will contribute to */
  } PST_comp_info;

#ifdef __cplusplus
}
#endif

#endif
