/*
                Copyright (c) 1999 by
                Advanced Visual Systems Inc.
                All Rights Reserved

        This software comprises unpublished confidential information of
        Advanced Visual Systems Inc. and may not be used, copied or made
        available to anyone, except in accordance with the license
        under which it is furnished.

        This file is under Perforce control
        $Id: //depot/express/fcs70/reduct/dsrLinks.h#1 $
*/

//============================================================================
// dsrLinks.h
// a class to maintain a list of links between the points of a triangular
// mesh and the triangles whose verices they are
//============================================================================

#ifndef __dsrLinks_h
#define __dsrLinks_h

#ifndef NULL
#define NULL    0L
#endif

#include <avs/port.h>	/* for the definition of xp_long */

struct dsrLink
{
  int ntris;
  xp_long *tris;
};

class dsrLinks
{
public:
  dsrLink *links;

  dsrLinks() : links(NULL), maxId(0) {};
  dsrLinks(xp_long nnodes) : maxId(nnodes) { this->links=new dsrLink[nnodes]; };

  void BuildLinks(xp_long nnodes, xp_long ntris, xp_long *tris);
  void RemoveTriFromPoint(xp_long triId, xp_long p);
  void Resize(xp_long p, int newSize);

  // Return number of tris used by pt
  int GetNTris(xp_long ptId) { return this->links[ptId].ntris; };

  // Return a pts tri list
  xp_long *GetTris(xp_long ptId) { return this->links[ptId].tris; };

  // increase pts tri list by one (using Resize) and append new tri
  void AddTriToPoint(xp_long triId, xp_long p)
  {
    int oldntris;

    oldntris=this->links[p].ntris;
    this->Resize(p, oldntris+1);
    this->links[p].tris[oldntris]=triId;
  };

  // set ntris to 0 delete tri list and set to NULL
  void DeletePoint(xp_long p)
  {
    this->links[p].ntris=0;
    delete [] this->links[p].tris;
    this->links[p].tris=NULL;
  };

  // remove tri from each of its pts
  void DeleteTri(xp_long triId, xp_long *tris)
  {
    int i;
    xp_long *pts;

    pts=&tris[triId*3];

    for(i=0; i<3; i++)
      // if pt hasn't already been deleted
      if(this->links[pts[i]].ntris)
        this->RemoveTriFromPoint(triId, pts[i]);
  };

  ~dsrLinks()
  {
    xp_long i;

    if(!this->links)
      return;

    for(i=0; i<maxId; i++)
      delete [] this->links[i].tris;

    delete [] this->links;
  };

private:
  xp_long maxId;
};

#endif
