//			Copyright (c) 1993 by
//			Advanced Visual Systems Inc.
//			All Rights Reserved
//
//	This software comprises unpublished confidential information of
//	Advanced Visual Systems Inc. and may not be used, copied or made
//	available to anyone, except in accordance with the license
//	under which it is furnished.
//
//	This file is under Perforce control
//	$Id: //depot/express/fcs70/cxxutl/baseattr.cxx#1 $
//

// baseattr.cxx - Source file for BaseAttr class

//----------------------------------------------------------------------

#include <avs/cxxutl/baseattr.hxx>

//----------------------------------------------------------------------
UtBaseAttr::UtBaseAttr(
    const char *name)
    : _state(UtATTR_UNSET),
      _name(name)
//----------------------------------------------------------------------
{}

//----------------------------------------------------------------------
UtBaseAttr::~UtBaseAttr()
//----------------------------------------------------------------------
{}

//----------------------------------------------------------------------
// Compare function -1(<), 0(==), 1(>)
//----------------------------------------------------------------------
int
UtBaseAttr::compare(
    const UtBaseAttr *other)
const
//----------------------------------------------------------------------
{
    // Check for same address
    if (_name == other->_name) {
        return 0;
    }
    else {
        return strcmp(_name, other->_name);
    }
}

//----------------------------------------------------------------------
// Set state
//----------------------------------------------------------------------
UtBaseAttr*
UtBaseAttr::setState(
    UtAttrState s)
//----------------------------------------------------------------------
{
    // Dont clear the changed flag
    _state = (UtAttrState)((_state & UtATTR_CHANGED) | s);
    return this;
}

//----------------------------------------------------------------------
// Clear changed state
//----------------------------------------------------------------------
UtBaseAttr*
UtBaseAttr::clearChangedState()
//----------------------------------------------------------------------
{
    _state = (UtAttrState)((_state | UtATTR_CHANGED) - UtATTR_CHANGED);
    return this;
}

//----------------------------------------------------------------------
// Return 0 pointer (i.e. cannot be cloned)
//----------------------------------------------------------------------
UtBaseAttr*
UtBaseAttr::newOf()
//----------------------------------------------------------------------
{
    return 0;
}

//----------------------------------------------------------------------
// No data to init in base class
//----------------------------------------------------------------------
void
UtBaseAttr::init()
//----------------------------------------------------------------------
{}

//----------------------------------------------------------------------
// No default validate function
//----------------------------------------------------------------------
void
UtBaseAttr::_validate()
//----------------------------------------------------------------------
{}

//----------------------------------------------------------------------
// No default data
//----------------------------------------------------------------------
void
UtBaseAttr::_init()
//----------------------------------------------------------------------
{}
