/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/gd/props_ed.c#1 $
*/

#define XP_WIDE_API	/* Use Wide APIs */

#include <stdio.h>
#include <avs/util.h>
#include <avs/err.h>
#include <avs/om.h>
#include <avs/math.h>
#include <avs/gd.h>
#include <avs/color.h>

int GDprops_edit_update(OMobj_id edit_id, OMevent_mask mask, int seq)
{
   OMobj_id notify_id, props_id;
   int active = 0, reset = 0;
   int changed, tmp_val, old_val;
   float col[3], ocol[3], material[4], trans, tmp_float, metal;

   /* Make sure we have a good props as input */
   if (!GDget_refer_db(edit_id, "props", &props_id) ||
       OMis_null_obj(props_id))
      return(1);

   /* If sub_elements in the props editor have changed, we need
      to update the instance of the props we are attached to.
      The elements that we are care about are defined by the
      notification template that we look up below. Typically,
      these sub-elements are attached to user interface widgets.
   */
   notify_id = OMfind_subobj(OMtempl_obj, OMstr_to_name("GDprops_edit_notify_templ"),
        OM_OBJ_RD);
   if (OMis_null_obj(notify_id))
      return(1);

   /* On the instance event, we always just update the object with
      the state of the current props.
   */
   if (!(mask & OM_EVENT_INST) &&
       OMget_obj_seq(edit_id, notify_id, OM_SEQ_VAL) > seq) {
      OMset_state_to_usr(1);
      /* update color */
      changed = 0;
      if (GDget_updfloat_val(edit_id, "red", seq, &col[0]))
	 changed = 1;
      if (GDget_updfloat_val(edit_id, "green", seq, &col[1]))
	 changed = 1;
      if (GDget_updfloat_val(edit_id, "blue", seq, &col[2]))
	 changed = 1;
      if (changed) {
         GDprops_set_color(props_id, col);
	 GDprops_set_inherit(props_id, 0);
         OMset_name_int_val(edit_id, OMstr_to_name("inherit"), 0);
      }

      /* update highlight color 1 */
      changed = 0;
      if (GDget_updfloat_val(edit_id, "hi1_red", seq, &col[0]))
	 changed = 1;
      if (GDget_updfloat_val(edit_id, "hi1_green", seq, &col[1]))
	 changed = 1;
      if (GDget_updfloat_val(edit_id, "hi1_blue", seq, &col[2]))
	 changed = 1;
      if (changed) {
         GDprops_set_hi1_col(props_id, col);
	 GDprops_set_inherit(props_id, 0);
         OMset_name_int_val(edit_id, OMstr_to_name("inherit"), 0);
      }

      /* update highlight color 2 */
      changed = 0;
      if (GDget_updfloat_val(edit_id, "hi2_red", seq, &col[0]))
	 changed = 1;
      if (GDget_updfloat_val(edit_id, "hi2_green", seq, &col[1]))
	 changed = 1;
      if (GDget_updfloat_val(edit_id, "hi2_blue", seq, &col[2]))
	 changed = 1;
      if (changed) {
         GDprops_set_hi2_col(props_id, col);
	 GDprops_set_inherit(props_id, 0);
         OMset_name_int_val(edit_id, OMstr_to_name("inherit"), 0);
      }

      /* update specular color */
      changed = 0;
      if (GDget_updfloat_val(edit_id, "spec_red", seq, &col[0]))
	 changed = 1;
      if (GDget_updfloat_val(edit_id, "spec_green", seq, &col[1]))
	 changed = 1;
      if (GDget_updfloat_val(edit_id, "spec_blue", seq, &col[2]))
	 changed = 1;
      if (changed) {
         GDprops_set_specular_color(props_id, col);
	 GDprops_set_inherit(props_id, 0);
         OMset_name_int_val(edit_id, OMstr_to_name("inherit"), 0);
      }

      if (GDget_updfloat_val(edit_id, "metal", seq, &metal)) {
         GDprops_get_color(props_id, col);
	 COLORrgb_to_hsv(col[0],col[1],col[2],&col[0],&col[1],&col[2]);
	 COLORhsv_to_rgb(col[0],metal*col[1],col[2],&col[0],&col[1],&col[2]);
	 GDprops_set_specular_color(props_id, col);
      }

      /* update material */
      changed = 0;
      if (GDget_updfloat_val(edit_id, "ambient", seq, &material[0]))
	 changed = 1;
      if (GDget_updfloat_val(edit_id, "diffuse", seq, &material[1]))
	 changed = 1;
      if (GDget_updfloat_val(edit_id, "specular", seq, &material[2]))
	 changed = 1;
      if (GDget_updfloat_val(edit_id, "spec_exp", seq, &material[3]))
	 changed = 1;
      if (changed) {
         GDprops_set_material(props_id, material);
	 GDprops_set_inherit(props_id, 0);
         OMset_name_int_val(edit_id, OMstr_to_name("inherit"), 0);
      }

      /* update transparency */
      if (GDget_updfloat_val(edit_id, "trans", seq, &trans)) {
         GDprops_set_transparency(props_id, trans);
	 GDprops_set_inherit(props_id, 0);
         OMset_name_int_val(edit_id, OMstr_to_name("inherit"), 0);
      }

      /* update draw mode */
      if (GDget_updint_val(edit_id, "draw_mode", seq, &tmp_val)) {
         GDprops_get_draw_mode(props_id, &old_val);
         if( old_val != tmp_val ) {
            GDprops_set_draw_mode(props_id, tmp_val);
	    GDprops_set_inherit(props_id, 0);
            OMset_name_int_val(edit_id, OMstr_to_name("inherit"), 0);
         }
      }

      /* update line width */
      if (GDget_updint_val(edit_id, "line_width", seq, &tmp_val)) {
         GDprops_set_line_width(props_id, tmp_val);
	 GDprops_set_inherit(props_id, 0);
         OMset_name_int_val(edit_id, OMstr_to_name("inherit"), 0);
      }

      /* update line style */
      if (GDget_updint_val(edit_id, "line_style", seq, &tmp_val)) {
         GDprops_get_line_style(props_id, &old_val);
         if( old_val != tmp_val ) {
            GDprops_set_line_style(props_id, tmp_val);
            GDprops_set_inherit(props_id, 0);
            OMset_name_int_val(edit_id, OMstr_to_name("inherit"), 0);
         }
      }

      /* update line aa */
      if (GDget_updint_val(edit_id, "line_aa", seq, &tmp_val)) {
         GDprops_set_line_aa(props_id, tmp_val);
	 GDprops_set_inherit(props_id, 0);
         OMset_name_int_val(edit_id, OMstr_to_name("inherit"), 0);
      }

      /* update directed point size */
      if (GDget_updfloat_val(edit_id, "dir_pt_size", seq, &tmp_float)) {
         GDprops_set_dir_pt_size(props_id, tmp_float);
	 GDprops_set_inherit(props_id, 0);
         OMset_name_int_val(edit_id, OMstr_to_name("inherit"), 0);
      }

      /* update subdiv */
      if (GDget_updint_val(edit_id, "subdiv", seq, &tmp_val)) {
         GDprops_set_subdiv(props_id, tmp_val);
         GDprops_set_inherit(props_id, 0);
         OMset_name_int_val(edit_id, OMstr_to_name("inherit"), 0);
      }

      /* update jitter */
      if (GDget_updint_val(edit_id, "jitter", seq, &tmp_val)) {
         GDprops_set_jitter(props_id, tmp_val);
         GDprops_set_inherit(props_id, 0);
         OMset_name_int_val(edit_id, OMstr_to_name("inherit"), 0);
      }

      /* update cull */
      if (GDget_updint_val(edit_id, "cull", seq, &tmp_val)) {
         GDprops_get_cull(props_id, &old_val);
         if( old_val != tmp_val ) {
            GDprops_set_cull(props_id, tmp_val);
            GDprops_set_inherit(props_id, 0);
            OMset_name_int_val(edit_id, OMstr_to_name("inherit"), 0);
         }
      }

      /* update vox interp */
      if (GDget_updint_val(edit_id, "voxel_interp", seq, &tmp_val)) {
         GDprops_get_vox_interp(props_id, &old_val);
         if( old_val != tmp_val ) {
            GDprops_set_vox_interp(props_id, tmp_val);
            GDprops_set_inherit(props_id, 0);
            OMset_name_int_val(edit_id, OMstr_to_name("inherit"), 0);
         }
      }

      /* update ray algo */
      if (GDget_updint_val(edit_id, "ray_algo", seq, &tmp_val)) {
         GDprops_get_ray_algo(props_id, &old_val);
         if( old_val != tmp_val ) {
            GDprops_set_ray_algo(props_id, tmp_val);
            GDprops_set_inherit(props_id, 0);
            OMset_name_int_val(edit_id, OMstr_to_name("inherit"), 0);
         }
      }

      /* update ray norm */
      if (GDget_updint_val(edit_id, "ray_norm", seq, &tmp_val)) {
         GDprops_get_ray_norm(props_id, &old_val);
         if( old_val != tmp_val ) {
            GDprops_set_ray_norm(props_id, tmp_val);
            GDprops_set_inherit(props_id, 0);
            OMset_name_int_val(edit_id, OMstr_to_name("inherit"), 0);
         }
      }

      /* update vox interp */
      if (GDget_updint_val(edit_id, "fat_ray", seq, &tmp_val)) {
         GDprops_set_fat_ray(props_id, tmp_val);
         GDprops_set_inherit(props_id, 0);
         OMset_name_int_val(edit_id, OMstr_to_name("inherit"), 0);
      }

      /* update sfp aborption */
      if (GDget_updfloat_val(edit_id, "sfp_absorb", seq, &tmp_float)) {
         GDprops_set_sfp_absorb(props_id, tmp_float);
	 GDprops_set_inherit(props_id, 0);
         OMset_name_int_val(edit_id, OMstr_to_name("inherit"), 0);
      }

      /* update sfp emission */
      if (GDget_updfloat_val(edit_id, "sfp_emit", seq, &tmp_float)) {
         GDprops_set_sfp_emit(props_id, tmp_float);
	 GDprops_set_inherit(props_id, 0);
         OMset_name_int_val(edit_id, OMstr_to_name("inherit"), 0);
      }

      /* update inherit */
      if (GDget_updint_val(edit_id, "inherit", seq, &tmp_val))
         GDprops_set_inherit(props_id, tmp_val);
      OMset_state_to_usr(0);
   }
   /* Else the modes editor sub-elements have not changed, see if
      we need to update those sub-elements based on changes to the
      modes we are attached to or the reset or active flags changing.
   */
   else {
      /* Get reset status. If it has changed, we need to reset
         the props we are attached to and the props editor sub-elements
         as well.
      */
      if (GDget_updint_val(edit_id, "reset", seq, &reset)) {
         OMset_name_real_val(edit_id, OMstr_to_name("red"), GD_DEFAULT_RED);
         OMset_name_real_val(edit_id, OMstr_to_name("green"), GD_DEFAULT_GREEN);
         OMset_name_real_val(edit_id, OMstr_to_name("blue"), GD_DEFAULT_BLUE);
         OMset_name_real_val(edit_id, OMstr_to_name("hi1_red"), GD_DEFAULT_RED);
         OMset_name_real_val(edit_id, OMstr_to_name("hi1_green"), GD_DEFAULT_GREEN);
         OMset_name_real_val(edit_id, OMstr_to_name("hi1_blue"), GD_DEFAULT_BLUE);
         OMset_name_real_val(edit_id, OMstr_to_name("hi2_red"), 0.0);
         OMset_name_real_val(edit_id, OMstr_to_name("hi2_green"), 0.0);
         OMset_name_real_val(edit_id, OMstr_to_name("hi2_blue"), GD_DEFAULT_BLUE);
         OMset_name_real_val(edit_id, OMstr_to_name("spec_red"), GD_DEFAULT_RED);
         OMset_name_real_val(edit_id, OMstr_to_name("spec_green"), GD_DEFAULT_GREEN);
         OMset_name_real_val(edit_id, OMstr_to_name("spec_blue"), GD_DEFAULT_BLUE);
         OMset_name_real_val(edit_id, OMstr_to_name("ambient"), GD_DEFAULT_AMBIENT);
         OMset_name_real_val(edit_id, OMstr_to_name("diffuse"), GD_DEFAULT_DIFFUSE);
         OMset_name_real_val(edit_id, OMstr_to_name("specular"), GD_DEFAULT_SPECULAR);
         OMset_name_real_val(edit_id, OMstr_to_name("spec_exp"), GD_DEFAULT_SPEC_EXP);
         OMset_name_real_val(edit_id, OMstr_to_name("trans"), GD_DEFAULT_TRANS);
         OMset_name_int_val(edit_id, OMstr_to_name("draw_mode"), GD_DEFAULT_DRAW_MODE);
         OMset_name_int_val(edit_id, OMstr_to_name("line_width"), GD_DEFAULT_LINE_WIDTH);
         OMset_name_int_val(edit_id, OMstr_to_name("line_style"), GD_DEFAULT_LINE_STYLE);
         OMset_name_int_val(edit_id, OMstr_to_name("line_aa"), GD_DEFAULT_LINE_AA);
         OMset_name_real_val(edit_id, OMstr_to_name("dir_pt_size"), GD_DEFAULT_DIR_PT_SIZE);
         OMset_name_int_val(edit_id, OMstr_to_name("subdiv"), GD_DEFAULT_SUBDIV);
         OMset_name_int_val(edit_id, OMstr_to_name("jitter"), GD_DEFAULT_JITTER);
         OMset_name_int_val(edit_id, OMstr_to_name("cull"), GD_DEFAULT_CULL);
         OMset_name_int_val(edit_id, OMstr_to_name("voxel_interp"), GD_DEFAULT_VOX_INTERP);
         OMset_name_int_val(edit_id, OMstr_to_name("ray_algo"), GD_DEFAULT_RAY_ALGO);
         OMset_name_int_val(edit_id, OMstr_to_name("ray_norm"), GD_DEFAULT_RAY_NORM);
         OMset_name_int_val(edit_id, OMstr_to_name("fat_ray"), GD_DEFAULT_FAT_RAY);
         OMset_name_real_val(edit_id, OMstr_to_name("sfp_absorb"), GD_DEFAULT_SFP_ABSORB);
         OMset_name_real_val(edit_id, OMstr_to_name("sfp_emit"), GD_DEFAULT_SFP_EMIT);
         OMset_name_int_val(edit_id, OMstr_to_name("inherit"), 1);
         GDprops_reset(props_id);
      }

      /* Get active status. If the active status has changed,
         the modes editor is most likely becoming visible or invisible.
         If it is becoming visible, we need to update the sub-elements
         that would normally be attached to UI widgets.
         If it is becoming invisible, we don't have to do anything.
      */
      GDget_updint_val(edit_id, "shell_vis", seq, &active);
      if (active) {
         /* update inherit */
         GDprops_get_inherit(props_id, &tmp_val);
         OMset_name_int_val(edit_id, OMstr_to_name("inherit"), tmp_val);

         /* update color */
         GDprops_get_color(props_id, ocol);
         OMset_name_real_val(edit_id, OMstr_to_name("red"), ocol[0]);
         OMset_name_real_val(edit_id, OMstr_to_name("green"), ocol[1]);
         OMset_name_real_val(edit_id, OMstr_to_name("blue"), ocol[2]);

         /* update highlight color 1 */
         GDprops_get_hi1_col(props_id, col);
         OMset_name_real_val(edit_id, OMstr_to_name("hi1_red"), col[0]);
         OMset_name_real_val(edit_id, OMstr_to_name("hi1_green"), col[1]);
         OMset_name_real_val(edit_id, OMstr_to_name("hi1_blue"), col[2]);

         /* update highlight color 2 */
         GDprops_get_hi2_col(props_id, col);
         OMset_name_real_val(edit_id, OMstr_to_name("hi2_red"), col[0]);
         OMset_name_real_val(edit_id, OMstr_to_name("hi2_green"), col[1]);
         OMset_name_real_val(edit_id, OMstr_to_name("hi2_blue"), col[2]);

         /* update specular color */
         GDprops_get_specular_color(props_id, col);
         OMset_name_real_val(edit_id, OMstr_to_name("spec_red"), col[0]);
         OMset_name_real_val(edit_id, OMstr_to_name("spec_green"), col[1]);
         OMset_name_real_val(edit_id, OMstr_to_name("spec_blue"), col[2]);

	 /*
	  * The metal factor is the ratio of the saturation of the
	  * specular color to the surface color.  Basically we just go
	  * from the surface color (metal = 1) to white (metal = 0)
	  *
	  * This may not be accurate if the specular color was specified
	  * with some other mechanism.
	  */
	 COLORrgb_to_hsv(ocol[0],ocol[1],ocol[2],&ocol[0],&ocol[1],&ocol[2]);
	 COLORrgb_to_hsv(col[0],col[1],col[2],&col[0],&col[1],&col[2]);
	 if (ocol[1] < 0.001) metal = 0.0;
	 else metal = col[1] / ocol[1];
	 OMset_name_real_val(edit_id, OMstr_to_name("metal"), metal);

         /* update material */
         GDprops_get_material(props_id, material);
         OMset_name_real_val(edit_id, OMstr_to_name("ambient"), material[0]);
         OMset_name_real_val(edit_id, OMstr_to_name("diffuse"), material[1]);
         OMset_name_real_val(edit_id, OMstr_to_name("specular"), material[2]);
         OMset_name_real_val(edit_id, OMstr_to_name("spec_exp"), material[3]);

         /* update transparency */
         GDprops_get_transparency(props_id, &trans);
         OMset_name_real_val(edit_id, OMstr_to_name("trans"), trans);

         /* update draw mode */
         GDprops_get_draw_mode(props_id, &tmp_val);
         OMset_name_int_val(edit_id, OMstr_to_name("draw_mode"), tmp_val);

         /* update line width */
         GDprops_get_line_width(props_id, &tmp_val);
         OMset_name_int_val(edit_id, OMstr_to_name("line_width"), tmp_val);

         /* update line style */
         GDprops_get_line_style(props_id, &tmp_val);
         OMset_name_int_val(edit_id, OMstr_to_name("line_style"), tmp_val);

         /* update line aa */
         GDprops_get_line_aa(props_id, &tmp_val);
         OMset_name_int_val(edit_id, OMstr_to_name("line_aa"), tmp_val);

         /* update directed point size */
         GDprops_get_dir_pt_size(props_id, &tmp_float);
         OMset_name_real_val(edit_id, OMstr_to_name("dir_pt_size"), tmp_float);

         /* update subdiv */
         GDprops_get_subdiv(props_id, &tmp_val);
         OMset_name_int_val(edit_id, OMstr_to_name("subdiv"), tmp_val);

         /* update subdiv */
         GDprops_get_jitter(props_id, &tmp_val);
         OMset_name_int_val(edit_id, OMstr_to_name("jitter"), tmp_val);

         /* update cull */
         GDprops_get_cull(props_id, &tmp_val);
         OMset_name_int_val(edit_id, OMstr_to_name("cull"), tmp_val);

         /* update vox interp */
         GDprops_get_vox_interp(props_id, &tmp_val);
         OMset_name_int_val(edit_id, OMstr_to_name("voxel_interp"), tmp_val);

         /* update ray_algo */
         GDprops_get_ray_algo(props_id, &tmp_val);
         OMset_name_int_val(edit_id, OMstr_to_name("ray_algo"), tmp_val);

         /* update ray norm */
         GDprops_get_ray_norm(props_id, &tmp_val);
         OMset_name_int_val(edit_id, OMstr_to_name("ray_norm"), tmp_val);

         /* update fat ray */
         GDprops_get_fat_ray(props_id, &tmp_val);
         OMset_name_int_val(edit_id, OMstr_to_name("fat_ray"), tmp_val);

         /* update sfp absorption */
         GDprops_get_sfp_absorb(props_id, &tmp_float);
         OMset_name_real_val(edit_id, OMstr_to_name("sfp_absorb"), tmp_float);

         /* update sfp emission */
         GDprops_get_sfp_emit(props_id, &tmp_float);
         OMset_name_real_val(edit_id, OMstr_to_name("sfp_emit"), tmp_float);
      }
   }
   return(1);
}
