/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved
	
	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.
	
	This file is under Perforce control
	$Id: //depot/express/fcs70/gd/sw/sw_init.c#1 $
*/

#define XP_WIDE_API	/* Use Wide APIs */

#include <stdio.h>

#include <avs/util.h>
#include <avs/om.h>
#include <avs/om_type.h>
#include <avs/gd.h>
#include "swx.h"

/* Software renderer specific function tables */
/* Software renderer view device dependent functions */
static OMfunc_table GDsw_view_funcs[] = {
   { (OMpfi)GDsw_view_transp_pass,	"GDsw_view_transp_pass" },
   { (OMpfi)GDsw_view_accel,		"GDsw_view_accel" },
#ifndef MSDOS
   { (OMpfi)GDswx_view_available,	"GDsw_view_available" },
   { (OMpfi)GDswx_view_create,          "GDsw_view_create" },
   { (OMpfi)GDswx_view_clear,           "GDsw_view_clear" },
   { (OMpfi)GDswx_view_swap1,           "GDsw_view_swap1" },
   { (OMpfi)GDswx_view_image_pass,      "GDsw_view_image_pass" },
   { (OMpfi)GDswx_view_accel2d,			"GDsw_view_accel2d" },
   { (OMpfi)GDswx_view_swap2,           "GDsw_view_swap2" },
   { (OMpfi)GDswx_view_refresh,         "GDsw_view_refresh" },
   { (OMpfi)GDswx_view_delete,          "GDsw_view_delete" },
   { (OMpfi)GDswx_view_resize,          "GDsw_view_resize" },
   { (OMpfi)GDswx_view_get_buffers,     "GDsw_view_get_buffers" },
   { (OMpfi)GDswx_view_set_video_mode,  "GDsw_view_set_video_mode" },
   { (OMpfi)GDswx_view_set_left_eye,    "GDsw_view_set_left_eye" },
   { (OMpfi)GDswx_view_set_right_eye,   "GDsw_view_set_right_eye" },
   { (OMpfi)GDswx_view_get_image,		"GDsw_view_get_image" },
   { (OMpfi)GDswx_view_put_image,		"GDsw_view_put_image" },
#else
   { (OMpfi)GDsww_view_available,	"GDsw_view_available" },
   { (OMpfi)GDsww_view_create,          "GDsw_view_create" },
   { (OMpfi)GDsww_view_clear,           "GDsw_view_clear" },
   { (OMpfi)GDsww_view_swap1,           "GDsw_view_swap1" },
   { (OMpfi)GDsww_view_image_pass,      "GDsw_view_image_pass" },
   { (OMpfi)GDsww_view_accel2d,		"GDsw_view_accel2d" },
   { (OMpfi)GDsww_view_swap2,           "GDsw_view_swap2" },
   { (OMpfi)GDsww_view_refresh,         "GDsw_view_refresh" },
   { (OMpfi)GDsww_view_delete,          "GDsw_view_delete" },
   { (OMpfi)GDsww_view_resize,          "GDsw_view_resize" },
   { (OMpfi)GDsww_view_get_buffers,     "GDsw_view_get_buffers" },
   { (OMpfi)GDsww_view_set_video_mode,  "GDsw_view_set_video_mode" },
   { (OMpfi)GDsww_view_set_left_eye,    "GDsw_view_set_left_eye" },
   { (OMpfi)GDsww_view_set_right_eye,   "GDsw_view_set_right_eye" },
   { (OMpfi)GDsww_view_get_image,		"GDsw_view_get_image" },
   { (OMpfi)GDsww_view_put_image,		"GDsw_view_put_image" },
#endif
};

/* Software renderer state device dependent functions */
static OMfunc_table GDsw_state_funcs[] = {
   { (OMpfi)GDsw_state_create,		"GDsw_state_create" },
   { (OMpfi)GDsw_state_delete,		"GDsw_state_delete" },
   { (OMpfi)GDsw_state_init,		"GDsw_state_init" },
   { (OMpfi)GDstate_concat_obj_matrix,	"GDstate_concat_obj_matrix" },
   { (OMpfi)GDstate_set_backface_cull,	"GDstate_set_backface_cull" },
   { (OMpfi)GDstate_set_vox_interp,	"GDstate_set_vox_interp" },
   { (OMpfi)GDstate_set_ray_algo,	"GDstate_set_ray_algo" },
   { (OMpfi)GDstate_set_ray_norm,	"GDstate_set_ray_norm" },
   { (OMpfi)GDstate_set_blend_mode,	"GDstate_set_blend_mode" },
   { (OMpfi)GDstate_set_fat_ray,	"GDstate_set_fat_ray" },
   { (OMpfi)GDstate_set_sfp_absorb,	"GDstate_set_sfp_absorb" },
   { (OMpfi)GDstate_set_sfp_emit,	"GDstate_set_sfp_emit" },
   { (OMpfi)GDsw_set_camera_attrs,	"GDsw_set_camera_attrs" },
   { (OMpfi)GDstate_set_color,		"GDstate_set_color" },
   { (OMpfi)GDstate_set_highlight_colors,	"GDstate_set_highlight_colors" },
   { (OMpfi)GDstate_set_draw_mode,	"GDstate_set_draw_mode" },
   { (OMpfi)GDstate_set_font,		"GDstate_set_font" },
   { (OMpfi)GDstate_set_line_width,	"GDstate_set_line_width" },
   { (OMpfi)GDstate_set_line_style,	"GDstate_set_line_style" },
   { (OMpfi)GDstate_set_dir_pt_size,	"GDstate_set_dir_pt_size" },
   { (OMpfi)GDstate_set_jitter,		"GDstate_set_jitter" },
   { (OMpfi)GDstate_set_cmap,		"GDstate_set_cmap" },
   { (OMpfi)GDstate_set_depth_cue,	"GDstate_set_depth_cue" },
   { (OMpfi)GDsw_set_lights,		"GDsw_set_lights" },
   { (OMpfi)GDstate_set_material,	"GDstate_set_material" },
   { (OMpfi)GDstate_set_mode,		"GDstate_set_mode" },
   { (OMpfi)GDstate_set_mode_normals,	"GDstate_set_mode_normals" },
   { (OMpfi)GDstate_set_mode_outline,	"GDstate_set_mode_outline" },
   { (OMpfi)GDstate_set_obj_matrix,	"GDstate_set_obj_matrix" },
   { (OMpfi)GDstate_set_specular_color,	"GDstate_set_specular_color" },
   { (OMpfi)GDstate_set_texture,	"GDstate_set_texture" },
   { (OMpfi)GDstate_set_transparency,	"GDstate_set_transparency" },
   { (OMpfi)GDstate_update_matrix,	"GDstate_update_matrix" },
   { (OMpfi)GDstate_set_drawable,	"GDstate_set_drawable" },
   { (OMpfi)GDstate_set_viewport,	"GDstate_set_viewport" },
   { (OMpfi)GDstate_set_stereo_attrs,	"GDstate_set_stereo_attrs" },
};

/* Software renderer primitive device dependent functions */
static OMfunc_table GDsw_prim_funcs[] = {
   { (OMpfi)GDsw_points,	"GDsw_points" },
   { (OMpfi)GDsw_lines,		"GDsw_lines" },
   { (OMpfi)GDsw_polyline,	"GDsw_polyline" },
   { (OMpfi)GDsw_polytri,	"GDsw_polytri" },
   { (OMpfi)GDsw_spheres,	"GDsw_spheres" },
   { (OMpfi)GDsw_image,		"GDsw_image" },
   { (OMpfi)GDsw_image_tiled,	"GDsw_image_tiled" },
   { (OMpfi)GDsw_text,          "GDsw_text" },
   { (OMpfi)GDsw_2d_text,	"GDsw_2d_text" },
   { (OMpfi)GDsw_2d_points,	"GDsw_2d_points" },
   { (OMpfi)GDsw_2d_lines,	"GDsw_2d_lines" },
   { (OMpfi)GDsw_2d_polyline,	"GDsw_2d_polyline" },
   { (OMpfi)GDsw_2d_polylines,	"GDsw_2d_polylines" },
   { (OMpfi)GDsw_2d_polytri,	"GDsw_2d_polytri" },
   { (OMpfi)GDsw_2d_polygons,	"GDsw_2d_polygons" },
   { (OMpfi)GDsw_geom_init,	"GDsw_geom_init" },
   { (OMpfi)GDsw_geom_build,	"GDsw_geom_build" },
   { (OMpfi)GDsw_geom_free,	"GDsw_geom_free" },
};


void GDgd_init_sw()
{
   char *env_str;

   OMadd_named_funcs(GDsw_view_funcs, sizeof(GDsw_view_funcs)/sizeof(OMfunc_table));
   OMadd_named_funcs(GDsw_state_funcs, sizeof(GDsw_state_funcs)/sizeof(OMfunc_table));
   OMadd_named_funcs(GDsw_prim_funcs, sizeof(GDsw_prim_funcs)/sizeof(OMfunc_table));

   /* set default renderer as us if env var indicates */
   env_str = getenv("XP_DEFAULT_RENDERER");
   if (env_str && (!strcmp(env_str, "SW") || !strcmp(env_str, "sw")))
   {
     OMobj_id obj_id;
     int      default_renderer = GD_SWX_RENDERER;

     obj_id = OMfind_str_subobj(OMtempl_obj,"CONFIG.gd_default_renderer", 
				OM_OBJ_RW);
     if (!OMis_null_obj(obj_id))
       OMset_int_val(obj_id, default_renderer);
   }
}

