/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by the Board of Trustees of the University of Illinois.         *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the files COPYING and Copyright.html.  COPYING can be found at the root   *
 * of the source code distribution tree; Copyright.html can be found at the  *
 * root level of an installed copy of the electronic HDF5 document set and   *
 * is linked from the top-level documents page.  It can also be found at     *
 * http://hdf.ncsa.uiuc.edu/HDF5/doc/Copyright.html.  If you do not have     *
 * access to either file, you may request a copy from hdfhelp@ncsa.uiuc.edu. *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*
 * This is the main public HDF5 include file.  Put further information in
 * a particular header file and include that here, don't fill this file with
 * lots of gunk...
 */
#ifndef _HDF5_H
#define _HDF5_H

#include "H5public.h"
#include "H5Ipublic.h"		/* Interface abstraction		*/
#include "H5Apublic.h"		/* Attributes				*/
#include "H5ACpublic.h"		/* Metadata cache			*/
#include "H5Bpublic.h"		/* B-trees				*/
#include "H5Dpublic.h"		/* Datasets				*/
#include "H5Epublic.h"		/* Errors				*/
#include "H5Fpublic.h"		/* Files				*/
#include "H5FDpublic.h"		/* File drivers				*/
#include "H5Gpublic.h"		/* Groups				*/
#include "H5HGpublic.h"		/* Global heaps				*/
#include "H5HLpublic.h"		/* Local heaps				*/
#include "H5MMpublic.h"		/* Memory management			*/
#include "H5Opublic.h"		/* Object headers			*/
#include "H5Ppublic.h"		/* Property lists			*/
#include "H5Rpublic.h"		/* References				*/
#include "H5Spublic.h"		/* Dataspaces				*/
#include "H5Tpublic.h"		/* Datatypes				*/
#include "H5Zpublic.h"		/* Data filters				*/

/* Predefined file drivers */
#include "H5FDcore.h"		/* Files stored entirely in memory	*/
#include "H5FDfamily.h"		/* File families 			*/
#ifdef H5_HAVE_FPHDF5
#include "H5FDfphdf5.h" 	/* Flexible Parallel HDF5               */
#endif
#ifdef H5_HAVE_GASS
#include "H5FDgass.h"		/* Remote files using GASS I/O		*/
#endif
#include "H5FDlog.h"        	/* sec2 driver with I/O logging (for debugging) */
#include "H5FDmpio.h"		/* Parallel files using MPI-2 I/O	*/
#include "H5FDmpiposix.h"	/* Parallel files using combination MPI-2 & posix I/O */
#include "H5FDmulti.h"		/* Usage-partitioned file family	*/
#include "H5FDsec2.h"		/* POSIX unbuffered file I/O		*/
#ifdef H5_HAVE_SRB
#include "H5FDsrb.h"        	/* Remote access using SRB              */
#endif
#include "H5FDstdio.h"		/* Standard C buffered I/O		*/
#include "H5FDstream.h"     	/* In-memory files streamed via sockets */

#endif
