/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/tool/arr_type.c#1 $
*/

#define XP_WIDE_API	/* Use Wide APIs */

#include <stdlib.h>

#include <avs/dll_in.h>
#include <avs/comm.h>
#include <avs/arr.h>
#include <avs/err.h>

ARRtype *ARR_type_malloc;
ARRtype *ARR_type_unmanaged;

/* First arg is really a COMMconn * */
extern int (*ARR_read_prim_rtn) (void *, int, char *);
/* First arg is really a RPpacket *   */
extern void (*ARR_write_int_rtn) (void *, int);
extern void (*ARR_write_long_rtn) (void *, xp_long);
/* First arg is really a COMMconn * */
extern int (*ARR_read_array_rtn) (void *, int, char **, xp_long);
/* First arg is really a RPpacket *   */
extern void (*ARR_write_array_rtn) (void *, int, char *, xp_long);

int ARRmalloc_read (void *conn, int *type, char **ptr, xp_long *len, int mode);
int ARRmalloc_write (void *conn, int type, char *ptr, xp_long len, int mode);


void *
ARRmalloc_alloc(size_t len, char *info) /* ARGSUSED */
{
   return(malloc(len));
}

void *
ARRmalloc_realloc(void *ptr, size_t len, char *info) /* ARGSUSED */
{
   return(realloc(ptr, len));
}

void
ARRmalloc_free(void *ptr, char *info) /* ARGSUSED */
{
   free(ptr);
}

/* 64-bit porting. Directly Modified */
int
ARRmalloc_read(
     void *conn,
     int *type,
     char **ptr,
     xp_long *len,
     int mode )
{
   int stat;
   int toread;
   int alloced;

   xp_long i;

   stat = (*ARR_read_prim_rtn)(conn, DTYPE_LONG,  (char *)len);
   stat += (*ARR_read_prim_rtn)(conn, DTYPE_INT, (char *)type);
   if (*len == 0) return(1);
   /*
    * Do not allocate space here unless this guy started out as NULL.
    * This is the case in OMget_array where the ptr is set to allow
    * us to copy directly into the users space.
    */
   if (*ptr == NULL) {
      *ptr = ARRalloc(ARR_type_malloc,*type,*len,NULL);
      alloced = 1;
   }
   else alloced = 0;
   if (*ptr == NULL) {
#define NELEMS 256
      double buf[NELEMS];
      char *buf_ptr = (char *)buf;
      ERRerror("ARRmalloc_read",2,ERR_ORIG,
	"array allocation failed during array read of type: %s size: %ld\n",
	DTYPEtype_id_to_str(*type),*len);

      if (*len < 0)
         return(0);
      /*
       * We've still got to chew up the values that we didn't read
       * or else we throw off the count majorly..
       */
      for (i = 0; i < *len / NELEMS; i++) {
         stat = (*ARR_read_array_rtn)(conn, *type, &buf_ptr, NELEMS);
	 if (stat != 1)
	    return(-1);
      }
      /*
       * Chew up the remainder..
       */
      stat = (*ARR_read_array_rtn)(conn, *type, &buf_ptr, *len % NELEMS);
      if (stat != 1)
	 return(-1);

      /* 
       * A return of 0 means that the connection is still ok, but the
       * read of the request failed...  This allows us to recover from
       * this error.
       */
      return(0);
   }
   if (mode == ARR_ARRAY_WR) return(1);
   stat += (*ARR_read_array_rtn)(conn, *type, ptr, *len);
   if (stat != 3) {
      if (alloced) {
         ARRfree(*ptr);
	 *ptr = NULL;
      }
      ERRerror("ARRmalloc_read",2,ERR_ORIG,
	"read of array from connection failed. type: %s size: %ld\n",
	DTYPEtype_id_to_str(*type),*len);
      return(-1);
   }
   return(1);
}

/* 64-bit porting. Directly Modified */
int
ARRmalloc_write(
     void *write_arg,
     int type,
     char *ptr,
     xp_long len,
     int mode )
{
   (*ARR_write_long_rtn)(write_arg,len);
   (*ARR_write_int_rtn)(write_arg,type);
   if (mode == ARR_ARRAY_WR) return(1);
   (*ARR_write_array_rtn)(write_arg, type, ptr, len);
   return(1);
}

void *
ARRunmanaged_alloc(size_t len, char *info) /* ARGSUSED */
{
   ERRerror("ARRunmanaged_alloc",0,ERR_ORIG,
	    "can't allocate an unmanaged array");
   return(NULL);
}

void *
ARRunmanaged_realloc(void *ptr, size_t len, char *info) /* ARGSUSED */
{
   ERRerror("ARRunmanaged_realloc",0,ERR_ORIG,
	    "can't reallocate an unmanaged array");
   return(ptr);
}

void
ARRunmanaged_free(void *ptr, char *info) /* ARGSUSED */
{
}

/* 64-bit porting. Directly Modified */
int
ARRunmanaged_read(
     void *conn,
     int *type,
     char **ptr,
     xp_long *len,
     int mode )
{
   return(ARRmalloc_read(conn, type, ptr, len, mode));
}

/* 64-bit porting. Directly Modified */
int
ARRunmanaged_write(
     void *write_arg,
     int type,
     char *ptr,
     xp_long len,
     int mode )
{
   return(ARRmalloc_write(write_arg, type, ptr, len, mode));
}

void
ARRinit_types(void)
{
   ARR_type_malloc = ARRnew_type("malloc",ARRmalloc_alloc,ARRmalloc_realloc,
				   ARRmalloc_free,ARRmalloc_read, 
				   ARRmalloc_write);
   ARR_type_unmanaged = ARRnew_type("unmanaged",
				    ARRunmanaged_alloc,ARRunmanaged_realloc,
				    ARRunmanaged_free,ARRunmanaged_read, 
				    ARRunmanaged_write);
   ARRset_default_type(ARR_type_malloc);
}
