/*
			Copyright (c) 1996 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/webclnt/xp_mods/geturl.c#1 $
*/

#define XP_WIDE_API	/* Use Wide APIs */

#include <stdio.h>
#include <stdlib.h>

/* Express headers */
#include <avs/om.h>
#define METHOD_SUCCESS 1
#define METHOD_FAILURE 0
#define ERR_RETURN(A) {ERRerror("geturl", 0, ERR_ORIG, A); \
                       return METHOD_FAILURE;}

/* cURL headers */
#include <curl/curl.h>
#include <curl/types.h>
#include <curl/easy.h>

/*
 * Interface between AVS/Express and the cURL library
 * used for downloading files specified by a URL.
 *
 * Based in part on doc/examples/ftpget.c from the curl 
 * distribution.
 */

struct FtpFile {
    char *filename;
    FILE *stream;
};

static int
callback_fwrite(void *buffer, size_t size, size_t nmemb, void *stream )
{
    struct FtpFile *out = (struct FtpFile *)stream;
    if( out && !out->stream ) {
        /* open file for writing */
#if 0
        fprintf( stderr, "Opening %s\n", out->filename );
#endif
        out->stream = fopen( out->filename, "wb" );
        if( !out->stream )
            return -1; /* failure, can't open file to write */
    }
#if 0
    fprintf( stderr, "Writing: %ld x %ld bytes\n", size, nmemb );
#endif
    return fwrite( buffer, size, nmemb, out->stream );
}

/* 64-bit porting. Only Modified Internally */
static int
callback_progress(void *data,
                  double dltotal, double dlcurr,
                  double ultotal, double ulcurr )
{
    if( dltotal > 0 ) {
#if 0
        fprintf( stderr, "Percent downloaded: %ld\n",
                 (xp_long)((dlcurr*100/dltotal)+0.499999) );
#endif
        OMstatus_check( (int)((dlcurr*100/dltotal)+0.499999),
                        "geturl", NULL );
    }
    return 0;
}

/* 64-bit porting. Only Modified Internally */
int
geturl( OMobj_id ReadURL_id, OMevent_mask event_mask, int seq_num )
{
    int   numberOfUrlsRead = 0;
    char  *URL = NULL;
    char  *LocalFile = NULL;

    /* cURL variables */
    CURL *curl;
    CURLcode res;
    struct FtpFile ftpfile;

    char errorbuffer[CURL_ERROR_SIZE];
    char statusbuffer[CURL_ERROR_SIZE+256];

    /* Get URL's value */
    if (OMget_name_str_val(ReadURL_id, OMstr_to_name("URL"),
                           &URL, 0) != 1)
      URL = (char *) NULL;

#if 0	/* Obsolete? */
   /* This guy will fire when instanced. If there is nothing
    * in the URL field, it will fail in the local file test.
    * So, first time through, just exit.
    */
   if( event_mask & OM_EVENT_INST ) {
       if( (URL == (char *)NULL) || (strlen(URL) == 0) )
           return METHOD_SUCCESS;
   }
#endif

   if( URL == NULL ) {
       return METHOD_FAILURE;
   }

   ftpfile.filename = NULL;
   ftpfile.stream   = NULL;

   /* Get LocalFile's value */
   if( OMget_name_str_val(ReadURL_id, OMstr_to_name("LocalFile"),
			  &LocalFile, 0) != OM_STAT_SUCCESS ) {
       LocalFile = malloc( 256 );
#ifdef WIN32
       { char *p = _tempnam("\\", "XP_" );
         if( p != NULL ) {
           strcpy( LocalFile, p );
           free( p );
         }
         else strcpy( LocalFile, "XP_URL_tmp" );
       }
#else
       tmpnam( LocalFile );
#endif

   }
   else ftpfile.filename = LocalFile;

   if( event_mask & OM_EVENT_INST ) {
       curl_global_init( CURL_GLOBAL_DEFAULT );
   }
   curl = curl_easy_init( );

   if( curl ) {

       /* Initialize error handling */
       errorbuffer[0] = 0;
       curl_easy_setopt( curl, CURLOPT_ERRORBUFFER, errorbuffer );
       curl_easy_setopt( curl, CURLOPT_FAILONERROR, 1 );

       /* Setup callback to do actual file writing */
       curl_easy_setopt( curl, CURLOPT_WRITEFUNCTION, callback_fwrite );
       curl_easy_setopt( curl, CURLOPT_FILE, &ftpfile );

       /* Setup callback to do progress bar */
       curl_easy_setopt( curl, CURLOPT_NOPROGRESS, FALSE );
       curl_easy_setopt( curl, CURLOPT_PROGRESSFUNCTION, callback_progress );
       curl_easy_setopt( curl, CURLOPT_PROGRESSDATA, NULL ); /* TODO */

       /* Here is the URL to download */
       curl_easy_setopt( curl, CURLOPT_URL, URL );

       /* Do the download */
       res = curl_easy_perform( curl );

       /* cURL does not attempt to manage the contents of ftpfile,
        * so remember to close the stream. (Its opened in our
        * callback function.)
        */
       if( ftpfile.stream ) {
           fclose( ftpfile.stream );
       }

       statusbuffer[0] = 0;
       if( CURLE_OK != res ) {
           /* Download failed */
           sprintf( statusbuffer, "%s (error: %d)", errorbuffer, res );
       }
       else {
           double dlsize;
           res = curl_easy_getinfo( curl, CURLINFO_SIZE_DOWNLOAD, &dlsize );
           if( CURLE_OK == res ) {
               sprintf( statusbuffer, "Successfully downloaded %ld bytes",
                        (xp_long)(dlsize+0.499999) );
           }
           else {
               /* Not expecting to get here ... just in case */
               sprintf( statusbuffer, "Successful download" );
           }

           /* Set the trigger - successful read. */
           if( OMget_name_int_val( ReadURL_id, OMstr_to_name("captured"),
                                   &numberOfUrlsRead ) != OM_STAT_SUCCESS )
               numberOfUrlsRead = 0;
           numberOfUrlsRead++;
           OMset_name_int_val( ReadURL_id, OMstr_to_name("captured"),
                               numberOfUrlsRead );

           /* Reset the name field to trigger anything downstream
            * of this module.
            */
           OMset_name_str_val( ReadURL_id, OMstr_to_name("OutputFile"),
                               LocalFile );
       }

       OMset_name_str_val( ReadURL_id, OMstr_to_name("status"),
                           statusbuffer );

       /* always cleanup */
       curl_easy_cleanup( curl );
   }

   if( URL ) {
       free( URL );
   }
   if( LocalFile ) {
       free( LocalFile );
   }

   return METHOD_SUCCESS;
}
