//-*-Mode: C++;-*-
/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/motif_ui/ui/core.h#1 $
*/

#ifndef ui_core_h_
#define ui_core_h_

#ifdef XP_STD_IOSTREAM
#include <iostream>
using std::ostream;
#else
#include <iostream.h>
#endif

class UIwinHandle;

#include "ui_core.h"
#include "ui.h"
#include <avs/wt.h>

class UtString;

//
// Program generated hdr definition for class: UIwinHandle
//
typedef int  HandleEvent;
class UIwinHandle : public virtual OMXgroup {
   public:
	UIwinHandle(OMobj_id id = OMinst_obj ,
		 const char *name = NULL,
	         int mode = OMX_CREATE_NEW_OBJ,
	         OMXobj *parent_ptr = NULL,
	         const char *class_ptr = "UIwinHandle");
	virtual void	*ret_omx_ptr(const char *);
// Hand coded
	unsigned int		pushCtx( int, int, int );
	int			popCtx();
	Widget			widget();		// Get widget pointer
	void			widget( Widget );	// Set widget pointer
	Window			window();		// Get window value
	void			window( Window );	// Set window value
	HandleEvent		event();		// Get event value
	void			event( HandleEvent );	// Set event value

  private:
      OMXint _window;
      OMXptr _widget;
      OMXint _event;
};

// Some "helper" functions for OMobj_id types
Boolean		operator==(OMobj_id, OMobj_id);
Boolean		operator!=(OMobj_id, OMobj_id);
Boolean		operator!(ObjDefType);
ostream & operator<<(ostream &, OMobj_id);
// For Widget class
ostream & operator<<(ostream &, Widget);


class UIcore : public OMXobj {
  public:
	UIcore(OMobj_id);
	~UIcore();

	virtual void		setCoreResources(int SeqNum);
	virtual void		setResources(Widget, int );
	/* Set the active value*/
	virtual void		setActive(ObjDefType SubId, Widget hWnd);
	virtual void		setBackgroundPixmap( ObjDefType SubId, Widget hWnd, int SeqNum);
	virtual void		setBackgroundColor( ObjDefType SubId, Widget hWnd);
	virtual void		setForegroundColor( ObjDefType SubId, Widget hWnd);
	virtual void		setGroupToParent( ObjDefType SubId, Widget hWnd);
	/* Set visibilty of widget*/
//	virtual void		setVisible(Boolean value);
	/* Set widget font list */
	virtual void		setFontList(ObjDefType, Widget );
	static int		getColorFromString( Widget w, UtString colorString, XColor &xcolor );

	UIwinHandle		handle;
	UIcolor			color;
	UIpixmap		pixmap;
	UIfontAttributes	fontAttributes; // New fontset interface
	WTfontset_ptr		fontSet; // New fontset pointer to cache
	OMXstr			fontList;
	OMobj_id		ObjId;

  protected:
	void			setResourceList(ObjDefType); // Initialize widget resource list
	void			initFontSet(Widget, int);
	int			isCoreResource; // True when a core resource has changed and
						// children should be updated

  private:
	OMXstr			widgetRes; // Widget resource string object
	void			installConverters(); // Install resource converters
	static Boolean		convertersInstalled; // flag for cvt install method
};

//---- UIgeom -----------------------------------------------------------

class UIgeom {
   public:
	static Boolean		check();
	// Functions to Get Widget info
	static Boolean		getWidgetPos( Widget w, Position &x, Position &y );
	static Boolean		getWidgetSize( Widget w, Dimension &width, Dimension &height );
	static Boolean		getWidgetPosSize( Widget w, Position &x, Position &y, Dimension &width, Dimension &height );
	// Functions to Set Widget info
	static Boolean		setWidgetPos( Widget w, Position x, Position y );
	static Boolean		setWidgetSize( Widget w, Dimension width, Dimension height );
	static Boolean		setWidgetPosSize( Widget w, Position x, Position y, Dimension width, Dimension height );
};

#endif
