//-*-Mode: C++;-*-
/*
			Copyright (c) 1995 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/motif_ui/ui/import.h#1 $
*/

#ifndef _UIimport_h_
#define _UIimport_h_

//
// file: UIimport.h
//
// purpose: Define object used to 'import' UI components into AVS
//    Express object manager. UIimport inherits from UIwindow class
//    which provides general functionality of basic UI components.
//

#include <avs/om.h>

#include "ui.h"
#include "wind.h"
#include "layout.h"

#ifdef XP_STD_IOSTREAM
using std::cout;
using std::endl;
#endif

class UIimport: public UIwindow {
  public:
    UIimport( OMobj_id );
    ~UIimport();

    // Method to return Widget of parent based on object id
    //
    Widget GetParentWindow( OMobj_id );

    // Return the name of the widget (object name)
    //
    void GetWindowName( OMobj_id object, char *name, int maxlen );

    // Method to return the current size of window, attempts
    //   to read width and height from object, else defaults
    //
    void GetWindowSize( OMobj_id object, int &width, int &height );

    // Methods to return width and height individually, allows user
    //   to specify default if not set in object
    //
    void GetWindowWidth( OMobj_id object, int &width, int defaultWidth );
    void GetWindowHeight( OMobj_id object, int &height, int defaultHeight );

    // Instance Method, overload to create imported objects specific widget(s)
    //
    virtual Boolean	instanceObject(OMobj_id){
        cout << "UIimport::instanceObject(OMobj_id) must be implemented by user in derived class" << endl;
        return False;
    }

    virtual Boolean	instanceObject(){
        cout << "UIimport::instanceObject() must be implemented by user in derived class" << endl;
        return False;
    }

    // Post widget creation method, can use to initialize anything that needs 
    // widget created first.
    //
    virtual void onObjectCreate( Widget hWnd, OMobj_id object );
    virtual void onObjectCreate( Widget hWnd);

    // Update method, handles general resize, editing, etc, overload as
    //   required
    //
    virtual void updateObject( OMobj_id );
    virtual void updateObject(int);

    // Destroy method, use to destroy imported objects widgets, and clean up
    //
    virtual void destroyObject( OMobj_id );
    virtual void destroyObject();
};

#endif
