/*
    		Copyright (c) 1993 by
    		Advanced Visual Systems Inc.
    		All Rights Reserved

    This software comprises unpublished confidential information of
    Advanced Visual Systems Inc. and may not be used, copied or made
    available to anyone, except in accordance with the license
    under which it is furnished.

    This file is under Perforce control
    $Id: //depot/express/fcs70/motif_ui/ui/layout.h#1 $
*/

#ifndef _layout_h
#define _layout_h

#include "wind.h"
#include "cursor.h"

extern const int LAYOUT_HANDLE_SIZE;

enum UIlayoutObjectState {
	LAYOUT_OBJECT_OFF,
	LAYOUT_OBJECT_ON,
	LAYOUT_OBJECT_EXPOSE
};

enum UIlayoutObjectType {
	LAYOUT_OBJECT_NORMAL,
	LAYOUT_OBJECT_MOVE,
	LAYOUT_OBJECT_RESIZE
};

enum UIlayoutState { 
	LAYOUT_STATE_NORMAL, 
	LAYOUT_STATE_MOVE, 
	LAYOUT_STATE_RESIZE, 
	LAYOUT_STATE_PENDING_NORMAL 
};

class UIlayout {
  friend class UIlayoutEditState;

  public:
	UIlayout();
	~UIlayout();

	// Add and remove event handlers
	static void		addDirectEventHandlers(Widget hWnd);
	static void		addIndirectEventHandlers(Widget hWnd, Widget SendTo);
	static void		removeDirectEventHandlers(Widget hWnd);
	static void		removeIndirectEventHandlers(Widget hWnd, Widget SendTo);

	// main editor event handlers
	static void		buttonMotionCB(Widget, XtPointer, XMotionEvent *);
	static void		buttonPressCB(Widget, XtPointer, XButtonEvent *, Boolean *);
	static void		buttonReleaseCB(Widget, XtPointer, XButtonEvent *, Boolean *);
	static void		pointerMotionCB(Widget, XtPointer, XMotionEvent *);
	static void		enterNotifyCB(Widget w, Widget registered, XCrossingEvent *event);
	static void		keyPressCB(Widget, XtPointer, XKeyEvent *event);

	// indirect event handlers from composite widget types
	static void		indirectButtonMotionCB(Widget w, Widget hWnd, XMotionEvent *event);
	static void		indirectButtonPressCB(Widget w, Widget hWnd, XButtonEvent *event, Boolean *);
	static void		indirectButtonReleaseCB(Widget w, Widget hWnd, XButtonEvent *event, Boolean *);
	static void		indirectPointerMotionCB(Widget, Widget hWnd, XMotionEvent *);	

	// draws editor frame when widget gets expose events
	static void		overlayWindowExposeHandler(Widget, XPointer, XExposeEvent *); 

	static void		cleanupOnObjectDestroy( Widget w );
	static void 		cmdListEnterNotifyCB(Widget, Widget hWnd, XCrossingEvent *event);

	// draws editor frames and resize handles around widgets
	static void		drawLayoutObject( Widget, Window, GC, int x, int y, 
						 int width, int height, 
						 UIlayoutObjectType, UIlayoutObjectState);

	// snaps the x and y mouse position to the grid
	static Position		gridMapX(Position in, Position floor);
	static Position		gridMapY(Position in, Position floor);

	// Sets the current state of the editor
	static void		setState( UIlayoutState s );

	static int		editEnable;
	static UIlayoutState 	state;
	static UIlayoutObjectType potentialActionState;
	static Widget		moveWidget;
	static Position		last_motion_x, last_motion_y;

  protected:
	static Position		findParentZeroY(Widget w, Widget Parent);
	static Position		findParentZeroX(Widget w, Widget Parent);
	void			groupObjects();
	void			ungroupObjects();
	void			setChildPropagateEvents(Widget hWnd, Widget SendTo);
	int			edit_update(ObjDefType ObjId);
	void			rebuildWidgetTree(Widget hWnd);
	static void		cleanUpLayoutState();
	static int 		checkForReparent(Widget newParent, XtWidgetGeometry *request,
						 UIwindow **Parent, UIwindow **Win,
						 int x_root, int y_root, int x, int y);

	static int		snapToGrid;
	static int		gridX, gridY;
	static Time		moveReleaseTime;
	static Widget		destParent;
	static Position		destParent_x, destParent_y;
	static GC		layout_gc, expose_gc;
	static Window		root;
	static Position		select_x, select_y;
	static Dimension	last_motion_width, last_motion_height;
	static Boolean		changeX, changeY; 
	static Boolean		resizeWidth, resizeHeight;
	// Cursors for interaction in resize
	static Cursor		moveCursor; // Predefined cursor shapes
	static Cursor		resizeTCursor, resizeBCursor; // Predefined cursor shapes
	static Cursor		resizeLCursor, resizeRCursor; // Predefined cursor shapes
	static Cursor		resizeBLCursor, resizeBRCursor; // Predefined cursor shapes
	static Cursor		resizeTLCursor, resizeTRCursor; // Predefined cursor shapes
};

#endif
