/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/user/add_num.c#1 $
*/

/******************************************************************************
 *
 * These functions are invoked by the elements of the same name
 * defined in the file express/v/user.v (and linked together
 * during Express initialization by the functions BASEinit and
 * PREinit located in the generated file express/user.c).
 *
 *****************************************************************************/

#define XP_WIDE_API	/* Use Wide APIs */

#include <avs/err.h>
#include <avs/om.h>

#define METHOD_SUCCESS 1
#define METHOD_FAILURE 0

/******************************************************************************
 * Add two numbers
 *****************************************************************************/
int
USERadd_num(OMobj_id elem_id, OMevent_mask event_mask, int seq_num)
{
    OMobj_id src_1_id, src_2_id, res_id;
    double src_1, src_2, res;
    int stat;

    /*
     * First we look up the element id's for each of our sub-elements.
     *
     * Although adding error checking to OM calls is always a good thing to
     * do, the chance of a module not being able to find its own subobjects
     * is very low.
     */
    src_1_id = OMfind_subobj(elem_id, OMstr_to_name("src_1"), OM_OBJ_RD);
    if (OMis_null_obj(src_1_id)) {
	ERRerror("add_num", 0, ERR_ORIG, "can't find src_1");
	return METHOD_FAILURE;
    }

    src_2_id = OMfind_subobj(elem_id, OMstr_to_name("src_2"), OM_OBJ_RD);
    if (OMis_null_obj(src_2_id)) {
	ERRerror("add_num", 0, ERR_ORIG, "can't find src_2");
	return METHOD_FAILURE;
    }

    res_id = OMfind_subobj(elem_id, OMstr_to_name("res"), OM_OBJ_RW);
    if (OMis_null_obj(res_id)) {
	ERRerror("add_num", 0, ERR_ORIG, "can't find res");
	return METHOD_FAILURE;
    }

    /*
     * Next, we get the value of the source subelements.
     */
    stat = OMget_real_val(src_1_id, &src_1);
    if( stat != OM_STAT_SUCCESS ) {
	ERRerror("add_num", 0, ERR_ORIG, "can't get src_1's value");
        return METHOD_FAILURE;
    }

    stat = OMget_real_val(src_2_id, &src_2);
    if( stat != OM_STAT_SUCCESS ) {
	ERRerror("add_num", 0, ERR_ORIG, "can't get src_2's value");
        return METHOD_FAILURE;
    }

    /*
     * Next, we add the two source values.
     */
    res = src_1 + src_2;

    /* 
     * Finally, we set the subelement value of the result element 
     * and return 1 to indicate success.
     */
    stat = OMset_real_val(res_id, res);
    if( stat != OM_STAT_SUCCESS ) {
	ERRerror("add_num", 0, ERR_ORIG, "can't set res's value");
        return METHOD_FAILURE;
    }

    return METHOD_SUCCESS;
}

/******************************************************************************
 * Subtract two numbers
 *****************************************************************************/
int
USERsubtract_num(OMobj_id elem_id, OMevent_mask event_mask, int seq_num)
{
    double src_1, src_2, res;
    int stat;

    /*
     * First, we get the value of the source subelements.
     * "OMget_name_real_val" takes the parent element as its
     * first argument, and the target element as its second.
     * Here, we use the function OMstr_to_name to lookup the
     * element id for the target.
     */
    stat = OMget_name_real_val(elem_id, OMstr_to_name("src_1"), &src_1);
    if( stat != OM_STAT_SUCCESS ) {
	ERRerror("subtract_num", 0, ERR_ORIG, "can't get src_1");
        return METHOD_FAILURE;
    }
    stat = OMget_name_real_val(elem_id, OMstr_to_name("src_2"), &src_2);
    if( stat != OM_STAT_SUCCESS ) {
	ERRerror("subtract_num", 0, ERR_ORIG, "can't get src_2");
        return METHOD_FAILURE;
    }

    /*
     * Next, we add the two source values (the easy part).
     */
    res = src_1 - src_2;

    /* 
     * Finally, we set the subelement value of the result element 
     * and return 1 to indicate success.
     */
    stat = OMset_name_real_val(elem_id, OMstr_to_name("res"), res);
    if( stat != OM_STAT_SUCCESS ) {
	ERRerror("subtract_num", 0, ERR_ORIG, "can't set res");
        return METHOD_FAILURE;
    }

    return METHOD_SUCCESS;
}
