//			Copyright (c) 1994 by
//			Advanced Visual Systems Inc.
//			All Rights Reserved
//	
//	This software comprises unpublished confidential information of
//	Advanced Visual Systems Inc. and may not be used, copied or made
//	available to anyone, except in accordance with the license
//	under which it is furnished.
//	
//	This file is under Perforce control
//	$Id: //depot/express/fcs70/v/ACUmods.v#1 $
//	
//
// This file has been generated automatically by:
//   		express -avsui ../v/ACUmods.v
// It contains all the UI wrappers for the AVS modules and needs to be updated
// whenever new AVS modules are added.
//
library+buffered ACU_Data_Input {
//
// ACU_background
//
macro ACU_background {
   ilink input0;

   Data_Input.background background {
      Input => input0;
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "background";
     message = "Select background control panel.";
     rowColumnBehavior = 1;
   };

   Controls.UIslider Upper_Left_Hue  {
      parent => UIpanel;
      title = "Upper_Left_Hue";
      value => background.Upper_Left_Hue;
      min => background.Upper_Left_Hue_min;
      max => background.Upper_Left_Hue_max;
   };

   Controls.UIslider Upper_Right_Hue  {
      parent => UIpanel;
      title = "Upper_Right_Hue";
      value => background.Upper_Right_Hue;
      min => background.Upper_Right_Hue_min;
      max => background.Upper_Right_Hue_max;
   };

   Controls.UIslider Lower_Left_Hue  {
      parent => UIpanel;
      title = "Lower_Left_Hue";
      value => background.Lower_Left_Hue;
      min => background.Lower_Left_Hue_min;
      max => background.Lower_Left_Hue_max;
   };

   Controls.UIslider Lower_Right_Hue  {
      parent => UIpanel;
      title = "Lower_Right_Hue";
      value => background.Lower_Right_Hue;
      min => background.Lower_Right_Hue_min;
      max => background.Lower_Right_Hue_max;
   };

   Controls.UIslider Upper_Left_Sat  {
      parent => UIpanel;
      title = "Upper_Left_Sat";
      value => background.Upper_Left_Sat;
     min => background.Upper_Left_Sat_min;
     max => background.Upper_Left_Sat_max;
   };

   Controls.UIslider Upper_Left_Value  {
      parent => UIpanel;
      title = "Upper_Left_Value";
      value => background.Upper_Left_Value;
     min => background.Upper_Left_Value_min;
     max => background.Upper_Left_Value_max;
   };

   Controls.UIslider Upper_Right_Sat  {
      parent => UIpanel;
      title = "Upper_Right_Sat";
      value => background.Upper_Right_Sat;
     min => background.Upper_Right_Sat_min;
     max => background.Upper_Right_Sat_max;
   };

   Controls.UIslider Upper_Right_Value  {
      parent => UIpanel;
      title = "Upper_Right_Value";
      value => background.Upper_Right_Value;
     min => background.Upper_Right_Value_min;
     max => background.Upper_Right_Value_max;
   };

   Controls.UIslider Lower_Left_Sat  {
      parent => UIpanel;
      title = "Lower_Left_Sat";
      value => background.Lower_Left_Sat;
     min => background.Lower_Left_Sat_min;
     max => background.Lower_Left_Sat_max;
   };

   Controls.UIslider Lower_Left_Value  {
      parent => UIpanel;
      title = "Lower_Left_Value";
      value => background.Lower_Left_Value;
     min => background.Lower_Left_Value_min;
     max => background.Lower_Left_Value_max;
   };

   Controls.UIslider Lower_Right_Sat  {
      parent => UIpanel;
      title = "Lower_Right_Sat";
      value => background.Lower_Right_Sat;
     min => background.Lower_Right_Sat_min;
     max => background.Lower_Right_Sat_max;
   };

   Controls.UIslider Lower_Right_Value  {
      parent => UIpanel;
      title = "Lower_Right_Value";
      value => background.Lower_Right_Value;
     min => background.Lower_Right_Value_min;
     max => background.Lower_Right_Value_max;
   };

   Controls.UIfield X_Resolution  {
      parent => UIpanel;
      value => background.X_Resolution;
      mode = 1;
     min => background.X_Resolution_min;
     max => background.X_Resolution_max;
   };

   Controls.UIfield Y_Resolution  {
      parent => UIpanel;
      value => background.Y_Resolution;
      mode = 1;
     min => background.Y_Resolution_min;
     max => background.Y_Resolution_max;
   };

   Controls.UItoggle Dither  {
      parent => UIpanel;
      label = "Dither";
      set => background.Dither;
   };

   olink output0=>background.Field_Output;
};         // end of ACU_background definition

//
// ACU_boolean
//
macro ACU_boolean {

   Data_Input.boolean boolean {
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "boolean";
     message = "Select boolean control panel.";
     rowColumnBehavior = 1;
   };

   Controls.UItoggle boolean_ {
      parent => UIpanel;
      label = "boolean";
      set => boolean.boolean;
   };

   olink output0=>boolean.boolean_output;
};         // end of ACU_boolean definition

//
// ACU_character_string
//
macro ACU_character_string {

   Data_Input.character_string character_string {
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "character_string";
     message = "Select character_string control panel.";
     rowColumnBehavior = 1;
   };

   olink output0=>character_string.filename;
};         // end of ACU_character_string definition

//
// ACU_color_range
//
macro ACU_color_range {
   ilink input0;
   ilink input1;

   Data_Input.color_range color_range {
      Field_Input => input0;
      Input_Colormap => input1;
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "color_range";
     message = "Select color_range control panel.";
     rowColumnBehavior = 1;
   };

   olink output0=>color_range.Output_Colormap;
};         // end of ACU_color_range definition

//
// ACU_create_geom
//
macro ACU_create_geom {
   ilink input0;
   ilink input1;

   Data_Input.create_geom create_geom {
      upstream_geom => input0;
      upstream_transform => input1;
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "create_geom";
     message = "Select create_geom control panel.";
     rowColumnBehavior = 1;
   };

   UIoption ADD {
      label="ADD";
   };

   UIoption CONSTRUCT {
      label="CONSTRUCT";
   };

   UIoption MODIFY {
      label="MODIFY";
   };

   UIoption DELETE {
      label="DELETE";
   };

   UIoption REDRAW {
      label="REDRAW";
   };

   Controls.UIradioBox action  {
      parent => UIpanel;
      label = "action";
      cmdList => {ADD, CONSTRUCT, MODIFY, DELETE, REDRAW};
      selectedItem => create_geom.action;
   };

   Controls.UIlabel dummy1  {
      parent => UIpanel;
      label => create_geom.dummy1;
   };

   UIoption Select {
      label="Select";
   };

   UIoption Point {
      label="Point";
   };

   UIoption Polyline {
      label="Polyline";
   };

   UIoption Arc_3_point {
      label="Arc 3 point";
   };

   UIoption Circle_3_point {
      label="Circle 3 point";
   };

   UIoption DONE {
      label="DONE";
   };

   Controls.UIradioBox sub_action  {
      parent => UIpanel;
      label = "sub_action";
      cmdList => {Select, Point, Polyline, Arc_3_point, Circle_3_point, DONE};
      selectedItem => create_geom.sub_action;
   };

   Controls.UIlabel dummy3  {
      parent => UIpanel;
      label => create_geom.dummy3;
   };

   UIoption X_axis {
      label="X-axis";
   };

   UIoption Y_axis {
      label="Y-axis";
   };

   UIoption Z_axis {
      label="Z-axis";
   };

   Controls.UIradioBox axis  {
      parent => UIpanel;
      label = "axis";
      cmdList => {X_axis, Y_axis, Z_axis};
      selectedItem => create_geom.axis;
   };

   Controls.UIslider Tolerance  {
      parent => UIpanel;
      title = "Tolerance";
      value => create_geom.Tolerance;
      min => create_geom.Tolerance_min;
      max => create_geom.Tolerance_max;
   };

   UIsliderUnbnd Length  {
      UIparent => UIpanel;
      stitle = "Length";
      sval => create_geom.Length;
      smin => create_geom.Length_min;
      smax => create_geom.Length_max;
   };

   UIsliderUnbnd Scale  {
      UIparent => UIpanel;
      stitle = "Scale";
      sval => create_geom.Scale;
      smin => create_geom.Scale_min;
      smax => create_geom.Scale_max;
   };

   Controls.UIslider N_Segment  {
      parent => UIpanel;
      title = "N_Segment";
      value => create_geom.N_Segment;
      mode = 1;
      min => create_geom.N_Segment_min;
      max => create_geom.N_Segment_max;
   };

   Controls.UIlabel dummy2  {
      parent => UIpanel;
      label => create_geom.dummy2;
   };

   Controls.UItoggle Output_Samplers  {
      parent => UIpanel;
      label = "Output_Samplers";
      set => create_geom.Output_Samplers;
   };

   UIoption Current_Object {
      label="Current Object";
   };

   UIoption All_Objects {
      label="All Objects";
   };

   Controls.UIradioBox samplers  {
      parent => UIpanel;
      label = "samplers";
      cmdList => {Current_Object, All_Objects};
      selectedItem => create_geom.samplers;
   };

   olink output0=>create_geom.Output;

   olink output1=>create_geom.output;
};         // end of ACU_create_geom definition

//
// ACU_edit_substances
//
macro ACU_edit_substances {

   Data_Input.edit_substances edit_substances {
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "edit_substances";
     message = "Select edit_substances control panel.";
     rowColumnBehavior = 1;
   };

   Dialogs.UIfileSB filename  {
      parent => UIpanel;
      visible => UIpanel.visible;
      title = "filename";
      &filename => edit_substances.filename;
   };

   Controls.UIbutton read_file  {
      parent => UIpanel;
      label = "read_file";
   };

   Controls.UIbutton write_file  {
      parent => UIpanel;
      label = "write_file";
   };

   Controls.UIbutton write_colormap  {
      parent => UIpanel;
      label = "write_colormap";
   };

   Controls.UIslider current_substance  {
      parent => UIpanel;
      title = "current_substance";
      value => edit_substances.current_substance;
      mode = 1;
     min => edit_substances.current_substance_min;
     max => edit_substances.current_substance_max;
   };

   Controls.UIfield lo_threshold  {
      parent => UIpanel;
      value => edit_substances.lo_threshold;
     min => edit_substances.lo_threshold_min;
   };

   Controls.UIfield hi_threshold  {
      parent => UIpanel;
      value => edit_substances.hi_threshold;
     min => edit_substances.hi_threshold_min;
   };

   Controls.UIfield opacity  {
      parent => UIpanel;
      value => edit_substances.opacity;
     min => edit_substances.opacity_min;
     max => edit_substances.opacity_max;
   };

   Controls.UIfield red  {
      parent => UIpanel;
      value => edit_substances.red;
     min => edit_substances.red_min;
     max => edit_substances.red_max;
   };

   Controls.UIfield green  {
      parent => UIpanel;
      value => edit_substances.green;
     min => edit_substances.green_min;
     max => edit_substances.green_max;
   };

   Controls.UIfield blue  {
      parent => UIpanel;
      value => edit_substances.blue;
     min => edit_substances.blue_min;
     max => edit_substances.blue_max;
   };

   Controls.UIfield skip_layers  {
      parent => UIpanel;
      value => edit_substances.skip_layers;
      mode = 1;
     min => edit_substances.skip_layers_min;
     max => edit_substances.skip_layers_max;
   };

   olink output0=>edit_substances.subs;

   olink output1=>edit_substances.colormap;
};         // end of ACU_edit_substances definition

//
// ACU_euler_transformation
//
macro ACU_euler_transformation {

   Data_Input.euler_transformation euler_transformation {
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "euler_transformation";
     message = "Select euler_transformation control panel.";
     rowColumnBehavior = 1;
   };

   UIsliderUnbnd theta  {
      UIparent => UIpanel;
      stitle = "theta";
      sval => euler_transformation.theta;
      smin => euler_transformation.theta_min;
      smax => euler_transformation.theta_max;
   };

   UIsliderUnbnd phi  {
      UIparent => UIpanel;
      stitle = "phi";
      sval => euler_transformation.phi;
      smin => euler_transformation.phi_min;
      smax => euler_transformation.phi_max;
   };

   UIsliderUnbnd rho  {
      UIparent => UIpanel;
      stitle = "rho";
      sval => euler_transformation.rho;
      smin => euler_transformation.rho_min;
      smax => euler_transformation.rho_max;
   };

   Controls.UIslider scale  {
      parent => UIpanel;
      title = "scale";
      value => euler_transformation.scale;
      min => euler_transformation.scale_min;
      max => euler_transformation.scale_max;
   };

   olink output0=>euler_transformation.Output;
};         // end of ACU_euler_transformation definition

//
// ACU_file_browser
//
macro ACU_file_browser {

   Data_Input.file_browser file_browser {
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "file_browser";
     message = "Select file_browser control panel.";
     rowColumnBehavior = 1;
   };

   Dialogs.UIfileSB File_Browser  {
      parent => UIpanel;
      visible => UIpanel.visible;
      title = "File_Browser";
      &filename => file_browser.File_Browser;
   };

   olink output0=>file_browser.filename;
};         // end of ACU_file_browser definition

//
// ACU_float
//
macro ACU_float {

   Data_Input.float float {
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "float";
     message = "Select float control panel.";
     rowColumnBehavior = 1;
   };

   UIsliderUnbnd float_value  {
      UIparent => UIpanel;
      stitle = "float_value";
      sval => float.float_value;
      smin => float.float_value_min;
      smax => float.float_value_max;
   };

   olink output0=>float.float_output;
};         // end of ACU_float definition

//
// ACU_generate_filters
//
macro ACU_generate_filters {

   Data_Input.generate_filters generate_filters {
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "generate_filters";
     message = "Select generate_filters control panel.";
     rowColumnBehavior = 1;
   };

   UIoption Gaussian {
      label="Gaussian";
   };

   UIoption Laplacian {
      label="Laplacian";
   };

   UIoption Power {
      label="Power";
   };

   UIoption Ellipse {
      label="Ellipse";
   };

   UIoption Line {
      label="Line";
   };

   UIoption Random {
      label="Random";
   };

   UIoption dx {
      label="dx";
   };

   UIoption dy {
      label="dy";
   };

   Controls.UIradioBox selection  {
      parent => UIpanel;
      label = "selection";
      cmdList => {Gaussian, Laplacian, Power, Ellipse, Line, Random, dx, dy};
      selectedItem => generate_filters.selection;
   };

   Controls.UIslider Size  {
      parent => UIpanel;
      title = "Size";
      value => generate_filters.Size;
      mode = 1;
      min => generate_filters.Size_min;
      max => generate_filters.Size_max;
   };

   Controls.UIslider focus1  {
      parent => UIpanel;
      title = "focus1";
      value => generate_filters.focus1;
      min => generate_filters.focus1_min;
      max => generate_filters.focus1_max;
   };

   Controls.UIslider focus2  {
      parent => UIpanel;
      title = "focus2";
      value => generate_filters.focus2;
      min => generate_filters.focus2_min;
      max => generate_filters.focus2_max;
   };

   Controls.UIslider power  {
      parent => UIpanel;
      title = "power";
      value => generate_filters.power;
      min => generate_filters.power_min;
      max => generate_filters.power_max;
   };

   UIsliderUnbnd angle  {
      UIparent => UIpanel;
      stitle = "angle";
      sval => generate_filters.angle;
      smin => generate_filters.angle_min;
      smax => generate_filters.angle_max;
   };

   Controls.UIslider scale  {
      parent => UIpanel;
      title = "scale";
      value => generate_filters.scale;
      min => generate_filters.scale_min;
      max => generate_filters.scale_max;
   };

   olink output0=>generate_filters.Output_Filter;
};         // end of ACU_generate_filters definition

//
// ACU_integer
//
macro ACU_integer {

   Data_Input.integer integer {
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "integer";
     message = "Select integer control panel.";
     rowColumnBehavior = 1;
   };

   Controls.UIslider integer_value  {
      parent => UIpanel;
      title = "integer_value";
      value => integer.integer_value;
      mode = 1;
   };

   olink output0=>integer.integer_output;
};         // end of ACU_integer definition

//
// ACU_oneshot
//
macro ACU_oneshot {

   Data_Input.oneshot oneshot {
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "oneshot";
     message = "Select oneshot control panel.";
     rowColumnBehavior = 1;
   };

   Controls.UIlabel oneshot_ {
      parent => UIpanel;
      label => oneshot.oneshot;
   };

   olink output0=>oneshot.oneshot_port;
};         // end of ACU_oneshot definition

//
// ACU_pdb_to_geom
//
macro ACU_pdb_to_geom {

   Data_Input.pdb_to_geom pdb_to_geom {
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "pdb_to_geom";
     message = "Select pdb_to_geom control panel.";
     rowColumnBehavior = 1;
   };

   Dialogs.UIfileSB filename  {
      parent => UIpanel;
      visible => UIpanel.visible;
      title = "filename";
      &filename => pdb_to_geom.filename;
   };

   UIoption ball_and_stick {
      label="ball and stick";
   };

   UIoption ball {
      label="ball";
   };

   UIoption stick {
      label="stick";
   };

   UIoption colored_stick {
      label="colored stick";
   };

   UIoption colored_residue {
      label="colored residue";
   };

   Controls.UIradioBox Representation  {
      parent => UIpanel;
      label = "Representation";
      cmdList => {ball_and_stick, ball, stick, colored_stick, colored_residue};
      selectedItem => pdb_to_geom.Representation;
   };

   olink output0=>pdb_to_geom.geometry;
};         // end of ACU_pdb_to_geom definition

//
// ACU_read_colormap
//
macro ACU_read_colormap {

   Data_Input.read_colormap read_colormap {
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "read_colormap";
     message = "Select read_colormap control panel.";
     rowColumnBehavior = 1;
   };

   Dialogs.UIfileSB filename  {
      parent => UIpanel;
      visible => UIpanel.visible;
      title = "filename";
      &filename => read_colormap.filename;
   };

   olink output0=>read_colormap.cmap_out;

   olink output1=>read_colormap.field_out;
};         // end of ACU_read_colormap definition

//
// ACU_read_field
//
macro ACU_read_field {

   Data_Input.read_field read_field {
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "read_field";
     message = "Select read_field control panel.";
     rowColumnBehavior = 1;
   };

   Dialogs.UIfileSB Read_Field_Browser  {
      parent => UIpanel;
      visible => UIpanel.visible;
      title = "Read_Field_Browser";
      &filename => read_field.Read_Field_Browser;
   };

   UIoption Auto {
      label="Auto";
   };

   UIoption Portable__XDR_ {
      label="Portable (XDR)";
   };

   Controls.UIradioBox Data_Conversion  {
      parent => UIpanel;
      label = "Data_Conversion";
      cmdList => {Auto, Portable__XDR_};
      selectedItem => read_field.Data_Conversion;
   };

   Controls.UIlabel Read_Status  {
      parent => UIpanel;
      label => read_field.Read_Status;
   };

   olink output0=>read_field.Field_Output;
};         // end of ACU_read_field definition

//
// ACU_read_image
//
macro ACU_read_image {

   Data_Input.read_image read_image {
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "read_image";
     message = "Select read_image control panel.";
     rowColumnBehavior = 1;
   };

   Dialogs.UIfileSB Read_Image_Browser  {
      parent => UIpanel;
      visible => UIpanel.visible;
      title = "Read_Image_Browser";
      &filename => read_image.Read_Image_Browser;
   };

   olink output0=>read_image.Field_Output;
};         // end of ACU_read_image definition

//
// ACU_read_ucd
//
macro ACU_read_ucd {

   Data_Input.read_ucd read_ucd {
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "read_ucd";
     message = "Select read_ucd control panel.";
     rowColumnBehavior = 1;
   };

   Dialogs.UIfileSB read_file  {
      parent => UIpanel;
      visible => UIpanel.visible;
      title = "read_file";
      &filename => read_ucd.read_file;
   };

   olink output0=>read_ucd.tet_output;
};         // end of ACU_read_ucd definition

//
// ACU_read_volume
//
macro ACU_read_volume {

   Data_Input.read_volume read_volume {
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "read_volume";
     message = "Select read_volume control panel.";
     rowColumnBehavior = 1;
   };

   Dialogs.UIfileSB Read_Volume_Browser  {
      parent => UIpanel;
      visible => UIpanel.visible;
      title = "Read_Volume_Browser";
      &filename => read_volume.Read_Volume_Browser;
   };

   olink output0=>read_volume.Field_Output;
};         // end of ACU_read_volume definition

//
// ACU_samplers
//
macro ACU_samplers {
   ilink input0;
   ilink input1;

   Data_Input.samplers samplers {
      input_field => input0;
      Transform_Info => input1;
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "samplers";
     message = "Select samplers control panel.";
     rowColumnBehavior = 1;
   };

   UIoption point {
      label="point";
   };

   UIoption line {
      label="line";
   };

   UIoption circle {
      label="circle";
   };

   UIoption plane {
      label="plane";
   };

   UIoption space {
      label="space";
   };

   Controls.UIradioBox choice  {
      parent => UIpanel;
      label = "choice";
      cmdList => {point, line, circle, plane, space};
      selectedItem => samplers.choice;
   };

   Controls.UIslider N_Segment  {
      parent => UIpanel;
      title = "N_Segment";
      value => samplers.N_Segment;
      mode = 1;
      min => samplers.N_Segment_min;
      max => samplers.N_Segment_max;
   };

   olink output0=>samplers.output;
};         // end of ACU_samplers definition

//
// ACU_tristate
//
macro ACU_tristate {

   Data_Input.tristate tristate {
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "tristate";
     message = "Select tristate control panel.";
     rowColumnBehavior = 1;
   };

   Controls.UIlabel tristate_ {
      parent => UIpanel;
      label => tristate.tristate;
   };

   olink output0=>tristate.tristate_output;
};         // end of ACU_tristate definition


};
library+buffered ACU_Filters {

//
// ACU_antialias
//
macro ACU_antialias {
   ilink input0;

   Filters.antialias antialias {
      Field_Input => input0;
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "antialias";
     message = "Select antialias control panel.";
     rowColumnBehavior = 1;
   };

   olink output0=>antialias.Field_Output;
};         // end of ACU_antialias definition

//
// ACU_average_down
//
macro ACU_average_down {
   ilink input0;

   Filters.average_down average_down {
      input => input0;
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "average_down";
     message = "Select average_down control panel.";
     rowColumnBehavior = 1;
   };

   Controls.UIslider X  {
      parent => UIpanel;
      title = "X";
      value => average_down.X;
      mode = 1;
      min => average_down.X_min;
      max => average_down.X_max;
   };

   Controls.UIslider Y  {
      parent => UIpanel;
      title = "Y";
      value => average_down.Y;
      mode = 1;
      min => average_down.Y_min;
      max => average_down.Y_max;
   };

   Controls.UIslider Z  {
      parent => UIpanel;
      title = "Z";
      value => average_down.Z;
      mode = 1;
      min => average_down.Z_min;
      max => average_down.Z_max;
   };

   olink output0=>average_down.output;
};         // end of ACU_average_down definition

//
// ACU_blend_colormaps
//
macro ACU_blend_colormaps {
   ilink input0;
   ilink input1;

   Filters.blend_colormaps blend_colormaps {
      cmap1 => input0;
      cmap2 => input1;
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "blend_colormaps";
     message = "Select blend_colormaps control panel.";
     rowColumnBehavior = 1;
   };

   Controls.UIslider scale  {
      parent => UIpanel;
      title = "scale";
      value => blend_colormaps.scale;
      min => blend_colormaps.scale_min;
      max => blend_colormaps.scale_max;
   };

   olink output0=>blend_colormaps.cmap_out;
};         // end of ACU_blend_colormaps definition

//
// ACU_cfd_values
//
macro ACU_cfd_values {
   ilink input0;

   Filters.cfd_values cfd_values {
      Field_Input => input0;
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "cfd_values";
     message = "Select cfd_values control panel.";
     rowColumnBehavior = 1;
   };

   Controls.UIslider Gamma  {
      parent => UIpanel;
      title = "Gamma";
      value => cfd_values.Gamma;
      min => cfd_values.Gamma_min;
      max => cfd_values.Gamma_max;
   };

   Controls.UIslider Gas_constant  {
      parent => UIpanel;
      title = "Gas_constant";
      value => cfd_values.Gas_constant;
      min => cfd_values.Gas_constant_min;
      max => cfd_values.Gas_constant_max;
   };

   Controls.UItoggle density  {
      parent => UIpanel;
      label = "density";
      set => cfd_values.density;
   };

   Controls.UItoggle x_momentum  {
      parent => UIpanel;
      label = "x_momentum";
      set => cfd_values.x_momentum;
   };

   Controls.UItoggle y_momentum  {
      parent => UIpanel;
      label = "y_momentum";
      set => cfd_values.y_momentum;
   };

   Controls.UItoggle z_momentum  {
      parent => UIpanel;
      label = "z_momentum";
      set => cfd_values.z_momentum;
   };

   Controls.UItoggle stagnation  {
      parent => UIpanel;
      label = "stagnation";
      set => cfd_values.stagnation;
   };

   Controls.UItoggle energy  {
      parent => UIpanel;
      label = "energy";
      set => cfd_values.energy;
   };

   Controls.UItoggle pressure  {
      parent => UIpanel;
      label = "pressure";
      set => cfd_values.pressure;
   };

   Controls.UItoggle enthalpy  {
      parent => UIpanel;
      label = "enthalpy";
      set => cfd_values.enthalpy;
   };

   Controls.UItoggle mach_number  {
      parent => UIpanel;
      label = "mach_number";
      set => cfd_values.mach_number;
   };

   Controls.UItoggle temperature  {
      parent => UIpanel;
      label = "temperature";
      set => cfd_values.temperature;
   };

   Controls.UItoggle total_pressure  {
      parent => UIpanel;
      label = "total_pressure";
      set => cfd_values.total_pressure;
   };

   Controls.UItoggle total_temp  {
      parent => UIpanel;
      label = "total_temp";
      set => cfd_values.total_temp;
   };

   Controls.UIslider Vector_Length  {
      parent => UIpanel;
      title = "Vector_Length";
      value => cfd_values.Vector_Length;
      mode = 1;
      min => cfd_values.Vector_Length_min;
      max => cfd_values.Vector_Length_max;
   };

   olink output0=>cfd_values.Field_Output;
};         // end of ACU_cfd_values definition

//
// ACU_clamp
//
macro ACU_clamp {
   ilink input0;

   Filters.clamp clamp {
      Input_Field => input0;
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "clamp";
     message = "Select clamp control panel.";
     rowColumnBehavior = 1;
   };

   UIsliderUnbnd clamp_min  {
      UIparent => UIpanel;
      stitle = "clamp_min";
      sval => clamp.clamp_min;
      smin => clamp.clamp_min_min;
      smax => clamp.clamp_min_max;
   };

   UIsliderUnbnd clamp_max  {
      UIparent => UIpanel;
      stitle = "clamp_max";
      sval => clamp.clamp_max;
      smin => clamp.clamp_max_min;
      smax => clamp.clamp_max_max;
   };

   olink output0=>clamp.Output_Field;
};         // end of ACU_clamp definition

//
// ACU_colorize_geom
//
macro ACU_colorize_geom {
   ilink input0;
   ilink input1;
   ilink input2;
   ilink input3;

   Filters.colorize_geom colorize_geom {
      Geom_Input => input0;
      Field_Input => input1;
      Colormap_Input => input2;
      input_trans => input3;
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "colorize_geom";
     message = "Select colorize_geom control panel.";
     rowColumnBehavior = 1;
   };

   Controls.UItoggle Vertex_Colors  {
      parent => UIpanel;
      label = "Vertex_Colors";
      set => colorize_geom.Vertex_Colors;
   };

   Controls.UItoggle Vertex_Trans  {
      parent => UIpanel;
      label = "Vertex_Trans";
      set => colorize_geom.Vertex_Trans;
   };

   Controls.UItoggle Vertex_UVW  {
      parent => UIpanel;
      label = "Vertex_UVW";
      set => colorize_geom.Vertex_UVW;
   };

   olink output0=>colorize_geom.Output;

   olink output1=>colorize_geom.output_trans;
};         // end of ACU_colorize_geom definition

//
// ACU_colorizer
//
macro ACU_colorizer {
   ilink input0;
   ilink input1;

   Filters.colorizer colorizer {
      Input_Field => input0;
      Input_Colormap => input1;
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "colorizer";
     message = "Select colorizer control panel.";
     rowColumnBehavior = 1;
   };

   olink output0=>colorizer.Output_Field;
};         // end of ACU_colorizer definition

//
// ACU_colorizer
//
macro ACU_colorizer {
   ilink input0;
   ilink input1;

   Filters.colorizer colorizer {
      Input_Field => input0;
      Input_Colormap => input1;
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "colorizer";
     message = "Select colorizer control panel.";
     rowColumnBehavior = 1;
   };

   olink output0=>colorizer.Output_Field;
};         // end of ACU_colorizer definition

//
// ACU_combine_scalars
//
macro ACU_combine_scalars {
   ilink input0;
   ilink input1;
   ilink input2;
   ilink input3;

   Filters.combine_scalars combine_scalars {
      Channel_0 => input0;
      Channel_1 => input1;
      Channel_2 => input2;
      Channel_3 => input3;
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "combine_scalars";
     message = "Select combine_scalars control panel.";
     rowColumnBehavior = 1;
   };

   Controls.UIslider vector_length  {
      parent => UIpanel;
      title = "vector_length";
      value => combine_scalars.vector_length;
      mode = 1;
      min => combine_scalars.vector_length_min;
      max => combine_scalars.vector_length_max;
   };

   olink output0=>combine_scalars.Output_Field;
};         // end of ACU_combine_scalars definition

//
// ACU_composite
//
macro ACU_composite {
   ilink input0;
   ilink input1;

   Filters.composite composite {
      ForeGround => input0;
      BackGround => input1;
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "composite";
     message = "Select composite control panel.";
     rowColumnBehavior = 1;
   };

   olink output0=>composite.Field_Output;
};         // end of ACU_composite definition

//
// ACU_composite
//
macro ACU_composite {
   ilink input0;
   ilink input1;

   Filters.composite composite {
      ForeGround => input0;
      BackGround => input1;
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "composite";
     message = "Select composite control panel.";
     rowColumnBehavior = 1;
   };

   olink output0=>composite.Field_Output;
};         // end of ACU_composite definition

//
// ACU_compute_gradient
//
macro ACU_compute_gradient {
   ilink input0;

   Filters.compute_gradient compute_gradient {
      Input_Field => input0;
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "compute_gradient";
     message = "Select compute_gradient control panel.";
     rowColumnBehavior = 1;
   };

   Controls.UIslider _2D_Height  {
      parent => UIpanel;
      title = "_2D_Height";
      value => compute_gradient._2D_Height;
      min => compute_gradient._2D_Height_min;
      max => compute_gradient._2D_Height_max;
   };

   Controls.UItoggle Flip  {
      parent => UIpanel;
      label = "Flip";
      set => compute_gradient.Flip;
   };

   olink output0=>compute_gradient.Output_Field;
};         // end of ACU_compute_gradient definition

//
// ACU_contrast
//
macro ACU_contrast {
   ilink input0;

   Filters.contrast contrast {
      Input_Field => input0;
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "contrast";
     message = "Select contrast control panel.";
     rowColumnBehavior = 1;
   };

   UIsliderUnbnd cont_in_min  {
      UIparent => UIpanel;
      stitle = "cont_in_min";
      sval => contrast.cont_in_min;
      smin => contrast.cont_in_min_min;
      smax => contrast.cont_in_min_max;
   };

   UIsliderUnbnd cont_in_max  {
      UIparent => UIpanel;
      stitle = "cont_in_max";
      sval => contrast.cont_in_max;
      smin => contrast.cont_in_max_min;
      smax => contrast.cont_in_max_max;
   };

   UIsliderUnbnd cont_out_min  {
      UIparent => UIpanel;
      stitle = "cont_out_min";
      sval => contrast.cont_out_min;
      smin => contrast.cont_out_min_min;
      smax => contrast.cont_out_min_max;
   };

   UIsliderUnbnd cont_out_max  {
      UIparent => UIpanel;
      stitle = "cont_out_max";
      sval => contrast.cont_out_max;
      smin => contrast.cont_out_max_min;
      smax => contrast.cont_out_max_max;
   };

   olink output0=>contrast.Output_Field;
};         // end of ACU_contrast definition

//
// ACU_convolve
//
macro ACU_convolve {
   ilink input0;
   ilink input1;

   Filters.convolve convolve {
      Input_Field => input0;
      Filter => input1;
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "convolve";
     message = "Select convolve control panel.";
     rowColumnBehavior = 1;
   };

   Controls.UItoggle Normalize_Filter  {
      parent => UIpanel;
      label = "Normalize_Filter";
      set => convolve.Normalize_Filter;
   };

   olink output0=>convolve.Output_Field;
};         // end of ACU_convolve definition

//
// ACU_crop
//
macro ACU_crop {
   ilink input0;

   Filters.crop crop {
      Input_Field => input0;
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "crop";
     message = "Select crop control panel.";
     rowColumnBehavior = 1;
   };

   Controls.UIslider min_x  {
      parent => UIpanel;
      title = "min_x";
      value => crop.min_x;
      mode = 1;
      min => crop.min_x_min;
      max => crop.min_x_max;
   };

   Controls.UIslider max_x  {
      parent => UIpanel;
      title = "max_x";
      value => crop.max_x;
      mode = 1;
      min => crop.max_x_min;
      max => crop.max_x_max;
   };

   Controls.UIslider min_y  {
      parent => UIpanel;
      title = "min_y";
      value => crop.min_y;
      mode = 1;
      min => crop.min_y_min;
      max => crop.min_y_max;
   };

   Controls.UIslider max_y  {
      parent => UIpanel;
      title = "max_y";
      value => crop.max_y;
      mode = 1;
      min => crop.max_y_min;
      max => crop.max_y_max;
   };

   Controls.UIslider min_z  {
      parent => UIpanel;
      title = "min_z";
      value => crop.min_z;
      mode = 1;
      min => crop.min_z_min;
      max => crop.min_z_max;
   };

   Controls.UIslider max_z  {
      parent => UIpanel;
      title = "max_z";
      value => crop.max_z;
      mode = 1;
      min => crop.max_z_min;
      max => crop.max_z_max;
   };

   Controls.UItoggle size_to_fit  {
      parent => UIpanel;
      label = "size_to_fit";
      set => crop.size_to_fit;
   };

   olink output0=>crop.Output_Field;
};         // end of ACU_crop definition

//
// ACU_downsize
//
macro ACU_downsize {
   ilink input0;

   Filters.downsize downsize {
      Input_Field => input0;
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "downsize";
     message = "Select downsize control panel.";
     rowColumnBehavior = 1;
   };

   Controls.UIslider downsize_ {
      parent => UIpanel;
      title = "downsize";
      value => downsize.downsize;
      mode = 1;
      min => downsize.downsize_min;
      max => downsize.downsize_max;
   };

   olink output0=>downsize.Output_Field;
};         // end of ACU_downsize definition

//
// ACU_extract_graph
//
macro ACU_extract_graph {
   ilink input0;

   Filters.extract_graph extract_graph {
      field_input => input0;
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "extract_graph";
     message = "Select extract_graph control panel.";
     rowColumnBehavior = 1;
   };

   Controls.UIslider Graph_Select  {
      parent => UIpanel;
      title = "Graph_Select";
      value => extract_graph.Graph_Select;
      mode = 1;
      min => extract_graph.Graph_Select_min;
      max => extract_graph.Graph_Select_max;
   };

   UIoption I {
      label="I";
   };

   UIoption J {
      label="J";
   };

   Controls.UIradioBox axis  {
      parent => UIpanel;
      label = "axis";
      cmdList => {I, J};
      selectedItem => extract_graph.axis;
   };

   Controls.UIlabel Abscissa_Mapping  {
      parent => UIpanel;
      label => extract_graph.Abscissa_Mapping;
   };

   UIoption Dist {
      label="Dist";
   };

   UIoption Index {
      label="Index";
   };

   UIoption X {
      label="X";
   };

   UIoption Y {
      label="Y";
   };

   UIoption Z {
      label="Z";
   };

   Controls.UIradioBox abs_mapping  {
      parent => UIpanel;
      label = "abs_mapping";
      cmdList => {Dist, Index, X, Y, Z};
      selectedItem => extract_graph.abs_mapping;
   };

   olink output0=>extract_graph.Image_Output;

   olink output1=>extract_graph.Output;
};         // end of ACU_extract_graph definition

//
// ACU_extract_scalar
//
macro ACU_extract_scalar {
   ilink input0;

   Filters.extract_scalar extract_scalar {
      Input_Field => input0;
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "extract_scalar";
     message = "Select extract_scalar control panel.";
     rowColumnBehavior = 1;
   };

   UIoption channel_0 {
      label="channel 0";
   };

   UIoption channel_1 {
      label="channel 1";
   };

   UIoption channel_2 {
      label="channel 2";
   };

   UIoption channel_3 {
      label="channel 3";
   };

   UIoption channel_4 {
      label="channel 4";
   };

   UIoption channel_5 {
      label="channel 5";
   };

   Controls.UIradioBox Channel  {
      parent => UIpanel;
      label = "Channel";
      cmdList => {channel_0, channel_1, channel_2, channel_3, channel_4, channel_5};
      selectedItem => extract_scalar.Channel;
   };

   olink output0=>extract_scalar.Output_Field;
};         // end of ACU_extract_scalar definition

//
// ACU_extract_vector
//
macro ACU_extract_vector {
   ilink input0;

   Filters.extract_vector extract_vector {
      Input_Field => input0;
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "extract_vector";
     message = "Select extract_vector control panel.";
     rowColumnBehavior = 1;
   };

   Controls.UItoggle Channel_0  {
      parent => UIpanel;
      label = "Channel_0";
      set => extract_vector.Channel_0;
   };

   Controls.UItoggle Channel_1  {
      parent => UIpanel;
      label = "Channel_1";
      set => extract_vector.Channel_1;
   };

   Controls.UItoggle Channel_2  {
      parent => UIpanel;
      label = "Channel_2";
      set => extract_vector.Channel_2;
   };

   Controls.UItoggle Channel_3  {
      parent => UIpanel;
      label = "Channel_3";
      set => extract_vector.Channel_3;
   };

   Controls.UItoggle Channel_4  {
      parent => UIpanel;
      label = "Channel_4";
      set => extract_vector.Channel_4;
   };

   Controls.UItoggle Channel_5  {
      parent => UIpanel;
      label = "Channel_5";
      set => extract_vector.Channel_5;
   };

   Controls.UItoggle Channel_6  {
      parent => UIpanel;
      label = "Channel_6";
      set => extract_vector.Channel_6;
   };

   Controls.UItoggle Channel_7  {
      parent => UIpanel;
      label = "Channel_7";
      set => extract_vector.Channel_7;
   };

   Controls.UItoggle Channel_8  {
      parent => UIpanel;
      label = "Channel_8";
      set => extract_vector.Channel_8;
   };

   Controls.UItoggle Channel_9  {
      parent => UIpanel;
      label = "Channel_9";
      set => extract_vector.Channel_9;
   };

   Controls.UItoggle Channel_10  {
      parent => UIpanel;
      label = "Channel_10";
      set => extract_vector.Channel_10;
   };

   Controls.UItoggle Channel_11  {
      parent => UIpanel;
      label = "Channel_11";
      set => extract_vector.Channel_11;
   };

   Controls.UItoggle Channel_12  {
      parent => UIpanel;
      label = "Channel_12";
      set => extract_vector.Channel_12;
   };

   Controls.UItoggle Channel_13  {
      parent => UIpanel;
      label = "Channel_13";
      set => extract_vector.Channel_13;
   };

   Controls.UItoggle Channel_14  {
      parent => UIpanel;
      label = "Channel_14";
      set => extract_vector.Channel_14;
   };

   Controls.UItoggle Channel_15  {
      parent => UIpanel;
      label = "Channel_15";
      set => extract_vector.Channel_15;
   };

   Controls.UItoggle Channel_16  {
      parent => UIpanel;
      label = "Channel_16";
      set => extract_vector.Channel_16;
   };

   Controls.UItoggle Channel_17  {
      parent => UIpanel;
      label = "Channel_17";
      set => extract_vector.Channel_17;
   };

   Controls.UItoggle Channel_18  {
      parent => UIpanel;
      label = "Channel_18";
      set => extract_vector.Channel_18;
   };

   Controls.UItoggle Channel_19  {
      parent => UIpanel;
      label = "Channel_19";
      set => extract_vector.Channel_19;
   };

   Controls.UItoggle Channel_20  {
      parent => UIpanel;
      label = "Channel_20";
      set => extract_vector.Channel_20;
   };

   Controls.UItoggle Channel_21  {
      parent => UIpanel;
      label = "Channel_21";
      set => extract_vector.Channel_21;
   };

   Controls.UItoggle Channel_22  {
      parent => UIpanel;
      label = "Channel_22";
      set => extract_vector.Channel_22;
   };

   Controls.UItoggle Channel_23  {
      parent => UIpanel;
      label = "Channel_23";
      set => extract_vector.Channel_23;
   };

   Controls.UItoggle Channel_24  {
      parent => UIpanel;
      label = "Channel_24";
      set => extract_vector.Channel_24;
   };

   Controls.UIslider Vector_Length  {
      parent => UIpanel;
      title = "Vector_Length";
      value => extract_vector.Vector_Length;
      mode = 1;
      min => extract_vector.Vector_Length_min;
      max => extract_vector.Vector_Length_max;
   };

   olink output0=>extract_vector.Output_Field;
};         // end of ACU_extract_vector definition

//
// ACU_field_math
//
macro ACU_field_math {
   ilink input0;
   ilink input1;

   Filters.field_math field_math {
      field_1 => input0;
      field_2 => input1;
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "field_math";
     message = "Select field_math control panel.";
     rowColumnBehavior = 1;
   };

   UIoption _ {
      label="+";
   };

   UIoption _ {
      label="-";
   };

   UIoption _ {
      label="*";
   };

   UIoption _ {
      label="/";
   };

   UIoption And {
      label="And";
   };

   UIoption Or {
      label="Or";
   };

   UIoption Xor {
      label="Xor";
   };

   UIoption Not {
      label="Not";
   };

   UIoption Left_Shift {
      label="Left-Shift";
   };

   UIoption Right_Shift {
      label="Right-Shift";
   };

   UIoption Square {
      label="Square";
   };

   UIoption Sqrt {
      label="Sqrt";
   };

   UIoption RMS {
      label="RMS";
   };

   Controls.UIradioBox choice  {
      parent => UIpanel;
      label = "choice";
      cmdList => {_, _, _, _, And, Or, Xor, Not, Left_Shift, Right_Shift, Square, Sqrt, RMS};
      selectedItem => field_math.choice;
   };

   Controls.UItoggle Normalize  {
      parent => UIpanel;
      label = "Normalize";
      set => field_math.Normalize;
   };

   Controls.UIfield Constant  {
      parent => UIpanel;
      value => field_math.Constant;
   };

   olink output0=>field_math.field_out;
};         // end of ACU_field_math definition

//
// ACU_field_to_byte
//
macro ACU_field_to_byte {
   ilink input0;

   Filters.field_to_byte field_to_byte {
      Input_Field => input0;
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "field_to_byte";
     message = "Select field_to_byte control panel.";
     rowColumnBehavior = 1;
   };

   Controls.UItoggle byte_normalize  {
      parent => UIpanel;
      label = "byte_normalize";
      set => field_to_byte.byte_normalize;
   };

   olink output0=>field_to_byte.Output_Field;
};         // end of ACU_field_to_byte definition

//
// ACU_field_to_double
//
macro ACU_field_to_double {
   ilink input0;

   Filters.field_to_double field_to_double {
      Input_Field => input0;
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "field_to_double";
     message = "Select field_to_double control panel.";
     rowColumnBehavior = 1;
   };

   Controls.UItoggle double_normalize  {
      parent => UIpanel;
      label = "double_normalize";
      set => field_to_double.double_normalize;
   };

   olink output0=>field_to_double.Output_Field;
};         // end of ACU_field_to_double definition

//
// ACU_field_to_float
//
macro ACU_field_to_float {
   ilink input0;

   Filters.field_to_float field_to_float {
      Input_Field => input0;
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "field_to_float";
     message = "Select field_to_float control panel.";
     rowColumnBehavior = 1;
   };

   Controls.UItoggle float_normalize  {
      parent => UIpanel;
      label = "float_normalize";
      set => field_to_float.float_normalize;
   };

   olink output0=>field_to_float.Output_Field;
};         // end of ACU_field_to_float definition

//
// ACU_field_to_int
//
macro ACU_field_to_int {
   ilink input0;

   Filters.field_to_int field_to_int {
      Input_Field => input0;
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "field_to_int";
     message = "Select field_to_int control panel.";
     rowColumnBehavior = 1;
   };

   Controls.UItoggle int_normalize  {
      parent => UIpanel;
      label = "int_normalize";
      set => field_to_int.int_normalize;
   };

   olink output0=>field_to_int.Output_Field;
};         // end of ACU_field_to_int definition

//
// ACU_field_to_short
//
macro ACU_field_to_short {
   ilink input0;

   Filters.field_to_short field_to_short {
      Input_Field => input0;
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "field_to_short";
     message = "Select field_to_short control panel.";
     rowColumnBehavior = 1;
   };

   Controls.UItoggle short_normalize  {
      parent => UIpanel;
      label = "short_normalize";
      set => field_to_short.short_normalize;
   };

   olink output0=>field_to_short.Output_Field;
};         // end of ACU_field_to_short definition

//
// ACU_field_to_ucd
//
macro ACU_field_to_ucd {
   ilink input0;

   Filters.field_to_ucd field_to_ucd {
      Input => input0;
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "field_to_ucd";
     message = "Select field_to_ucd control panel.";
     rowColumnBehavior = 1;
   };

   olink output0=>field_to_ucd.Output;
};         // end of ACU_field_to_ucd definition

//
// ACU_flip_normal
//
macro ACU_flip_normal {
   ilink input0;

   Filters.flip_normal flip_normal {
      Input => input0;
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "flip_normal";
     message = "Select flip_normal control panel.";
     rowColumnBehavior = 1;
   };

   olink output0=>flip_normal.Output;
};         // end of ACU_flip_normal definition

//
// ACU_generate_histogram
//
macro ACU_generate_histogram {
   ilink input0;

   Filters.generate_histogram generate_histogram {
      Input_Field => input0;
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "generate_histogram";
     message = "Select generate_histogram control panel.";
     rowColumnBehavior = 1;
   };

   Controls.UIslider number_of_bins  {
      parent => UIpanel;
      title = "number_of_bins";
      value => generate_histogram.number_of_bins;
      mode = 1;
      min => generate_histogram.number_of_bins_min;
      max => generate_histogram.number_of_bins_max;
   };

   UIsliderUnbnd min_bin  {
      UIparent => UIpanel;
      stitle = "min_bin";
      sval => generate_histogram.min_bin;
      smin => generate_histogram.min_bin_min;
      smax => generate_histogram.min_bin_max;
   };

   UIsliderUnbnd max_bin  {
      UIparent => UIpanel;
      stitle = "max_bin";
      sval => generate_histogram.max_bin;
      smin => generate_histogram.max_bin_min;
      smax => generate_histogram.max_bin_max;
   };

   UIoption histogram {
      label="histogram";
   };

   UIoption cumulative {
      label="cumulative";
   };

   Controls.UIradioBox choice  {
      parent => UIpanel;
      label = "choice";
      cmdList => {histogram, cumulative};
      selectedItem => generate_histogram.choice;
   };

   Controls.UItoggle Normalize  {
      parent => UIpanel;
      label = "Normalize";
      set => generate_histogram.Normalize;
   };

   olink output0=>generate_histogram.Output_Field;
};         // end of ACU_generate_histogram definition

//
// ACU_histogram_stretch
//
macro ACU_histogram_stretch {
   ilink input0;

   Filters.histogram_stretch histogram_stretch {
      Input_Field => input0;
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "histogram_stretch";
     message = "Select histogram_stretch control panel.";
     rowColumnBehavior = 1;
   };

   Controls.UIslider histr_min  {
      parent => UIpanel;
      title = "histr_min";
      value => histogram_stretch.histr_min;
      mode = 1;
      min => histogram_stretch.histr_min_min;
      max => histogram_stretch.histr_min_max;
   };

   Controls.UIslider histr_max  {
      parent => UIpanel;
      title = "histr_max";
      value => histogram_stretch.histr_max;
      mode = 1;
      min => histogram_stretch.histr_max_min;
      max => histogram_stretch.histr_max_max;
   };

   olink output0=>histogram_stretch.Output_Field;
};         // end of ACU_histogram_stretch definition

//
// ACU_image_compare
//
macro ACU_image_compare {
   ilink input0;
   ilink input1;

   Filters.image_compare image_compare {
      Input_1 => input0;
      Input_2 => input1;
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "image_compare";
     message = "Select image_compare control panel.";
     rowColumnBehavior = 1;
   };

   UIoption vert_slice {
      label="vert_slice";
   };

   UIoption horiz_slice {
      label="horiz_slice";
   };

   UIoption diag_slice {
      label="diag_slice";
   };

   UIoption solid {
      label="solid";
   };

   UIoption circle {
      label="circle";
   };

   UIoption checker {
      label="checker";
   };

   UIoption venetian {
      label="venetian";
   };

   UIoption random {
      label="random";
   };

   Controls.UIradioBox choice  {
      parent => UIpanel;
      label = "choice";
      cmdList => {vert_slice, horiz_slice, diag_slice, solid, circle, checker, venetian, random};
      selectedItem => image_compare.choice;
   };

   Controls.UItoggle switch  {
      parent => UIpanel;
      label = "switch";
      set => image_compare.switch;
   };

   Controls.UIslider valuator  {
      parent => UIpanel;
      title = "valuator";
      value => image_compare.valuator;
      min => image_compare.valuator_min;
      max => image_compare.valuator_max;
   };

   olink output0=>image_compare.Field_Output;
};         // end of ACU_image_compare definition

//
// ACU_interpolate
//
macro ACU_interpolate {
   ilink input0;

   Filters.interpolate interpolate {
      Input_Field => input0;
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "interpolate";
     message = "Select interpolate control panel.";
     rowColumnBehavior = 1;
   };

   Controls.UIslider interp_sx  {
      parent => UIpanel;
      title = "interp_sx";
      value => interpolate.interp_sx;
      min => interpolate.interp_sx_min;
      max => interpolate.interp_sx_max;
   };

   Controls.UIslider interp_sy  {
      parent => UIpanel;
      title = "interp_sy";
      value => interpolate.interp_sy;
      min => interpolate.interp_sy_min;
      max => interpolate.interp_sy_max;
   };

   Controls.UIslider interp_sz  {
      parent => UIpanel;
      title = "interp_sz";
      value => interpolate.interp_sz;
      min => interpolate.interp_sz_min;
      max => interpolate.interp_sz_max;
   };

   UIoption Point {
      label="Point";
   };

   UIoption Bi_Trilinear {
      label="Bi/Trilinear";
   };

   Controls.UIradioBox Sampling  {
      parent => UIpanel;
      label = "Sampling";
      cmdList => {Point, Bi_Trilinear};
      selectedItem => interpolate.Sampling;
   };

   olink output0=>interpolate.Output_Field;
};         // end of ACU_interpolate definition

//
// ACU_local_area_ops
//
macro ACU_local_area_ops {
   ilink input0;

   Filters.local_area_ops local_area_ops {
      Input_Field => input0;
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "local_area_ops";
     message = "Select local_area_ops control panel.";
     rowColumnBehavior = 1;
   };

   UIoption Min {
      label="Min";
   };

   UIoption Max {
      label="Max";
   };

   UIoption Median {
      label="Median";
   };

   UIoption Mean {
      label="Mean";
   };

   Controls.UIradioBox choice  {
      parent => UIpanel;
      label = "choice";
      cmdList => {Min, Max, Median, Mean};
      selectedItem => local_area_ops.choice;
   };

   Controls.UIslider kernel_width  {
      parent => UIpanel;
      title = "kernel_width";
      value => local_area_ops.kernel_width;
      mode = 1;
      min => local_area_ops.kernel_width_min;
      max => local_area_ops.kernel_width_max;
   };

   olink output0=>local_area_ops.Output_Field;
};         // end of ACU_local_area_ops definition

//
// ACU_luminance
//
macro ACU_luminance {
   ilink input0;

   Filters.luminance luminance {
      Field_Input => input0;
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "luminance";
     message = "Select luminance control panel.";
     rowColumnBehavior = 1;
   };

   olink output0=>luminance.Field_Output;
};         // end of ACU_luminance definition

//
// ACU_luminence
//
macro ACU_luminence {
   ilink input0;

   Filters.luminence luminence {
      Field_Output => input0;
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "luminence";
     message = "Select luminence control panel.";
     rowColumnBehavior = 1;
   };

   olink output0=>luminence.Field_Output;
};         // end of ACU_luminence definition

//
// ACU_minmax
//
macro ACU_minmax {
   ilink input0;

   Filters.minmax minmax {
      Input => input0;
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "minmax";
     message = "Select minmax control panel.";
     rowColumnBehavior = 1;
   };

   Controls.UIslider channel  {
      parent => UIpanel;
      title = "channel";
      value => minmax.channel;
      mode = 1;
      min => minmax.channel_min;
      max => minmax.channel_max;
   };

   Controls.UIfield min_value  {
      parent => UIpanel;
      value => minmax.min_value;
   };

   Controls.UIfield max_value  {
      parent => UIpanel;
      value => minmax.max_value;
   };

   olink output0=>minmax.Output;

   olink output1=>minmax.min_value;

   olink output2=>minmax.max_value;
};         // end of ACU_minmax definition

//
// ACU_mirror
//
macro ACU_mirror {
   ilink input0;

   Filters.mirror mirror {
      Input_Field => input0;
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "mirror";
     message = "Select mirror control panel.";
     rowColumnBehavior = 1;
   };

   UIoption Original {
      label="Original";
   };

   UIoption X {
      label="X";
   };

   UIoption Y {
      label="Y";
   };

   UIoption Z {
      label="Z";
   };

   Controls.UIradioBox Axis  {
      parent => UIpanel;
      label = "Axis";
      cmdList => {Original, X, Y, Z};
      selectedItem => mirror.Axis;
   };

   olink output0=>mirror.Output_Field;
};         // end of ACU_mirror definition

//
// ACU_offset
//
macro ACU_offset {
   ilink input0;

   Filters.offset offset {
      Input => input0;
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "offset";
     message = "Select offset control panel.";
     rowColumnBehavior = 1;
   };

   UIsliderUnbnd offset_ {
      UIparent => UIpanel;
      stitle = "offset";
      sval => offset.offset;
      smin => offset.offset_min;
      smax => offset.offset_max;
   };

   olink output0=>offset.Output;
};         // end of ACU_offset definition

//
// ACU_replace_alpha
//
macro ACU_replace_alpha {
   ilink input0;
   ilink input1;

   Filters.replace_alpha replace_alpha {
      Image => input0;
      Alpha => input1;
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "replace_alpha";
     message = "Select replace_alpha control panel.";
     rowColumnBehavior = 1;
   };

   olink output0=>replace_alpha.Field_Output;
};         // end of ACU_replace_alpha definition

//
// ACU_replace_alpha
//
macro ACU_replace_alpha {
   ilink input0;
   ilink input1;

   Filters.replace_alpha replace_alpha {
      Image => input0;
      Alpha => input1;
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "replace_alpha";
     message = "Select replace_alpha control panel.";
     rowColumnBehavior = 1;
   };

   olink output0=>replace_alpha.Field_Output;
};         // end of ACU_replace_alpha definition

//
// ACU_scatter_to_tri
//
macro ACU_scatter_to_tri {
   ilink input0;

   Filters.scatter_to_tri scatter_to_tri {
      Input => input0;
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "scatter_to_tri";
     message = "Select scatter_to_tri control panel.";
     rowColumnBehavior = 1;
   };

   olink output0=>scatter_to_tri.Output;
};         // end of ACU_scatter_to_tri definition

//
// ACU_scatter_to_ucd
//
macro ACU_scatter_to_ucd {
   ilink input0;

   Filters.scatter_to_ucd scatter_to_ucd {
      Input => input0;
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "scatter_to_ucd";
     message = "Select scatter_to_ucd control panel.";
     rowColumnBehavior = 1;
   };

   Controls.UItoggle Check_Tetras  {
      parent => UIpanel;
      label = "Check_Tetras";
      set => scatter_to_ucd.Check_Tetras;
   };

   olink output0=>scatter_to_ucd.Output;
};         // end of ACU_scatter_to_ucd definition

//
// ACU_shrink
//
macro ACU_shrink {
   ilink input0;

   Filters.shrink shrink {
      Input => input0;
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "shrink";
     message = "Select shrink control panel.";
     rowColumnBehavior = 1;
   };

   Controls.UIslider offset  {
      parent => UIpanel;
      title = "offset";
      value => shrink.offset;
      min => shrink.offset_min;
      max => shrink.offset_max;
   };

   olink output0=>shrink.Output;
};         // end of ACU_shrink definition

//
// ACU_sobel
//
macro ACU_sobel {
   ilink input0;

   Filters.sobel sobel {
      Input_Field => input0;
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "sobel";
     message = "Select sobel control panel.";
     rowColumnBehavior = 1;
   };

   olink output0=>sobel.Output_Field;
};         // end of ACU_sobel definition

//
// ACU_threshold
//
macro ACU_threshold {
   ilink input0;

   Filters.threshold threshold {
      Input_Field => input0;
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "threshold";
     message = "Select threshold control panel.";
     rowColumnBehavior = 1;
   };

   UIsliderUnbnd thresh_min  {
      UIparent => UIpanel;
      stitle = "thresh_min";
      sval => threshold.thresh_min;
      smin => threshold.thresh_min_min;
      smax => threshold.thresh_min_max;
   };

   UIsliderUnbnd thresh_max  {
      UIparent => UIpanel;
      stitle = "thresh_max";
      sval => threshold.thresh_max;
      smin => threshold.thresh_max_min;
      smax => threshold.thresh_max_max;
   };

   olink output0=>threshold.Output_Field;
};         // end of ACU_threshold definition

//
// ACU_time_sampler
//
macro ACU_time_sampler {
   ilink input0;

   Filters.time_sampler time_sampler {
      input => input0;
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "time_sampler";
     message = "Select time_sampler control panel.";
     rowColumnBehavior = 1;
   };

   Controls.UIslider time_step  {
      parent => UIpanel;
      title = "time_step";
      value => time_sampler.time_step;
      min => time_sampler.time_step_min;
      max => time_sampler.time_step_max;
   };

   UIoption slice {
      label="slice";
   };

   UIoption linear {
      label="linear";
   };

   UIoption cubic {
      label="cubic";
   };

   Controls.UIradioBox choice  {
      parent => UIpanel;
      label = "choice";
      cmdList => {slice, linear, cubic};
      selectedItem => time_sampler.choice;
   };

   olink output0=>time_sampler.output;
};         // end of ACU_time_sampler definition

//
// ACU_transpose
//
macro ACU_transpose {
   ilink input0;

   Filters.transpose transpose {
      Input_Field => input0;
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "transpose";
     message = "Select transpose control panel.";
     rowColumnBehavior = 1;
   };

   UIoption Original {
      label="Original";
   };

   UIoption YZ {
      label="YZ";
   };

   UIoption XZ {
      label="XZ";
   };

   UIoption XY {
      label="XY";
   };

   Controls.UIradioBox Axis  {
      parent => UIpanel;
      label = "Axis";
      cmdList => {Original, YZ, XZ, XY};
      selectedItem => transpose.Axis;
   };

   olink output0=>transpose.Output_Field;
};         // end of ACU_transpose definition

//
// ACU_tube
//
macro ACU_tube {
   ilink input0;

   Filters.tube tube {
      Input => input0;
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "tube";
     message = "Select tube control panel.";
     rowColumnBehavior = 1;
   };

   Controls.UIslider radius  {
      parent => UIpanel;
      title = "radius";
      value => tube.radius;
      min => tube.radius_min;
      max => tube.radius_max;
   };

   olink output0=>tube.Output;
};         // end of ACU_tube definition

//
// ACU_ucd_cell_to_node
//
macro ACU_ucd_cell_to_node {
   ilink input0;

   Filters.ucd_cell_to_node ucd_cell_to_node {
      Input => input0;
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "ucd_cell_to_node";
     message = "Select ucd_cell_to_node control panel.";
     rowColumnBehavior = 1;
   };

   Controls.UIlabel Method  {
      parent => UIpanel;
      label => ucd_cell_to_node.Method;
   };

   UIoption Average {
      label="Average";
   };

   UIoption Interpolate {
      label="Interpolate";
   };

   Controls.UIradioBox method  {
      parent => UIpanel;
      label = "method";
      cmdList => {Average, Interpolate};
      selectedItem => ucd_cell_to_node.method;
   };

   olink output0=>ucd_cell_to_node.Output;
};         // end of ACU_ucd_cell_to_node definition

//
// ACU_ucd_crop
//
macro ACU_ucd_crop {
   ilink input0;
   ilink input1;

   Filters.ucd_crop ucd_crop {
      Input => input0;
      Transform_Info => input1;
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "ucd_crop";
     message = "Select ucd_crop control panel.";
     rowColumnBehavior = 1;
   };

   UIoption plane {
      label="plane";
   };

   UIoption space {
      label="space";
   };

   Controls.UIradioBox choice  {
      parent => UIpanel;
      label = "choice";
      cmdList => {plane, space};
      selectedItem => ucd_crop.choice;
   };

   UIoption inside {
      label="inside";
   };

   UIoption outside {
      label="outside";
   };

   Controls.UIradioBox side  {
      parent => UIpanel;
      label = "side";
      cmdList => {inside, outside};
      selectedItem => ucd_crop.side;
   };

   Controls.UItoggle Do_Crop  {
      parent => UIpanel;
      label = "Do_Crop";
      set => ucd_crop.Do_Crop;
   };

   olink output0=>ucd_crop.Output;

   olink output1=>ucd_crop.Geom_Output;
};         // end of ACU_ucd_crop definition

//
// ACU_ucd_curl
//
macro ACU_ucd_curl {
   ilink input0;

   Filters.ucd_curl ucd_curl {
      Input => input0;
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "ucd_curl";
     message = "Select ucd_curl control panel.";
     rowColumnBehavior = 1;
   };

   Controls.UIlabel Node_Data  {
      parent => UIpanel;
      label => ucd_curl.Node_Data;
   };

   UIoption _data_1_ {
      label="<data 1>";
   };

   UIoption _data_2_ {
      label="<data 2>";
   };

   UIoption _data_3_ {
      label="<data 3>";
   };

   UIoption _data_4_ {
      label="<data 4>";
   };

   UIoption _data_5_ {
      label="<data 5>";
   };

   Controls.UIradioBox node_data  {
      parent => UIpanel;
      label = "node_data";
      cmdList => {_data_1_, _data_2_, _data_3_, _data_4_, _data_5_};
      selectedItem => ucd_curl.node_data;
   };

   olink output0=>ucd_curl.Output;
};         // end of ACU_ucd_curl definition

//
// ACU_ucd_div
//
macro ACU_ucd_div {
   ilink input0;

   Filters.ucd_div ucd_div {
      Input => input0;
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "ucd_div";
     message = "Select ucd_div control panel.";
     rowColumnBehavior = 1;
   };

   Controls.UIlabel Node_Data  {
      parent => UIpanel;
      label => ucd_div.Node_Data;
   };

   UIoption _data_1_ {
      label="<data 1>";
   };

   UIoption _data_2_ {
      label="<data 2>";
   };

   UIoption _data_3_ {
      label="<data 3>";
   };

   UIoption _data_4_ {
      label="<data 4>";
   };

   UIoption _data_5_ {
      label="<data 5>";
   };

   Controls.UIradioBox node_data  {
      parent => UIpanel;
      label = "node_data";
      cmdList => {_data_1_, _data_2_, _data_3_, _data_4_, _data_5_};
      selectedItem => ucd_div.node_data;
   };

   olink output0=>ucd_div.Output;
};         // end of ACU_ucd_div definition

//
// ACU_ucd_extract
//
macro ACU_ucd_extract {
   ilink input0;

   Filters.ucd_extract ucd_extract {
      Input => input0;
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "ucd_extract";
     message = "Select ucd_extract control panel.";
     rowColumnBehavior = 1;
   };

   Controls.UIlabel Node_Data  {
      parent => UIpanel;
      label => ucd_extract.Node_Data;
   };

   UIoption _data_1_ {
      label="<data 1>";
   };

   UIoption _data_2_ {
      label="<data 2>";
   };

   UIoption _data_3_ {
      label="<data 3>";
   };

   UIoption _data_4_ {
      label="<data 4>";
   };

   UIoption _data_5_ {
      label="<data 5>";
   };

   Controls.UIradioBox node_data  {
      parent => UIpanel;
      label = "node_data";
      cmdList => {_data_1_, _data_2_, _data_3_, _data_4_, _data_5_};
      selectedItem => ucd_extract.node_data;
   };

   olink output0=>ucd_extract.Output;
};         // end of ACU_ucd_extract definition

//
// ACU_ucd_extract_scalars
//
macro ACU_ucd_extract_scalars {
   ilink input0;

   Filters.ucd_extract_scalars ucd_extract_scalars {
      Input => input0;
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "ucd_extract_scalars";
     message = "Select ucd_extract_scalars control panel.";
     rowColumnBehavior = 1;
   };

   Controls.UItoggle Channel_0  {
      parent => UIpanel;
      label = "Channel_0";
      set => ucd_extract_scalars.Channel_0;
   };

   Controls.UItoggle Channel_1  {
      parent => UIpanel;
      label = "Channel_1";
      set => ucd_extract_scalars.Channel_1;
   };

   Controls.UItoggle Channel_2  {
      parent => UIpanel;
      label = "Channel_2";
      set => ucd_extract_scalars.Channel_2;
   };

   Controls.UItoggle Channel_3  {
      parent => UIpanel;
      label = "Channel_3";
      set => ucd_extract_scalars.Channel_3;
   };

   Controls.UItoggle Channel_4  {
      parent => UIpanel;
      label = "Channel_4";
      set => ucd_extract_scalars.Channel_4;
   };

   Controls.UItoggle Channel_5  {
      parent => UIpanel;
      label = "Channel_5";
      set => ucd_extract_scalars.Channel_5;
   };

   Controls.UItoggle Channel_6  {
      parent => UIpanel;
      label = "Channel_6";
      set => ucd_extract_scalars.Channel_6;
   };

   Controls.UItoggle Channel_7  {
      parent => UIpanel;
      label = "Channel_7";
      set => ucd_extract_scalars.Channel_7;
   };

   Controls.UItoggle Channel_8  {
      parent => UIpanel;
      label = "Channel_8";
      set => ucd_extract_scalars.Channel_8;
   };

   Controls.UItoggle Channel_9  {
      parent => UIpanel;
      label = "Channel_9";
      set => ucd_extract_scalars.Channel_9;
   };

   Controls.UItoggle Channel_10  {
      parent => UIpanel;
      label = "Channel_10";
      set => ucd_extract_scalars.Channel_10;
   };

   Controls.UItoggle Channel_11  {
      parent => UIpanel;
      label = "Channel_11";
      set => ucd_extract_scalars.Channel_11;
   };

   Controls.UItoggle Channel_12  {
      parent => UIpanel;
      label = "Channel_12";
      set => ucd_extract_scalars.Channel_12;
   };

   Controls.UItoggle Channel_13  {
      parent => UIpanel;
      label = "Channel_13";
      set => ucd_extract_scalars.Channel_13;
   };

   Controls.UItoggle Channel_14  {
      parent => UIpanel;
      label = "Channel_14";
      set => ucd_extract_scalars.Channel_14;
   };

   Controls.UItoggle Channel_15  {
      parent => UIpanel;
      label = "Channel_15";
      set => ucd_extract_scalars.Channel_15;
   };

   Controls.UItoggle Channel_16  {
      parent => UIpanel;
      label = "Channel_16";
      set => ucd_extract_scalars.Channel_16;
   };

   Controls.UItoggle Channel_17  {
      parent => UIpanel;
      label = "Channel_17";
      set => ucd_extract_scalars.Channel_17;
   };

   Controls.UItoggle Channel_18  {
      parent => UIpanel;
      label = "Channel_18";
      set => ucd_extract_scalars.Channel_18;
   };

   Controls.UItoggle Channel_19  {
      parent => UIpanel;
      label = "Channel_19";
      set => ucd_extract_scalars.Channel_19;
   };

   Controls.UItoggle Channel_20  {
      parent => UIpanel;
      label = "Channel_20";
      set => ucd_extract_scalars.Channel_20;
   };

   Controls.UItoggle Channel_21  {
      parent => UIpanel;
      label = "Channel_21";
      set => ucd_extract_scalars.Channel_21;
   };

   Controls.UItoggle Channel_22  {
      parent => UIpanel;
      label = "Channel_22";
      set => ucd_extract_scalars.Channel_22;
   };

   Controls.UItoggle Channel_23  {
      parent => UIpanel;
      label = "Channel_23";
      set => ucd_extract_scalars.Channel_23;
   };

   Controls.UItoggle Channel_24  {
      parent => UIpanel;
      label = "Channel_24";
      set => ucd_extract_scalars.Channel_24;
   };

   olink output0=>ucd_extract_scalars.Output;
};         // end of ACU_ucd_extract_scalars definition

//
// ACU_ucd_extract_vector
//
macro ACU_ucd_extract_vector {
   ilink input0;

   Filters.ucd_extract_vector ucd_extract_vector {
      Input => input0;
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "ucd_extract_vector";
     message = "Select ucd_extract_vector control panel.";
     rowColumnBehavior = 1;
   };

   Controls.UItoggle Channel_0  {
      parent => UIpanel;
      label = "Channel_0";
      set => ucd_extract_vector.Channel_0;
   };

   Controls.UItoggle Channel_1  {
      parent => UIpanel;
      label = "Channel_1";
      set => ucd_extract_vector.Channel_1;
   };

   Controls.UItoggle Channel_2  {
      parent => UIpanel;
      label = "Channel_2";
      set => ucd_extract_vector.Channel_2;
   };

   Controls.UItoggle Channel_3  {
      parent => UIpanel;
      label = "Channel_3";
      set => ucd_extract_vector.Channel_3;
   };

   Controls.UItoggle Channel_4  {
      parent => UIpanel;
      label = "Channel_4";
      set => ucd_extract_vector.Channel_4;
   };

   Controls.UItoggle Channel_5  {
      parent => UIpanel;
      label = "Channel_5";
      set => ucd_extract_vector.Channel_5;
   };

   Controls.UItoggle Channel_6  {
      parent => UIpanel;
      label = "Channel_6";
      set => ucd_extract_vector.Channel_6;
   };

   Controls.UItoggle Channel_7  {
      parent => UIpanel;
      label = "Channel_7";
      set => ucd_extract_vector.Channel_7;
   };

   Controls.UItoggle Channel_8  {
      parent => UIpanel;
      label = "Channel_8";
      set => ucd_extract_vector.Channel_8;
   };

   Controls.UItoggle Channel_9  {
      parent => UIpanel;
      label = "Channel_9";
      set => ucd_extract_vector.Channel_9;
   };

   Controls.UItoggle Channel_10  {
      parent => UIpanel;
      label = "Channel_10";
      set => ucd_extract_vector.Channel_10;
   };

   Controls.UItoggle Channel_11  {
      parent => UIpanel;
      label = "Channel_11";
      set => ucd_extract_vector.Channel_11;
   };

   Controls.UItoggle Channel_12  {
      parent => UIpanel;
      label = "Channel_12";
      set => ucd_extract_vector.Channel_12;
   };

   Controls.UItoggle Channel_13  {
      parent => UIpanel;
      label = "Channel_13";
      set => ucd_extract_vector.Channel_13;
   };

   Controls.UItoggle Channel_14  {
      parent => UIpanel;
      label = "Channel_14";
      set => ucd_extract_vector.Channel_14;
   };

   Controls.UItoggle Channel_15  {
      parent => UIpanel;
      label = "Channel_15";
      set => ucd_extract_vector.Channel_15;
   };

   Controls.UItoggle Channel_16  {
      parent => UIpanel;
      label = "Channel_16";
      set => ucd_extract_vector.Channel_16;
   };

   Controls.UItoggle Channel_17  {
      parent => UIpanel;
      label = "Channel_17";
      set => ucd_extract_vector.Channel_17;
   };

   Controls.UItoggle Channel_18  {
      parent => UIpanel;
      label = "Channel_18";
      set => ucd_extract_vector.Channel_18;
   };

   Controls.UItoggle Channel_19  {
      parent => UIpanel;
      label = "Channel_19";
      set => ucd_extract_vector.Channel_19;
   };

   Controls.UItoggle Channel_20  {
      parent => UIpanel;
      label = "Channel_20";
      set => ucd_extract_vector.Channel_20;
   };

   Controls.UItoggle Channel_21  {
      parent => UIpanel;
      label = "Channel_21";
      set => ucd_extract_vector.Channel_21;
   };

   Controls.UItoggle Channel_22  {
      parent => UIpanel;
      label = "Channel_22";
      set => ucd_extract_vector.Channel_22;
   };

   Controls.UItoggle Channel_23  {
      parent => UIpanel;
      label = "Channel_23";
      set => ucd_extract_vector.Channel_23;
   };

   Controls.UItoggle Channel_24  {
      parent => UIpanel;
      label = "Channel_24";
      set => ucd_extract_vector.Channel_24;
   };

   Controls.UIslider Vector_Length  {
      parent => UIpanel;
      title = "Vector_Length";
      value => ucd_extract_vector.Vector_Length;
      mode = 1;
      min => ucd_extract_vector.Vector_Length_min;
      max => ucd_extract_vector.Vector_Length_max;
   };

   olink output0=>ucd_extract_vector.Output;
};         // end of ACU_ucd_extract_vector definition

//
// ACU_ucd_grad
//
macro ACU_ucd_grad {
   ilink input0;

   Filters.ucd_grad ucd_grad {
      Input => input0;
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "ucd_grad";
     message = "Select ucd_grad control panel.";
     rowColumnBehavior = 1;
   };

   Controls.UIlabel Node_Data  {
      parent => UIpanel;
      label => ucd_grad.Node_Data;
   };

   UIoption _data_1_ {
      label="<data 1>";
   };

   UIoption _data_2_ {
      label="<data 2>";
   };

   UIoption _data_3_ {
      label="<data 3>";
   };

   UIoption _data_4_ {
      label="<data 4>";
   };

   UIoption _data_5_ {
      label="<data 5>";
   };

   Controls.UIradioBox node_data  {
      parent => UIpanel;
      label = "node_data";
      cmdList => {_data_1_, _data_2_, _data_3_, _data_4_, _data_5_};
      selectedItem => ucd_grad.node_data;
   };

   olink output0=>ucd_grad.Output;
};         // end of ACU_ucd_grad definition

//
// ACU_ucd_hex_to_tet
//
macro ACU_ucd_hex_to_tet {
   ilink input0;

   Filters.ucd_hex_to_tet ucd_hex_to_tet {
      Input => input0;
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "ucd_hex_to_tet";
     message = "Select ucd_hex_to_tet control panel.";
     rowColumnBehavior = 1;
   };

// 24_Tet is not a valid identifier
//
//   Controls.UItoggle 24_Tet  {
//      parent => UIpanel;
//      label = "24_Tet";
//      set => ucd_hex_to_tet.24_Tet;
//   };

   Controls.UIlabel Node_Data  {
      parent => UIpanel;
      label => ucd_hex_to_tet.Node_Data;
   };

   UIoption _data_1_ {
      label="<data 1>";
   };

   UIoption _data_2_ {
      label="<data 2>";
   };

   UIoption _data_3_ {
      label="<data 3>";
   };

   UIoption _data_4_ {
      label="<data 4>";
   };

   UIoption _data_5_ {
      label="<data 5>";
   };

   Controls.UIradioBox node_data  {
      parent => UIpanel;
      label = "node_data";
      cmdList => {_data_1_, _data_2_, _data_3_, _data_4_, _data_5_};
      selectedItem => ucd_hex_to_tet.node_data;
   };

   olink output0=>ucd_hex_to_tet.Output;
};         // end of ACU_ucd_hex_to_tet definition

//
// ACU_ucd_math
//
macro ACU_ucd_math {
   ilink input0;
   ilink input1;

   Filters.ucd_math ucd_math {
      ucd_1 => input0;
      ucd_2 => input1;
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "ucd_math";
     message = "Select ucd_math control panel.";
     rowColumnBehavior = 1;
   };

   UIoption _ {
      label="+";
   };

   UIoption _ {
      label="-";
   };

   UIoption _ {
      label="*";
   };

   UIoption _ {
      label="/";
   };

   UIoption Square {
      label="Square";
   };

   UIoption Sqrt {
      label="Sqrt";
   };

   UIoption Pow {
      label="Pow";
   };

   UIoption Log {
      label="Log";
   };

   UIoption Sin {
      label="Sin";
   };

   UIoption Cos {
      label="Cos";
   };

   UIoption NONE {
      label="NONE";
   };

   Controls.UIradioBox choice  {
      parent => UIpanel;
      label = "choice";
      cmdList => {_, _, _, _, Square, Sqrt, Pow, Log, Sin, Cos, NONE};
      selectedItem => ucd_math.choice;
   };

   Controls.UIfield Constant  {
      parent => UIpanel;
      value => ucd_math.Constant;
   };

   olink output0=>ucd_math.ucd_out;
};         // end of ACU_ucd_math definition

//
// ACU_ucd_minmax
//
macro ACU_ucd_minmax {
   ilink input0;

   Filters.ucd_minmax ucd_minmax {
      Input => input0;
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "ucd_minmax";
     message = "Select ucd_minmax control panel.";
     rowColumnBehavior = 1;
   };

   Controls.UIfield min_value  {
      parent => UIpanel;
      value => ucd_minmax.min_value;
   };

   Controls.UIfield max_value  {
      parent => UIpanel;
      value => ucd_minmax.max_value;
   };

   Controls.UIlabel Node_Data  {
      parent => UIpanel;
      label => ucd_minmax.Node_Data;
   };

   UIoption _data_1_ {
      label="<data 1>";
   };

   UIoption _data_2_ {
      label="<data 2>";
   };

   UIoption _data_3_ {
      label="<data 3>";
   };

   UIoption _data_4_ {
      label="<data 4>";
   };

   UIoption _data_5_ {
      label="<data 5>";
   };

   Controls.UIradioBox node_data  {
      parent => UIpanel;
      label = "node_data";
      cmdList => {_data_1_, _data_2_, _data_3_, _data_4_, _data_5_};
      selectedItem => ucd_minmax.node_data;
   };

   olink output0=>ucd_minmax.Output;

   olink output1=>ucd_minmax.min_value;

   olink output2=>ucd_minmax.max_value;
};         // end of ACU_ucd_minmax definition

//
// ACU_ucd_offset
//
macro ACU_ucd_offset {
   ilink input0;

   Filters.ucd_offset ucd_offset {
      Input => input0;
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "ucd_offset";
     message = "Select ucd_offset control panel.";
     rowColumnBehavior = 1;
   };

   Controls.UIlabel Node_Data  {
      parent => UIpanel;
      label => ucd_offset.Node_Data;
   };

   UIoption _data_1_ {
      label="<data 1>";
   };

   UIoption _data_2_ {
      label="<data 2>";
   };

   UIoption _data_3_ {
      label="<data 3>";
   };

   UIoption _data_4_ {
      label="<data 4>";
   };

   UIoption _data_5_ {
      label="<data 5>";
   };

   Controls.UIradioBox node_data  {
      parent => UIpanel;
      label = "node_data";
      cmdList => {_data_1_, _data_2_, _data_3_, _data_4_, _data_5_};
      selectedItem => ucd_offset.node_data;
   };

   UIsliderUnbnd offset_factor  {
      UIparent => UIpanel;
      stitle = "offset_factor";
      sval => ucd_offset.offset_factor;
      smin => ucd_offset.offset_factor_min;
      smax => ucd_offset.offset_factor_max;
   };

   olink output0=>ucd_offset.Output;
};         // end of ACU_ucd_offset definition

//
// ACU_ucd_offset
//
macro ACU_ucd_offset {
   ilink input0;

   Filters.ucd_offset ucd_offset {
      Input => input0;
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "ucd_offset";
     message = "Select ucd_offset control panel.";
     rowColumnBehavior = 1;
   };

   Controls.UIlabel Node_Data  {
      parent => UIpanel;
      label => ucd_offset.Node_Data;
   };

   UIoption _data_1_ {
      label="<data 1>";
   };

   UIoption _data_2_ {
      label="<data 2>";
   };

   UIoption _data_3_ {
      label="<data 3>";
   };

   UIoption _data_4_ {
      label="<data 4>";
   };

   UIoption _data_5_ {
      label="<data 5>";
   };

   Controls.UIradioBox node_data  {
      parent => UIpanel;
      label = "node_data";
      cmdList => {_data_1_, _data_2_, _data_3_, _data_4_, _data_5_};
      selectedItem => ucd_offset.node_data;
   };

   UIsliderUnbnd offset_factor  {
      UIparent => UIpanel;
      stitle = "offset_factor";
      sval => ucd_offset.offset_factor;
      smin => ucd_offset.offset_factor_min;
      smax => ucd_offset.offset_factor_max;
   };

   olink output0=>ucd_offset.Output;
};         // end of ACU_ucd_offset definition

//
// ACU_ucd_reverse_cell
//
macro ACU_ucd_reverse_cell {
   ilink input0;

   Filters.ucd_reverse_cell ucd_reverse_cell {
      Input => input0;
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "ucd_reverse_cell";
     message = "Select ucd_reverse_cell control panel.";
     rowColumnBehavior = 1;
   };

   UIoption Correct_Topology {
      label="Correct Topology";
   };

   UIoption Reverse_Cells {
      label="Reverse Cells";
   };

   Controls.UIradioBox choice  {
      parent => UIpanel;
      label = "choice";
      cmdList => {Correct_Topology, Reverse_Cells};
      selectedItem => ucd_reverse_cell.choice;
   };

   Controls.UItoggle Reverse_TRIANGLES  {
      parent => UIpanel;
      label = "Reverse_TRIANGLES";
      set => ucd_reverse_cell.Reverse_TRIANGLES;
   };

   Controls.UItoggle Reverse_QUADS  {
      parent => UIpanel;
      label = "Reverse_QUADS";
      set => ucd_reverse_cell.Reverse_QUADS;
   };

   Controls.UItoggle Reverse_TETRAS  {
      parent => UIpanel;
      label = "Reverse_TETRAS";
      set => ucd_reverse_cell.Reverse_TETRAS;
   };

   Controls.UItoggle Reverse_HEXAS  {
      parent => UIpanel;
      label = "Reverse_HEXAS";
      set => ucd_reverse_cell.Reverse_HEXAS;
   };

   Controls.UItoggle Reverse_PRISMS  {
      parent => UIpanel;
      label = "Reverse_PRISMS";
      set => ucd_reverse_cell.Reverse_PRISMS;
   };

   olink output0=>ucd_reverse_cell.Output;
};         // end of ACU_ucd_reverse_cell definition

//
// ACU_ucd_threshold
//
macro ACU_ucd_threshold {
   ilink input0;
   ilink input1;

   Filters.ucd_threshold ucd_threshold {
      Input => input0;
      Info => input1;
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "ucd_threshold";
     message = "Select ucd_threshold control panel.";
     rowColumnBehavior = 1;
   };

   Controls.UItoggle Below  {
      parent => UIpanel;
      label = "Below";
      set => ucd_threshold.Below;
   };

   Controls.UItoggle Inclusive  {
      parent => UIpanel;
      label = "Inclusive";
      set => ucd_threshold.Inclusive;
   };

   olink output0=>ucd_threshold.Output;
};         // end of ACU_ucd_threshold definition

//
// ACU_ucd_vecmag
//
macro ACU_ucd_vecmag {
   ilink input0;

   Filters.ucd_vecmag ucd_vecmag {
      Input => input0;
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "ucd_vecmag";
     message = "Select ucd_vecmag control panel.";
     rowColumnBehavior = 1;
   };

   olink output0=>ucd_vecmag.Output;
};         // end of ACU_ucd_vecmag definition

//
// ACU_vector_curl
//
macro ACU_vector_curl {
   ilink input0;

   Filters.vector_curl vector_curl {
      Input_Field => input0;
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "vector_curl";
     message = "Select vector_curl control panel.";
     rowColumnBehavior = 1;
   };

   olink output0=>vector_curl.Output_Field;
};         // end of ACU_vector_curl definition

//
// ACU_vector_div
//
macro ACU_vector_div {
   ilink input0;

   Filters.vector_div vector_div {
      Input_Field => input0;
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "vector_div";
     message = "Select vector_div control panel.";
     rowColumnBehavior = 1;
   };

   olink output0=>vector_div.Output_Field;
};         // end of ACU_vector_div definition

//
// ACU_vector_grad
//
macro ACU_vector_grad {
   ilink input0;

   Filters.vector_grad vector_grad {
      Input_Field => input0;
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "vector_grad";
     message = "Select vector_grad control panel.";
     rowColumnBehavior = 1;
   };

   olink output0=>vector_grad.Output_Field;
};         // end of ACU_vector_grad definition

//
// ACU_vector_mag
//
macro ACU_vector_mag {
   ilink input0;

   Filters.vector_mag vector_mag {
      Input_Field => input0;
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "vector_mag";
     message = "Select vector_mag control panel.";
     rowColumnBehavior = 1;
   };

   olink output0=>vector_mag.Output_Field;
};         // end of ACU_vector_mag definition

//
// ACU_vector_norm
//
macro ACU_vector_norm {
   ilink input0;

   Filters.vector_norm vector_norm {
      Input_Field => input0;
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "vector_norm";
     message = "Select vector_norm control panel.";
     rowColumnBehavior = 1;
   };

   olink output0=>vector_norm.Output_Field;
};         // end of ACU_vector_norm definition

//
// ACU_wireframe
//
macro ACU_wireframe {
   ilink input0;

   Filters.wireframe wireframe {
      Input => input0;
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "wireframe";
     message = "Select wireframe control panel.";
     rowColumnBehavior = 1;
   };

   olink output0=>wireframe.Output;
};         // end of ACU_wireframe definition


};
library+buffered ACU_Mappers {

//
// ACU_arbitrary_slicer
//
macro ACU_arbitrary_slicer {
   ilink input0;
   ilink input1;
   ilink input2;

   Mappers.arbitrary_slicer arbitrary_slicer {
      Field_Input => input0;
      Input_Colormap => input1;
      upstream => input2;
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "arbitrary_slicer";
     message = "Select arbitrary_slicer control panel.";
     rowColumnBehavior = 1;
   };

   UIsliderUnbnd X_Rotation  {
      UIparent => UIpanel;
      stitle = "X_Rotation";
      sval => arbitrary_slicer.X_Rotation;
      smin => arbitrary_slicer.X_Rotation_min;
      smax => arbitrary_slicer.X_Rotation_max;
   };

   UIsliderUnbnd Y_Rotation  {
      UIparent => UIpanel;
      stitle = "Y_Rotation";
      sval => arbitrary_slicer.Y_Rotation;
      smin => arbitrary_slicer.Y_Rotation_min;
      smax => arbitrary_slicer.Y_Rotation_max;
   };

   Controls.UIslider Distance  {
      parent => UIpanel;
      title = "Distance";
      value => arbitrary_slicer.Distance;
      min => arbitrary_slicer.Distance_min;
      max => arbitrary_slicer.Distance_max;
   };

   Controls.UIslider Mesh_Res  {
      parent => UIpanel;
      title = "Mesh_Res";
      value => arbitrary_slicer.Mesh_Res;
      mode = 1;
      min => arbitrary_slicer.Mesh_Res_min;
      max => arbitrary_slicer.Mesh_Res_max;
   };

   Controls.UIlabel Sampling_Style  {
      parent => UIpanel;
      label => arbitrary_slicer.Sampling_Style;
   };

   UIoption Point {
      label="Point";
   };

   UIoption Trilinear {
      label="Trilinear";
   };

   Controls.UIradioBox choice  {
      parent => UIpanel;
      label = "choice";
      cmdList => {Point, Trilinear};
      selectedItem => arbitrary_slicer.choice;
   };

   olink output0=>arbitrary_slicer.geometry;
};         // end of ACU_arbitrary_slicer definition

//
// ACU_bar_chart_3D
//
macro ACU_bar_chart_3D {
   ilink input0;
   ilink input1;

   Mappers.bar_chart_3D bar_chart_3D {
      Field_Input => input0;
      Input_Colormap => input1;
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "bar_chart_3D";
     message = "Select bar_chart_3D control panel.";
     rowColumnBehavior = 1;
   };

   UIsliderUnbnd Z_scale  {
      UIparent => UIpanel;
      stitle = "Z_scale";
      sval => bar_chart_3D.Z_scale;
      smin => bar_chart_3D.Z_scale_min;
      smax => bar_chart_3D.Z_scale_max;
   };

   Controls.UIslider width  {
      parent => UIpanel;
      title = "width";
      value => bar_chart_3D.width;
      min => bar_chart_3D.width_min;
      max => bar_chart_3D.width_max;
   };

   Controls.UIslider offset  {
      parent => UIpanel;
      title = "offset";
      value => bar_chart_3D.offset;
      min => bar_chart_3D.offset_min;
      max => bar_chart_3D.offset_max;
   };

   UIsliderUnbnd threshold  {
      UIparent => UIpanel;
      stitle = "threshold";
      sval => bar_chart_3D.threshold;
      smin => bar_chart_3D.threshold_min;
      smax => bar_chart_3D.threshold_max;
   };

   UIsliderUnbnd tic_scale  {
      UIparent => UIpanel;
      stitle = "tic_scale";
      sval => bar_chart_3D.tic_scale;
      smin => bar_chart_3D.tic_scale_min;
      smax => bar_chart_3D.tic_scale_max;
   };

   olink output0=>bar_chart_3D.geometry;
};         // end of ACU_bar_chart_3D definition

//
// ACU_brick
//
macro ACU_brick {
   ilink input0;
   ilink input1;

   Mappers.brick brick {
      volume => input0;
      Transform_Info => input1;
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "brick";
     message = "Select brick control panel.";
     rowColumnBehavior = 1;
   };

   UIsliderUnbnd X_Rot  {
      UIparent => UIpanel;
      stitle = "X_Rot";
      sval => brick.X_Rot;
      smin => brick.X_Rot_min;
      smax => brick.X_Rot_max;
   };

   UIsliderUnbnd Y_Rot  {
      UIparent => UIpanel;
      stitle = "Y_Rot";
      sval => brick.Y_Rot;
      smin => brick.Y_Rot_min;
      smax => brick.Y_Rot_max;
   };

   UIsliderUnbnd Offset  {
      UIparent => UIpanel;
      stitle = "Offset";
      sval => brick.Offset;
      smin => brick.Offset_min;
      smax => brick.Offset_max;
   };

   Controls.UItoggle Sides  {
      parent => UIpanel;
      label = "Sides";
      set => brick.Sides;
   };

   olink output0=>brick.geometry;
};         // end of ACU_brick definition

//
// ACU_contour_to_geom
//
macro ACU_contour_to_geom {
   ilink input0;

   Mappers.contour_to_geom contour_to_geom {
      Input => input0;
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "contour_to_geom";
     message = "Select contour_to_geom control panel.";
     rowColumnBehavior = 1;
   };

   UIsliderUnbnd threshold  {
      UIparent => UIpanel;
      stitle = "threshold";
      sval => contour_to_geom.threshold;
      smin => contour_to_geom.threshold_min;
      smax => contour_to_geom.threshold_max;
   };

   olink output0=>contour_to_geom.Output;
};         // end of ACU_contour_to_geom definition

//
// ACU_excavate_brick
//
macro ACU_excavate_brick {
   ilink input0;

   Mappers.excavate_brick excavate_brick {
      input => input0;
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "excavate_brick";
     message = "Select excavate_brick control panel.";
     rowColumnBehavior = 1;
   };

   Controls.UIslider X  {
      parent => UIpanel;
      title = "X";
      value => excavate_brick.X;
      mode = 1;
      min => excavate_brick.X_min;
      max => excavate_brick.X_max;
   };

   Controls.UIslider Y  {
      parent => UIpanel;
      title = "Y";
      value => excavate_brick.Y;
      mode = 1;
      min => excavate_brick.Y_min;
      max => excavate_brick.Y_max;
   };

   Controls.UIslider Z  {
      parent => UIpanel;
      title = "Z";
      value => excavate_brick.Z;
      mode = 1;
      min => excavate_brick.Z_min;
      max => excavate_brick.Z_max;
   };

   Controls.UItoggle Flip_X  {
      parent => UIpanel;
      label = "Flip_X";
      set => excavate_brick.Flip_X;
   };

   Controls.UItoggle Flip_Y  {
      parent => UIpanel;
      label = "Flip_Y";
      set => excavate_brick.Flip_Y;
   };

   Controls.UItoggle Flip_Z  {
      parent => UIpanel;
      label = "Flip_Z";
      set => excavate_brick.Flip_Z;
   };

   Controls.UItoggle Draw_Sides  {
      parent => UIpanel;
      label = "Draw_Sides";
      set => excavate_brick.Draw_Sides;
   };

   olink output0=>excavate_brick.output;
};         // end of ACU_excavate_brick definition

//
// ACU_field_to_mesh
//
macro ACU_field_to_mesh {
   ilink input0;
   ilink input1;

   Mappers.field_to_mesh field_to_mesh {
      Field_Input => input0;
      Input_Colormap => input1;
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "field_to_mesh";
     message = "Select field_to_mesh control panel.";
     rowColumnBehavior = 1;
   };

   UIsliderUnbnd Z_scale  {
      UIparent => UIpanel;
      stitle = "Z_scale";
      sval => field_to_mesh.Z_scale;
      smin => field_to_mesh.Z_scale_min;
      smax => field_to_mesh.Z_scale_max;
   };

   Controls.UItoggle Normalize  {
      parent => UIpanel;
      label = "Normalize";
      set => field_to_mesh.Normalize;
   };

   olink output0=>field_to_mesh.geometry;
};         // end of ACU_field_to_mesh definition

//
// ACU_orthogonal_slicer
//
macro ACU_orthogonal_slicer {
   ilink input0;

   Mappers.orthogonal_slicer orthogonal_slicer {
      ortho_slice_input => input0;
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "orthogonal_slicer";
     message = "Select orthogonal_slicer control panel.";
     rowColumnBehavior = 1;
   };

   Controls.UIslider slice_plane  {
      parent => UIpanel;
      title = "slice_plane";
      value => orthogonal_slicer.slice_plane;
      mode = 1;
      min => orthogonal_slicer.slice_plane_min;
      max => orthogonal_slicer.slice_plane_max;
   };

   UIoption I {
      label="I";
   };

   UIoption J {
      label="J";
   };

   UIoption K {
      label="K";
   };

   Controls.UIradioBox axis  {
      parent => UIpanel;
      label = "axis";
      cmdList => {I, J, K};
      selectedItem => orthogonal_slicer.axis;
   };

   olink output0=>orthogonal_slicer.Image_Output;
};         // end of ACU_orthogonal_slicer definition

//
// ACU_ucd_anno
//
macro ACU_ucd_anno {
   ilink input0;
   ilink input1;

   Mappers.ucd_anno ucd_anno {
      Input => input0;
      upstream_geom => input1;
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "ucd_anno";
     message = "Select ucd_anno control panel.";
     rowColumnBehavior = 1;
   };

   Controls.UItoggle Node_Data  {
      parent => UIpanel;
      label = "Node_Data";
      set => ucd_anno.Node_Data;
   };

   UIoption _data_1_ {
      label="<data 1>";
   };

   UIoption _data_2_ {
      label="<data 2>";
   };

   UIoption _data_3_ {
      label="<data 3>";
   };

   UIoption _data_4_ {
      label="<data 4>";
   };

   UIoption _data_5_ {
      label="<data 5>";
   };

   Controls.UIradioBox node_data  {
      parent => UIpanel;
      label = "node_data";
      cmdList => {_data_1_, _data_2_, _data_3_, _data_4_, _data_5_};
      selectedItem => ucd_anno.node_data;
   };

   Controls.UItoggle Cell_Data  {
      parent => UIpanel;
      label = "Cell_Data";
      set => ucd_anno.Cell_Data;
   };

   UIoption _data_1_ {
      label="<data 1>";
   };

   UIoption _data_2_ {
      label="<data 2>";
   };

   UIoption _data_3_ {
      label="<data 3>";
   };

   UIoption _data_4_ {
      label="<data 4>";
   };

   UIoption _data_5_ {
      label="<data 5>";
   };

   Controls.UIradioBox cell_data  {
      parent => UIpanel;
      label = "cell_data";
      cmdList => {_data_1_, _data_2_, _data_3_, _data_4_, _data_5_};
      selectedItem => ucd_anno.cell_data;
   };

   Controls.UIlabel Label_Options  {
      parent => UIpanel;
      label => ucd_anno.Label_Options;
   };

   Controls.UItoggle label_id  {
      parent => UIpanel;
      label = "label_id";
      set => ucd_anno.label_id;
   };

   Controls.UItoggle label_value  {
      parent => UIpanel;
      label = "label_value";
      set => ucd_anno.label_value;
   };

   Controls.UItoggle cell_nodes  {
      parent => UIpanel;
      label = "cell_nodes";
      set => ucd_anno.cell_nodes;
   };

   Controls.UItoggle title  {
      parent => UIpanel;
      label = "title";
      set => ucd_anno.title;
   };

   Controls.UIslider Text_Size  {
      parent => UIpanel;
      title = "Text_Size";
      value => ucd_anno.Text_Size;
      mode = 1;
      min => ucd_anno.Text_Size_min;
      max => ucd_anno.Text_Size_max;
   };

   Controls.UIslider Text_Offset  {
      parent => UIpanel;
      title = "Text_Offset";
      value => ucd_anno.Text_Offset;
      min => ucd_anno.Text_Offset_min;
      max => ucd_anno.Text_Offset_max;
   };

   olink output0=>ucd_anno.Output;
};         // end of ACU_ucd_anno definition

//
// ACU_ucd_contour
//
macro ACU_ucd_contour {
   ilink input0;
   ilink input1;

   Mappers.ucd_contour ucd_contour {
      Input => input0;
      Input_Colormap => input1;
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "ucd_contour";
     message = "Select ucd_contour control panel.";
     rowColumnBehavior = 1;
   };

   Controls.UIlabel Node_Data  {
      parent => UIpanel;
      label => ucd_contour.Node_Data;
   };

   UIoption _data_1_ {
      label="<data 1>";
   };

   UIoption _data_2_ {
      label="<data 2>";
   };

   UIoption _data_3_ {
      label="<data 3>";
   };

   UIoption _data_4_ {
      label="<data 4>";
   };

   UIoption _data_5_ {
      label="<data 5>";
   };

   Controls.UIradioBox node_data  {
      parent => UIpanel;
      label = "node_data";
      cmdList => {_data_1_, _data_2_, _data_3_, _data_4_, _data_5_};
      selectedItem => ucd_contour.node_data;
   };

   olink output0=>ucd_contour.Output;
};         // end of ACU_ucd_contour definition

//
// ACU_ucd_hog
//
macro ACU_ucd_hog {
   ilink input0;
   ilink input1;
   ilink input2;

   Mappers.ucd_hog ucd_hog {
      Input => input0;
      Input_Colormap => input1;
      Transform_Info => input2;
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "ucd_hog";
     message = "Select ucd_hog control panel.";
     rowColumnBehavior = 1;
   };

   Controls.UIlabel Node_Data  {
      parent => UIpanel;
      label => ucd_hog.Node_Data;
   };

   UIoption _data_1_ {
      label="<data 1>";
   };

   UIoption _data_2_ {
      label="<data 2>";
   };

   UIoption _data_3_ {
      label="<data 3>";
   };

   UIoption _data_4_ {
      label="<data 4>";
   };

   UIoption _data_5_ {
      label="<data 5>";
   };

   Controls.UIradioBox node_data  {
      parent => UIpanel;
      label = "node_data";
      cmdList => {_data_1_, _data_2_, _data_3_, _data_4_, _data_5_};
      selectedItem => ucd_hog.node_data;
   };

   UIsliderUnbnd Scale  {
      UIparent => UIpanel;
      stitle = "Scale";
      sval => ucd_hog.Scale;
      smin => ucd_hog.Scale_min;
      smax => ucd_hog.Scale_max;
   };

   Controls.UItoggle Arrows  {
      parent => UIpanel;
      label = "Arrows";
      set => ucd_hog.Arrows;
   };

   Controls.UIslider N_Segment  {
      parent => UIpanel;
      title = "N_Segment";
      value => ucd_hog.N_Segment;
      mode = 1;
      min => ucd_hog.N_Segment_min;
      max => ucd_hog.N_Segment_max;
   };

   UIoption point {
      label="point";
   };

   UIoption line {
      label="line";
   };

   UIoption circle {
      label="circle";
   };

   UIoption plane {
      label="plane";
   };

   UIoption space {
      label="space";
   };

   UIoption nodes {
      label="nodes";
   };

   Controls.UIradioBox choice  {
      parent => UIpanel;
      label = "choice";
      cmdList => {point, line, circle, plane, space, nodes};
      selectedItem => ucd_hog.choice;
   };

   Controls.UItoggle Normalize_Vectors  {
      parent => UIpanel;
      label = "Normalize_Vectors";
      set => ucd_hog.Normalize_Vectors;
   };

   olink output0=>ucd_hog.Output;
};         // end of ACU_ucd_hog definition

//
// ACU_ucd_iso
//
macro ACU_ucd_iso {
   ilink input0;
   ilink input1;
   ilink input2;

   Mappers.ucd_iso ucd_iso {
      Input => input0;
      Input_Colormap => input1;
      Info => input2;
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "ucd_iso";
     message = "Select ucd_iso control panel.";
     rowColumnBehavior = 1;
   };

   Controls.UIlabel Node_Data  {
      parent => UIpanel;
      label => ucd_iso.Node_Data;
   };

   UIoption _data_1_ {
      label="<data 1>";
   };

   UIoption _data_2_ {
      label="<data 2>";
   };

   UIoption _data_3_ {
      label="<data 3>";
   };

   UIoption _data_4_ {
      label="<data 4>";
   };

   UIoption _data_5_ {
      label="<data 5>";
   };

   Controls.UIradioBox node_data  {
      parent => UIpanel;
      label = "node_data";
      cmdList => {_data_1_, _data_2_, _data_3_, _data_4_, _data_5_};
      selectedItem => ucd_iso.node_data;
   };

   Controls.UIslider Level  {
      parent => UIpanel;
      title = "Level";
      value => ucd_iso.Level;
      min => ucd_iso.Level_min;
      max => ucd_iso.Level_max;
   };

   Controls.UItoggle Map_Scalar  {
      parent => UIpanel;
      label = "Map_Scalar";
      set => ucd_iso.Map_Scalar;
   };

   UIoption _data_1_ {
      label="<data 1>";
   };

   UIoption _data_2_ {
      label="<data 2>";
   };

   UIoption _data_3_ {
      label="<data 3>";
   };

   UIoption _data_4_ {
      label="<data 4>";
   };

   UIoption _data_5_ {
      label="<data 5>";
   };

   Controls.UIradioBox map_data  {
      parent => UIpanel;
      label = "map_data";
      cmdList => {_data_1_, _data_2_, _data_3_, _data_4_, _data_5_};
      selectedItem => ucd_iso.map_data;
   };

   olink output0=>ucd_iso.Output;
};         // end of ACU_ucd_iso definition

//
// ACU_ucd_probe
//
macro ACU_ucd_probe {
   ilink input0;
   ilink input1;
   ilink input2;
   ilink input3;

   Mappers.ucd_probe ucd_probe {
      Input => input0;
      Input_Colors => input1;
      upstream_geom => input2;
      Transform_Info => input3;
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "ucd_probe";
     message = "Select ucd_probe control panel.";
     rowColumnBehavior = 1;
   };

   Controls.UIfield x  {
      parent => UIpanel;
      value => ucd_probe.x;
   };

   Controls.UIfield y  {
      parent => UIpanel;
      value => ucd_probe.y;
   };

   Controls.UIfield z  {
      parent => UIpanel;
      value => ucd_probe.z;
   };

   Controls.UIlabel Probe_Type  {
      parent => UIpanel;
      label => ucd_probe.Probe_Type;
   };

   UIoption Cursor {
      label="Cursor";
   };

   UIoption Crosshair {
      label="Crosshair";
   };

   UIoption Probe {
      label="Probe";
   };

   Controls.UIradioBox type  {
      parent => UIpanel;
      label = "type";
      cmdList => {Cursor, Crosshair, Probe};
      selectedItem => ucd_probe.type;
   };

   Controls.UItoggle Pick_Geometry  {
      parent => UIpanel;
      label = "Pick_Geometry";
      set => ucd_probe.Pick_Geometry;
   };

   Controls.UIlabel Label_Options  {
      parent => UIpanel;
      label => ucd_probe.Label_Options;
   };

   Controls.UItoggle label_nodes  {
      parent => UIpanel;
      label = "label_nodes";
      set => ucd_probe.label_nodes;
   };

   Controls.UItoggle label_id  {
      parent => UIpanel;
      label = "label_id";
      set => ucd_probe.label_id;
   };

   Controls.UItoggle label_value  {
      parent => UIpanel;
      label = "label_value";
      set => ucd_probe.label_value;
   };

   Controls.UItoggle label_cell  {
      parent => UIpanel;
      label = "label_cell";
      set => ucd_probe.label_cell;
   };

   Controls.UIslider Text_Size  {
      parent => UIpanel;
      title = "Text_Size";
      value => ucd_probe.Text_Size;
      mode = 1;
      min => ucd_probe.Text_Size_min;
      max => ucd_probe.Text_Size_max;
   };

   Controls.UIslider Text_Offset  {
      parent => UIpanel;
      title = "Text_Offset";
      value => ucd_probe.Text_Offset;
      min => ucd_probe.Text_Offset_min;
      max => ucd_probe.Text_Offset_max;
   };

   Controls.UIlabel Node_Data  {
      parent => UIpanel;
      label => ucd_probe.Node_Data;
   };

   UIoption _data_1_ {
      label="<data 1>";
   };

   UIoption _data_2_ {
      label="<data 2>";
   };

   UIoption _data_3_ {
      label="<data 3>";
   };

   UIoption _data_4_ {
      label="<data 4>";
   };

   UIoption _data_5_ {
      label="<data 5>";
   };

   Controls.UIradioBox node_data  {
      parent => UIpanel;
      label = "node_data";
      cmdList => {_data_1_, _data_2_, _data_3_, _data_4_, _data_5_};
      selectedItem => ucd_probe.node_data;
   };

   olink output0=>ucd_probe.Output;
};         // end of ACU_ucd_probe definition

//
// ACU_ucd_streamline
//
macro ACU_ucd_streamline {
   ilink input0;
   ilink input1;
   ilink input2;
   ilink input3;

   Mappers.ucd_streamline ucd_streamline {
      Input => input0;
      Input_Colormap => input1;
      Probe => input2;
      Transform_Info => input3;
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "ucd_streamline";
     message = "Select ucd_streamline control panel.";
     rowColumnBehavior = 1;
   };

   Controls.UIlabel Node_Data  {
      parent => UIpanel;
      label => ucd_streamline.Node_Data;
   };

   UIoption _data_1_ {
      label="<data 1>";
   };

   UIoption _data_2_ {
      label="<data 2>";
   };

   UIoption _data_3_ {
      label="<data 3>";
   };

   UIoption _data_4_ {
      label="<data 4>";
   };

   UIoption _data_5_ {
      label="<data 5>";
   };

   Controls.UIradioBox node_data  {
      parent => UIpanel;
      label = "node_data";
      cmdList => {_data_1_, _data_2_, _data_3_, _data_4_, _data_5_};
      selectedItem => ucd_streamline.node_data;
   };

   Controls.UIslider N_Segment  {
      parent => UIpanel;
      title = "N_Segment";
      value => ucd_streamline.N_Segment;
      mode = 1;
      min => ucd_streamline.N_Segment_min;
      max => ucd_streamline.N_Segment_max;
   };

   UIoption point {
      label="point";
   };

   UIoption line {
      label="line";
   };

   UIoption circle {
      label="circle";
   };

   UIoption plane {
      label="plane";
   };

   Controls.UIradioBox choice  {
      parent => UIpanel;
      label = "choice";
      cmdList => {point, line, circle, plane};
      selectedItem => ucd_streamline.choice;
   };

   Controls.UIslider N_Steps  {
      parent => UIpanel;
      title = "N_Steps";
      value => ucd_streamline.N_Steps;
      mode = 1;
      min => ucd_streamline.N_Steps_min;
      max => ucd_streamline.N_Steps_max;
   };

   Controls.UIlabel Integration  {
      parent => UIpanel;
      label => ucd_streamline.Integration;
   };

   UIoption _1st_Order {
      label="1st Order";
   };

   UIoption _2nd_Order {
      label="2nd Order";
   };

   UIoption _3rd_Order {
      label="3rd Order";
   };

   Controls.UIradioBox integ_method  {
      parent => UIpanel;
      label = "integ_method";
      cmdList => {_1st_Order, _2nd_Order, _3rd_Order};
      selectedItem => ucd_streamline.integ_method;
   };

   Controls.UItoggle Ribbons  {
      parent => UIpanel;
      label = "Ribbons";
      set => ucd_streamline.Ribbons;
   };

   UIsliderUnbnd Ribbon_Width  {
      UIparent => UIpanel;
      stitle = "Ribbon_Width";
      sval => ucd_streamline.Ribbon_Width;
      smin => ucd_streamline.Ribbon_Width_min;
      smax => ucd_streamline.Ribbon_Width_max;
   };

   UIsliderUnbnd Ribbon_Angle  {
      UIparent => UIpanel;
      stitle = "Ribbon_Angle";
      sval => ucd_streamline.Ribbon_Angle;
      smin => ucd_streamline.Ribbon_Angle_min;
      smax => ucd_streamline.Ribbon_Angle_max;
   };

   Controls.UItoggle Backward  {
      parent => UIpanel;
      label = "Backward";
      set => ucd_streamline.Backward;
   };

   Controls.UItoggle Color_Streams  {
      parent => UIpanel;
      label = "Color_Streams";
      set => ucd_streamline.Color_Streams;
   };

   Controls.UItoggle Show_Bounds  {
      parent => UIpanel;
      label = "Show_Bounds";
      set => ucd_streamline.Show_Bounds;
   };

   Controls.UIlabel Interaction_Mode  {
      parent => UIpanel;
      label => ucd_streamline.Interaction_Mode;
   };

   UIoption Immediate {
      label="Immediate";
   };

   UIoption Wait {
      label="Wait";
   };

   UIoption Button_Up {
      label="Button Up";
   };

   Controls.UIradioBox inter_mode  {
      parent => UIpanel;
      label = "inter_mode";
      cmdList => {Immediate, Wait, Button_Up};
      selectedItem => ucd_streamline.inter_mode;
   };

   Controls.UItoggle Start_Streams  {
      parent => UIpanel;
      label = "Start_Streams";
      set => ucd_streamline.Start_Streams;
   };

   olink output0=>ucd_streamline.Output;

   olink output1=>ucd_streamline.Upstream_Transform;
};         // end of ACU_ucd_streamline definition

//
// ACU_ucd_to_geom
//
macro ACU_ucd_to_geom {
   ilink input0;
   ilink input1;
   ilink input2;

   Mappers.ucd_to_geom ucd_to_geom {
      Input => input0;
      Input_Contour => input1;
      Cell_Colors => input2;
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "ucd_to_geom";
     message = "Select ucd_to_geom control panel.";
     rowColumnBehavior = 1;
   };

   Controls.UItoggle Shrink  {
      parent => UIpanel;
      label = "Shrink";
      set => ucd_to_geom.Shrink;
   };

   Controls.UIslider Shrink_Factor  {
      parent => UIpanel;
      title = "Shrink_Factor";
      value => ucd_to_geom.Shrink_Factor;
      mode = 1;
      min => ucd_to_geom.Shrink_Factor_min;
      max => ucd_to_geom.Shrink_Factor_max;
   };

   Controls.UIlabel Geometry_Display_Mode  {
      parent => UIpanel;
      label => ucd_to_geom.Geometry_Display_Mode;
   };

   UIoption External_Faces {
      label="External Faces";
   };

   UIoption External_Edges {
      label="External Edges";
   };

   UIoption All_Faces {
      label="All Faces";
   };

   Controls.UIradioBox mode  {
      parent => UIpanel;
      label = "mode";
      cmdList => {External_Faces, External_Edges, All_Faces};
      selectedItem => ucd_to_geom.mode;
   };

   Controls.UItoggle Explode_Materials  {
      parent => UIpanel;
      label = "Explode_Materials";
      set => ucd_to_geom.Explode_Materials;
   };

   Controls.UIslider Explode_Factor  {
      parent => UIpanel;
      title = "Explode_Factor";
      value => ucd_to_geom.Explode_Factor;
      mode = 1;
      min => ucd_to_geom.Explode_Factor_min;
      max => ucd_to_geom.Explode_Factor_max;
   };

   Controls.UItoggle Save_Geometry  {
      parent => UIpanel;
      label = "Save_Geometry";
      set => ucd_to_geom.Save_Geometry;
   };

   Controls.UItoggle Color_Cells  {
      parent => UIpanel;
      label = "Color_Cells";
      set => ucd_to_geom.Color_Cells;
   };

   olink output0=>ucd_to_geom.Output;
};         // end of ACU_ucd_to_geom definition

//
// ACU_volume_bounds
//
macro ACU_volume_bounds {
   ilink input0;

   Mappers.volume_bounds volume_bounds {
      Field_Input => input0;
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "volume_bounds";
     message = "Select volume_bounds control panel.";
     rowColumnBehavior = 1;
   };

   Controls.UItoggle Hull  {
      parent => UIpanel;
      label = "Hull";
      set => volume_bounds.Hull;
   };

   Controls.UItoggle Min_I  {
      parent => UIpanel;
      label = "Min_I";
      set => volume_bounds.Min_I;
   };

   Controls.UItoggle Max_I  {
      parent => UIpanel;
      label = "Max_I";
      set => volume_bounds.Max_I;
   };

   Controls.UItoggle Min_J  {
      parent => UIpanel;
      label = "Min_J";
      set => volume_bounds.Min_J;
   };

   Controls.UItoggle Max_J  {
      parent => UIpanel;
      label = "Max_J";
      set => volume_bounds.Max_J;
   };

   Controls.UItoggle Min_K  {
      parent => UIpanel;
      label = "Min_K";
      set => volume_bounds.Min_K;
   };

   Controls.UItoggle Max_K  {
      parent => UIpanel;
      label = "Max_K";
      set => volume_bounds.Max_K;
   };

   Controls.UItoggle Colored_Bounds  {
      parent => UIpanel;
      label = "Colored_Bounds";
      set => volume_bounds.Colored_Bounds;
   };

   olink output0=>volume_bounds.geometry;
};         // end of ACU_volume_bounds definition


};
library+buffered ACU_Data_Output {

//
// ACU_image_to_cgm
//
macro ACU_image_to_cgm {
   ilink input0;

   Data_Output.image_to_cgm image_to_cgm {
      AVS_Image => input0;
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "image_to_cgm";
     message = "Select image_to_cgm control panel.";
     rowColumnBehavior = 1;
   };

   Dialogs.UIfileSB CGM_File_Name  {
      parent => UIpanel;
      visible => UIpanel.visible;
      title = "CGM_File_Name";
      &filename => image_to_cgm.CGM_File_Name;
   };

   UIoption Binary {
      label="Binary";
   };

   UIoption Character {
      label="Character";
   };

   UIoption Clear_Text {
      label="Clear Text";
   };

   Controls.UIradioBox Encoding  {
      parent => UIpanel;
      label = "Encoding";
      cmdList => {Binary, Character, Clear_Text};
      selectedItem => image_to_cgm.Encoding;
   };

   Controls.UItoggle Landscape  {
      parent => UIpanel;
      label = "Landscape";
      set => image_to_cgm.Landscape;
   };

   Controls.UIfield Page_Width  {
      parent => UIpanel;
      value => image_to_cgm.Page_Width;
     min => image_to_cgm.Page_Width_min;
   };

   Controls.UIfield Page_Height  {
      parent => UIpanel;
      value => image_to_cgm.Page_Height;
     min => image_to_cgm.Page_Height_min;
   };

   Controls.UIslider Image_Width  {
      parent => UIpanel;
      title = "Image_Width";
      value => image_to_cgm.Image_Width;
      min => image_to_cgm.Image_Width_min;
      max => image_to_cgm.Image_Width_max;
   };

   Controls.UIslider Image_Height  {
      parent => UIpanel;
      title = "Image_Height";
      value => image_to_cgm.Image_Height;
      min => image_to_cgm.Image_Height_min;
      max => image_to_cgm.Image_Height_max;
   };

   Controls.UItoggle Preserve_Aspect_Ratio  {
      parent => UIpanel;
      label = "Preserve_Aspect_Ratio";
      set => image_to_cgm.Preserve_Aspect_Ratio;
   };
};         // end of ACU_image_to_cgm definition

//
// ACU_ucd_vol_integral
//
macro ACU_ucd_vol_integral {
   ilink input0;

   Data_Output.ucd_vol_integral ucd_vol_integral {
      Input => input0;
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "ucd_vol_integral";
     message = "Select ucd_vol_integral control panel.";
     rowColumnBehavior = 1;
   };

   Controls.UIlabel Node_Data  {
      parent => UIpanel;
      label => ucd_vol_integral.Node_Data;
   };

   UIoption _data_1_ {
      label="<data 1>";
   };

   UIoption _data_2_ {
      label="<data 2>";
   };

   UIoption _data_3_ {
      label="<data 3>";
   };

   UIoption _data_4_ {
      label="<data 4>";
   };

   UIoption _data_5_ {
      label="<data 5>";
   };

   Controls.UIradioBox node_data  {
      parent => UIpanel;
      label = "node_data";
      cmdList => {_data_1_, _data_2_, _data_3_, _data_4_, _data_5_};
      selectedItem => ucd_vol_integral.node_data;
   };
};         // end of ACU_ucd_vol_integral definition

//
// ACU_write_field
//
macro ACU_write_field {
   ilink input0;

   Data_Output.write_field write_field {
      Field_Input => input0;
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "write_field";
     message = "Select write_field control panel.";
     rowColumnBehavior = 1;
   };

   Dialogs.UIfileSB Write_Field_Browser  {
      parent => UIpanel;
      visible => UIpanel.visible;
      title = "Write_Field_Browser";
      &filename => write_field.Write_Field_Browser;
   };

   UIoption Native {
      label="Native";
   };

   UIoption Portable__XDR_ {
      label="Portable (XDR)";
   };

   Controls.UIradioBox Data_Format  {
      parent => UIpanel;
      label = "Data_Format";
      cmdList => {Native, Portable__XDR_};
      selectedItem => write_field.Data_Format;
   };

   Controls.UItoggle Compute_Extents  {
      parent => UIpanel;
      label = "Compute_Extents";
      set => write_field.Compute_Extents;
   };

   Controls.UItoggle Compute_Min_Max  {
      parent => UIpanel;
      label = "Compute_Min_Max";
      set => write_field.Compute_Min_Max;
   };
};         // end of ACU_write_field definition

 
//
// ACU_write_image
//
macro ACU_write_image {
   ilink input0;

   Data_Output.write_image write_image {
      Image_Input => input0;
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "write_image";
     message = "Select write_image control panel.";
     rowColumnBehavior = 1;
   };

   Dialogs.UIfileSB Write_Image_Browser  {
      parent => UIpanel;
      visible => UIpanel.visible;
      title = "Write_Image_Browser";
      &filename => write_image.Write_Image_Browser;
   };
};         // end of ACU_write_image definition


//
// ACU_write_ucd
//
macro ACU_write_ucd {
   ilink input0;

   Data_Output.write_ucd write_ucd {
      Input => input0;
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "write_ucd";
     message = "Select write_ucd control panel.";
     rowColumnBehavior = 1;
   };

   Dialogs.UIfileSB file_name  {
      parent => UIpanel;
      visible => UIpanel.visible;
      title = "file_name";
      &filename => write_ucd.file_name;
   };

   Controls.UIlabel File_Format  {
      parent => UIpanel;
      label => write_ucd.File_Format;
   };

   UIoption Binary {
      label="Binary";
   };

   UIoption ASCII {
      label="ASCII";
   };

   Controls.UIradioBox file  {
      parent => UIpanel;
      label = "file";
      cmdList => {Binary, ASCII};
      selectedItem => write_ucd.file;
   };
};         // end of ACU_write_ucd definition

//
// ACU_write_volume
//
macro ACU_write_volume {
   ilink input0;

   Data_Output.write_volume write_volume {
      Scalar_Data_Input => input0;
   };

   UImod_panel UIpanel {
     parent<NEportLevels={3,0}>;
     title = "write_volume";
     message = "Select write_volume control panel.";
     rowColumnBehavior = 1;
   };

   Dialogs.UIfileSB Write_Volume_Browser  {
      parent => UIpanel;
      visible => UIpanel.visible;
      title = "Write_Volume_Browser";
      &filename => write_volume.Write_Volume_Browser;
   };
};         // end of ACU_write_volume definition


};
