//
// Set Configure
//
#define MAVS_CFG_FILE	MAVS_XP_PATH+"/runtime/MicroAVS/config.v"
GMOD.instancer SetConfigureInstancer {
   Value => <-.params.config;
   Group => <-.SetConfigure;
};
macro SetConfigure<instanced=0> {
   ilink params => <-.params;
   
   MAUIokCancelDialog ConfigDialog {
      title => "MACFG_TITLE";
      parent => <-.params.parent;
      visible = 0;
      width = 475;
      height = 363;
   };
   MAUIresetHelpButtons resetHelpButtons {
      parent => <-.ConfigDialog;
      y = 0;
      width => <-.ConfigDialog.clientWidth;
   };
   MAUIlabel initDirLabel {
      parent => <-.ConfigDialog;
      label = "MACFG_INIT_DIR_TITLE";
      x = 0;
      y => <-.resetHelpButtons.y + <-.resetHelpButtons.height + 5;
      width => <-.ConfigDialog.clientWidth;
      height = 32;
      alignment = "center";
      fontAttributes.height = 20;
   };
   MAUIDirectorySelector readDir {
      title => "MACFG_READ_DATA_TITLE";
      parent => <-.ConfigDialog;
      x = 5;
      y => <-.initDirLabel.y + <-.initDirLabel.height;
   };
   MAUIDirectorySelector writeDir {
      title => "MACFG_WRITE_DATA_TITLE";
      parent => <-.ConfigDialog;
      x => <-.readDir.x;
      y => <-.readDir.y + <-.readDir.height+ 3;
   };
   MAUIDirectorySelector loadDir {
      title => "MACFG_LOAD_APPL_TITLE";
      parent => <-.ConfigDialog;
      x => <-.readDir.x + <-.readDir.width + 17;
      y => <-.readDir.y;
   };
   MAUIDirectorySelector saveDir {
      title => "MACFG_SAVE_APPL_TITLE";
      parent => <-.ConfigDialog;
      x => <-.loadDir.x;
      y => <-.writeDir.y;
   };
   string header[] => {
      "// MicroAVS 3.0 Configuration File",
      "//"
   };
   GMOD.parse_v setup_config_dialog {
      on_inst = 1;
      active => <-.params.config;
      trigger => .active;
      v_commands => "$push\n"
+ "readDir.directory=Templates.MicroAVS.CONFIG.read_data_init_directory;\n"
+ "writeDir.directory=Templates.MicroAVS.CONFIG.write_data_init_directory;\n"
+ "loadDir.directory=Templates.MicroAVS.CONFIG.load_appl_init_directory;\n"
+ "saveDir.directory=Templates.MicroAVS.CONFIG.save_appl_init_directory;\n"
+ "ConfigDialog.visible=>params.config;"
+"$pop\n";
      relative => <-.<-;
   };
   GMOD.parse_v reset_config {
      on_inst = 0;
      active => <-.resetHelpButtons.reset;
      trigger => .active;
      v_commands => "$push\n"
+ "readDir.directory=Templates.MicroAVS.CONFIG.read_data_def_directory;\n"
+ "writeDir.directory=Templates.MicroAVS.CONFIG.write_data_def_directory;\n"
+ "loadDir.directory=Templates.MicroAVS.CONFIG.load_appl_def_directory;\n"
+ "saveDir.directory=Templates.MicroAVS.CONFIG.save_appl_def_directory;\n"
+"$pop\n";
      relative => <-.<-;
   };
   MAmime HelpViewer {
      trigger => <-.resetHelpButtons.help;
      stFilename => MAVS_HELP_PATH+"/main/config.htm";
   };
   MicroAVS.CONFIG config;
   GMOD.parse_v save_config {
      on_inst = 0;
      trigger => <-.ConfigDialog.ok;
      v_commands = "$push\n"
                  + "config.read_data_init_directory=readDir.directory;"
                  + "config.write_data_init_directory=writeDir.directory;"
                  + "config.load_appl_init_directory=loadDir.directory;"
                  + "config.save_appl_init_directory=saveDir.directory;\n"
                  + "$get_str_array header >"                +MAVS_CFG_FILE+"\n"
                  + "$print config.read_data_init_directory >>" +MAVS_CFG_FILE+"\n"
                  + "$print config.write_data_init_directory >>"+MAVS_CFG_FILE+"\n"
                  + "$print config.load_appl_init_directory >>" +MAVS_CFG_FILE+"\n"
                  + "$print config.save_appl_init_directory >>" +MAVS_CFG_FILE+"\n"
                  +"$pop\n"
                  +"$push\n"
                  + "params.init_config=1;"
                  +"$pop\n";
      relative => <-.<-;
   };
};
GMOD.parse_v init_config {
   on_inst = 1;
   active => <-.params.init_config;
   trigger => .active;
   v_commands = "$include "+MAVS_CFG_FILE+"\n"
               +"$push\n"
               +"read_data_directory=read_data_init_directory;"
               +"write_data_directory=write_data_init_directory;"
               +"load_appl_directory=load_appl_init_directory;"
               +"save_appl_directory=save_appl_init_directory;"
               +"$pop\n";
   relative => Templates.MicroAVS.CONFIG;
};
#undef MAVS_CFG_FILE
