/*
	"$Id: //depot/express/fcs70/v/MicroAVS/Appl/helprw.v#1 $"
			Copyright (c) 1997 by
				KGT Inc.
			All Rights Reserved

	This software  comprises  unpublished confidential information of
	KGT Inc. and may not be used, copied or made  available to anyone,
	except in accordance with the license under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/MicroAVS/Appl/helprw.v#1 $
*/
//
// Help Readers/Writers
//
#ifdef MSDOS
GMOD.instancer HelpRWInstancer {
   Group => <-.HelpRW;
   Value => <-.params.help_rw;
};
macro HelpRW<instanced=0> {
   ilink params => <-.params;
   ilink+nres dataObj => <-.dataObj;

   UIshell shell {
      title = "MAMHELP_RW_TITLE";
      width = 500;
      height = 300;
      visible  => <-.params.help_rw;
      showStatusBar = 0;
   };
   macro ReaderList {
      ilink parent => <-.shell;
      link title = "MAMHELP_RW_READER_TITLE";
      link help_path = "read";
      string &suffix[]    => <-.dataObj.read_file_suffix;
      string &data_type[] => <-.dataObj.read_data_type;
      string &comments[]  => <-.dataObj.read_comment;
      string &help[]      => <-.dataObj.read_help;
      link y = 15;
   
      MAUIframe TitleFrame {
         parent => <-.parent;
         x = 0;
         y => <-.y;
         height = 40;
         width => (parent.clientWidth - 5);
      };
      MAUIlabel Title {
         parent => <-.TitleFrame;
         label => <-.title;
         x = 0;
         y = 3;
         width => (parent.clientWidth - 5);
         height = 35;
         color.foregroundColor = "green";
         fontAttributes.height = 25;
      };
      MAUIlabel+nosave ListLabel {
         parent => <-.parent;
         label = "MAMHELP_RW_LIST_LABEL";
         y => <-.TitleFrame.y + <-.TitleFrame.height + 5;
         height = 20;
         alignment = "left";
      };
      MAUIcomboBox A {
         parent => <-.parent;
         strings => <-.suffix;
         x = 5;
         y => <-.ListLabel.y + <-.ListLabel.height;
         width = 80;
         height = 30;
         fontAttributes.height = 18;
         numShowItems = 10;
         selectedItem = 0;
      };
      MAUIcomboBox B {
         parent => <-.parent;
         strings => <-.data_type;
         x => A.x + A.width;
         y => A.y;
         width = 80;
         height = 30;
         fontAttributes.height = 18;
         selectedItem => <-.A.selectedItem;
         numShowItems => <-.A.numShowItems;
      };
      MAUIcomboBox C {
         parent => <-.parent;
         x => B.x + B.width;
         y => A.y;
         strings => <-.comments;
         width => parent.clientWidth
                -(<-.A.width + <-.B.width + <-.Help.width + 10);
         height = 30;
         fontAttributes.height = 18;
         selectedItem => <-.A.selectedItem;
         numShowItems => <-.A.numShowItems;
      };
      MAUIhelpButton Help {
         parent => <-.parent;
         x => parent.clientWidth - .width - 5;
         y => A.y;
      };
      MAmime HelpViewer {
         trigger => <-.Help.do;
         stFilename => MAVS_HELP_PATH+"/"+help_path+"/"+<-.help[A.selectedItem];
      };
   };
   ReaderList WriterList {
      title = "MAMHELP_RW_WRITER_TITLE";
      help_path = "write";
      suffix    => concat_array(<-.dataObj.write_file_suffix,
                             { "PS", "WRL" }
                            );
      data_type => concat_array(<-.dataObj.write_data_type,
                             { "PS", "VRML" }
                            );
      comments  => concat_array(<-.dataObj.write_comment,
         { "Vector PostScript", "Virtual Reality Modeling Language" }
                            );
      help      => concat_array(<-.dataObj.write_help,
                             { "default.htm", "default.htm" }
                            );
      y = 130;
   };
   MAUIbutton Close {
      parent => <-.shell;
      x => .parent.clientWidth - .width - 10;
      y => .parent.clientHeight - .height - 10;
      width = 80;
      height = 20;
      label = "MAUI_CLOSE";
      do =;
   };
   GMOD.copy_on_change set_close {
      input => <-.Close.do * 0;
      output => <-.params.help_rw;
      on_inst = 0;
   };
};
#else
// Unix does NOT support comboBox.
#endif //MSDOS
