/*
	"$Id: //depot/express/fcs70/v/MicroAVS/DV/Cmap/changeUI.v#1 $"
			Copyright (c) 1997 by
				KGT Inc.
			All Rights Reserved

	This software  comprises  unpublished confidential information of
	KGT Inc. and may not be used, copied or made  available to anyone,
	except in accordance with the license under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/MicroAVS/DV/Cmap/changeUI.v#1 $
*/
macro+nosave MAchangeColorUI {
   ilink parent => <-.shell;
   MAcolmap_params_templ &colmap_params<NEportLevels={2,1}> => <-.colmap_params;
   GMOD.instancer UIinstancer {
      Value => <-.UI.vis;
      Group => <-.UI;
   };
   macro UI<instanced=0> {
      ilink colmap_params => <-.colmap_params;
      ilink parent => <-.parent;
      link vis => .colmap_params.vis;
      MAUIframe frame {
         visible => <-.vis;
         parent => <-.parent;
         x = 150;
#ifdef MSDOS
         y = 150;
#else
         y = 205; 
#endif //MSDOS
         width = 165;
         height = 120; 
      };
      MAUIbutton own_map_b {
         /*** v6.0 ***/
         active => <-.colmap_params.UI_active;
         /*** end v6.0 ***/
         parent => <-.frame;
         x = 5;
         y => mapbutton.y + mapbutton.height + 5;
         width => mapbutton.width; 
         label = "MACOLMAP_EDIT";
         do => <-.colmap_params.edit;
      };
      MAUIlabel color_type_label {
         parent => <-.frame;
         y = 5;
         width =><-.frame.width;
         label = "MACOLMAP_SELECT";
      };
      MAUIpanel mapbutton {
         parent => <-.frame;
         width = 149;
         height = 53;
         x = 5;
         y =>color_type_label.y + color_type_label.height + 5;
         pixmap.filename = MAVS_ICON_PATH + "mapall.x";
         pixmap.fileType = "avs_image";
      };
      UIonePoint pick_colormap {
         view => <-.mapbutton;
         runEvent = "<Btn1Down>";
      };
#ifdef OLD
      GMOD.copy_on_change set_colormap_index {
         input => (<-.pick_colormap.x - 4) / 18;
         output => <-.colmap_params.colormap_index;
         on_inst = 0;
      };
#else
      GMOD.parse_v set_colormap_index {
         relative => <-.colmap_params;
         //trigger => .idx;
         int idx => (<-.pick_colormap.x-4)/18;
         v_commands => "$push -usr\n"
                      +"colormap_index="+idx+";\n"
                      +"$pop\n";
         on_inst = 0;
      };
#endif
      macro edit_colormap {
         MAcolmap_params_templ+IPort2 &colmap_params => <-.colmap_params;
         GMOD.instancer UIinstancer {
            Value =><-.UI.vis;
            Group =><-.UI;
         }; 
         macro UI<instanced=0> {
            MAcolmap_params_templ+IPort2 &colmap_params => <-.colmap_params;
            link vis => .colmap_params.edit;
            MAUIsimpleDialog shell {
               visible => <-.vis;
               title = "MACOLMAP_EDIT_TITLE";
               width = 373;
#ifdef MSDOS
               height = 260;
#else
               height = 300;
#endif //MSDOS
            }; 
            MAUIframe max_frame {
               parent =><-.shell;
               x = 5;
               y = 5;
               width = 175;
#ifdef MSDOS
               height = 185;
#else
               height = 245;
#endif //MSDOS
            };
            MAUIlabel max_label {
               parent =><-.max_frame;
               x = 5;
               y = 5;
               width =><-.max_frame.width;
               label = "MACOLMAP_MAXCOL";
            };
            MAUIpanel max_colbutton {
               parent =><-.max_frame;
               x = 5;
               y =><-.max_label.y + <-.max_label.height + 5;
               width = 165;
               height = 22;
               pixmap.filename => MAVS_ICON_PATH + "mapcol.x";
               pixmap.fileType = "avs_image";
            };
            UIonePoint pick_max {
               view =><-.max_colbutton;
               runEvent = "<Btn1Down>";
            };
            GMOD.copy_on_change set_max_index {
               input => (<-.pick_max.x - 4) / 20;
               output => <-.colmap_params.max_index;
               on_inst = 0;
            };
            MAUIslider max_hue_slider {
               parent =><-.max_frame;
               y => <-.max_colbutton.y + <-.max_colbutton.height + 5;
               value =><-.colmap_params.max_h;
               x = 5;
               width = 120;
               min = 0;
               max = 1;
               decimalPoints = 2;
               immediateMode = 1;
               title = "MAUI_HUE";
            };
            max_hue_slider max_sat_slider {
               y => max_hue_slider.y + max_hue_slider.height + 2;
               value =><-.colmap_params.max_s;
               title = "MAUI_SAT";
            };
            max_hue_slider max_val_slider {
               y => max_sat_slider.y + max_sat_slider.height + 2;
               value =><-.colmap_params.max_v;
               title = "MAUI_VAL";
            };
            MAUIfield max_hue_field {
               parent =><-.max_frame;
               width = 40;
               height => max_hue_slider.height;
               min = 0;
               max = 1;
               decimalPoints = 2;
               mode = "real";
               immediateMode = 1;
               parent =><-.max_frame;
               x => max_hue_slider.x + max_hue_slider.width+2;
               y => max_hue_slider.y;
               value => max_hue_slider.value;
               visible => <-.vis;
            };
            max_hue_field max_sat_field {
               parent =><-.max_frame;
               x => max_sat_slider.x + max_sat_slider.width+2;
               y => max_sat_slider.y;
               value => max_sat_slider.value;
            };
            max_hue_field max_val_field {
               parent =><-.max_frame;
               x => max_val_slider.x + max_val_slider.width+2;
               y => max_val_slider.y;
               value => max_val_slider.value;
            };
            MAUIframe min_frame {
               parent =><-.shell;
               x => max_frame.x + max_frame.width + 5;
               y => max_frame.y;
               width = 175;
               height => <-.max_frame.height;
            };
            MAUIlabel min_label {
               parent =><-.min_frame;
               x = 5;
               y = 5;
               width =><-.min_frame.width;
               label = "MACOLMAP_MINCOL";
            };
            MAUIpanel min_colbutton {
               parent =><-.min_frame;
               x = 5;
               y =><-.min_label.y + <-.min_label.height + 5;
               width = 165;
               height = 22;
               pixmap.filename => MAVS_ICON_PATH + "mapcol.x";
               pixmap.fileType = "avs_image";
            };
            UIonePoint pick_min {
               view =><-.min_colbutton;
               runEvent = "<Btn1Down>";
            };
            GMOD.copy_on_change set_min_index {
               input => (<-.pick_min.x - 4) / 20;
               output => <-.colmap_params.min_index;
               on_inst = 0;
            };
            MAUIslider min_hue_slider {
               parent =><-.min_frame;
               x = 5;
               y => <-.min_colbutton.y + <-.min_colbutton.height + 5;
               width = 120;
               min = 0;
               max = 1;
               decimalPoints = 2;
               immediateMode = 1;
               title = "MAUI_HUE";
               float &value =><-.colmap_params.min_h;
            };
            min_hue_slider min_sat_slider {
               y => min_hue_slider.y + min_hue_slider.height + 2;
               title = "MAUI_SAT";
               float &value =><-.colmap_params.min_s;
            };
            min_hue_slider min_val_slider {
               y => min_sat_slider.y + min_sat_slider.height + 2;
               title = "MAUI_VAL";
               float &value =><-.colmap_params.min_v;
            };
            MAUIfield min_hue_field {
               parent =><-.min_frame;
               x => min_hue_slider.x + min_hue_slider.width + 2;
               y => min_hue_slider.y;
               width = 40;
               height => min_hue_slider.height;
               min = 0;
               max = 1;
               decimalPoints = 2;
               mode = "real";
               immediateMode = 1;
               &value => min_hue_slider.value;
               visible => <-.vis;
            };
            min_hue_field min_sat_field {
               y => min_sat_slider.y;
               float &value => min_sat_slider.value;
            };
            min_hue_field min_val_field {
               y => min_val_slider.y;
               float &value => min_val_slider.value;
            };
            MAUIbutton close_b {
               parent => <-.shell;
               x => shell.clientWidth/2 - width/2;
               y => min_frame.y + min_frame.height + 10;
               width = 60;
               label = "MAUI_CLOSE";
            };
            GMOD.copy_on_change set_close {
               trigger =><-.close_b.do;
               input = 0;
               output =><-.vis;
               on_inst = 0;
            };
         };
      };
   };
};
