/*
	"$Id: //depot/express/fcs70/v/MicroAVS/DV/Cmap/cmapP.v#1 $"
			Copyright (c) 1997 by
				KGT Inc.
			All Rights Reserved

	This software  comprises  unpublished confidential information of
	KGT Inc. and may not be used, copied or made  available to anyone,
	except in accordance with the license under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/MicroAVS/DV/Cmap/cmapP.v#1 $
*/
//
// Colormap Process
//
/*** v6.0 ***
   macro makedmap {
      Grid+Space2+Xform+Node_Data_Float PointMesh<NEportLevels={0,1}> {
          nnodes = 2;
             coordinates {
             values = {0.,0.,255.,1.};
          };
          int  ncell_sets = 1;
          Point  cell_set {
             ncells => <-.nnodes;
             node_connect_list => init_array(ncells, 0, ncells-1);
          };
          nnode_data = 1;
          node_data {
             veclen = 3;
             values = { 0,0,1, 1,0,0 };
             labels = "rgb";
          };
      };
      CMAP_EDTR.modMakeDmap modMakeDmap {
          map_field => <-.PointMesh;
          obj_in<NEportLevels={4,0}> => <-.<-.<-.obj_in;
          refresh => <-.modSaveLoadColorMap.regen;
          regen=> <-.modSaveLoadColorMap.regen;
      };
      CMAP_EDTR.modSaveLoadColorMap modSaveLoadColorMap {
         filename<NEportLevels={3,0}> => <-.<-.MAcolormapUI.MADVcmap_updata.filename;
         point_mesh => <-.PointMesh;
         load_trigger = 0;
      };
      GMOD.copy_on_change copy_on_change{
      input<NEportLevels={3,0}> => <-.<-.MAcolormapUI.MADVcmap_updata.load;
      output => <-.modSaveLoadColorMap.load_trigger;
      };
   };
*** end v6.0 ***/
   MAdefaultMinMax MinMax {
      input => <-.fld_in;
      min_value =;
      max_value =;
   };

// Reset
   GMOD.parse_v all_reset {
      trigger => <-.colmap_params.all_reset;
      active => .trigger;
      on_inst = 0;
      relative => <-.colmap_params;
      //parse_v_relative<weight=2>;
      v_commands =
                   "$push\nScheduler.percent_done=30;$pop\n"
                  +"$push -usr\n"
                  +switch(is_valid(colmap_params.def_curmin)+1,
                          "curmin=;", "curmin=def_curmin;")
                  +switch(is_valid(colmap_params.def_curmax)+1,
                          "curmax=;", "curmax=def_curmax;")
                  +switch(is_valid(colmap_params.def_min_col_val)+1,
                          "min_col_val=;", "min_col_val=def_min_col_val;")
                  +switch(is_valid(colmap_params.def_max_col_val)+1,
                          "max_col_val=;", "max_col_val=def_max_col_val;")
                  +"curmin_deci=2;"
                  +"curmax_deci=2;"
                  +"min_col_val_deci=2;"
                  +"max_col_val_deci=2;"
                  +"color_size=def_color_size;"
                  +"max_h=0;"
                  +"max_s=1;"
                  +"max_v=1;"
                  +"min_h=0.67;"
                  +"min_s=1;"
                  +"min_v=1;"
                  +"$pop\n"
                  +"$push\nScheduler.percent_done=80;$pop\n"
                  +"$push\n"
                  +"all_reset=0;"
                  +"$pop\n"
                  +"$push\nScheduler.percent_done=100;$pop\n"
                  ;
   };
   MAset_param set_curmin {
      trigger   => is_valid(MinMax.min_value)|!is_valid(<-.colmap_params.curmin);
      in_value  => <-.MinMax.min_value;
      def_value => <-.colmap_params.def_curmin;
      value     => <-.colmap_params.curmin;
   };
   MAset_param set_curmax {
      trigger   => is_valid(MinMax.max_value)|!is_valid(<-.colmap_params.curmax);
      in_value  => <-.MinMax.max_value;
      def_value => <-.colmap_params.def_curmax;
      value     => <-.colmap_params.curmax;
   };
   MAset_param set_min_col_val {
      trigger   => is_valid(MinMax.min_value)|!is_valid(<-.colmap_params.min_col_val);
      in_value  => <-.MinMax.min_value;
      def_value => <-.colmap_params.def_min_col_val;
      value     => <-.colmap_params.min_col_val;
   };
   MAset_param set_max_col_val {
      trigger   => is_valid(MinMax.max_value)|!is_valid(<-.colmap_params.max_col_val);
      in_value  => <-.MinMax.max_value;
      def_value => <-.colmap_params.def_max_col_val;
      value     => <-.colmap_params.max_col_val;
   };
//
   GMOD.parse_v set_just_fit {
      trigger => <-.colmap_params.fit;
      active => <-.colmap_params.fit;
      on_inst = 0;
      relative => <-.colmap_params;
      v_commands => "$push\nScheduler.percent_done=30;$pop\n"
                   +"$push -usr\n"
                   +switch(is_valid(colmap_params.def_curmin)+1,
                           "curmin=;", "curmin=def_curmin;")
                   +switch(is_valid(colmap_params.def_curmax)+1,
                           "curmax=;", "curmax=def_curmax;")
                   +switch(is_valid(colmap_params.def_min_col_val)+1,
                           "min_col_val=;", "min_col_val=def_min_col_val;")
                   +switch(is_valid(colmap_params.def_max_col_val)+1,
                           "max_col_val=;", "max_col_val=def_max_col_val;")
                   +"$pop\n"
                   +"$push\nScheduler.percent_done=80;$pop\n"
                   +"$push\n"
                   +"fit=0;"
                   +"$pop\n"
                   +"$push\nScheduler.percent_done=100;$pop\n"
                   ;
   };
// 
// change Colormap
//
   int max_color_index = 1; // 1:normal, 3: for Volume Rendering
/*** v6.0    
   DatamapValue+nres &min_color => .dmap.DatamapValue[0];
   DatamapValue+nres &max_color => .dmap.DatamapValue[max_color_index];
   GMOD.parse_v set_hsv {
      on_inst = 0;
      relative =><-;
      v_commands => "$push\nScheduler.percent_done=30;$pop\n"
                   +"$push -usr\n"
                   +"min_color.v2 ="+<-.colmap_params.min_h+";"
                   +"min_color.v3 ="+<-.colmap_params.min_s+";"
                   +"min_color.v4 ="+<-.colmap_params.min_v+";"
                   +"max_color.v2 ="+<-.colmap_params.max_h+";"
                   +"max_color.v3 ="+<-.colmap_params.max_s+";"
                   +"max_color.v4 ="+<-.colmap_params.max_v+";"
                   +"$pop\n"
                   +"$push\nScheduler.percent_done=100;$pop\n"
                   ;
   };
end v6.0 ***/
//
// Color Table Process
//
   string colormap_table[] = {
      "min_h=0.67;min_s=1.0;min_v=1.0;max_h=0.00;max_s=1.0;max_v=1.0;",
      "min_h=0.00;min_s=1.0;min_v=1.0;max_h=0.67;max_s=1.0;max_v=1.0;",
      "min_h=0.00;min_s=0.0;min_v=1.0;max_h=0.00;max_s=0.0;max_v=0.0;",
      "min_h=0.00;min_s=0.0;min_v=0.0;max_h=0.00;max_s=0.0;max_v=1.0;",
      "min_h=0.17;min_s=1.0;min_v=1.0;max_h=0.00;max_s=1.0;max_v=1.0;",
      "min_h=0.00;min_s=0.0;min_v=1.0;max_h=0.00;max_s=1.0;max_v=1.0;",
      "min_h=0.00;min_s=0.0;min_v=0.0;max_h=0.50;max_s=1.0;max_v=1.0;",
      "min_h=0.67;min_s=1.0;min_v=1.0;max_h=0.16;max_s=1.0;max_v=1.0;"
   };
   GMOD.parse_v set_colormap {
      relative => <-;
      on_inst = 1;
      v_commands => "$push\nScheduler.percent_done=30;$pop\n"
                   +"$push -usr\n"
                   +"colmap_params {"
                   +<-.colormap_table[colmap_params.colormap_index]
                   +"};"
                   +"$pop\n"
                   +"$push\nScheduler.percent_done=100;$pop\n"
                   ;
   };
   string maxmap_table[] = {
      "max_h=0.00;max_s=1.0;max_v=1.0;",	// red
      "max_h=0.33;max_s=1.0;max_v=1.0;",	// green
      "max_h=0.67;max_s=1.0;max_v=1.0;",	// blue
      "max_h=0.50;max_s=1.0;max_v=1.0;",	// cyan
      "max_h=0.83;max_s=1.0;max_v=1.0;",	// yellow
      "max_h=0.17;max_s=1.0;max_v=1.0;",	// magenta
      "max_h=0.00;max_s=0.0;max_v=1.0;",	// white
      "max_h=0.00;max_s=0.0;max_v=0.0;"		// black
   };
   GMOD.parse_v set_maxmap {
      relative =><-;
      on_inst = 0;
      v_commands => "$push\nScheduler.percent_done=30;$pop\n"
                   +"$push -usr\n"
                   +"colmap_params {"
                   +<-.maxmap_table[colmap_params.max_index]
                   +"};"
                   +"$pop\n"
                   +"$push\nScheduler.percent_done=100;$pop\n"
                   ;
   };
   string minmap_table[] = {
      "min_h=0.00;min_s=1.0;min_v=1.0;",	// red
      "min_h=0.33;min_s=1.0;min_v=1.0;",	// green
      "min_h=0.67;min_s=1.0;min_v=1.0;",	// blue
      "min_h=0.50;min_s=1.0;min_v=1.0;",	// cyan
      "min_h=0.83;min_s=1.0;min_v=1.0;",	// yellow
      "min_h=0.17;min_s=1.0;min_v=1.0;",	// magenta
      "min_h=0.00;min_s=0.0;min_v=1.0;",	// white
      "min_h=0.00;min_s=0.0;min_v=0.0;"		// black
   };
   GMOD.parse_v set_minmap {
      relative => <-;
      on_inst = 0;
      v_commands => "$push\nScheduler.percent_done=30;$pop\n"
                   +"$push -usr\n"
                   +"colmap_params {"
                   +<-.minmap_table[colmap_params.min_index]
                   +"};"
                   +"$pop\n"
                   +"$push\nScheduler.percent_done=100;$pop\n"
                   ;
   };
//
// Color Range
//
   GMOD.copy_on_change copy_size {
      input => <-.colmap_params.color_size;
      output =><-.dmap.ranges[0].size;
   };
   /*** v6.0 
   GMOD.copy_on_change copy_min_val {
      input => <-.colmap_params.min_col_val;
      output =><-.dmap.ranges[0].UIMinValue;
   };
   GMOD.copy_on_change copy_max_val {
      input => <-.colmap_params.max_col_val;
      output =><-.dmap.ranges[0].UIMaxValue;
   };
   GMOD.copy_on_change set_selectValues {
      trigger => <-.colmap_params.min_col_val
               ||<-.colmap_params.max_col_val;
      input = 1;
      output =><-.dmap.ranges[0].selectValues;
   };
   end v6.0 ***/
