/*
	"$Id: //depot/express/fcs70/v/MicroAVS/DV/Cmap/legendP.v#1 $"
			Copyright (c) 1997 by
				KGT Inc.
			All Rights Reserved

	This software  comprises  unpublished confidential information of
	KGT Inc. and may not be used, copied or made  available to anyone,
	except in accordance with the license under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/MicroAVS/DV/Cmap/legendP.v#1 $
*/
//
// Legend Process
//
   GMOD.parse_v set_default_vis {
      v_commands = "$push -usr\nlegend_vis=1;\n$pop\n";
      trigger => <-.vis;
      active => <-.vis;
      on_inst = 0;
      relative => <-.legend_params;
   };
   GMOD.parse_v numlabel_reset {
      v_commands = "$push\nScheduler.percent_done=30;\n$pop\n"
                  +"$push\n"
                  +"label_vis=1;"
                  +"label_num=6;"
                  +"label_height=14;"
                  +"label_offset=-0.03;"
                  +"label_offset_min=-0.5;"
                  +"label_offset_max=0.5;"
                  +"label_offset_deci=2;"
                  +"decimal=0;"
                  +"format=0;"
                  +"red=1.0;"
                  +"green=1.0;"
                  +"blue=1.0;\n"
                  +"$pop\n"
                  +"$push\nScheduler.percent_done=100;\n$pop\n"
                  ;
      trigger => <-.legend_params.numlabel_reset;
      on_inst=0;
      relative => <-.legend_params;
   };
   GMOD.parse_v all_reset {
      v_commands = "$push\nScheduler.percent_done=30;\n$pop\n"
                  +"$push\n"
                  +"legend_vis=1;"
      	  	  +"label_vis=1;"
 	          +"x=-0.7;"
 	          +"x_min=-1;"
 	   	  +"x_max=1;"
          	  +"x_deci=1;"
      		  +"y=-0.6;"
	          +"y_min=-1;"
	          +"y_max=1;"
      		  +"y_deci=1;"
		  +"width=0.1;"
		  +"w_min=0;"
		  +"w_max=1;"
		  +"w_deci=1;"
                  +"height=1.3;"
		  +"h_min=0;"
                  +"h_max=2;"
                  +"h_deci=1;"
                  +"label_offset=-0.03;"
                  +"label_offset_min=-0.5;"
                  +"label_offset_max=0.5;"
                  +"label_offset_deci=2;"
                  +"label_num=6;"
                  +"label_height=14;"
                  +"decimal=0;"
                  +"format=0;"
                  +"red=1.0;"
                  +"green=1.0;"
                  +"blue=1.0;\n"
                  +"color_fit=1;\n"
                  +"horizontal=0;"
                  +"horiz_x=-0.7;"
                  +"horiz_y=-0.9;"
                  +"horiz_w=1.4;"
                  +"horiz_h=0.1;\n"
                  +"$pop\n"
                  +"$push\nScheduler.percent_done=100;\n$pop\n"
                  ;
      trigger => <-.legend_params.all_reset;
      on_inst = 0;
      relative => <-.legend_params;
   };

   macro LegendMacro {
      int horizontal => <-.legend_params.horizontal+1;
      float dmapMin => <-.curMin;
      float dmapMax => <-.curMax;
      float+nres dmapIncr => ((dmapMax - dmapMin) / 256.0);
      float arr1[256][1] => init_array(256, dmapMin, (255.0 * dmapIncr) + dmapMin);
      float x => switch(horizontal, <-.legend_params.x,
                                    <-.legend_params.horiz_x);
      float y => switch(horizontal, <-.legend_params.y,
                                    <-.legend_params.horiz_y);
      float width => switch(horizontal, <-.legend_params.width,
                                        <-.legend_params.horiz_w);
      float height => switch(horizontal, <-.legend_params.height,
                                         <-.legend_params.horiz_h);
      float x_max => .x <+> .width;
      float y_max => .y <+> .height;
      float z = 0.9;
      Mesh_Unif+Node_Data+Float LegendField<NEportLevels={0,1}> {
         nnodes => prod(dims);
         dims => switch(<-.horizontal, {2, 256}, {256, 2});
         ndim = 2;
         Data_Array+Float.node_data node_data[nnode_data] {
	    values => switch(<-.<-.horizontal,
                         combine_array(arr1, arr1), concat_array(arr1, arr1));
            veclen = 1;
            nvals => nnodes;
         } = {};
         nnode_data = 1;
         nspace = 3;
         points => {{<-.x,<-.y,<-.z}, {<-.x_max,<-.y_max, <-.z}};
      };
      DefaultModes DefaultModes {
	 mode => {0,0,2,0,0};
      };
      MAdefaultObject Legend<NEportLevels={0,2}, export_all=2> {
         input => <-.LegendField;
         dmap => <-.<-.obj_in.dmap;
         modes => <-.DefaultModes;
         xform_mode = "Locked";
         name => "NOOBJLIST"+ (name_of(<-.<-.<-) + "Legend Bar");
      };
   };
   macro LabelsMacro {
      ilink legend_obj => <-.LegendMacro.Legend;
      int horizontal => <-.legend_params.horizontal+1;
      float dmapMin => <-.curMin;
      float dmapMax => <-.curMax;
      int label_height => <-.legend_params.label_height;
      int numIntervals => <-.legend_params.label_num;
      int decimalPoints => <-.legend_params.decimal;
      string num_format=> switch(<-.legend_params.format+1,"f","e");
      float red => <-.legend_params.red;
      float green => <-.legend_params.green;
      float blue => <-.legend_params.blue;
      link vis => legend_params.label_vis;
      float labelsOffset => <-.legend_params.label_offset;
      string format => (("%." + .decimalPoints) + .num_format);
      float string_values[] => init_array(.numIntervals,.dmapMin,.dmapMax);
      string string_array[] => str_format(.format,.string_values);

      float xvalues[.numIntervals][1] =>
            switch(horizontal,
            <-.LegendMacro.x + .labelsOffset,
            init_array(.numIntervals,<-.LegendMacro.x,<-.LegendMacro.x_max));
      float yvalues[.numIntervals][1] =>
            switch(horizontal,
            init_array(.numIntervals,<-.LegendMacro.y,<-.LegendMacro.y_max),
            <-.LegendMacro.y + .labelsOffset);

      float zvalues[.numIntervals][1] => <-.LegendMacro.z;
      Mesh LabelField<NEportLevels={0,1}> {
         nnodes => <-.numIntervals;
         nspace = 3;
         coordinates {
            values => combine_array(<-.<-.xvalues,<-.<-.yvalues,<-.<-.zvalues);
         };
         ncell_sets = 1;
         Point cell_set {
            ncells => <-.<-.numIntervals;
            node_connect_list => init_array(.ncells,0,(.ncells - 1));
         };
      };
      group TextValues {
         int align_horiz => switch(horizontal, 2, 1);
         int align_vert = 2;
         int drop_shadow = 0;
         int background = 0;
         int bounds = 0;
         int underline = 0;
         int lead_line = 0;
         int radial = 0;
         int do_offset = 0;
         float offset[3];
         int xform_mode;
         int color;
         string text_values[] => <-.string_array;
         int stroke = 0;
         group StrokeTextAttribs {
            int font_type;
            int style;
            int plane;
            int orient;
            int path;
            int space_mode;
            float spacing;
            float angle;
            float height;
            float expansion;
            float width;
         };
      };
      Grid+Xform &TextField<NEportLevels={0,1}> => 
         merge(.TextValues,.LabelField);
      macro obj<locked=0> {
         imlink child_objs => <-.legend_obj;
         GMOD.copy_on_change set_vis {
            input =><-.<-.vis;
         };
         group &in<NEportLevels={2,1},NEnumColors=4,NEcolor0=255> {
            GDxform_templ &xform;
         } => <-.TextField;
         DefaultProps Props<export_all=1> {
            font<NEportLevels={2,0}> => 
            (("-adobe-*-*-r-*-*-" + <-.<-.label_height) + "-*-*-*-*-*-*-*");
            col => {<-.<-.red,<-.<-.green,<-.<-.blue};
         };
         MAdefaultObject Obj<NEportLevels={0,1},export_all=2> {
            input => <-.in;
            xform => in.xform;
            props => <-.Props;
            objects => <-.child_objs;
            xform_mode = "Locked";
            name => "NOOBJLIST" + (name_of(<-.<-.<-.<-) + "Label");
            visible => <-.set_vis.output;
         };
         link obj<NEportLevels={0,3}> => .Obj;
      };
   };
   macro GroupObject<locked=0> {
      link vis => <-.legend_params.legend_vis;
      imlink child_objs => {<-.LabelsMacro.obj.obj};
      GDIF.DefaultModes+OPort Modes<export_all=0> { mode = 1; };
      MAdefaultObject Top<NEportLevels={0,2},export_all=0> {
         objects => <-.child_objs;
         xform_mode = "Locked";
         name => "NOOBJLIST" + name_of(<-.<-.<-) + "Legend";
         visible => <-.vis;
         modes => <-.Modes;
      };
   };
