/*
#	This file is under Perforce control
#	$Id: //depot/express/fcs70/v/MicroAVS/DV/Cmap/makedmap.v#1 $
#*/

   /*** make data map ***/
   
   /*** module makedmap ***/
   CMAP_EDTR.modMakeDmap+nosave MakeDmap{
      obj_in => <-.obj_in;
      map_field => <-.TransferFunction.PointMesh;
      dmap_out{
         dataMin = 0;
         dataMax = 255;
      };
      /**** v6.0 2002.01.21 change set = 1,mode = 1; regen = 1; => all 0 ****/
      set   = 0;
      mode  = 0;
      regen = 0;
      /**** v6.0 2002.01.21 add ****/
   };

   GMOD.copy_on_change+nosave copy_Makedmap_min {
      input => switch(((<-.colmap_params.curmax == <-.colmap_params.curmin) + 1),
                      <-.colmap_params.curmin,(<-.colmap_params.curmin  ));
      output => <-.MakeDmap.dmap_out.dataMin;
   };

   GMOD.copy_on_change+nosave copy_Makedmap_max {
      input => switch(((<-.colmap_params.curmax == <-.colmap_params.curmin) + 1),
                      <-.colmap_params.curmax,(<-.colmap_params.curmax + 1));
      output => <-.MakeDmap.dmap_out.dataMax;
   };
   
   /*** macro TransferFunction Save and load color map ***/
   macro TransferFunction{
      MAcolmap_params_templ &colmap_params<NEportLevels={2,1}> => <-.colmap_params;

      Grid+Mesh+Space2+Xform+Node_Data_Float+nosave PointMesh<NEportLevels={0,2}> {
         nnodes = 2;
         coordinates {
            values = {0.,0.,255.,1.};
         };
         int  ncell_sets = 1;
         Point  cell_set {
            ncells => <-.nnodes;
            node_connect_list => init_array(ncells, 0, ncells-1);
         };
         nnode_data = 1;
         node_data {
            veclen = 3;
            values = { 0,0,1, 1,0,0 };
            labels = "rgb";
         };
      };
      

      CMAP_EDTR.modSaveLoadColorMap+nosave SaveLoadColorMap{
         min => <-.<-.MakeDmap.dmap_out.dataMin;
         max => <-.<-.MakeDmap.dmap_out.dataMax;
         regen => <-.<-.MakeDmap.regen;
         rescale = 0;
         save_trigger => <-.colmap_params.wt_ok;
         load_trigger => <-.colmap_params.rd_ok;
         point_mesh => <-.PointMesh;
      };

      GMOD.parse_v+nosave load_file {
         trigger => <-.<-.colmap_params.rd_ok;
         relative => <-.<-.<-;
         on_inst = 1;
         /**** v6.0b change 2002.01.18  ***/
         active => (is_valid(<-.colmap_params.rd_filename) * (is_valid(<-.<-.colmap_params.rd_ok)));
         /**** end  v6.0b change ***/

         v_commands => "$push -usr\n"
                      +"colmap_params{ UI_active = 0;};\n"
                      +"TransferFunction.SaveLoadColorMap { filename = <-.colmap_params.rd_filename;};\n"
                      +"$pop\n"
                      +"$push -usr\n"
                      +"TransferFunction.SaveLoadColorMap { load_trigger = 1;};\n"
                      +"$pop\n"
                      +"$push -usr\n"
                      +"MakeDmap.refresh = 1;"
                      +"$pop\n"
                      +"$push -usr\n"
                      +"TransferFunction.set_field_colmap_params {active  = 1;};"
                      +"TransferFunction.set_field_colmap_params {trigger = 1;};"
                      +"$pop\n"
                      +"$push -usr\n"
                      +"TransferFunction.set_field_colmap_params {active  = 0;};"
                      +"$pop\n"
                      +"$push -usr\n"
                      /**** v6.0b 2002.01.18  add***/
                      +"TransferFunction.set_UI_active { input = ((<-.<-.max_color_index + 1) == <-.PointMesh.nnodes );};\n"
                      +"$pop\n";
      };
      
      GMOD.parse_v save_file {
         trigger => <-.<-.colmap_params.wt_ok;
         relative => <-.<-;
         on_inst = 0;
         v_commands => "$push -usr\n"
                     +"$pop\n"
                     +"$push -usr\n"
                     +"SaveLoadColorMap { filename = <-.colmap_params.wt_filename;};\n"
                     +"$pop\n"
                     +"$push -usr\n"
                     +"SaveLoadColorMap { save_trigger = 1;};\n"
                     +"$pop\n";
      };

      GMOD.copy_on_change set_UI_active_on {
/**** v6.0b 2002.01.18 ***/
         trigger => <-.colmap_params.colormap_index || <-.colmap_params.all_reset;
/**** end v6.0b 2002.01.18 ***/
         input => 1;
         on_inst = 0;
         output => <-.colmap_params.UI_active;
      };
      

/**** v6.0b 2002.01.18 ***/
      GMOD.parse_v+nosave set_rd_ok {
         trigger => <-.colmap_params.colormap_index || <-.colmap_params.all_reset;
         relative => <-.<-;
         on_inst = 0;
         v_commands => "$push -usr\n"
                       + "colmap_params{ rd_ok = ;};"
                       +"$pop\n";
      };

      GMOD.copy_on_change+nosave set_UI_active {
         output => <-.colmap_params.UI_active;
      };

/**** end v6.0b 2002.01.18 ***/

      GMOD.rgb_to_hsv min_hsv{
         r => <-.PointMesh.node_data[0].values[0][0];
         g => <-.PointMesh.node_data[0].values[0][1];
         b => <-.PointMesh.node_data[0].values[0][2];
      };

      GMOD.rgb_to_hsv max_hsv{
         /*** v6.0b 2002.01.18 change max_color_index -> (nnodes -1)  ***/
         r => <-.PointMesh.node_data[0].values[(<-.PointMesh.nnodes -1 ) ][0];
         g => <-.PointMesh.node_data[0].values[(<-.PointMesh.nnodes -1 ) ][1];
         b => <-.PointMesh.node_data[0].values[(<-.PointMesh.nnodes -1 ) ][2];
      /*** end v6.0b 2002.01.18 change  ***/
      };

      GMOD.parse_v+nosave set_field_colmap_params {
         relative => <-.colmap_params;
         trigger = 0;
         active = 0;
         on_inst = 0;
         v_commands => "$push -usr\n"
                    /*** v6.0b 2002.01.18 change max_color_index -> (nnodes -1)  ***/
                     + str_format(" min_col_val  = %f ;\n",((<-.PointMesh.coordinates.values[0][0] 
                                                    * (<-.SaveLoadColorMap.max - <-.SaveLoadColorMap.min) / 255.) + <-.SaveLoadColorMap.min ))
                     + str_format(" max_col_val  = %f ;\n",((<-.PointMesh.coordinates.values[ ( <-.PointMesh.nnodes - 1)][0] 
                                                    * (<-.SaveLoadColorMap.max - <-.SaveLoadColorMap.min) / 255.) + <-.SaveLoadColorMap.min ))
                    /*** v6.0b 2002.01.18 change max_color_index -> (nnodes -1)  ***/
                     + str_format(" min_h  = %f ;\n",<-.min_hsv.h)
                     + str_format(" min_s  = %f ;\n",<-.min_hsv.s)
                     + str_format(" min_v  = %f ;\n",<-.min_hsv.v)
                     + str_format(" max_h  = %f ;\n",<-.max_hsv.h)
                     + str_format(" max_s  = %f ;\n",<-.max_hsv.s)
                     + str_format(" max_v  = %f ;\n",<-.max_hsv.v)
                     + str_format(" curmin  = %f ;\n",<-.SaveLoadColorMap.min)
                     + str_format(" curmax  = %f ;\n",<-.SaveLoadColorMap.max)
                     +"$pop\n";
      };
   };
  
   /*** macro set_dmap set colmap_params ***/
   macro set_dmap{

      Grid+Mesh+Space2+Xform+Node_Data_Float &PointMesh<NEportLevels={2,0}> => <-.TransferFunction.PointMesh;

      MAcolmap_params_templ &colmap_params<NEportLevels={2,1}> => <-.colmap_params;

      float cur_size     => .colmap_params.curmax - .colmap_params.curmin;
      float col_val_size => .colmap_params.max_col_val - .colmap_params.min_col_val;
      int points       => (( .col_val_size == 0 ) + 1);

      GMOD.parse_v set_colormap {
         trigger => (<-.node_value || <-.coord_value );
         relative => <-.<-.<-;
         on_inst = 0;
         active => ((is_valid(<-.node_value)*is_valid(<-.coord_value)) * <-.colmap_params.UI_active);
         v_commands =>  "$push -usr\n"
                     /**** v6.0 2002.01.21 add ****/
                     +"copy_Makedmap_max { trigger = 1;};\n"
                     +"copy_Makedmap_min { trigger = 1;};\n"
                     //+"MakeDmap.mode=1;\n"
                     +"$pop\n"
                     +"$push -usr\n"
                     /**** end v6.0 2002.01.21 add ****/
                     +"MakeDmap.regen=1;\n"
                     +switch( <-.points,
                     "TransferFunction.PointMesh { nnodes = 2 ;};\n",
                     "TransferFunction.PointMesh { nnodes = 4 ;};\n")
                     +"TransferFunction.PointMesh { coordinates { values = <-.<-.<-.set_dmap.coord_value ;};}; \n"
                     +"TransferFunction.PointMesh { !node_data[0] { values = <-.<-.<-.set_dmap.node_value; };};\n"
                     +"$pop\n"
                     +"$push -usr\n"
                     +"MakeDmap.refresh=1;\n"
                     +"$pop\n"
                     +"$push -usr\n"
                     +"colmap_params {UI_active = 1;};"
                     +"$pop\n";
      };
     
      GMOD.hsv_to_rgb max_hsv_to_rgb{
      h => <-.colmap_params.max_h;
      s => <-.colmap_params.max_s;
      v => <-.colmap_params.max_v;
      };
      GMOD.hsv_to_rgb min_hsv_to_rgb{
      h => <-.colmap_params.min_h;
      s => <-.colmap_params.min_s;
      v => <-.colmap_params.min_v;
      };
      
      float node_value[] => 
      switch(.points,
      {.min_hsv_to_rgb.r,.min_hsv_to_rgb.g,.min_hsv_to_rgb.b,
       .max_hsv_to_rgb.r,.max_hsv_to_rgb.g,.max_hsv_to_rgb.b
      },
      {.min_hsv_to_rgb.r,.min_hsv_to_rgb.g,.min_hsv_to_rgb.b,
       .min_hsv_to_rgb.r,.min_hsv_to_rgb.g,.min_hsv_to_rgb.b,
       .max_hsv_to_rgb.r,.max_hsv_to_rgb.g,.max_hsv_to_rgb.b,
       .max_hsv_to_rgb.r,.max_hsv_to_rgb.g,.max_hsv_to_rgb.b
      }
      );

      float coord_value[] => 
      switch(.points,
      { (((.colmap_params.min_col_val - .colmap_params.curmin) * 255.0) / .cur_size),0,
        (((.colmap_params.max_col_val - .colmap_params.curmin) * 255.0) / .cur_size),1},
      { -1,0,
        switch ((( cur_size == 0) + 1),
          (((.colmap_params.min_col_val - .colmap_params.curmin) * 255.0) / .cur_size),0),0,
        switch ((( cur_size == 0) + 1),
        /**** v6.0 2002.01.21 change ...255),255  => 0),1, ****/
          (((.colmap_params.max_col_val - .colmap_params.curmin) * 255.0) / .cur_size),0),1,
        /**** end v6.0 2002.01.21 add ****/
        256,1}
      );

   };
   