/*
	"$Id: //depot/express/fcs70/v/MicroAVS/DV/Cmap/rangeUI.v#1 $"
			Copyright (c) 1997 by
				KGT Inc.
			All Rights Reserved

	This software  comprises  unpublished confidential information of
	KGT Inc. and may not be used, copied or made  available to anyone,
	except in accordance with the license under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/MicroAVS/DV/Cmap/rangeUI.v#1 $
*/
macro MArangeColorUI {
   ilink parent => <-.shell;
   int x = 0;
   MAcolmap_params_templ &colmap_params => <-.colmap_params;

   GMOD.instancer UIinstancer {
      Value => <-.colmap_params.vis;
      Group => <-.UI;
   };
   macro UI<instanced=0> {
      ilink parent =><-.parent;
      ilink x => <-.x;
      MAcolmap_params_templ &colmap_params => <-.colmap_params;

      MAUIframe frame {
         parent => <-.parent;
         visible => <-.colmap_params.vis;
         x => <-.x;
         y = 10;
         width = 165;
         height =><-.range_max_slider.y + <-.range_max_slider.height + 10;
      };
      MAUIlabel range_label {
         x = 10;
         y = 5;
         width =><-.frame.width - x*2;
         parent =><-.frame;
         label = "MACOLMAP_RANGE";
      };
      MAUIslider2 range_min_slider {
         /*** v6.0 ***/
         active => <-.colmap_params.UI_active;
         /*** end v6.0 ***/
         parent =><-.frame;
         title = "MACOLMAP_MINCOLVAL";
         x =>range_label.x;
         y =>range_label.y + range_label.height;
         allwidth =><-.frame.width - x*2;
         min_oonly = 1;
         max_oonly = 1;
         fontAttributes.height = 12;
         min => <-.colmap_params.curmin;
         max => <-.colmap_params.curmax;
         value => <-.colmap_params.min_col_val;
         decimalPoints => <-.colmap_params.min_col_val_deci;
      };
      MAUIslider2 range_max_slider {
         /*** v6.0 ***/
         active => <-.colmap_params.UI_active;
         /*** end v6.0 ***/
         parent =><-.frame;
         x => range_min_slider.x;
         y => range_min_slider.y + range_min_slider.height;
         title = "MACOLMAP_MAXCOLVAL";
         allwidth => range_min_slider.allwidth;
         min_oonly = 1;
         max_oonly = 1;
         fontAttributes.height = 12;
         min => <-.colmap_params.curmin;
         max => <-.colmap_params.curmax;
         value => <-.colmap_params.max_col_val;
         decimalPoints => <-.colmap_params.max_col_val_deci;
      };
      // fix the slider value;
/*
      float fix => switch((range_min_slider.value > range_max_slider.value)+1,
                          range_min_slider.value,range_max_slider.value);
*/
      group+nosave fix{
         string        min     => str_format((("%." + <-.range_min_slider.decimalPoints) + "f"),<-.range_min_slider.value);
         string        max     => str_format((("%." + <-.range_max_slider.decimalPoints) + "f"),<-.range_max_slider.value);
         double+nosave min_val = 0;
         double+nosave max_val = 0;
         double+nosave cur_min = 0;
         double+nosave cur_max = 0;
         double+nosave out     => switch(((min_val > max_val) + 1), min_val, max_val);
         GMOD.parse_v set_min{
            v_commands => "$push\n"
                         +"min_val = " + <-.min + ";\n"
                         +"$pop\n";
            active     => (<-.cur_min != <-.min_val) || (<-.min_val != <-.max_val);
            on_inst    = 0;
            relative   => <-.<-;
         };
         GMOD.parse_v set_max{
            v_commands => "$push\n"
                         +"max_val = " + <-.max + ";\n"
                         +"$pop\n";
            active     => (<-.cur_max != <-.max_val) || (<-.min_val != <-.max_val);
            on_inst    = 0;
            relative   => <-.<-;
         };
         GMOD.parse_v exec_minmax{
            v_commands => "$push\n"
                         +"cur_min = " + <-.min + ";\n"
                         +"cur_max = " + <-.max + ";\n"
                         +"$pop\n"
                         +"$push\n"
                         +"set_min.trigger = 1;\n"
                         +"set_max.trigger = 1;\n"
                         +"$pop\n";
            trigger    => is_valid(<-.<-.range_min_slider.value) || is_valid(<-.<-.range_max_slider.value);
            active     = 1;
            on_inst    = 1;
            relative   => <-.<-;
         };
      };
      GMOD.copy_on_change copyfix {
         input   => <-.fix.out;
         output  => <-.range_min_slider.value;
         on_inst = 0;
      };
      GMOD.parse_v slider_init{
         v_commands => "trigger = 1;\n";
         active     => (<-.range_min_slider.value > <-.range_max_slider.value);
         on_inst    = 1;
         relative   => <-.copyfix;
      };
      //
      MAUIfield size_field {
         /*** v6.0 ***/
         active => <-.colmap_params.UI_active;
         /*** end v6.0 ***/
         parent =><-.parent;
         x => size_label.x + size_label.width;
         y => frame.y + frame.height + 5;
         width => frame.width/2;
         value = 256;
         min = 1; 
         max = 256; 
         mode = "integer";
         value => <-.colmap_params.color_size;
      };
      MAUIlabel size_label {
         parent =><-.parent;
         x =><-.frame.x;
         y =>size_field.y + 5;
         width => frame.width/2;
         label = "MACOLMAP_SIZE";
      };
   };
};
