/*
	This file is under Perforce control
	$Id: //depot/express/fcs70/v/MicroAVS/DV/Cmap/saveUI.v#1 $
*/

module MADVcmap_updata {
   double+nosave curmin;            /* f[^W̍ŏl */
   double+nosave curmax;            /* f[^W̍ől */
   double+nosave min_col_val;       /* ŏl̃Wl */
   double  min_r;                   /* RED   */
   double  min_g;                   /* GREEN */
   double  min_b;                   /* BLUE  */
   double+nosave max_col_val;       /* ől̃Wl */
   double  max_r;                   /* RED   */
   double  max_g;                   /* GREEN */
   double  max_b;                   /* BLUE  */
   int     color_size;              /* F */
   int    save<NEportLevels={2,0}>;        /* ۑp̃gK */
   int    load<NEportLevels={2,0}>;        /* Ǎݗp̃gK */
   string+nosave filename<NEportLevels={2,0}>; /* t@C */
   omethod  MADVload_cmap_func(
      .load+read+notify+req, .filename+read+req,
      .curmin+write, .curmax+write,
      .min_col_val+write, .min_r+write, .min_g+write, .min_b+write,
      .max_col_val+write, .max_r+write, .max_g+write, .max_b+write,
      .color_size+write
   ) = "MADVload_cmap_update";
   omethod  MADVsave_cmap_func(
      .save+read+notify+req, .filename+read+req,
      .curmin+read+req, .curmax+read+req,
      .min_col_val+read+req, .min_r+read+req, .min_g+read+req, .min_b+read+req,
      .max_col_val+read+req, .max_r+read+req, .max_g+read+req, .max_b+read+req,
      .color_size+read+req
   ) = "MADVsave_cmap_update";
};

macro MAsaveCmap {
   /* includeWJɂcmapUI.v MAUIsimpleDialog shell */
   ilink parent => <-.shell;
   /* includeWJɂcmapUI.v MAcolmap_params_templ &colmap_params */
   MAcolmap_params_templ &colmap_params => <-.colmap_params;
   GMOD.instancer UIinstancer {
      Value => <-.colmap_params.vis;
      Group => <-.UI;
   };
   GMOD.hsv_to_rgb  Min_hsv_to_rgb ;   /* ϊp RGBW[ */
   GMOD.hsv_to_rgb  Max_hsv_to_rgb ;   /* ϊp RGBW[ */
   macro UI<instanced=0> {
      string read_init_directory => Templates.MicroAVS.CONFIG.read_data_init_directory;
      MAcolmap_params_templ+nres &colmap_params => <-.colmap_params;			//Lqǉ
      MicroAVS.MAUIfileDialog+nosave MAsaveDialog {
         parent => <-.<-.parent;
         title = "MACOLMAP_SAVE";
         visible => <-.<-.colmap_params.saveb;
         isModal => <-.<-.colmap_params.saveb;
         ok     => <-.colmap_params.wt_ok;			//LqύX
         cancel = 0;
         all_types = "*.cmp";
         searchPattern = read_init_directory;
         current_directory => searchPattern;
         filename => <-.colmap_params.wt_filename;		//Lqǉ
         confirmFileWrite = 1;
      };
/*
      GMOD.parse_v save_cmap {
         v_commands = "$push\n"
      + "MADVcmap_updata.filename = MAsaveCmap.UI.MAsaveDialog.filename;\n"
      + "$pop\n"
      + "$push\n"
      + "MADVcmap_updata.curmin = MAsaveCmap.colmap_params.curmin;\n"
      + "$pop\n"
      + "$push\n"
      + "MADVcmap_updata.curmax = MAsaveCmap.colmap_params.curmax;\n"
      + "$pop\n"
      + "$push\n"
      + "MADVcmap_updata.min_col_val = MAsaveCmap.colmap_params.min_col_val;\n"
      + "$pop\n"
      + "$push\n"
      + "MADVcmap_updata.max_col_val = MAsaveCmap.colmap_params.max_col_val;\n"
      + "$pop\n"
      + "$push\n"
      + "MAsaveCmap.Min_hsv_to_rgb.h = MAsaveCmap.colmap_params.min_h;\n"
      + "MAsaveCmap.Min_hsv_to_rgb.s = MAsaveCmap.colmap_params.min_s;\n"
      + "MAsaveCmap.Min_hsv_to_rgb.v = MAsaveCmap.colmap_params.min_v;\n"
      + "$pop\n"
      + "$push\n"
      + "MADVcmap_updata.min_r = MAsaveCmap.Min_hsv_to_rgb.r;\n"
      + "MADVcmap_updata.min_g = MAsaveCmap.Min_hsv_to_rgb.g;\n"
      + "MADVcmap_updata.min_b = MAsaveCmap.Min_hsv_to_rgb.b;\n"
      + "$pop\n"
      + "$push\n"
      + "MAsaveCmap.Max_hsv_to_rgb.h = MAsaveCmap.colmap_params.max_h;\n"
      + "MAsaveCmap.Max_hsv_to_rgb.s = MAsaveCmap.colmap_params.max_s;\n"
      + "MAsaveCmap.Max_hsv_to_rgb.v = MAsaveCmap.colmap_params.max_v;\n"
      + "$pop\n"
      + "$push\n"
      + "MADVcmap_updata.max_r = MAsaveCmap.Max_hsv_to_rgb.r;\n"
      + "MADVcmap_updata.max_g = MAsaveCmap.Max_hsv_to_rgb.g;\n"
      + "MADVcmap_updata.max_b = MAsaveCmap.Max_hsv_to_rgb.b;\n"
      + "$pop\n"
      + "$push\n"
      + "MADVcmap_updata.color_size = MAsaveCmap.colmap_params.color_size;\n"
      + "$pop\n"
      + "$push\n"
      + "MADVcmap_updata.save = 1 ;\n"
      + "$pop\n";
         trigger => <-.MAsaveDialog.ok;
         relative => <-.<-.<-;
         on_inst = 0;
      };
*/
   };
};

macro MAloadCmap {
   ilink parent => <-.shell;
   MAcolmap_params_templ+nres &colmap_params => <-.colmap_params;
   GMOD.instancer UIinstancer {
      Value => <-.colmap_params.vis;
      Group => <-.UI;
   };
   GMOD.rgb_to_hsv  Min_rgb_to_hsv ;   /* ϊp RGBW[ */
   GMOD.rgb_to_hsv  Max_rgb_to_hsv ;   /* ϊp RGBW[ */
   macro UI<instanced=0> {
      string read_init_directory => Templates.MicroAVS.CONFIG.read_data_init_directory;
      MAcolmap_params_templ+nres &colmap_params => <-.colmap_params;
      MicroAVS.MAUIfileDialog+nosave MAloadDialog {
         parent => <-.<-.parent;
         title = "MACOLMAP_LOAD";
         visible => <-.<-.colmap_params.loadb;
         isModal => <-.<-.colmap_params.loadb;
         ok     => <-.colmap_params.rd_ok;
         cancel = 0;
         all_types = "*.cmp";
         searchPattern = read_init_directory;
         current_directory => searchPattern;
         filename => <-.colmap_params.rd_filename;
         confirmFileWrite = 0;
      };
/*
      GMOD.parse_v load_cmap {
         v_commands = "$push\n"
   + "MADVcmap_updata.filename = MAloadCmap.UI.MAloadDialog.filename;\n"
   + "$pop\n"
   + "$push\n"
   + "MADVcmap_updata.load = 1 ;\n"
   + "$pop\n"
   + "$push\n"
   + "MAloadCmap.colmap_params.curmin = Modules.MAcmapLegendSet.MAcolmap.MAcolormapUI.MADVcmap_updata.curmin ;\n"
   + "$pop\n"
   + "$push\n"
   + "MAloadCmap.colmap_params.curmax = Modules.MAcmapLegendSet.MAcolmap.MAcolormapUI.MADVcmap_updata.curmax ;\n"
   + "$pop\n"
   + "$push\n"
   + "MAloadCmap.colmap_params.min_col_val = Modules.MAcmapLegendSet.MAcolmap.MAcolormapUI.MADVcmap_updata.min_col_val;\n"
   + "$pop\n"
   + "$push\n"
   + "MAloadCmap.colmap_params.max_col_val = Modules.MAcmapLegendSet.MAcolmap.MAcolormapUI.MADVcmap_updata.max_col_val;\n"
   + "$pop\n"
   + "$push\n"
   + "MAloadCmap.Min_rgb_to_hsv.r = MADVcmap_updata.min_r;\n"
   + "MAloadCmap.Min_rgb_to_hsv.g = MADVcmap_updata.min_g;\n"
   + "MAloadCmap.Min_rgb_to_hsv.b = MADVcmap_updata.min_b;\n"
   + "$pop\n"
   + "$push\n"
   + "MAloadCmap.colmap_params.min_h = Modules.MAcmapLegendSet.MAcolmap.MAcolormapUI.MAloadCmap.Min_rgb_to_hsv.h;\n"
   + "MAloadCmap.colmap_params.min_s = Modules.MAcmapLegendSet.MAcolmap.MAcolormapUI.MAloadCmap.Min_rgb_to_hsv.s;\n"
   + "MAloadCmap.colmap_params.min_v = Modules.MAcmapLegendSet.MAcolmap.MAcolormapUI.MAloadCmap.Min_rgb_to_hsv.v;\n"
   + "$pop\n"
   + "$push\n"
   + "MAloadCmap.Max_rgb_to_hsv.r = MADVcmap_updata.max_r;\n"
   + "MAloadCmap.Max_rgb_to_hsv.g = MADVcmap_updata.max_g;\n"
   + "MAloadCmap.Max_rgb_to_hsv.b = MADVcmap_updata.max_b;\n"
   + "$pop\n"
   + "$push\n"
   + "MAloadCmap.colmap_params.max_h = Modules.MAcmapLegendSet.MAcolmap.MAcolormapUI.MAloadCmap.Max_rgb_to_hsv.h;\n"
   + "MAloadCmap.colmap_params.max_s = Modules.MAcmapLegendSet.MAcolmap.MAcolormapUI.MAloadCmap.Max_rgb_to_hsv.s;\n"
   + "MAloadCmap.colmap_params.max_v = Modules.MAcmapLegendSet.MAcolmap.MAcolormapUI.MAloadCmap.Max_rgb_to_hsv.v;\n"
   + "$pop\n"
   + "$push\n"
   + "MAloadCmap.colmap_params.color_size = Modules.MAcmapLegendSet.MAcolmap.MAcolormapUI.MADVcmap_updata.color_size;\n"
   + "$pop\n"
   + "$pop\n";
         trigger => <-.MAloadDialog.ok;
         relative => <-.<-.<-;
         on_inst = 0;
      };
*/
   };
};

