/*
	"$Id: //depot/express/fcs70/v/MicroAVS/DV/MAbirdco.v#1 $"
			Copyright (c) 1997 by
				KGT Inc.
			All Rights Reserved

	This software  comprises  unpublished confidential information of
	KGT Inc. and may not be used, copied or made  available to anyone,
	except in accordance with the license under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/MicroAVS/DV/MAbirdco.v#1 $
*/
MAparams MAbird_color_params {
   int scale_comp = 0;
   int map_comp = 0;
   boolean color = 1;
   float scale = 0.1;
   float scale_min = -1;
   float scale_max = 1;
   int scale_deci = 2;
   float offset = 0.0;
   float offset_min = -1;
   float offset_max = 1;
   int offset_deci = 2;
   init_commands = "";
   reset_commands = "bird_color_params.color=1;"
                   +"bird_color_params.scale=0.1;"
                   +"bird_color_params.scale_comp=0;"
                   +"bird_color_params.map_comp=0;"
                   +"bird_color_params.scale_min=-1;"
                   +"bird_color_params.scale_max=1;"
                   +"bird_color_params.scale_deci=2;"
                   +"bird_color_params.offset=0.0;"
                   +"bird_color_params.offset_min=-1;"
                   +"bird_color_params.offset_max=1;"
                   +"bird_color_params.offset_deci=2;"
                   ;
};

MAmacroUI MAbird_colorUI {
   MAbird_color_params+IPort2 &bird_color_params;
   Mesh+Node_Data &fld_in<NEportLevels={2,1}>;
   height => bird_color_panel.height;
   MAUIframe bird_color_panel {
      parent => <-.parent;
      y => <-.y;
      height =>offset_slider.y + offset_slider.height + 15;
   };
   MADVnode_data_labels node_data_labels {
      in =><-.fld_in;
   };
   MAUIradioBoxLabel map_radio {
      parent =><-.bird_color_panel;
      x = 5;
      y = 5;
      labels =><-.node_data_labels.labels;
      &selectedItem =><-.bird_color_params.map_comp;
      title ="MABIRDC_SEL_COL";
   };
   MAUIradioBoxLabel scale_radio {
      parent =><-.bird_color_panel;
      x = 5;
      y =><-.map_radio.y + <-.map_radio.height + 5;
      labels =><-.node_data_labels.labels;
      &selectedItem =><-.bird_color_params.scale_comp;
      title ="MABIRDC_SEL_H";
   };
   MAUItoggle color_toggle {
      parent =><-.bird_color_panel;
      x = 5;
      y =><-.scale_radio.y + <-.scale_radio.height + 5;
      label = "MABIRDC_COL";
      set =><-.bird_color_params.color;
   };
   MAUIslider2 scale_slider {
      parent =><-.bird_color_panel;
      x = 5;
      y =><-.color_toggle.y + <-.color_toggle.height + 5;
      min =><-.bird_color_params.scale_min;
      max =><-.bird_color_params.scale_max;
      decimalPoints =><-.bird_color_params.scale_deci;
      title = "MABIRDC_H";
      value =><-.bird_color_params.scale;
   };
   scale_slider offset_slider {
      y =><-.scale_slider.y + <-.scale_slider.height + 5;
      min =><-.bird_color_params.offset_min;
      max =><-.bird_color_params.offset_max;
      decimalPoints =><-.bird_color_params.offset_deci;
      title = "MABIRDC_OFFSET";
      value =><-.bird_color_params.offset;
   };

};

MAmodule MAbird_color {
   MAbird_color_params+IPort2 &bird_color_params;
   Mesh+Node_Data &fld_in<NEportLevels={2,1}>;

   MADVextract_comp+nosave extract_map_comp {
      &component =><-.bird_color_params.map_comp;
      &in =><-.fld_in;
   };
   MADVsurf_plot+nosave surf_plot {
      in =><-.fld_in;
      nspace = 2;
      &component =><-.bird_color_params.scale_comp;
      scale =><-.bird_color_params.scale;
      offset =><-.bird_color_params.offset;
   };
   MADVcombine_mesh_and_data combine_scale_map {
      in_mesh => <-.surf_plot.out;
      in_nd => <-.extract_map_comp.out_nd;
   };
   MADVextract_mesh+nosave extract_mesh {
      in =><-.combine_scale_map.out;
   };
   // for Bugs
   GMOD.copy_on_change set_uniform {
      trigger =><-.surf_plot.out.nnodes;
      input = 1;
      output+nres => <-.surf_plot.out.grid_type;
      on_inst = 0;
   };
   fld_out => switch(bird_color_params.color+1,
                     extract_mesh.out,combine_scale_map.out);
};
