/*
	"$Id: //depot/express/fcs70/v/MicroAVS/DV/MAbirdey.v#1 $"
			Copyright (c) 1997 by
				KGT Inc.
			All Rights Reserved

	This software  comprises  unpublished confidential information of
	KGT Inc. and may not be used, copied or made  available to anyone,
	except in accordance with the license under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/MicroAVS/DV/MAbirdey.v#1 $
*/
MAparams MAbird_eye_params {
   float scale = 0.1;
   float scale_min = -1;
   float scale_max = 1;
   float scale_deci = 2;
   float offset = 0;
   float offset_min = -1;
   float offset_max = 1;
   float offset_deci = 2;
   boolean texture = 1;
   string texture_file = ;
   boolean uv_switch = 0;
   boolean u_flip = 0;
   boolean v_flip = 0;
   float u_scale = 1;
   float u_scale_min = 0;
   float u_scale_max = 10;
   float u_scale_deci = 2;
   float v_scale = 1;
   float v_scale_min = 0;
   float v_scale_max = 10;
   float v_scale_deci = 2;
   float u_shift = 0;
   float u_shift_min = -1;
   float u_shift_max = 1;
   float u_shift_deci = 2;
   float v_shift = 0;
   float v_shift_min = -1;
   float v_shift_max = 1;
   float v_shift_deci = 2;
   init_commands = "";
   reset_commands = "bird_eye_params.scale=0.1;"
                   +"bird_eye_params.scale_min=-1;"
                   +"bird_eye_params.scale_max=1;"
                   +"bird_eye_params.scale_deci=2;"
                   +"bird_eye_params.offset=0;"
                   +"bird_eye_params.offset_min=-1;"
                   +"bird_eye_params.offset_max=1;"
                   +"bird_eye_params.offset_deci=2;"
                   +"bird_eye_params.texture=1;"
                   +"bird_eye_params.texture_file=;"
                   +"bird_eye_params.uv_switch=0;"
                   +"bird_eye_params.u_flip=0;"
                   +"bird_eye_params.v_flip=0;"
                   +"bird_eye_params.u_scale=1;"
                   +"bird_eye_params.u_scale_min=0;"
                   +"bird_eye_params.u_scale_max=10;"
                   +"bird_eye_params.u_scale_deci=2;"
                   +"bird_eye_params.v_scale=1;"
                   +"bird_eye_params.v_scale_min=0;"
                   +"bird_eye_params.v_scale_max=10;"
                   +"bird_eye_params.v_scale_deci=2;"
                   +"bird_eye_params.u_shift=0;"
                   +"bird_eye_params.u_shift_min=-1;"
                   +"bird_eye_params.u_shift_max=1;"
                   +"bird_eye_params.u_shift_deci=2;"
                   +"bird_eye_params.v_shift=0;"
                   +"bird_eye_params.v_shift_min=-1;"
                   +"bird_eye_params.v_shift_max=1;"
                   +"bird_eye_params.v_shift_deci=2;"
                   ;
};

MAmacroUI MAbird_eyeUI {
   MAbird_eye_params &bird_eye_params<NEportLevels={2,1}>;

   height => bird_eye_panel.height;
   MAUIframe bird_eye_panel {
      parent => <-.parent;
      y => <-.y;
      height => <-.v_shift_slider.y + <-.v_shift_slider.height + 5;
   };
   MAUIslider2 scale_slider {
      parent =><-.bird_eye_panel;
      x = 5;
      y = 5;
      value =><-.bird_eye_params.scale;
      min =><-.bird_eye_params.scale_min;
      max =><-.bird_eye_params.scale_max;
      decimalPoints =><-.bird_eye_params.scale_deci;
      title = "MABIRDE_H";
   };
   scale_slider offset_slider {
      y =><-.scale_slider.y + <-.scale_slider.height + 5;
      value =><-.bird_eye_params.offset;
      min =><-.bird_eye_params.offset_min;
      max =><-.bird_eye_params.offset_max;
      decimalPoints =><-.bird_eye_params.offset_deci;
      title = "MABIRDE_OFFSET";
   };
   MAUIbutton read_image_button {
      parent =><-.bird_eye_panel;
      x = 5;
      y =><-.offset_slider.y + <-.offset_slider.height + 5;
      label = "MABIRDE_RD_T";
   };
   MAUIfileDialog file_browser {
      parent =><-.bird_eye_panel;
      visible =><-.read_image_button.do;
      title = "MABIRDE_RD_TD";
#ifdef MSDOS
      current_directory = MAVS_XP_PATH + "/data/image";
      image_types = "*.x";
#else
      searchPattern = MAVS_XP_PATH + "/data/image/*.x";
#endif //MSDOS
      filename =><-.bird_eye_params.texture_file;
   };
   MAUItoggle texture_toggle {
      parent =><-.bird_eye_panel;
      x = 5;
      y =><-.read_image_button.y + <-.read_image_button.height + 5;
      label = "MABIRDE_VIS_T";
      set =><-.bird_eye_params.texture;
   };
   MAUItoggle uv_toggle {
      parent =><-.bird_eye_panel;
      x = 5;
      y =><-.texture_toggle.y + <-.texture_toggle.height + 5;
      label = "MABIRDE_SWITCH_UV";
      set =><-.bird_eye_params.uv_switch;
   };
   uv_toggle u_toggle {
      y =><-.uv_toggle.y + <-.uv_toggle.height + 5;
      label = "MABIRDE_FLIP_U";
      set =><-.bird_eye_params.u_flip;
   };
   uv_toggle v_toggle {
      y =><-.u_toggle.y + <-.u_toggle.height + 5;
      label = "MABIRDE_FLIP_V";
      set =><-.bird_eye_params.v_flip;
   };
   MAUIslider2 u_scale_slider {
      parent =><-.bird_eye_panel;
      x = 5;
      y =><-.v_toggle.y + <-.v_toggle.height + 5;
      title = "MABIRDE_SCALE_U";
      value =><-.bird_eye_params.u_scale;
      min =><-.bird_eye_params.u_scale_min;
      max =><-.bird_eye_params.u_scale_max;
      decimalPoints =><-.bird_eye_params.u_scale_deci;
   }; 
   u_scale_slider v_scale_slider {
      y =><-.u_scale_slider.y + <-.u_scale_slider.height + 5;
      title = "MABIRDE_SCALE_V";
      value =><-.bird_eye_params.v_scale;
      min =><-.bird_eye_params.v_scale_min;
      max =><-.bird_eye_params.v_scale_max;
      decimalPoints =><-.bird_eye_params.v_scale_deci;
   };
   u_scale_slider u_shift_slider {
      y =><-.v_scale_slider.y + <-.v_scale_slider.height + 5;
      title = "MABIRDE_SHIFT_U";
      value =><-.bird_eye_params.u_shift;
      min =><-.bird_eye_params.u_shift_min;
      max =><-.bird_eye_params.u_shift_max;
      decimalPoints =><-.bird_eye_params.u_shift_deci;
   };
   u_scale_slider v_shift_slider {
      y =><-.u_shift_slider.y + <-.u_shift_slider.height + 5;
      title = "MABIRDE_SHIFT_V";
      value =><-.bird_eye_params.v_shift;
      min =><-.bird_eye_params.v_shift_min;
      max =><-.bird_eye_params.v_shift_max;
      decimalPoints =><-.bird_eye_params.v_shift_deci;
   };
};

MAmodule MAbird_eye {
   Mesh+Node_Data &fld_in<NEportLevels={2,1}>;
   MAbird_eye_params &bird_eye_params<NEportLevels={2,1}>;

   MADVsurf_plot+nosave surf_plot {
      in =><-.fld_in;
      component = 0;
      nspace = 2;
      &scale =><-.bird_eye_params.scale;
      &offset =><-.bird_eye_params.offset;
   };
   // for Bugs
   GMOD.copy_on_change set_uniform {
      trigger =><-.surf_plot.out.nnodes;
      input = 1;
      output+nres =><-.surf_plot.out.grid_type;
   }; 
   MADVread_image read_image {  
      filename =><-.bird_eye_params.texture_file;
      flip = 0;
      format = 0;
   };
   macro mesh_uv {
      Mesh+IPort2 &in => <-.surf_plot.out;
      int+IPort2  uv_switch => <-.bird_eye_params.uv_switch;
      int+IPort2  u_flip    => <-.bird_eye_params.u_flip;
      int+IPort2  v_flip    => <-.bird_eye_params.v_flip;
      float+IPort2 u_shift  => <-.bird_eye_params.u_shift;
      float+IPort2 v_shift  => <-.bird_eye_params.v_shift;
      float+IPort2 u_scale  => <-.bird_eye_params.u_scale;
      float+IPort2 v_scale  => <-.bird_eye_params.v_scale;

      group u0 {
         float values[in.nnodes][1] => u_shift
              + u_scale*((in.coordinates.values[][0]
              - in.coordinates.min_vec[0]) / 
               (in.coordinates.max_vec[0] - in.coordinates.min_vec[0]));
      };
      group v0 {
         float values[in.nnodes][1] => v_shift
              + v_scale*((in.coordinates.values[][1]
              - in.coordinates.min_vec[1]) / 
               (in.coordinates.max_vec[1] - in.coordinates.min_vec[1]));
      };
      group u1 {
         float values[in.nnodes][1] => u_shift
              + u_scale*((in.coordinates.max_vec[0]
              - in.coordinates.values[][0]) /
               (in.coordinates.max_vec[0] - in.coordinates.min_vec[0]));
      };
      group v1 {
         float values[in.nnodes][1] => v_shift
              + v_scale*((in.coordinates.max_vec[1]
              - in.coordinates.values[][1]) /
               (in.coordinates.max_vec[1] - in.coordinates.min_vec[1]));
      };
      MADVswitch  switch_u {
         in => {u0, u1};
         index =>u_flip;
      };
      MADVswitch  switch_v {
         in => {v0, v1};
         index =>v_flip;
      };
      MADVswitch  switch_uv {
         in => {switch_u.out, switch_v.out};
         index =>uv_switch;
      };
      MADVswitch  switch_vu {
         in => {switch_v.out, switch_u.out};
         index =>uv_switch;
      };
      Node_Data uv_data {
         nnodes => <-.in.nnodes;
         nnode_data = 1;
         node_data {
            veclen = 2;
            id = 670;
            values => combine_array(switch_uv.out.values,switch_vu.out.values);
         };
      };
      Mesh+Node_Data+OPort2 &out => merge(uv_data, in);
   };
   fld_out => mesh_uv.out;
   olink+nres fld2_out => switch(bird_eye_params.texture,read_image.out);
};
