/*
	"$Id: //depot/express/fcs70/v/MicroAVS/DV/MAbrick.v#1 $"
			Copyright (c) 1999 by
				KGT Inc.
			All Rights Reserved

	This software  comprises  unpublished confidential information of
	KGT Inc. and may not be used, copied or made  available to anyone,
	except in accordance with the license under which it is furnished.

	This file is under CVS control at KGT in:
	$Source:$
*/
MAparams MAbrick3D_params {
   int+nosave def_x =;
   int+nosave def_y =;
   int+nosave def_z =;
   int x;
   int y;
   int z; 
   boolean flip_x = 0;
   boolean flip_y = 0;
   boolean flip_z = 0;
   boolean draw_sides = 0;
   init_commands = "";
   reset_commands = 
    "brick3D_params.x=brick3D_params.def_x;"
   +"brick3D_params.y=brick3D_params.def_y;"
   +"brick3D_params.z=brick3D_params.def_z;"
   +"brick3D_params.flip_x=0;"
   +"brick3D_params.flip_y=0;"
   +"brick3D_params.flip_z=0;"
   +"brick3D_params.draw_sides=0;"
   ;
};

MAmacroUI MAbrick3DUI {
   MAbrick3D_params+IPort2 &brick3D_params;
   Mesh_Unif+Dim3+Node_Data+IPort2 &fld_in;
   
   height => brick3D_panel.height;
   MAUIframe brick3D_panel {
      parent => <-.parent;
      y => <-.y;
      height => draw_sides_toggle.y + draw_sides_toggle.height + 15;
   };
   MAUIslider2 X_slider {
      parent =><-.brick3D_panel;
      x = 5;
      y = 5;
      min = 0;
      max => <-.fld_in.dims[0]-1;
      value =><-.brick3D_params.x;
      title = "X";
      min_oonly = 1;
      max_oonly = 1;
      mode = "integer";
      decimalPoints = 0;
   };
   MAUIslider2 Y_slider {
      parent =><-.brick3D_panel;
      x = 5;
      y =><-.X_slider.y + <-.X_slider.height + 5;
      min = 0;
      max => <-.fld_in.dims[1]-1;
      value =><-.brick3D_params.y;
      title = "Y";
      min_oonly = 1;
      max_oonly = 1;
      mode = "integer";
      decimalPoints = 0;
   };
   MAUIslider2 Z_slider {
      parent =><-.brick3D_panel;
      x = 5;
      y =><-.Y_slider.y + <-.Y_slider.height + 5;
      min = 0;
      max => <-.fld_in.dims[2]-1;
      value =><-.brick3D_params.z;
      title = "Z";
      min_oonly = 1;
      max_oonly = 1;
      mode = "integer";
      decimalPoints = 0;
  }; 
  MAUItoggle flipx {
      parent =><-.brick3D_panel;
      label = "MABRI3D_FLIPX";
      set => <-.brick3D_params.flip_x;
      x = 5;
      y =><-.Z_slider.y + <-.Z_slider.height + 5;
      width = 150;
  };
  MAUItoggle flipy {
      parent =><-.brick3D_panel;
      label = "MABRI3D_FLIPY";
      set => <-.brick3D_params.flip_y;
      x = 5;
      y =><-.flipx.y + <-.flipx.height + 5;
      width = 150;
  }; 
  MAUItoggle flipz {
      parent =><-.brick3D_panel;
      label = "MABRI3D_FLIPZ";
      set => <-.brick3D_params.flip_z;
      x = 5;
      y =><-.flipy.y + <-.flipy.height + 5;
      width = 150;
  };
  MAUItoggle draw_sides_toggle {
      parent =><-.brick3D_panel;
      label = "MABRI3D_DRAWSIDES";
      set => <-.brick3D_params.draw_sides;
      x = 5;
      y =><-.flipz.y + <-.flipz.height + 5;
      width = 150;
  };
};
   
MAmodule MAbrick3D {
   Mesh_Unif+Dim3+Node_Data+IPort2 &fld_in;
   MAbrick3D_params+IPort2 &brick3D_params;
   MAset_param set_x {
      trigger+nres => is_valid(fld_in.dims[0]);
      in_value+nres => fld_in.dims[0]/2;
      def_value => <-.brick3D_params.def_x;
      value => <-.brick3D_params.x;
   };
   MAset_param set_y {
      trigger+nres => is_valid(fld_in.dims[1]);
      in_value+nres => fld_in.dims[1]/2;
      def_value => <-.brick3D_params.def_y;
      value => <-.brick3D_params.y;
   };
   MAset_param set_z {
      trigger+nres => is_valid(fld_in.dims[2]);
      in_value+nres => fld_in.dims[2]/2;
      def_value => <-.brick3D_params.def_z;
      value => <-.brick3D_params.z;
   };
   MADVexcavate_brick3d brick3D {
      in => <-.fld_in;
      x => <-.brick3D_params.x;
      y => <-.brick3D_params.y;
      z => <-.brick3D_params.z;
      flip_x => <-.brick3D_params.flip_x;
      flip_y => <-.brick3D_params.flip_y;
      flip_z => <-.brick3D_params.flip_z;
      draw_sides => <-.brick3D_params.draw_sides;
   };
   fld_out => brick3D.out;
};
