/*
	"$Id: //depot/express/fcs70/v/MicroAVS/DV/MAcombvt.v#1 $"
			Copyright (c) 1997 by
				KGT Inc.
			All Rights Reserved

	This software  comprises  unpublished confidential information of
	KGT Inc. and may not be used, copied or made  available to anyone,
	except in accordance with the license under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/MicroAVS/DV/MAcombvt.v#1 $
*/
MAparams MAcombine_vect_params {
   int veclen;
   int components[];
   int sub_components[4];
   int selectedItem;

/* Add */
   int+nres select_opt = 0;
   int+nres x_element  = 0;
   int+nres y_element  = 0;
   int+nres z_element  = 0;
   int+nres null_flag  = 0;
   string+nres labels[] => <-.<-.Modules.MAcombine_vect.combine_vect_opt.Params.labels;
/* Add */

};
MAcombine_vect_params MAcombine_vect3d_params {
   veclen = 3;
   components[] = {0, 1, 2};
   sub_components[4] = 0;
   selectedItem	= 1;
   init_commands = "";
   reset_commands =
       "combine_vect_params.veclen=3;"
      +"combine_vect_params.components[]={0,1,2};"
      +"combine_vect_params.selectedItem=1;"
      +"combine_vect_params.select_opt=0;"
      +"combine_vect_params.x_element=0;"
      +"combine_vect_params.y_element=0;"
      +"combine_vect_params.z_element=0;"
      +"combine_vect_params.null_flag=0;"
      ;
};
MAcombine_vect_params MAcombine_vect2d_params {
   veclen = 2;
   components[] = {0, 1};
   sub_components[4] = 0;
   selectedItem = 0;
   init_commands = "";
   reset_commands =
       "combine_vect_params.veclen=2;"
      +"combine_vect_params.components[]={0,1};"
      +"combine_vect_params.selectedItem=0;"
      +"combine_vect_params.select_opt=0;"
      +"combine_vect_params.x_element=0;"
      +"combine_vect_params.y_element=0;"
      +"combine_vect_params.z_element=0;"
      +"combine_vect_params.null_flag=0;"
      ;
};

MAmacroUI+nosave MAcombine_vectUI {
   MAcommon_params+IPort2 &params;
   MAcombine_vect_params+IPort2 &combine_vect_params;
   ilink fld_in;
   height => combine_vect_panel.height;

   MADVnode_data_labels node_or_cell_data_labels {
      in => <-.fld_in;
      int+nres ncomp => in.nnode_data;
   };
   MAUIframe combine_vect_panel {
      parent => <-.parent;
      y => <-.y;
      height => switch((set_vector_element.set + 1),(combine_vect_panel_fix.y + combine_vect_panel_fix.height +10),(combine_vect_panel_opt.y + combine_vect_panel_opt.height +10));
/*
      height => optionBoxLabel.height + optionBoxLabel.y + 10;
*/

   };

/* add  for MicroAVS5.0*/
   MAUIlabel combine_vect_title{
      parent => <-.combine_vect_panel;
      y = 5;
      width => <-.combine_vect_panel.clientWidth;
      label = "MACOMBV_OPT_TITLE";
   };
   MAUItoggle set_vector_element{
      parent => <-.combine_vect_panel;
      y => <-.combine_vect_title.y + <-.combine_vect_title.height;
      label = "MACOMBV_OPT_ON";
      set => combine_vect_params.select_opt;
   };

   MAUIpanel combine_vect_panel_fix{
      parent => <-.combine_vect_panel;
      x = 5;
      y => <-.set_vector_element.y + <-.set_vector_element.height;
      width => <-.combine_vect_panel.clientWidth - 10;
      height => ((<-.optionBoxLabel.height + <-.optionBoxLabel.y) + 10);
      visible => (<-.combine_vect_params.select_opt != 1);
   };

   MAUIpanel combine_vect_panel_opt{
      x = 5;
      y => (set_vector_element.y + set_vector_element.height);
      parent => <-.combine_vect_panel;
      width => <-.combine_vect_panel.clientWidth - 10;
      height => <-.comb_vect_opt_UI.UIpanel.height;
      visible => <-.combine_vect_params.select_opt;
   };

   int+nosave set=> combine_vect_params.select_opt;
   GMOD.parse_v select_panel{
      v_commands = "$push -usr\n"
                  +"set= set_vector_element.set;\n"
                  +"$pop\n";
      trigger => <-.set_vector_element.do;
      on_inst = 0;
      relative => <-;
   };


   MAmacroUI comb_vect_opt_UI{
      MAcombine_vect_params+IPort2+nres &combine_vect_params => <-.<-.<-.Params.combine_vect_params;
      parent => <-.combine_vect_panel_opt;
      string+nres labels<NEportLevels={2,0}>[] => combine_vect_params.labels;
      group element {
         int+nres x_element<NEportLevels={2,1}> => <-.X_comp.selectedItem;
         int+nres y_element<NEportLevels={2,1}> => <-.Y_comp.selectedItem;
         int+nres z_element<NEportLevels={2,1}> => <-.Z_comp.selectedItem;
         int+nres set_x_elt<NEportLevels={2,1}> => <-.combine_vect_params.x_element;
         int+nres set_y_elt<NEportLevels={2,1}> => <-.combine_vect_params.y_element;
         int+nres set_z_elt<NEportLevels={2,1}> => <-.combine_vect_params.z_element;
         GMOD.parse_v set_x_element {
            v_commands = "$push -usr\n"
                        +"set_x_elt = x_element;\n"
                        +"$pop\n";
            trigger => <-.x_element;
            on_inst = 0;
            relative => <-;
         };
         GMOD.parse_v set_y_element {
            v_commands = "$push -usr\n"
                        +"set_y_elt = y_element;\n"
                        +"$pop\n";
            trigger => <-.y_element;
            on_inst = 0;
            relative => <-;
         };
         GMOD.parse_v set_z_element {
            v_commands = "$push -usr\n"
                        +"set_z_elt = z_element;\n"
                        +"$pop\n";
            trigger => <-.z_element;
            on_inst = 0;
            relative => <-;
         };
      };
      MAUIpanel UIpanel {
         parent => <-.parent;
         x = 0;
         y = 0;
         width => parent.clientWidth;
         height => (Z_comp.y + Z_comp.height);
      };
      MAUIlabel vector_components_label {
         parent => <-.UIpanel;
         x => (UIpanel.width - width)/2;
         y = 15;
         width => UIpanel.width;
         label ="MACOMBV_OPT_SET";
      };
      label_cmd label_cmd {
         labels => <-.labels;
         cmd[];
      };
      MAUIoptionMenu X_comp {
         parent => <-.UIpanel;
         x            => (parent.clientWidth - width)/2;
         y => vector_components_label.y + vector_components_label.height + 10;
         cmdList      => <-.label_cmd.cmd;
         selectedItem = 0;
         label ="MACOMBV_OPT_1V";
      };
      MAUIoptionMenu Y_comp {
         parent => <-.UIpanel;
         x            => X_comp.x;
         y            => X_comp.y + X_comp.height + 10;
         cmdList      => <-.label_cmd.cmd;
         selectedItem = 0;
         label ="MACOMBV_OPT_2V";
   };
      MAUIoptionMenu Z_comp {
         parent => <-.UIpanel;
         x            => X_comp.x;
         y            => Y_comp.y + Y_comp.height + 10;
         cmdList      => <-.label_cmd.cmd;
         selectedItem = 0;
         label ="MACOMBV_OPT_3V";
      };
   };


/* add  for MicroAVS5.0*/

   GMOD.copy_on_change for_reset { // (;.;)
      input => <-.params.reset * 3;
      output => optionBoxLabel.max;
      on_inst = 0;
   };
   MAUIoptionBoxLabel optionBoxLabel {
/*
      parent => <-.combine_vect_panel;
*/
      parent => <-.combine_vect_panel_fix;
      x = 5;
      y = 10;
      labels => <-.node_or_cell_data_labels.labels;
      string titles[] => { "MACOMBV_DEFAULT", "MACOMBV_MORE",
                           "MACOMBV_2V",      "MACOMBV_3V"   };
      title => titles[UIoptionBox.numSelectedItems];
      &selectedItems => <-.combine_vect_params.components;
      max = 3;
      GMOD.parse_v set_veclen {
         string cmds[] = { "combine_vect_params.veclen=;\n",
                           "combine_vect_params.veclen=1;\n",
                           "combine_vect_params.veclen=2;\n",
                           "combine_vect_params.veclen=3;\n" };
         v_commands => "$push -usr\n"
                      +cmds[<-.UIoptionBox.numSelectedItems]
                      +"$pop\n";
         on_inst = 0;
         relative => <-.<-;
      };
   };
};
MAcombine_vectUI MAcombine_cell_vectUI {
   MADVcell_data_labels node_or_cell_data_labels {
      in => <-.fld_in;
      int+nres ncomp => array_size(labels);
   };
};

MAmodule MAcombine_vect {
   MAcombine_vect_params+IPort2 &combine_vect_params;

   macro combine_vect {
      MAcombine_vect_params+IPort2 &combine_vect_params
         => <-.combine_vect_params;
      ilink fld_in => <-.fld_in;

      MADVextr_vector extr_vector {
         in => <-.fld_in;
         veclen => combine_vect_params.veclen;
         components
          => combine_vect_params.components[0:combine_vect_params.veclen-1];
         sub_components[veclen]
          => combine_vect_params.sub_components[0:combine_vect_params.veclen-1];
      };
      MADVcombine_mesh_and_data comb_mesh_and_data {
         in_mesh => fld_in;
         in_nd => extr_vector.out;
      };
      olink fld_out => switch(combine_vect_params.veclen > 1,
                              comb_mesh_and_data.out);
   };

/* add  for MicroAVS5.0*/

   macro combine_vect_opt {
      MAcombine_vect_params+IPort2+nres &combine_vect_params
         => <-.combine_vect_params;
      Mesh+Node_Data+Iparam &in_fld<NEportLevels={2,1}> => <-.fld_in;
      group+nres Params{
         MADVnode_data_labels MADVnode_data_labels {
            in<NEportLevels={3,0}> => <-.<-.in_fld;
         };
//         ilink in_dum => <-.set_dummy_data.dummy_data;
         string labels<NEportLevels=1>[] => concat_array("MACOMBV_OPT_NON"
                                                        ,MADVnode_data_labels.labels);
         int ncomp<NEportLevels=1> => MADVnode_data_labels.ncomp;
         int+nres x_element<NEportLevels={2,1}> => <-.<-.combine_vect_params.x_element;
         int+nres y_element<NEportLevels={2,1}> => <-.<-.combine_vect_params.y_element;
         int+nres z_element<NEportLevels={2,1}> => <-.<-.combine_vect_params.z_element;
         MADV_Param_extract_scalar ExtractScalarParam_X<export_all=2> {
            vector<NEportLevels={2,2}> => <-.x_element;
            component<NEportLevels={2,2}> = 0;
         };
         MADV_Param_extract_scalar ExtractScalarParam_Y<export_all=2> {
            vector<NEportLevels={2,2}> => <-.y_element;
            component<NEportLevels={2,2}> = 0;
         };
         MADV_Param_extract_scalar ExtractScalarParam_Z<export_all=2> {
            vector<NEportLevels={2,2}> => <-.z_element;
            component<NEportLevels={2,2}> = 0;
         };
      };
/*
      group set_dummy_data{
         int set => is_valid(in_fld.node_data[0]);
         GMOD.parse_v parse_v_set {
            v_commands => switch((<-.set+1), " ", "values=0;\n");
            trigger => <-.set;
            on_inst = 0;
            sync = 1;
            relative => <-.dummy_data.node_data[0];
         };
         Node_Data+Oparam dummy_data<NEportLevels={0,2}>{
            nnode_data = 1;
            nnodes => <-.<-.in_fld.nnodes;
            node_data = {
               {
                  labels="MACOMBV_OPT_NON",,veclen=1,,,,,,,,
               }};
         };
      };
*/

      MAextr_vector comb_node{
         select_opt => <-.combine_vect_params.select_opt;
         x_element  => <-.combine_vect_params.x_element;
         y_element  => <-.combine_vect_params.y_element;
         z_element  => <-.combine_vect_params.z_element;
         in         => <-.in_fld;
      };
/*
      group comb_node {
         ilink in_fld<NEportLevels={2,1}> => <-.in_fld;
         ilink in_dum<NEportLevels={2,1}> => <-.set_dummy_data.dummy_data;
         prim x_val[in_fld.nnodes][1] => switch((<-.combine_vect_params.x_element == 0) + 1
                                                ,in_fld.node_data[<-.combine_vect_params.x_element-1].values
                                                ,in_dum.node_data[0].values
                                               );
         prim y_val[in_fld.nnodes][1] => switch((<-.combine_vect_params.y_element == 0) + 1
                                                ,in_fld.node_data[<-.combine_vect_params.y_element-1].values
                                                ,in_dum.node_data[0].values
                                               );
         prim z_val[in_fld.nnodes][1] => switch((<-.combine_vect_params.z_element == 0) + 1
                                                ,in_fld.node_data[<-.combine_vect_params.z_element-1].values
                                                ,in_dum.node_data[0].values
                                               );
         prim out_values[in_fld.nnodes][3] => combine_array(x_val,y_val,z_val);
         Node_Data out<NEportLevels={1,2}> {
            node_data = {
               {
                  null_flag => <-.<-.<-.combine_vect_params.null_flag,null_value=0,veclen=3,values=><-.<-.out_values,,,,,
               }};
            nnode_data = 1;
            nnodes => in_fld.nnodes;
         };
      };

      group set_null_flag{
         prim+nosave+nres min        => <-.comb_node.out.node_data[0].min;
         prim+nosave+nres max        => <-.comb_node.out.node_data[0].max;
         int+nosave+nres  null_flag  => <-.combine_vect_params.null_flag;
         string+nosave+nres commands = "$push -usr\n"
                                       + "null_flag = ((min == 0) && (max == 0));\n"
                                       +"$pop\n";
         int+nosave+nres index       => ((is_valid(<-.min) == 1) && (is_valid(<-.max)) == 1);
         GMOD.parse_v parse_v {
            v_commands => switch(index,<-.commands);
            trigger[]  => {<-.min,<-.max};
            on_inst    = 0;
            relative   => <-;
         };

      };
*/

      MADVcombine_mesh_and_data comb_mesh_and_data {
         in_mesh+Iparam => <-.in_fld;
         in_nd+Iparam => <-.comb_node.out;
      };
      olink fld_out<NEportLevels={1,2}> => .comb_mesh_and_data.out;

   };
   MADVswitch MADVswitch{
      in => {<-.combine_vect.fld_out,<-.combine_vect_opt.fld_out};
      index => combine_vect_params.select_opt;
   };
/* add  for MicroAVS5.0*/

   fld_out => MADVswitch.out;
};
