/*
	"$Id: //depot/express/fcs70/v/MicroAVS/DV/MAcontou.v#1 $"
			Copyright (c) 1997 by
				KGT Inc.
			All Rights Reserved

	This software  comprises  unpublished confidential information of
	KGT Inc. and may not be used, copied or made  available to anyone,
	except in accordance with the license under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/MicroAVS/DV/MAcontou.v#1 $
*/
MAparams MAcontour_params {
   float+nosave def_level_min =;
   float+nosave def_level_max =;
   float level_min =;
   float level_max =;
   int   level_min_deci = 2;
   int   level_max_deci = 2;
   boolean+nosave fit = 0; // init zero
   init_commands = "";
   reset_commands =
        "contour_params.level_min=contour_params.def_level_min;"
       +"contour_params.level_max=contour_params.def_level_max;"
       +"contour_params.level_min_deci=2;"
       +"contour_params.level_max_deci=2;"
       +"contour_params.fit=1;"
       ;
};
MAmacroUI MAcontourUI {
   MAcontour_params+IPort2 &contour_params;
   Mesh+Node_Data+IPort2 &fld_in;

   height => contour_panel.height;
   MAUIframe contour_panel {
      parent => <-.parent;
      y => <-.y;
      height => minmaxLevelUI.y + minmaxLevelUI.height + 5;
   };
   // MicroAVS 2.0 Compatibility begin
   $include v/MicroAVS/DV/compat2.v
   // MicroAVS 2.0 Compatibility end
   MADVminmaxLevelUI minmaxLevelUI {
      parent         => <-.contour_panel;
      fld_in         => <-.fld_in;
      level_min      => <-.contour_params.level_min;
      level_max      => <-.contour_params.level_max;
      level_min_deci => <-.contour_params.level_min_deci;
      level_max_deci => <-.contour_params.level_max_deci;
      fit            => <-.contour_params.fit;
   };
};

MAmodule MAcontour {
   MAcontour_params+IPort2 &contour_params;

   MAset_param set_level_min {
      trigger+nres   => is_valid(fld_in.node_data[0].min);
      in_value+nres  => fld_in.node_data[0].min;
      def_value      => contour_params.def_level_min;
      value          => contour_params.level_min;
   };
   MAset_param set_level_max {
      trigger+nres   => is_valid(fld_in.node_data[0].max);
      in_value+nres  => fld_in.node_data[0].max;
      def_value      => contour_params.def_level_max;
      value          => contour_params.level_max;
   };
   MADVcontour contour {
      in => <-.fld_in;
      contour_comp = 0;
      map_comp = {0};
      level_min => <-.contour_params.level_min - 0.000001;
      level_max => <-.contour_params.level_max + 0.000001;
   };
   fld_out => contour.out;
};
