/*
	"$Id: //depot/express/fcs70/v/MicroAVS/DV/MAcrop.v#1 $"
			Copyright (c) 1999 by
				KGT Inc.
			All Rights Reserved

	This software  comprises  unpublished confidential information of
	KGT Inc. and may not be used, copied or made  available to anyone,
	except in accordance with the license under which it is furnished.

	This file is under CVS control at KGT in:
	$Source:$
*/
//
// Crop
//
// NOTES: 3D only
//
MAparams MAcrop_params {
   int        x_min;
   int        y_min;
   int        z_min;
   int        x_max;
   int        y_max;
   int        z_max;
   int+nosave min[] => { x_min, y_min, z_min };
   int+nosave max[] => { x_max, y_max, z_max };
   int+nosave def_x_min;
   int+nosave def_y_min;
   int+nosave def_z_min;
   int+nosave def_x_max;
   int+nosave def_y_max;
   int+nosave def_z_max;
   int+nosave def_min[] => { def_x_min, def_y_min, def_z_min };
   int+nosave def_max[] => { def_x_max, def_y_max, def_z_max };
   init_commands  = "";
   reset_commands =
       "crop_params.x_min=crop_params.def_x_min;"
      +"crop_params.y_min=crop_params.def_y_min;"
      +"crop_params.z_min=crop_params.def_z_min;"
      +"crop_params.x_max=crop_params.def_x_max;"
      +"crop_params.y_max=crop_params.def_y_max;"
      +"crop_params.z_max=crop_params.def_z_max;"
      ;
};

MAmacroUI MAcropUI {
   MAcrop_params+IPort2 &crop_params;
   Mesh_Struct+Node_Data+IPort2 &fld_in;
   int+nres size => array_size(fld_in.dims);

   height => crop_panel.height;

   int slider_height = 32;
   int max_height => (2 * size) * (slider_height + 5);
   MAUIframe crop_panel {
      parent => <-.parent;
      y => <-.y;
      height => ((<-.set_minmax_button.y + <-.set_minmax_button.height) + 15);
   };
   MAUIslider min_slider[size] {
      int idx => index_of(min_slider);
      string titles[] = { "I", "J", "K" } + " min"; //later
      title => titles[idx];
      parent => <-.crop_panel;
      x = 5;
      y => 5 + (2 * (height + 5)) * idx;
      height => <-.slider_height;
      max => <-.fld_in.dims[idx]-1;
      value+nres+IPort2 => <-.crop_params.min[idx];
      mode = 1;
   };
   int min_height => min_slider[0].y + min_slider[0].height + 5;
   MAUIslider max_slider[size] {
      int idx => index_of(max_slider);
      string titles[] = { "I", "J", "K" } + " max"; //later
      title => titles[idx];
      parent => <-.crop_panel;
      x = 5;
      y => <-.min_height + (2 * (height + 5)) * idx;
      height => <-.slider_height;
      max => <-.fld_in.dims[idx]-1;
      value+nres+IPort2 => <-.crop_params.max[idx];
      mode = 1;
   };
   GMOD.copy_on_change check_minmax[size] {
      int idx => index_of(check_minmax);
      on_inst = 0;
      input+nres => switch((min_slider[idx].value >= max_slider[idx].value),
                            max_slider[idx].value-1);
      output => <-.min_slider[idx].value;
   };
   MAUIbutton set_minmax_button{
      x      = 5;
      y      => <-.max_height+ 10;
      parent => <-.crop_panel;
      label  = "MABRI3D_SET_MINMAX";
   };
   GMOD.parse_v set_mimmax{
      v_commands = "$push \n"
                  +"x_min = def_x_min;\n"
                  +"y_min = def_y_min;\n"
                  +"z_min = def_z_min;\n"
                  +"x_max = def_x_max;\n"
                  +"y_max = def_y_max;\n"
                  +"z_max = def_z_max;\n"
                  +"$pop \n";
      trigger    => set_minmax_button.do;
      on_inst    = 0;
      relative   => <-.crop_params;
   };
};

MAmodule MAcrop {
   MAcrop_params+IPort2 &crop_params;
   Mesh_Struct+Node_Data+IPort2 &fld_in;

   MAset_param set_x_min {
      trigger+nres  => is_valid(fld_in.dims[0]);
      in_value+nres => 0;
      def_value     => <-.crop_params.def_x_min;
      value         => <-.crop_params.x_min;
   };
   MAset_param set_y_min {
      trigger+nres  => is_valid(fld_in.dims[1]);
      in_value+nres => 0;
      def_value     => <-.crop_params.def_y_min;
      value         => <-.crop_params.y_min;
   };
   MAset_param set_z_min {
      trigger+nres  => is_valid(fld_in.dims[2]);
      in_value+nres => 0;
      def_value     => <-.crop_params.def_z_min;
      value         => <-.crop_params.z_min;
   };
   MAset_param set_x_max {
      trigger+nres  => is_valid(fld_in.dims[0]);
      in_value+nres => <-.fld_in.dims[0]-1;
      def_value     => <-.crop_params.def_x_max;
      value         => <-.crop_params.x_max;
   };
   MAset_param set_y_max {
      trigger+nres  => is_valid(fld_in.dims[1]);
      in_value+nres => <-.fld_in.dims[1]-1;
      def_value     => <-.crop_params.def_y_max;
      value         => <-.crop_params.y_max;
   };
   MAset_param set_z_max {
      trigger+nres  => is_valid(fld_in.dims[2]);
      in_value+nres => <-.fld_in.dims[2]-1;
      def_value     => <-.crop_params.def_z_max;
      value         => <-.crop_params.z_max;
   };

   MADVcrop crop {
     in => <-.fld_in;
     min => <-.crop_params.min;
     max => <-.crop_params.max;
   };
   fld_out => crop.out;
};
