/*
			Copyright (c) 1998 by
				KGT Inc.
			All Rights Reserved

	This software  comprises  unpublished confidential information of
	KGT Inc. and may not be used, copied or made  available to anyone,
	except in accordance with the license under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/MicroAVS/DV/MAcut.v#1 $
*/
//
// MAcut_plane with MA_new_slice_plane
//

MAnew_slice_plane MAnew_slice_plane2{
   MADVslice_gen{
      in    => ;
      plane => ;
   };
   switch_plane{
      in    => ;
      index => ;
   };
   fld_out => .slice_plane.out_fld;
};

MAmacro MACut {
	ilink in_fld;
	ilink in_pln;
	MADV_Param_cut+IPort2 &param;

	int+nres has_node_data => (is_valid(in_fld.nnode_data) && in_fld.nnode_data > 0);

	MADVplane_dist MADVplane_dist{
		in => in_fld;
		plane => in_pln;
	};
	MADVcomb_comp MADVcomb_comp{
		comp1+nres=> switch(<-.has_node_data, init_array(in_fld.nnode_data, 0, in_fld.nnode_data-1));
		comp2={0};
		nd1 => switch(<-.has_node_data, in_fld);
		nd2 => switch(<-.has_node_data, MADVplane_dist.out);
	};
	MADVcomb_mesh_and_data MADVcomb_mesh_and_data {
		in_mesh => in_fld;
		in_nd => switch(<-.has_node_data+1, <-.MADVplane_dist.out, <-.MADVcomb_comp.out);
	};
	MADVcut MADVcut {
		in => MADVcomb_mesh_and_data.out;
		cut_comp+nres => switch(<-.has_node_data+1, 0, in_fld.nnode_data);
		map_comp+nres => switch(<-.has_node_data, param.component);
		level => MADVplane_dist.dist+param.dist;
		&above => param.above;
		cell_data => param.cell_data;
	};
	olink out_fld => MADVcut.out;
};


MAparams MAcut_plane_params{
   int cut_on = 0;
   int above  = 0;
   MAnew_slice_plane_params new_slice_plane_params1;
   MAnew_slice_plane_params new_slice_plane_params2;
};

MAmacro MAcut {
    ilink in_field<export_all=1>;
    ilink in_plane<export_all=1>;

    MADV_Param_cut+Port CutParam<export_all=2> {
	component = {0};
	dist = 0.0;
	above = 1;
	cell_data = {0};
    };

    int has_cell_data => (MADVcell_data_labels.ncomp > 0);
    MACut Cut {
	param => CutParam;
	in_fld => in_field;
	in_pln => in_plane;
	MADVcut {
		cell_data => switch(has_cell_data, param.cell_data);
	};
    };
    MADVnode_data_labels MADVnode_data_labels {
	    in => in_field;
	    int+nres  ncomp => in.nnode_data;
    };
    MADVcell_data_labels MADVcell_data_labels {
	    in => in_field;
    };
    olink out_fld<export_all=2> => Cut.out_fld;
};


/*  cut module  */

MAmacro MAcut_plane {
   ilink+nosave in_field<export_all=1>;
   Field+nosave Dfield;
   ilink+nosave in_cut_fld<export_all=1> => switch((cut_plane_params.cut_on + 1), Dfield, in_field);
   ilink+nosave in_pick;
   MAcut_plane_params &cut_plane_params;
   GMOD.parse_v set_Dfield{
      v_commands    = "$push\n Dfield = in_field;\n $pop\n"
                    + "$push\n slice_plane1.fld_in => <-.in_cut_fld;\n $pop\n"
                    + "$push\n slice_plane2.fld_in => <-.in_cut_fld;\n $pop\n"
                    + "$push\n set_Dfield.active = 0;\n $pop\n";
      on_inst       = 0;
      active+nosave => is_valid(<-.in_field.nnodes);
      trigger       => is_valid(<-.in_field.nnodes);
      relative      => <-.<-;
   };

   MAnew_slice_plane2 slice_plane1{
	new_slice_plane_params => <-.cut_plane_params.new_slice_plane_params1;
        in_pick => <-.in_pick;
	fld_in;
        slice_plane{
           plane{
              plane_cent2_z => (((fld_in.coordinates.max_vec[2] + fld_in.coordinates.min_vec[2]) * 0.5)
                              + ((fld_in.coordinates.max_vec[2] - fld_in.coordinates.min_vec[2]) * 0.25));
           };
        };
   };
   MAnew_slice_plane2 slice_plane2{
	new_slice_plane_params => <-.cut_plane_params.new_slice_plane_params2;
        in_pick => <-.in_pick;
	fld_in;
        slice_plane{
           plane{
              plane_cent2_z => (((fld_in.coordinates.max_vec[2] + fld_in.coordinates.min_vec[2]) * 0.5)
                              - ((fld_in.coordinates.max_vec[2] - fld_in.coordinates.min_vec[2]) * 0.25));
           };
        };
   };
   MAcut cut1{
      CutParam{
         above => (<-.<-.cut_plane_params.above == 1);
      };
      in_field => <-.in_cut_fld;
      in_plane => <-.slice_plane1.fld_out;
   };
   MAcut cut2{
      CutParam{
         above => (<-.<-.cut_plane_params.above == 0);
      };
      in_field => <-.cut1.out_fld;
      in_plane => <-.slice_plane2.fld_out;
   };
   MicroAVS.MAdataObjectLite Plane_Axis_Obj{
      child_objs => {<-.slice_plane1.out_slice_obj,<-.slice_plane1.out_axis_obj
                    ,<-.slice_plane2.out_slice_obj,<-.slice_plane2.out_axis_obj};
      Obj{
         visible => <-.<-.cut_plane_params.cut_on;  /* plane & axis̕\ؑւ */
         name = "NOOBJLIST cut plane and axis";
      };
   };
   MicroAVS.MAdataObjectLite DObj{
      Obj.name = "NOOBJLIST dummy of cut plane and axis";
   };
   GMOD.parse_v set_plane_points {
      on_inst      =  0;
      trigger+nres => <-.cut_plane_params.cut_on;
      active       =  1;
      relative     => <-;
      v_commands   => "$push\n cut1.in_plane => <-.slice_plane1.fld_out;\n $pop\n"
                     +"$push\n cut2.in_plane => <-.slice_plane2.fld_out;\n $pop\n"
                     +"$push\n set_plane_points.active = 0;\n $pop\n";
   };
   olink out_fld<export_all=2> => switch((cut_plane_params.cut_on + 1), in_field ,cut2.out_fld);  /* f[^Jbg邵Ȃ̐ؑւ */
   olink+nres plane_axis_obj   => switch((cut_plane_params.cut_on + 1), DObj.obj ,Plane_Axis_Obj.obj);
};

