/*
	"$Id: //depot/express/fcs70/v/MicroAVS/DV/MAdownsz.v#1 $"
			Copyright (c) 1997 by
				KGT Inc.
			All Rights Reserved

	This software  comprises  unpublished confidential information of
	KGT Inc. and may not be used, copied or made  available to anyone,
	except in accordance with the license under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/MicroAVS/DV/MAdownsz.v#1 $
*/
//
// Downsize
//
MAparams MAdownsize_params {
   int downsize =;
   int max =;
   int+nosave def_downsize =;
   int+nosave def_max =;
   init_commands = "";
   reset_commands =
      "downsize_params.downsize=max_array({1, downsize_params.max/2});"
   ;
   // NOTES:
   // on Unix, set UIslider.value =; but set value = min; never undefined
   // on PC  , set UIslider.value =; is ok.
};

MAmacroUI MAdownsizeUI {
   MAdownsize_params+IPort2 &downsize_params;

   height => downsize_panel.height;
   MAUIframe downsize_panel {
      parent => <-.parent;
      y => <-.y;
      height => downsize_downsize_slider.y
              + downsize_downsize_slider.height + 5;
   };
   MAUIslider downsize_downsize_slider {
      title = "MADOWN_SIZE";
      parent => <-.downsize_panel;
      x = 5;
      y = 5;
      min = 1;
      max => <-.downsize_params.max;
      value => <-.downsize_params.downsize;
      decimalPoints = 0;
   };
};

MAmodule MAdownsize {
   MAdownsize_params+IPort2 &downsize_params;

   macro downsize {
      MAdownsize_params+IPort2 &downsize_params => <-.downsize_params;
      Mesh_Struct+Node_Data &in { nnodes+req; } => <-.fld_in;
      ilink params => <-.params;

      MAset_param set_max {
         trigger   => max_array({2, min_array(<-.in.dims)/4});
         in_value  => trigger;
         def_value => <-.downsize_params.def_max;
         value     => <-.downsize_params.max;
      };
      MAset_param set_downsize {
         trigger   => max_array({1, <-.downsize_params.max/2});
         in_value  => trigger;
         def_value => <-.downsize_params.def_downsize;
         value     => <-.downsize_params.downsize;
      };
   
      MADVfld_match fld_match {
         Mesh_Struct+IPort2 &in => <-.in;
      };
      float+IPort2 factor[in.ndim] => switch(in.ndim,
                                         {downsize_params.downsize},
                                         {downsize_params.downsize,
                                          downsize_params.downsize},
                                         {downsize_params.downsize,
                                          downsize_params.downsize,
                                          downsize_params.downsize});
      MADVdownsize_unif MADVdownsize_unif {
         in => <-.fld_match.links.link0;
         factor => <-.factor;
      }; 
      MADVdownsize_rect MADVdownsize_rect {
         in => <-.fld_match.links.link1;
         factor => <-.factor;
      }; 
      MADVdownsize_struct MADVdownsize_struct {
         in => <-.fld_match.links.link2;
         factor => <-.factor;
      }; 

      // workaround: write netCDF
      // write netCDF make a wrong file, when switch used.
      MADVswitch DVswitch {
         in => { MADVdownsize_unif.out,
                 MADVdownsize_rect.out,
                 MADVdownsize_struct.out };
         index => <-.fld_match.index;
      };
      olink out => DVswitch.out;
   }; 
   fld_out => downsize.out;
};
