/*
			Copyright (c) 1997 by
				KGT Inc.
			All Rights Reserved

	This software  comprises  unpublished confidential information of
	KGT Inc. and may not be used, copied or made  available to anyone,
	except in accordance with the license under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/MicroAVS/DV/MAfline.v#1 $
*/
MAparams MAfline_params {
   boolean+nosave  reset =;
   boolean         allnode   = 0;
   int             downsize  = 5;
   int             downmax   = 10;
   boolean         line_vis  = 1;
   boolean         rot_trans = 0;
   float           scale     = 1.0;
   int             dim1      = 8;
   DefaultXform    xform;
   float           z_rot        = 0.0;
   int             z_rot_deci   = 0;
   float+nosave    def_x_trans  =;
   float+nosave    def_y_trans  =;
   float           x_trans      =;
   float           y_trans      =;
   int             x_trans_deci = 1;
   int             y_trans_deci = 1;
   init_commands  = "";
   reset_commands = 
      "fline_params.line_vis=1;"
     +"fline_params.allnode=0;"
     +"fline_params.downsize=5;"
     +"fline_params.downmax=10;"
     +"fline_params.rot_trans=0;"
     +"fline_params.scale=1;"
     +"fline_params.dim1=8;"
     +"fline_params.z_rot=0.0;"
     +"fline_params.z_rot_deci=1;"
     +"fline_params.x_trans=fline_params.def_x_trans;"
     +"fline_params.y_trans=fline_params.def_y_trans;"
     +"fline_params.x_trans_deci=1;"
     +"fline_params.y_trans_deci=1;"
     ;
};

MAmacroUI MAfline2dUI {
   MAfline_params+IPort2 &fline_params;
   Mesh+Node_Data+IPort2 &fld_in;

   height => fline_panel.height;
   MAUIframe fline_panel {
      parent => <-.parent;
      y => <-.y;
      height => switch(<-.fline_params.allnode+1,
                       <-.reset_button.y + <-.reset_button.height + 10,
                       <-.downsize_slider.y + <-.downsize_slider.height + 10
                      );
   };
   MAUItoggle allnode_toggle {
      parent =><-.fline_panel;
      label = "MAFLINE_ALL";
      x = 5;
      y = 5;
      &set =><-.fline_params.allnode;
   };
   // For Allnode
   MAUIslider downsize_slider {
      parent =><-.fline_panel;
      title = "MADOWN_SIZE";
      visible => switch(<-.fline_params.allnode+1,0,1);
      x = 5;
      y =><-.allnode_toggle.y + <-.allnode_toggle.height + 5;
      min = 1;
      &max =><-.fline_params.downmax;
      &value =><-.fline_params.downsize;
      decimalPoints = 0;
   };
   // For Allnode Off
   MAUItoggle radioBox {
      parent =><-.fline_panel;
      label = "MAFLINE_VIS";
      visible => switch(<-.fline_params.allnode+1,1,0);
      x = 5;
      y =><-.allnode_toggle.y + <-.allnode_toggle.height + 5;
      &set =><-.fline_params.line_vis;
   };
   MAUIslider2 z_rot_slider {
      parent =><-.fline_panel;
      visible => switch(<-.fline_params.allnode+1,1,0);
      x = 5;
      y =><-.radioBox.y + <-.radioBox.height + 5;
      min = -180;
      max = 180;
      &value =><-.fline_params.z_rot;
      &decimalPoints =><-.fline_params.z_rot_deci;
      min_oonly = 1;
      max_oonly = 1;
      title = "MAFLINE_ROT";
   };
   MAUIslider2 x_trans_slider {
      parent =><-.fline_panel;
      visible => switch(<-.fline_params.allnode+1,1,0);
      x = 5;
      y =><-.z_rot_slider.y + <-.z_rot_slider.height + 5;
      &min+nres=><-.fld_in.coordinates.min_vec[0];
      &max+nres=><-.fld_in.coordinates.max_vec[0];
      &value =><-.fline_params.x_trans;
      &decimalPoints =><-.fline_params.x_trans_deci;
      title = "MAFLINE_XTRANS";
   };
   x_trans_slider y_trans_slider {
      y =><-.x_trans_slider.y + <-.x_trans_slider.height + 5;
      &min+nres=><-.fld_in.coordinates.min_vec[1];
      &max+nres=><-.fld_in.coordinates.max_vec[1];
      &value =><-.fline_params.y_trans;
      &decimalPoints =><-.fline_params.y_trans_deci;
      title = "MAFLINE_YTRANS";
   };
   MAUIlabel scale_label {
      parent =><-.fline_panel;
      visible => switch(<-.fline_params.allnode+1,1,0);
      x = 5;
      y =><-.y_trans_slider.y + <-.y_trans_slider.height + 15;
      width = 100;
      height = 25;
      label = "MAFLINE_SCALE";
      alignment = "right";
   };
   scale_label xdim_label {
      y =><-.scale_label.y + <-.scale_label.height + 5;
      label = "MAFLINE_XDIM";
   };
   MAUIfield scale_field {
      parent =><-.fline_panel;
      visible => switch(<-.fline_params.allnode+1,1,0);
      x = 130;
      y =><-.scale_label.y - 4;
      width = 80;
      height = 25;
      decimalPoints = 2;
      min = 0;
      &value =><-.fline_params.scale;
   };
   scale_field xdim_field {
      y =><-.xdim_label.y - 4;
      min = 2;
      decimalPoints = 0;
      &value =><-.fline_params.dim1;
   };
   MAUIbutton reset_button {
      visible => switch(<-.fline_params.allnode+1,1,0);
      parent =><-.fline_panel;
      x =5;
      y =><-.xdim_label.y + <-.xdim_label.height + 5;
      width = 220;
      height = 25;
      &do =><-.fline_params.reset;
      label = "MAFLINE_RESET_LINE";
   };
};

MAmodule MAfline2d {
   MAfline_params+IPort2 &fline_params;
   Mesh_Struct+Node_Data &fld_in<NEportLevels ={2,1}>;

   GMOD.copy_on_change set_line_vis {
      input =>!(<-.fline_params.allnode);
      output =><-.fline_params.line_vis;
      on_inst = 0;
   };
   macro downsize {
      MAfline_params+IPort2 &fline_params => <-.fline_params;
      Mesh_Struct+Node_Data &in<NEportLevels={2,1}> => <-.fld_in;
      ilink params => <-.params;

      GMOD.copy_on_change check_max {
         trigger => <-.params.reset;
         input => max_array({1, min_array(<-.in.dims)/4});
         output => fline_params.downmax;
         on_inst = 1;
      };
      GMOD.copy_on_change check_downsize {
         input => switch(!is_valid(fline_params.downsize),
                         max_array({1, (fline_params.downmax/2)}));
         output => fline_params.downsize;
         on_inst = 1;
      };

      MADVfld_match fld_match {
         Mesh_Struct+IPort2 &in => <-.in;
      };
      float+IPort2 factor[in.ndim] => switch(in.ndim,
                                         {fline_params.downsize},
                                         {fline_params.downsize,
                                          fline_params.downsize},
                                         {fline_params.downsize,
                                          fline_params.downsize,
                                          fline_params.downsize});
      MADVdownsize_unif MADVdownsize_unif {
         in => <-.fld_match.links.link0;
         factor => <-.factor;
      };
      MADVdownsize_rect MADVdownsize_rect {
         in => <-.fld_match.links.link1;
         factor => <-.factor;
      };
      MADVdownsize_struct MADVdownsize_struct {
         in => <-.fld_match.links.link2;
         factor => <-.factor;
      };
      olink out => switch(fld_match.index+1,
                          MADVdownsize_unif.out,
                          MADVdownsize_rect.out,
                          MADVdownsize_struct.out
                         );
   };
   Line_Mesh fline {
      dims =>{<-.fline_params.dim1};
      points+nres => {<-.fld_in.coordinates.min_vec[0],
                      <-.fld_in.coordinates.max_vec[0]
                     };
      &xform =><-.fline_params.xform;
   };
   GMOD.parse_v ResetLine {
      v_commands+nres => "$push -usr\n"
                        +"scale=1.0;"
                        +"dim1=8;"
                        +"z_rot=0.0;"
                        +"x_trans=def_x_trans;"
                        +"y_trans=def_y_trans;"
                        +"$pop\n";
      trigger => <-.fline_params.reset;
      on_inst = 0;
      relative => <-.fline_params;
   };
   MAset_param set_x_trans {
      trigger+nres  => is_valid(fld_in.coordinates.min_vec[0])
                      &is_valid(fld_in.coordinates.max_vec[0]);
      in_value+nres => fld_in.coordinates.min_vec[0];
      def_value => <-.fline_params.def_x_trans;
      value     => <-.fline_params.x_trans;
   };
   MAset_param set_y_trans {
      trigger+nres  => is_valid(fld_in.coordinates.min_vec[1])
                      &is_valid(fld_in.coordinates.max_vec[1]);
      in_value+nres => (fld_in.coordinates.min_vec[1]
                       +fld_in.coordinates.max_vec[1]) * 0.5;
      def_value => <-.fline_params.def_y_trans;
      value     => <-.fline_params.y_trans;
   };

   MAGDxform_edit+nosave XformEdit {
      scale => <-.fline_params.scale;
      //shell_vis => <-.fline_params.line_vis;
      absolute = 1;
      xform => <-.fline_params.xform;
      z_rot => <-.fline_params.z_rot;
      /* v 7.0 */
      /*x_trans+nres => <-.fline_params.x_trans - fld_in.coordinates.min_vec[0];*/
      x_trans+nres => <-.fline_params.x_trans;
      y_trans+nres => <-.fline_params.y_trans;
      z_trans+nres => (fld_in.coordinates.min_vec[2]
                      +fld_in.coordinates.max_vec[2]) * 0.5;
   };
   MAdataObject+nosave DataObject {
      ilink fline_params =><-.fline_params;
      in =><-.fline;
      Obj {
         xform =><-.fline_params.xform;
         visible =><-.fline_params.line_vis;
         name => "ME_LINE";
      };
   };
   fld_out => switch(fline_params.allnode+1,fline,downsize.out);
   olink obj_out => DataObject.obj;
};
