/*
	"$Id: //depot/express/fcs70/v/MicroAVS/DV/MAfplane.v#1 $"
			Copyright (c) 1997 by
				KGT Inc.
			All Rights Reserved

	This software  comprises  unpublished confidential information of
	KGT Inc. and may not be used, copied or made  available to anyone,
	except in accordance with the license under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/MicroAVS/DV/MAfplane.v#1 $
*/
MAparams MAfplane_params {
   boolean plane_vis = 1;
   boolean rot_or_trans = 0;
   boolean plane_or_mesh = 0;
   boolean+nosave reset = 0;
   float   scale_x = 1.0;
   float   scale_y = 1.0;
   int     dim1 = 8;
   int     dim2 = 8;
   DefaultXform   xform;
   float   x_rot = 0.0;
   float   y_rot = 0.0;
   float   z_rot = 0.0;
   float+nosave   def_x_trans =;
   float+nosave   def_y_trans =;
   float+nosave   def_z_trans =;
   float   x_trans =;
   float   y_trans =;
   float   z_trans =;
   int     x_rot_deci = 0;
   int     y_rot_deci = 0;
   int     z_rot_deci = 0;
   int     x_trans_deci = 1;
   int     y_trans_deci = 1;
   int     z_trans_deci = 1;
   init_commands = "";
   reset_commands =
     "fplane_params.plane_vis=1;"
    +"fplane_params.rot_or_trans=0;"
    +"fplane_params.plane_or_mesh=0;"
    +"fplane_params.scale_x=1;"
    +"fplane_params.scale_y=1;"
    +"fplane_params.dim1=8;"
    +"fplane_params.dim2=8;"
    +"fplane_params.x_rot=0.0;"
    +"fplane_params.y_rot=0.0;"
    +"fplane_params.z_rot=0.0;"
    +"fplane_params.x_trans=fplane_params.def_x_trans;"
    +"fplane_params.y_trans=fplane_params.def_y_trans;"
    +"fplane_params.z_trans=fplane_params.def_z_trans;"
    +"fplane_params.x_rot_deci=0;"
    +"fplane_params.y_rot_deci=0;"
    +"fplane_params.z_rot_deci=0;"
    +"fplane_params.x_trans_deci=1;"
    +"fplane_params.y_trans_deci=1;"
    +"fplane_params.z_trans_deci=1;"
    ;
};

MAmacroUI+nosave MAfplaneUI {
   MAfplane_params+IPort2 &fplane_params;
   Mesh+Node_Data+IPort2 &fld_in;
   float+nres min0_value => .fld_in.coordinates.min_vec[0];
   float+nres max0_value => .fld_in.coordinates.max_vec[0];
   float+nres min1_value => .fld_in.coordinates.min_vec[1];
   float+nres max1_value => .fld_in.coordinates.max_vec[1];
   float+nres min2_value => .fld_in.coordinates.min_vec[2];
   float+nres max2_value => .fld_in.coordinates.max_vec[2];

   height => fplane_panel.height;
   MAUIframe fplane_panel {
      parent => <-.parent;
      y => <-.y;
      height => <-.plane_reset.y + <-.plane_reset.height + 5;
   };
   macro plane_type {
      ilink fplane_params => <-.fplane_params;
      ilink parent => <-.fplane_panel;
      UIoption+nosave mesh_opt  { label = "MAFPLANE_MESH"; };
      UIoption+nosave plane_opt { label = "MAFPLANE_PLANE"; };
      MAUIradioBox+nosave radioBox {
         visible => <-.plane_vis.set;
         parent => <-.parent;
         cmdList => {<-.plane_opt, <-.mesh_opt};
         x = 130;
         y = 4;
         selectedItem => <-.fplane_params.plane_or_mesh;
      };
      MAUItoggle plane_vis {
         parent => <-.parent;
         label = "MAFPLANE_VIS_PLANE";
         x = 8;
         y = 12;
         width = 120;
         set => <-.fplane_params.plane_vis;
      };
   };
   macro plane_trans {
      ilink fplane_params => <-.fplane_params;
      ilink parent => <-.fplane_panel;
      MAUIframe frame {
         parent => <-.parent;
         x = 5;
         y = 55;
         width = 220;
         height => max_array({<-.rot_panel.y + <-.rot_panel.height,
                              <-.trans_panel.y + <-.trans_panel.height});
      };
      UIoption+nosave rot_opt   { label = "MAFPLANE_ROTATE"; };
      UIoption+nosave trans_opt { label = "MAFPLANE_TRANS"; };
      MAUIradioBox+nosave switch_opt {
         parent => <-.frame;
         cmdList => {<-.rot_opt, <-.trans_opt};
         x = 5;
         y = 4;
         width = 200;
         height = 50;
         selectedItem => <-.fplane_params.rot_or_trans;
      };
      MAUIpanel rot_panel {
         parent => <-.frame;
         x = 0;
         y = 55;
         width = 205;
         height => <-.z_rot_slider.y + <-.z_rot_slider.height + 5; 
         visible => !<-.fplane_params.rot_or_trans;
      };
      MAUIslider2 x_rot_slider { 
         x = 5;
         y = 0;
         parent => <-.rot_panel;
         value => <-.fplane_params.x_rot;
         min = -180;
         max =  180;
         allwidth = 200;
         decimalPoints =><-.fplane_params.x_rot_deci;
         min_oonly = 1;
         max_oonly = 1;
         title = "MAFPLANE_XROT";
      };
      x_rot_slider y_rot_slider { 
         decimalPoints =><-.fplane_params.y_rot_deci;
         y =><-.x_rot_slider.y + <-.x_rot_slider.height + 5; 
         value => <-.fplane_params.y_rot; 
         title = "MAFPLANE_YROT";
      };
      x_rot_slider z_rot_slider { 
         decimalPoints =><-.fplane_params.z_rot_deci;
         y =><-.y_rot_slider.y + <-.y_rot_slider.height + 5; 
         value => <-.fplane_params.z_rot; 
         title = "MAFPLANE_ZROT";
      };
      rot_panel trans_panel {
         visible => <-.fplane_params.rot_or_trans;
         height => <-.z_trans_slider.y + <-.z_trans_slider.height + 5; 
      };
      MAUIslider2 x_trans_slider {
         value => <-.fplane_params.x_trans;
         x = 5;
         y =  0; 
         allwidth = 200; 
         parent => <-.trans_panel;
         min => <-.<-.min0_value;
         max => <-.<-.max0_value;
         decimalPoints => <-.fplane_params.x_trans_deci;
         title = "MAFPLANE_XTRANS";
      };
      x_trans_slider y_trans_slider {
         y =><-.x_trans_slider.y + <-.x_trans_slider.height + 5; 
         value => <-.fplane_params.y_trans;
         min => <-.<-.min1_value;
         max => <-.<-.max1_value;
         decimalPoints => <-.fplane_params.y_trans_deci;
         title = "MAFPLANE_YTRANS";
      };
      x_trans_slider z_trans_slider {
         y =><-.y_trans_slider.y + <-.y_trans_slider.height + 5; 
         value => <-.fplane_params.z_trans;
         min => <-.<-.min2_value;
         max => <-.<-.max2_value;
         decimalPoints => <-.fplane_params.z_trans_deci;
         title = "MAFPLANE_ZTRANS";
      };
   };
   macro plane_scale {
      ilink fplane_params => <-.fplane_params;
      ilink parent => <-.fplane_panel;
      MAUIframe frame {
         parent => <-.parent;
         x =><-.<-.plane_trans.frame.x;
         y =><-.<-.plane_trans.frame.y + <-.<-.plane_trans.frame.height;
         width = 220;
         height => <-.y_dim.y + <-.y_dim.height + 5;
      };
      MAUIFieldLabel x_scale {
         parent => <-.frame;
         x = 0;
         y = 7;
         label => "MAFPLANE_P_SCALE" + " " + "MAFPLANE_XDIM";
         decimalPoints = 2;
         immediateMode = 0;
         min = 0.;
         &value => <-.fplane_params.scale_x;
      };
      x_scale y_scale {
         y => <-.x_scale.y + <-.x_scale.height;
         label => "MAFPLANE_P_SCALE" + " " + "MAFPLANE_YDIM";
         &value => <-.fplane_params.scale_y;
      };
      MAUIFieldLabel x_dim {
         parent => <-.frame;
         y => <-.y_scale.y + <-.y_scale.height;
         label => "MAFPLANE_DIM" + " " + "MAFPLANE_XDIM";
         value => <-.fplane_params.dim1;
         mode = 1; //"integer";
         decimalPoints = 0;
         min = 2;
         immediateMode = 0;
      };
      x_dim y_dim {
         y => <-.x_dim.y + <-.x_dim.height;
         label => "MAFPLANE_DIM" + " " + "MAFPLANE_YDIM";
         value => <-.fplane_params.dim2;
      };
   };
   MAUIbutton plane_reset {
      parent => <-.fplane_panel;
      x =><-.plane_scale.frame.x;
      y =><-.plane_scale.frame.y + <-.plane_scale.frame.height + 5;
      width = 220;
      height = 25;
      &do => <-.fplane_params.reset;
      label = "MAFPLANE_RES_P";
   };
};

MAmodule MAfplane {
   MAfplane_params+IPort2 &fplane_params;
   Mesh+Node_Data &fld_in<NEportLevels={2,1}>;

   Mesh_Unif+Space2+Dim2 fplane<NEportLevels={0,1}> {
      dims => {<-.fplane_params.dim1,<-.fplane_params.dim2};
      points+nres => {0,0,
          (<-.fld_in.coordinates.max_vec[0]
          -<-.fld_in.coordinates.min_vec[0]) * <-.fplane_params.scale_x,
          (<-.fld_in.coordinates.max_vec[1]
          -<-.fld_in.coordinates.min_vec[1]) * <-.fplane_params.scale_y
                     };
      &xform => <-.fplane_params.xform;
   };
   GMOD.parse_v ResetPlane {
      v_commands =
      "$push -usr\nfplane_params {"
     +   "scale_x=1.0;scale_y=1.0;dim1=8;dim2=8;x_rot=0.0;y_rot=0.0;z_rot=0.0;"
     +   "x_trans_deci=1;y_trans_deci=1;z_trans_deci=1;"
     +   "x_trans=def_x_trans;"
     +   "y_trans=def_y_trans;"
     +   "z_trans=def_z_trans;"
     +   "reset=0;"
     +"};\n$pop\n";
      trigger => <-.fplane_params.reset;
      active  => <-.fplane_params.reset;
      on_inst = 0;
      relative => <-;
   };
   MAset_param set_x_trans {
      trigger+nres => is_valid(<-.fld_in.coordinates.min_vec[0]);
      in_value     => <-.fld_in.coordinates.min_vec[0];
      def_value    => <-.fplane_params.def_x_trans;
      value        => <-.fplane_params.x_trans;
   };
   MAset_param set_y_trans {
      trigger+nres => is_valid(<-.fld_in.coordinates.min_vec[1]);
      in_value     => <-.fld_in.coordinates.min_vec[1];
      def_value    => <-.fplane_params.def_y_trans;
      value        => <-.fplane_params.y_trans;
   };
   MAset_param set_z_trans {
      trigger+nres => is_valid(<-.fld_in.coordinates.min_vec[2])
                     &is_valid(<-.fld_in.coordinates.max_vec[2]);
      in_value     =>(<-.fld_in.coordinates.min_vec[2]
                     +<-.fld_in.coordinates.max_vec[2]) * 0.5;
      def_value    => <-.fplane_params.def_z_trans;
      value        => <-.fplane_params.z_trans;
   };
   MAGDxform_edit+nosave XformEdit {
      //shell_vis => <-.fplane_params.plane_vis;
      absolute = 1;
      xform => <-.fplane_params.xform;
      x_rot => <-.fplane_params.x_rot;
      y_rot => <-.fplane_params.y_rot;
      z_rot => <-.fplane_params.z_rot;
      x_trans => <-.fplane_params.x_trans;
      y_trans => <-.fplane_params.y_trans;
      z_trans => <-.fplane_params.z_trans;
   };

   MAdataObject+nosave DataObject {
      ilink fplane_params => <-.fplane_params;
      in => <-.fplane;
      Obj {
         xform => <-.fplane_params.xform;
         visible => <-.fplane_params.plane_vis;
         name => "ME_SLICE";
         pickable = 0;
      };
      Props.trans = 0.2;
      GMOD.copy_on_change set_plane_or_mesh {
         input => <-.fplane_params.plane_or_mesh + 1;
         output => <-.Modes.mode[1];
      };
   };
   fld_out => fplane;
   olink obj_out => DataObject.obj;
};
