/*
	"$Id: //depot/express/fcs70/v/MicroAVS/DV/MAiline.v#1 $"
			Copyright (c) 1997 by
				KGT Inc.
			All Rights Reserved

	This software  comprises  unpublished confidential information of
	KGT Inc. and may not be used, copied or made  available to anyone,
	except in accordance with the license under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/MicroAVS/DV/MAiline.v#1 $
*/
group MAiline_Param<NEnumColors=4,
                  NEcolor0=0x0000ff,
                  NEcolor1=0x00ff00,
                  NEcolor2=0xff0000,
                  NEcolor3=0xaabbcc> {
   int width          = 64;
   int height         = 64;
   int illuminationOn = 0;
   group IlluminationModel<NEnumColors=1, NEcolor0=0x00ff00> {
      double Ka<animate=1>    = 0.1;	// ambient 0->1
      double Kd<animate=1>    = 0.2;	// diffuse 0->1
      double Ks<animate=1>    = 0.8;	// specular 0->1
      double n<animate=1>     = 20;	// shininess 1->100
      double p<animate=1>     = 3;	// phong modifier 1.2->8
      double Trans<animate=1> = 1.0;	// Transparency 0->1
      double Blend<animate=1> = 0.25;// Color Blending 0->1
   };
   group HaloModel<NEnumColors=1, NEcolor0=0x00ff00> {
      int haloWidth<animate=1> = 0;
      int lineWidth<animate=1> = 1;
      int doDepthMask          = 0;
      int doAntialiasHalo      = 0;
      int doSmoothShade        = 0;
   };
   group AnimationEffect<NEnumColors=1, NEcolor0=0x00ff00> {
      int animationOn              = 0;
      int StairDash                = 0;	// 0 - stair  1 - dash
      int StairType                = 0;	// 0 - down  1 - up  2 - up&down
      int effectLength<animate=1>  = 1;
      int effectSpacing<animate=1> = 1;
      int TranspWidth              = 0;	// 0 - transparency  1 - width
      int InverseEffect            = 0;	// 0 - normal  1 - inverse
      int effectStep               = 0;
   };
};

MAmodule+nosave MAilluminated_lines {
   ilink fld_in;

   MAstream_params+IPort2 &stream_params;
   MAMesh_Polyline &mesh_polyline<export=1> => .fld_in;
   int &conn<NEportLevels=1>[] => mesh_polyline.cell_set[0].poly_connect_list;

   MAiline_calc_texmap set_texmap {
      param => <-.stream_params.iline_Param;
   };
   MAiline_calc_tangents calc_tangents {
      conn   => <-.conn;
      coords => <-.mesh_polyline.coordinates.values;
   };
   MAiline_create_effect_data effect_data {
      param => <-.stream_params.iline_Param;
   };
   MAilluminated_lines_mesh_mapper mesh_mapper {
      coord   => <-.mesh_polyline.coordinates.values;
      tangent => <-.calc_tangents.tangents;
      connect => <-.conn;
      param   => <-.stream_params.iline_Param;
      tex_map => <-.set_texmap.TexMap;
      mesh_in => <-.mesh_polyline;
      effect_data => <-.effect_data.effect_data;
      loop    => <-.loop;
      obj<NEportLevels={1,2}>;
      DataObject{
         Obj.name => "NOOBJLIST LINE_UNIT_OBJ";
         Obj.pickable = 0;
      };
   };
   GMOD.loop loop<NEportLevels={0,1}> {
      start_val    => 0.;
      end_val+nres => (<-.stream_params.iline_Param.AnimationEffect.effectLength +
                       <-.stream_params.line_Param.AnimationEffect.effectSpacing) - 1;
      count        => <-.stream_params.iline_Param.AnimationEffect.effectStep;
      incr         => 1.;
      cycle        => 1;
   };

    olink out_obj => mesh_mapper.obj;
};

MAmacroUI MAilluminatedUI {
   MAstream_params+IPort2 &stream_params;

   height => .illuminated_panel.height;
   MAUIframe illuminated_panel {
      parent => <-.parent;
      y => <-.y;
      height =>illuminated_linesUI.y + illuminated_linesUI.height +15;
   };
   MAUItoggle illumination_on_toggle {
      x = 5;
      y = 10;
      parent => <-.illuminated_panel;
      label => "MAILINE_ILL_TOGGLE";
      alignment = "center";
      set<NEportLevels={2,0}> => stream_params.iline_Param.illuminationOn;
   };

   MAmacroUI illuminated_linesUI{
      parent => <-.illuminated_panel;
      y      => <-.illumination_on_toggle.y + <-.illumination_on_toggle.height + 8;
      height => .panel.height;
      MAstream_params+IPort2 &stream_params => <-.stream_params;
      MAUIpanel panel{
         parent  => <-.parent;
         y       => <-.y;
         height  =>((halow_slider.y + halow_slider.height +15) * (<-.<-.illumination_on_toggle.set));
         visible => <-.<-.illumination_on_toggle.set;
      };
      MAUIslider2 Ka_slider {
         x      = 5;
         y      = 0;
         parent => <-.panel;
         min    = 0.;
         max    = 1.;
         value  => <-.stream_params.iline_Param.IlluminationModel.Ka;
         title  => "MAV3PROPS_AMBIENT";
         mode   = 0;
         decimalPoints = 2;
         valEditor.UI.min_field.min = 0;
         valEditor.UI.max_field.max = 1;
      };
      MAUIslider2 Kd_slider {
         x      = 5;
         y      => ((<-.Ka_slider.y + <-.Ka_slider.height) + 5);
         parent => <-.panel;
         min    = 0.;
         max    = 1.;
         value  => <-.stream_params.iline_Param.IlluminationModel.Kd;
         title  => "MAV3PROPS_DIFFUSE";
         mode   = 0;
         decimalPoints = 2;
         valEditor.UI.min_field.min = 0;
         valEditor.UI.max_field.max = 1;
      };
      MAUIslider2 Ks_slider {
         x      = 5;
         y      => ((<-.Kd_slider.y + <-.Kd_slider.height) + 5);
         parent => <-.panel;
         min    = 0.;
         max    = 1.;
         value  => <-.stream_params.iline_Param.IlluminationModel.Ks;
         title  => "MAV3PROPS_SPEC";
         mode   = 0;
         decimalPoints = 2;
         valEditor.UI.min_field.min = 0;
         valEditor.UI.max_field.max = 1;
      };
      MAUIslider2 n_slider {
         x      = 5;
         y      => ((<-.Ks_slider.y + <-.Ks_slider.height) + 5);
         parent => <-.panel;
         min    = 1;
         max    = 100;
         value  => <-.stream_params.iline_Param.IlluminationModel.n;
         title  => "MAILINE_PHONG_SHIN";
         mode   = 1;
         decimalPoints = 0;
         valEditor.UI.min_field.min = 0;
         valEditor.UI.max_field.max = 100;
      };
      MAUIslider2 lw_slider {
         x      = 5;
         y      => ((<-.n_slider.y + <-.n_slider.height) + 5);
         parent => <-.panel;
         min    = 1.;
         max    = 8.;
         value  => <-.stream_params.iline_Param.HaloModel.lineWidth;
         title  => "MAILINE_LINE_WIDTH";
         mode   = 1;
         decimalPoints = 0;
         valEditor.UI.min_field.min = 1;
         valEditor.UI.max_field.max = 8;
      };
      MAUIslider2 trans_slider {
         x      = 5;
         y      => ((<-.lw_slider.y + <-.lw_slider.height) + 5);
         parent => <-.panel;
         min    = 0.;
         max    = 1.;
         value  => <-.stream_params.iline_Param.IlluminationModel.Trans;
         title  => "MAILINE_LINE_OPACITY";
         mode   = 0;
         decimalPoints = 2;
         valEditor.UI.min_field.min = 0;
         valEditor.UI.max_field.max = 1;
      };
      MAUIslider2 blend_slider {
         x      = 5;
         y => ((<-.trans_slider.y + <-.trans_slider.height) + 5);
         parent => <-.panel;
         min    = 0.;
         max    = 1.;
         value  => <-.stream_params.iline_Param.IlluminationModel.Blend;
         title => "MAILINE_COL_BLEND";
         mode   = 0;
         decimalPoints = 2;
         valEditor.UI.min_field.min = 0;
         valEditor.UI.max_field.max = 1;
      };
      MAUItoggle depth_toggle {
         y      => ((<-.blend_slider.y + <-.blend_slider.height) + 5);
         width  => <-.panel.width - 5;
         parent => <-.panel;
         label  => "MAILINE_DEPTH_MASK";
         set    => <-.stream_params.iline_Param.HaloModel.doDepthMask;
      };
      MAUItoggle aa_toggle {
         y      => ((<-.depth_toggle.y + <-.depth_toggle.height) + 5);
         width  => <-.panel.width - 5;
         parent => <-.panel;
         label  => "MAILINE_ANTIALIAS";
         set    => <-.stream_params.iline_Param.HaloModel.doAntialiasHalo;
      };
      MAUItoggle smooth_shade_toggle {
         y      => ((<-.aa_toggle.y + <-.aa_toggle.height) + 5);
         width  => <-.panel.width - 5;
         parent => <-.panel;
         label  => "MAILINE_SMOOTH_SHADE";
         set    => <-.stream_params.iline_Param.HaloModel.doSmoothShade;
      };
      MAUIslider2 halow_slider {
         x      = 5;
         y      => ((<-.smooth_shade_toggle.y + <-.smooth_shade_toggle.height) + 5);
         parent => <-.panel;
         min    = 0.;
         max    = 10.;
         value  => <-.stream_params.iline_Param.HaloModel.haloWidth;
         title  => "MAILINE_HALO_WIDTH";
         mode   = 1;
         decimalPoints = 0;
         valEditor.UI.min_field.min = 0;
         valEditor.UI.max_field.max = 10;
      };
   };
};

