/*
			Copyright (c) 1998 by
				KGT Inc.
			All Rights Reserved

	This software  comprises  unpublished confidential information of
	KGT Inc. and may not be used, copied or made  available to anyone,
	except in accordance with the license under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/v/MicroAVS/DV/MAisolex.v#1 $
*/
MAparams MAisolinex_params {
   int linenum = 5;
   float+nosave def_level_min =;
   float+nosave def_level_max =;
   float level_min =;
   float level_max =;
   int   level_min_deci = 2;
   int   level_max_deci = 2;
   float color = 1;
   int linewidth = 1;
   int jitterlevel = 1;
   int smoothline = 0;
   boolean+nosave fit = 0; // init. zero
   init_commands = "";
   reset_commands =
      "isolinex_params.linenum=5;"
     +"isolinex_params.level_min=isolinex_params.def_level_min;"
     +"isolinex_params.level_max=isolinex_params.def_level_max;"
     +"isolinex_params.color=1;"
     +"isolinex_params.linewidth=1;"
     +"isolinex_params.jitterlevel=1;"
     +"isolinex_params.smoothline=0;"
     +"isolinex_params.fit=1;"
     +"isolinex_params.level_min_deci=2;"
     +"isolinex_params.level_max_deci=2;"
     ;
};

MAmacroUI MAisolinexUI {
   MAisolinex_params+IPort2 &isolinex_params;
   Mesh+Node_Data+IPort2 &fld_in;

   height => isolinex_panel.height;
   MAUIframe isolinex_panel {
      parent => <-.parent;
      y => <-.y;
      height => <-.minmaxLevelUI.height + 15;
   };
   MAUItoggle color_toggle {
      parent => <-.isolinex_panel;
      x = 5;
      y = 5;
      label = "MAISOL_COL";
      set =><-.isolinex_params.color;
   };
   color_toggle smooth_toggle {
      y =><-.color_toggle.y + <-.color_toggle.height + 5;
      label = "MAISOL_SMOTH";
      set =><-.isolinex_params.smoothline;
   };
   MAUIslider linenum_slider {
      parent => <-.isolinex_panel;
      x = 5;
      y =><-.smooth_toggle.y + <-.smooth_toggle.height + 5;
      mode="integer";
      min = 1;
      max = 100;
      value =><-.isolinex_params.linenum;
      title = "MAISOL_NUM";
   };
   MADVminmaxLevelUI minmaxLevelUI {
      parent         => <-.isolinex_panel;
      y              => <-.linenum_slider.y + <-.linenum_slider.height + 5;
      fld_in         => <-.fld_in;
      level_min      => <-.isolinex_params.level_min;
      level_max      => <-.isolinex_params.level_max;
      level_min_deci => <-.isolinex_params.level_min_deci;
      level_max_deci => <-.isolinex_params.level_max_deci;
      fit            => <-.isolinex_params.fit;
   };
   linenum_slider linewidth_slider {
      y => <-.minmaxLevelUI.height + 5;
      min = 1;
      max = 10;
      value =><-.isolinex_params.linewidth;
      title = "MAISOL_W";
   };
   linewidth_slider jitter_slider {
      y =><-.linewidth_slider.y + <-.linewidth_slider.height + 5;
      min = -5;
      max = 5;
      value =><-.isolinex_params.jitterlevel;
      title = "MAISOL_JITER";
   };
};

MAmodule MAisolinex {
   MAisolinex_params+IPort2 &isolinex_params;

   MAset_param set_level_min {
      trigger+nres  => is_valid(fld_in.node_data[0].min);
      in_value+nres => <-.fld_in.node_data[0].min;
      def_value     => <-.isolinex_params.def_level_min;
      value         => <-.isolinex_params.level_min;
   };
   MAset_param set_level_max {
      trigger+nres  => is_valid(fld_in.node_data[0].max);
      in_value+nres => <-.fld_in.node_data[0].max;
      def_value     => <-.isolinex_params.def_level_max;
      value         => <-.isolinex_params.level_max;
   };

   MADVisoline isoline {
      in => <-.fld_in;
      component = 0;
      level =>
         init_array(<-.isolinex_params.linenum,
                    <-.isolinex_params.level_min,
                    <-.isolinex_params.level_max);
      color => <-.isolinex_params.color;
   };
   fld_out => isoline.out;
};
